# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/mysqlConnection.json
#   timestamp: 2022-04-11T06:51:08+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from . import connectionBasicType


class SupportedPipelineType11(Enum):
    Metadata = 'Metadata'


class MySQLType(Enum):
    MySQL = 'MySQL'


class MySQLScheme(Enum):
    mysql_pymysql = 'mysql+pymysql'


class MysqlConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[MySQLType] = Field(MySQLType.MySQL, description='Service Type')
    scheme: Optional[MySQLScheme] = Field(
        MySQLScheme.mysql_pymysql, description='SQLAlchemy driver scheme options.'
    )
    username: Optional[str] = Field(
        None,
        description='username to connect  to the SingleStore. This user should have privileges to read all the metadata in SingleStore.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the SingleStore.'
    )
    hostPort: Optional[str] = Field(
        None, description='Host and port of the data source.'
    )
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in SingleStore.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportedPipelineTypes: Optional[List[SupportedPipelineType11]] = Field(
        ['Metadata'], description='Supported Metadata Extraction Pipelines.'
    )
