# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/dashboard/supersetConnection.json
#   timestamp: 2022-04-11T06:51:08+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, SecretStr


class SupportedPipelineTypes(Enum):
    Metadata = 'Metadata'


class SupersetType(Enum):
    Superset = 'Superset'


class SupersetConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[SupersetType] = Field(
        SupersetType.Superset, description='Service Type'
    )
    supersetURL: Optional[AnyUrl] = Field(
        'http://localhost:8088', description='URL for the superset instance'
    )
    username: Optional[str] = Field(None, description='username for the Superset')
    password: Optional[SecretStr] = Field(None, description='password for the Superset')
    provider: Optional[str] = Field(
        'db', description='authenticaiton provider for the Superset'
    )
    dbServiceConnection: Optional[str] = Field(
        None, description='Database Service to create lineage'
    )
    connectionOptions: Optional[Dict[str, Any]] = Field(
        None,
        description='Additional connection options that can be sent to service during the connection.',
    )
    supportedPipelineTypes: Optional[SupportedPipelineTypes] = Field(
        None, description='Supported Metadata Extraction Pipelines.'
    )
