# generated by datamodel-codegen:
#   filename:  schema/api/services/createDatabaseService.json
#   timestamp: 2022-04-11T16:37:08+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field, constr

from ...entity.services import databaseService
from ...type import entityReference


class CreateDatabaseServiceRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: constr(regex=r'^[^.]*$', min_length=1, max_length=128) = Field(
        ..., description='Name that identifies the this entity instance uniquely'
    )
    description: Optional[str] = Field(
        None, description='Description of Database entity.'
    )
    serviceType: databaseService.DatabaseServiceType
    databaseConnection: databaseService.DatabaseConnection
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this database service.'
    )
