import flydra_core.reconstruct
import pkg_resources

def test_failing_quartic_roots():
    fname = pkg_resources.resource_filename('flydra_analysis.a2',
                                            'sample_calibration_water.xml')
    R = flydra_core.reconstruct.Reconstructor(fname)
    cam_id = 'Basler_21426001'
    for pt in [(-0.054036740422969506, 0.045115631117431117, -1.4063962542297526e-09),
               ( -1.07175700e-01,   9.38379467e-02,  -2e-09 ),
               ( -1.07175700e-01,   9.38379467e-02,  -3e-09 ),
               ( -1.07175700e-01,   9.38379467e-02,  -3.89395627e-09 ),
               ( -1.07175700e-01,   9.38379467e-02,  -4e-09 ),
               ( -1.07175700e-01,   9.38379467e-02,  -5e-09 ),
               ( -1.07175700e-01,   9.38379467e-02,  -6e-09 ),
               ( -1.07175700e-01,   9.38379467e-02,  -7e-09 ),
               ( -1.07175700e-01,   9.38379467e-02,  -8e-09 ),
               ( -1.07175700e-01,   9.38379467e-02,  -9e-09 ),
               ( -1.07175700e-01,   9.38379467e-02,  -1e-08 ),
               ( -1.07175700e-01,   9.38379467e-02,  -2e-08 ),
               ( -1.07175700e-01,   9.38379467e-02,  -3e-08 ),
               ( -1.07175700e-01,   9.38379467e-02,  -1e-07 ),
               ( -1.07175700e-01,   9.38379467e-02,  -1e-06 ),
               ( -1.07175700e-01,   9.38379467e-02,  -1e-05 ),
               ( -1.07175700e-01,   9.38379467e-02,  -1e-04 ),
               ( -1.07175700e-01,   9.38379467e-02,  -1e-10 ),
               ( -1.07175700e-01,   9.38379467e-02,  -1e-11 ),
               ( -1.07175700e-01,   9.38379467e-02,  -1e-12 ),
               ]:
        R.find2d( cam_id, pt, distorted=True)
