# Generated by Django 3.0.8 on 2021-05-27 16:25

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import snakeface.apps.main.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Workflow',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('add_date', models.DateTimeField(auto_now_add=True, verbose_name='date published')),
                ('command', models.TextField()),
                ('data', snakeface.apps.main.models.JSONField(default='{}')),
                ('dag', models.TextField(blank=True, null=True)),
                ('error', models.TextField(blank=True, null=True)),
                ('output', models.TextField(blank=True, null=True)),
                ('modify_date', models.DateTimeField(auto_now=True, verbose_name='date modified')),
                ('name', models.CharField(blank=True, max_length=250, null=True, unique=True)),
                ('snakefile', models.TextField(max_length=250)),
                ('snakemake_id', models.TextField()),
                ('status', models.TextField(choices=[('RUNNING', 'RUNNING'), ('NOTRUNNING', 'NOTRUNNING'), ('CANCELLED', 'CANCELLED')], default='NOTRUNNING')),
                ('thread', models.PositiveIntegerField(blank=True, default=None, null=True)),
                ('retval', models.PositiveIntegerField(blank=True, default=None, null=True)),
                ('workdir', models.TextField(max_length=250)),
                ('private', models.BooleanField(choices=[(False, 'Public (The workflow collection will be accessible by anyone)'), (True, 'Private (The workflow collection will be not listed.)')], default=False, verbose_name='Accessibility')),
                ('contributors', models.ManyToManyField(blank=True, help_text='users with edit permission to the workflow', related_name='workflow_contributors', related_query_name='contributor', to=settings.AUTH_USER_MODEL, verbose_name='Contributors')),
                ('owners', models.ManyToManyField(blank=True, default=None, related_name='workflow_owners', related_query_name='owners', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='WorkflowStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('add_date', models.DateTimeField(auto_now_add=True, verbose_name='date published')),
                ('modify_date', models.DateTimeField(auto_now=True, verbose_name='date modified')),
                ('msg', snakeface.apps.main.models.JSONField(default='{}')),
                ('workflow', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.Workflow')),
            ],
        ),
    ]
