"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
describe('GitHub Repository', () => {
    let stack;
    beforeEach(() => {
        const app = new cdk.App();
        stack = new cdk.Stack(app, 'GitHubDemo');
    });
    test('create', () => {
        new lib_1.GitHubRepository(stack, 'GitHubRepo', {
            owner: 'foo',
            repositoryName: 'bar',
            accessToken: cdk.SecretValue.secretsManager('my-github-token', {
                jsonField: 'token',
            }),
            contentsBucket: aws_s3_1.Bucket.fromBucketName(stack, 'Bucket', 'bucket-name'),
            contentsKey: 'import.zip',
        });
        expect(stack).toHaveResource('AWS::CodeStar::GitHubRepository', {
            RepositoryAccessToken: '{{resolve:secretsmanager:my-github-token:SecretString:token::}}',
            RepositoryName: 'bar',
            RepositoryOwner: 'foo',
            Code: {
                S3: {
                    Bucket: 'bucket-name',
                    Key: 'import.zip',
                },
            },
        });
    });
    test('enable issues and private', () => {
        new lib_1.GitHubRepository(stack, 'GitHubRepo', {
            owner: 'foo',
            repositoryName: 'bar',
            accessToken: cdk.SecretValue.secretsManager('my-github-token', {
                jsonField: 'token',
            }),
            contentsBucket: aws_s3_1.Bucket.fromBucketName(stack, 'Bucket', 'bucket-name'),
            contentsKey: 'import.zip',
            enableIssues: true,
            visibility: lib_1.RepositoryVisibility.PRIVATE,
        });
        expect(stack).toHaveResourceLike('AWS::CodeStar::GitHubRepository', {
            EnableIssues: true,
            IsPrivate: true,
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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