"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepositoryVisibility = exports.GitHubRepository = void 0;
const cdk = require("@aws-cdk/core");
const codestar = require("./codestar.generated");
/**
 * The GitHubRepository resource
 */
class GitHubRepository extends cdk.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const resource = new codestar.CfnGitHubRepository(this, 'Resource', {
            repositoryOwner: props.owner,
            repositoryName: props.repositoryName,
            repositoryAccessToken: props.accessToken.toString(),
            code: {
                s3: {
                    bucket: props.contentsBucket.bucketName,
                    key: props.contentsKey,
                    objectVersion: props.contentsS3Version,
                },
            },
            enableIssues: (_a = props.enableIssues) !== null && _a !== void 0 ? _a : true,
            isPrivate: props.visibility === RepositoryVisibility.PRIVATE ? true : false,
            repositoryDescription: props.description,
        });
        this.owner = cdk.Fn.select(0, cdk.Fn.split('/', resource.ref));
        this.repo = cdk.Fn.select(1, cdk.Fn.split('/', resource.ref));
    }
}
exports.GitHubRepository = GitHubRepository;
/**
 * Visibility of the GitHubRepository
 */
var RepositoryVisibility;
(function (RepositoryVisibility) {
    /**
     * private repository
     */
    RepositoryVisibility[RepositoryVisibility["PRIVATE"] = 0] = "PRIVATE";
    /**
     * public repository
     */
    RepositoryVisibility[RepositoryVisibility["PUBLIC"] = 1] = "PUBLIC";
})(RepositoryVisibility = exports.RepositoryVisibility || (exports.RepositoryVisibility = {}));
//# sourceMappingURL=data:application/json;base64,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