# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pynfogen', 'pynfogen.cli', 'pynfogen.tracks']

package_data = \
{'': ['*']}

install_requires = \
['Unidecode>=1.2.0,<2.0.0',
 'appdirs>=1.4.4,<2.0.0',
 'click-default-group>=1.2.2,<2.0.0',
 'click>=8.0.0,<9.0.0',
 'dunamai>=1.5.5,<2.0.0',
 'jsonpickle>=2.1.0,<3.0.0',
 'langcodes[data]>=3.3.0,<4.0.0',
 'pyd2v>=1.3.0,<2.0.0',
 'pymediainfo>=5.1.0,<6.0.0',
 'requests>=2.25.1,<3.0.0',
 'tldextract>=3.1.2,<4.0.0']

entry_points = \
{'console_scripts': ['nfo = pynfogen.cli:cli']}

setup_kwargs = {
    'name': 'pynfogen',
    'version': '1.1.2',
    'description': 'Scriptable MediaInfo-fed NFO Generator for Movies and TV',
    'long_description': '# pynfogen\n\n[![License](https://img.shields.io/github/license/rlaphoenix/pynfogen)](https://github.com/rlaphoenix/pynfogen/blob/master/LICENSE)\n[![Python version tests](https://img.shields.io/github/workflow/status/rlaphoenix/pynfogen/ci)](https://github.com/rlaphoenix/pynfogen/releases)\n[![Python versions](https://img.shields.io/pypi/pyversions/pynfogen)](https://pypi.python.org/pypi/pynfogen)\n[![PyPI version](https://img.shields.io/pypi/v/pynfogen)](https://pypi.python.org/pypi/pynfogen)\n[![GitHub issues](https://img.shields.io/github/issues/rlaphoenix/pynfogen)](https://github.com/rlaphoenix/pynfogen/issues)\n[![DeepSource issues](https://deepsource.io/gh/rlaphoenix/pynfogen.svg/?label=active+issues)](https://deepsource.io/gh/rlaphoenix/pynfogen)\n\nScriptable MediaInfo-fed NFO Generator for Movies and TV.\n\n## Installation\n\n    pip install --user pynfogen\n\n## Development\n\n### Dependencies\n\n- [Python](https://python.org/downloads) (v3.6 or newer)\n- [PIP](https://pip.pypa.io/en/stable/installing) (v19.0 or newer)\n- [Poetry](https://python-poetry.org/docs) (latest recommended)\n\n### Installation\n\n1. `git clone https://github.com/rlaphoenix/pynfogen`\n2. `cd pynfogen`\n3. `poetry config virtualenvs.in-project true` (optional, but recommended)\n4. `poetry install`\n5. `nfo -h`\n\n## F.A.Q\n\nUsing pynfogen is fairly simple, it\'s a multi-command CLI program. You can see up-to-date help information by\nrunning `nfo --help`, or reading the readme file.\n\nOn initial installation, you won\'t have any [Artwork](#artwork) or [Templates](#templates), which are needed. You can\ntake a look at some examples at [/examples/art](/examples/art) and [/examples/templates](/examples/templates) in the\ngit. You may also want to take a look at [Configuration](#configuration).\n\nOnce you have everything set up as much as you want, simply take a look at the available commands with `nfo --help`.\nThe main command you want to take a look at would be `nfo generate -h`, which will create NFO and Description files\nbased on *one* provided video file.\n\nWhat is an NFO and Description file, you may ask? tl-dr; Think of an NFO as a Receipt with information about your\nrelease to be shared alongside it, and a Description file as the body for your post, thread, topic, message, or\nsuch. You could also think of a Description file as an alternative output you could use.\n\nMore information can be found in the sections below.\n\n### What is an NFO?\n\nAn NFO (aka .nfo, .NFO, a contraction of "Info" or "Information") is a commonly used filename extension for text files\nthat accompany various releases with information about them.\n\nThey are for delivering release information about the media, such as the title, release date, authorship, etc. They\nalso commonly contain elaborate [ANSI art](https://en.wikipedia.org/wiki/ANSI_art).\n\nAn NFO is generally archaic, do not think otherwise. Originally, NFO files would be shared through IRC, Usenet,\nEmail, etc. However, these days, most platforms do not allow NFO files to be shared with the release itself, but\nrather within a forum thread or post. NFOs are becoming more and more phased out in P2P sharing, but still remains\nin use in some cases.\n\nWhile there isn\'t any hard-rules, If you plan to create a modern-style NFO then the following is recommended:\n\n- Max line-length of 70 characters.\n- Text should not reach the edge of the file (col. 1 and 70), instead it should be padded by spacing or ANSI art.\n- Text-encoding should be UTF-8 and not CP437. CP437 is far too restricted compared to UTF-8.\n\nNote that, elaborate ANSI art is no longer really used or wanted. Modern NFO files tend to be verbose with minimal\nANSI art, rather than concise with elaborate ANSI art.\n\n### What is a Description file?\n\nIt\'s like an NFO, without any rules whatsoever. You can use a description template as an alternative output to the NFO\noutput. This alternative output can be used for any purpose you like, but most commonly used for forum posts, IRC\nmessages, and such.\n\n### What file should I pass to `nfo generate`?\n\nIt\'s best-practice to provide the first-most file that best represents the majority of the release. E.g., If Episode 1\nand 2 has a fault not found on Episodes 3 onwards, then provide Episode 3.\n\n### What Text-encoding is supported?\n\nThe input file templates and artwork must be UTF-8. The output generated files\' text-encoding can be chosen by you,\nbut defaults to UTF-8.\n\nTo choose a text-encoding for the output, see `-e/--encoding` of `nfo generate`. This can also be set in the config\nwith `nfo config generate.encoding cp437` (sets to CP437).\n\nNFOs with elaborate ANSI art may need to use CP437 text-encoding, where-as any other NFO can get away with just about\nany encoding. The default UTF-8 will work fine for most scenarios. However, some applications or websites may require\nyour NFO to be a specific text-encoding, which is usually either CP437 or UTF-8.\n\n### How is it detecting or getting ...?\n\n#### Database IDs (IMDB, TMDB, TVDB)\n\nCLI options (`-imdb`, `-tmdb`, `-tvdb`), the Config, or the provided file\'s global tags (in that order).\n\n#### Title Name and Year\n\nThe IMDB page\'s `<title>` tag for the provided IMDB ID.\n\n#### Release Name\n\nSeason releases get it from the parent folder name of the provided file.\nMovie and Episode releases get it from the filename.\n\n#### Preview Images\n\nIt scrapes the provided Preview URL (`-P`) for thumbnail and full image URLs.\nThe Preview URL must be for a Gallery or Album.\nSupported hosts:\n\n- <https://imgbox.com>\n- <https://beyondhd.co>\n\n#### Banner Image\n\nThe Fanart.tv API if a TVDB ID has been provided, and a Fanart.tv API key has been set.\nIt only returns banners that match the language of the primary Audio tracks language.\n\n#### Season Episode Count\n\nIt counts the amount of neighbouring files of the same file-extension as the provided file. Make sure all files\nmatching this check is going to be part of the release as an episode file, or the episode count will be inaccurate.\n\n## Templates\n\n| Type                 | Description                                                                        | File Extension |\n| -------------------- | ---------------------------------------------------------------------------------- | -------------- |\n| NFO Template         | Primary Scriptable, structural data, like the Title, Year, Media Information, etc. | .nfo           |\n| Description Template | Similar to NFO templates, but for the content of a forum post, IRC message, etc.   | .desc.txt      |\n\nYou can add, delete, edit, and list templates with `nfo template -h`.\n\nTip: If you notice you are copying and pasting something between templates that is not structural or media information,\nthen you should probably put it into an [Artwork](#artwork) instead.\n\n## Artwork\n\nArtworks are for surrounding an NFO templates generated output with artwork or common text. Artwork templates aren\'t\ncurrently applied to Description templates.\n\nYou can add, delete, edit, and list artwork with `nfo artwork -h`.\n\n**Important:**\nThe provided example Artwork files are for viewing and studying only, for more information see their\n[LICENSE](/examples/art/LICENSE).\n\n## Configuration\n\nAll configuration values is entirely optional, but may require to be set to enable some features.\n\nConfiguration values can be set with `nfo config`, e.g., `nfo config generate.artwork phoenix`.\nSee `nfo config -h` for more information.\n\n| Config Key     | Description                                                                   |\n| -------------- | ----------------------------------------------------------------------------- |\n| fanart_api_key | A Fanart.tv API Key to use for the fanart banner image (if available)         |\n| generate.*     | Allows you to set a default for any of the arguments in use by `nfo generate` |\n\n## Scripting\n\nThe scripting system used by pynfogen is by no means ideal. It is however, consistent.\nIt\'s mostly a mix of python\'s normal new-style string formatting, with custom formatters.\nIt also uses a PHP-like `<?{x:y}..?>` custom syntax for if statements.\n\nScripting is generally not recommended to be used within Artwork templates.\n\n### If statement\n\nFor example the following will check if the `{note}` variable (python new-style formatting) is a truthy value,\nand only if so, print it:\n\n    # note = "Hello World!"\n    <?{note:true}?Has note: {note}?>\n    # returns: `Has note: Hello World!`\n\n    # note = ""  # or None, 0, False, 1==2, e.t.c\n    <?{note:true}?Has note: {note}?>\n    # returns: ``\n\nIt\'s obvious this is in no way good syntax for `if` statements (no `else` or `elif` support either), but it works.\n\nIt uses `1` and `0` in the `<?{here}?...>` section to determine if it should print or not.\nEssentially speaking any time the If statement is used, you should be using the [Boolean custom formatter](#boolean).\n\n### Custom Formatting\n\nThe following custom additional formatting to pythons new-style formatting is available:\n\n#### Chaining\n\nExample: `{var:bbimg:layout,2x2x0}`\n\nUsing `:` you can chain formatter results from left to right, passing previous value as it goes on.\nThe previous value does not necessarily need to be used.\n\nFor less confusion, since `:` is already used as standard in new-string formatting, look at the above example as\n`{(var:bbimg):(layout,2x2x0)}`\n\n#### Boolean\n\nExample: `{var:true}` or `{var:!false}`.  \nType-hint: func(var: Any) -> Fixed\\[1, 0]\n\nReturns `1` if `var` is a truthy value, otherwise `0`.\n\nThere\'s also `{var:false}` and `{var:!true}` which is the flip-reverse of the above result.\n\n#### BBCode Image Links\n\nExample: `{var:bbimg}`  \nType-hint: bbimg(var: Union\\[List\\[dict], dict]) -> Union\\[List\\[str], str]  \nEach dictionary: e.g. `{url: \'https://url/to/image/page\', src: \'https://url/to/image/src.png\'}`\n\nEvery dictionary is converted to BBCode `[IMG]` wrapped in `[URL]`. For example:\n`[URL=https://url/to/image/page][IMG]https://url/to/image/src.png[/IMG][/URL]`\n\nReturns a list of converted bbcode strings, or a single string if only one dictionary was provided.\n\n#### Layout\n\nExample: `{var:layout,3x2x1}`  \nType-hint: layout(var: Union\\[List\\[Any], Any], width: int, height: int, spacing: int) -> str\n\nLays out items in a grid-like layout, spacing out items using spaces (or new lines) as specified.\nNew-lines are used when spacing vertically.\n\n#### Wrapping\n\nExample: `{var:>>2x68}`  \nType-hint: wrap(var: Any, indent: int, wrap: int)\n\nText-wrap to a specific length. Each subsequent new-line caused by the wrapping can be intended (or not if 0).\n\n#### Centering\n\nExample: `{var:^>70x68}`  \nType-hint: center(var: Any, centering: int, wrap: int)\n\nCenters and also Text-wraps (while also centering wraps) to a specific width.\n\n## Contribute\n\nPlease do contribute! Issues, pull requests, and discussion topics are welcome.\n\nThank you to anyone who helps contribute to the project!\n',
    'author': 'PHOENiX',
    'author_email': 'rlaphoenix@pm.me',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/rlaphoenix/pynfogen',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
