"use strict";
const lib_1 = require("../lib");
module.exports = {
    "default parameterGroupFamily for versionless Aurora cluster engine is 'aurora5.6'"(test) {
        // GIVEN
        const engine = lib_1.DatabaseClusterEngine.AURORA;
        // WHEN
        const family = engine.parameterGroupFamily;
        // THEN
        test.equals(family, 'aurora5.6');
        test.done();
    },
    "default parameterGroupFamily for versionless Aurora MySQL cluster engine is 'aurora-mysql5.7'"(test) {
        // GIVEN
        const engine = lib_1.DatabaseClusterEngine.AURORA_MYSQL;
        // WHEN
        const family = engine.parameterGroupFamily;
        // THEN
        test.equals(family, 'aurora-mysql5.7');
        test.done();
    },
    'default parameterGroupFamily for versionless Aurora PostgreSQL is not defined'(test) {
        // GIVEN
        const engine = lib_1.DatabaseClusterEngine.AURORA_POSTGRESQL;
        // WHEN
        const family = engine.parameterGroupFamily;
        // THEN
        test.equals(family, undefined);
        test.done();
    },
    'cluster parameter group correctly determined for AURORA and given version'(test) {
        // GIVEN
        const engine = lib_1.DatabaseClusterEngine.aurora({
            version: lib_1.AuroraEngineVersion.VER_1_22_2,
        });
        // WHEN
        const family = engine.parameterGroupFamily;
        // THEN
        test.equals(family, 'aurora5.6');
        test.done();
    },
    'cluster parameter group correctly determined for AURORA_MYSQL and given version'(test) {
        // GIVEN
        const engine = lib_1.DatabaseClusterEngine.auroraMysql({
            version: lib_1.AuroraMysqlEngineVersion.VER_2_07_1,
        });
        // WHEN
        const family = engine.parameterGroupFamily;
        // THEN
        test.equals(family, 'aurora-mysql5.7');
        test.done();
    },
    'cluster parameter group correctly determined for AURORA_POSTGRESQL and given version'(test) {
        // GIVEN
        const engine = lib_1.DatabaseClusterEngine.auroraPostgres({
            version: lib_1.AuroraPostgresEngineVersion.VER_11_6,
        });
        // WHEN
        const family = engine.parameterGroupFamily;
        // THEN
        test.equals(family, 'aurora-postgresql11');
        test.done();
    },
    'parameter group family'(test) {
        // the PostgreSQL engine knows about the following major versions: 9.6, 10 and 11
        test.equals(lib_1.DatabaseClusterEngine.auroraPostgres({ version: lib_1.AuroraPostgresEngineVersion.of('8', '8') }).parameterGroupFamily, 'aurora-postgresql8');
        test.equals(lib_1.DatabaseClusterEngine.auroraPostgres({ version: lib_1.AuroraPostgresEngineVersion.of('9', '9') }).parameterGroupFamily, 'aurora-postgresql9');
        test.equals(lib_1.DatabaseClusterEngine.auroraPostgres({ version: lib_1.AuroraPostgresEngineVersion.of('9.7', '9.7') }).parameterGroupFamily, 'aurora-postgresql9.7');
        test.equals(lib_1.DatabaseClusterEngine.auroraPostgres({ version: lib_1.AuroraPostgresEngineVersion.of('9.6', '9.6') }).parameterGroupFamily, 'aurora-postgresql9.6');
        test.equals(lib_1.DatabaseClusterEngine.auroraPostgres({ version: lib_1.AuroraPostgresEngineVersion.of('9.6.1', '9.6') }).parameterGroupFamily, 'aurora-postgresql9.6');
        test.equals(lib_1.DatabaseClusterEngine.auroraPostgres({ version: lib_1.AuroraPostgresEngineVersion.of('10.0', '10') }).parameterGroupFamily, 'aurora-postgresql10');
        test.done();
    },
    'supported log types'(test) {
        const mysqlLogTypes = ['error', 'general', 'slowquery', 'audit'];
        test.deepEqual(lib_1.DatabaseClusterEngine.aurora({ version: lib_1.AuroraEngineVersion.VER_1_22_2 }).supportedLogTypes, mysqlLogTypes);
        test.deepEqual(lib_1.DatabaseClusterEngine.auroraMysql({ version: lib_1.AuroraMysqlEngineVersion.VER_2_08_1 }).supportedLogTypes, mysqlLogTypes);
        test.deepEqual(lib_1.DatabaseClusterEngine.auroraPostgres({ version: lib_1.AuroraPostgresEngineVersion.VER_9_6_9 }).supportedLogTypes, ['postgresql']);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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