import io
from veriloghex import VerilogHex

bin8 = bytearray.fromhex(
    """
    00 00 22 00 75 01 00 00 71 01 00 00 6D 01 00 00
    71 01 00 00 71 01 00 00 71 01 00 00 00 00 00 00
    00 00 00 00 00 00 00 00 00 00 00 00 71 01 00 00
    71 01 00 00 00 00 00 00 71 01 00 00 71 01 00 00
    71 01 00 00 03 48 04 4B 83 42 02 D0 03 4B 03 B1
    18 47 70 47 80 00 20 00 80 00 20 00 00 00 00 00
    05 48 06 4B 1B 1A D9 0F 01 EB A3 01 49 10 02 D0
    03 4B 03 B1 18 47 70 47 80 00 20 00 80 00 20 00
    00 00 00 00 10 B5 06 4C 23 78 43 B9 FF F7 DA FF
    04 4B 13 B1 04 48 AF F3 00 80 01 23 23 70 10 BD
    80 00 20 00 00 00 00 00 34 0D 00 00 08 B5 05 4B
    1B B1 05 49 05 48 AF F3 00 80 BD E8 08 40 FF F7
    CF BF 00 BF 00 00 00 00 84 00 20 00 34 0D 00 00
    A3 F5 80 3A 70 47 00 BF 17 4B 00 2B 08 BF 13 4B
    9D 46 FF F7 F5 FF 00 21 8B 46 0F 46 13 48 14 4A
    12 1A 00 F0 41 F9 0E 4B 00 2B 00 D0 98 47 0D 4B
    00 2B 00 D0 98 47 00 20 00 21 04 00 0D 00 0D 48
    00 28 02 D0 0C 48 AF F3 00 80 00 F0 09 F9 20 00
    29 00 00 F0 9B F8 00 F0 EF F8 00 BF 00 00 08 00
    00 00 00 00 00 00 00 00 00 00 22 00 80 00 20 00
    AC 00 20 00 00 00 00 00 00 00 00 00 03 48 04 49
    04 4B 05 4A 88 60 1A 60 70 47 00 BF 00 00 00 00
    00 ED 00 E0 10 00 20 00 00 87 93 03 FE E7 00 BF
    FE E7 00 BF 08 B5 1F 4B 83 F3 09 88 FF F7 E6 FF
    1D 4C 1E 4A A2 42 14 D2 0C 32 52 F8 04 3C 94 46
    5B B1 00 23 52 E9 03 01 50 F8 23 00 41 F8 23 00
    52 F8 04 1C 01 33 8B 42 F4 D3 A4 45 02 F1 0C 02
    EB D3 13 4A 13 4B 9A 42 1A D2 00 20 03 F1 FF 3C
    AC EB 02 0C 02 F1 10 03 2C F0 07 0C 08 32 9C 44
    52 F8 04 3C 4B B1 00 23 52 F8 08 1C 41 F8 23 00
    52 F8 04 1C 01 33 8B 42 F6 D3 08 32 94 45 EF D1
    FF F7 72 FF 00 00 22 00 4C 0D 00 00 40 0D 00 00
    4C 0D 00 00 4C 0D 00 00 0E B4 10 B5 C3 B0 45 AB
    53 F8 04 2B 04 46 4F F4 80 71 02 A8 01 93 00 F0
    DF F8 10 F1 03 0C 48 BF 00 F1 06 0C 00 28 4F EA
    AC 0C 0A DD 00 23 4F F4 00 1E 02 AA 52 F8 04 1B
    01 33 9C 45 CE F8 04 10 F8 DC 4F F4 00 13 1C 60
    43 B0 BD E8 10 40 03 B0 70 47 00 BF 2D E9 F8 43
    40 F2 71 29 4F F0 02 08 00 27 03 20 1E 49 FF F7
    CB FF 03 20 1D 49 FF F7 C7 FF 4F F0 60 42 4F F0
    0F 0E 01 20 1A 4B 1B 49 C3 F8 10 90 C3 F8 F0 80
    C3 F8 04 73 D1 F8 FC 30 17 4D 18 4E 18 4C DF F8
    64 C0 43 F0 80 73 C1 F8 FC 30 2E 60 C2 F8 B0 4F
    C2 F8 40 EE C2 F8 80 CE C2 F8 00 0E 41 21 02 E0
    01 31 5B 29 FA D0 D2 F8 80 3E D8 07 F8 D5 D2 F8
    00 3E DB 07 F4 D5 13 68 1B B9 00 BF 13 68 00 2B
    FB D0 CB B2 13 70 EB E7 C4 0C 00 00 D0 0C 00 00
    00 00 04 E0 00 ED 00 E0 00 10 00 E0 FE 03 00 40
    55 CE AC C5 0D 00 01 00 08 B5 07 4B 04 46 13 B1
    00 21 AF F3 00 80 05 4B 18 68 83 6A 03 B1 98 47
    20 46 00 F0 C1 FC 00 BF 00 00 00 00 FC 0C 00 00
    70 B5 00 26 0C 4D 0D 4C 64 1B A4 10 A6 42 09 D1
    00 F0 B4 FC 00 26 0A 4D 0A 4C 64 1B A4 10 A6 42
    05 D1 70 BD 55 F8 04 3B 98 47 01 36 EE E7 55 F8
    04 3B 98 47 01 36 F2 E7 78 00 20 00 78 00 20 00
    78 00 20 00 7C 00 20 00 03 46 02 44 93 42 00 D1
    70 47 03 F8 01 1B F9 E7 30 B5 14 46 00 2C 05 46
    1A 46 9B B0 05 DA 8B 23 03 60 4F F0 FF 30 1B B0
    30 BD 4F F4 02 73 AD F8 0C 30 0C BF 23 46 04 F1
    FF 33 02 93 05 93 4F F6 FF 73 00 91 04 91 AD F8
    0E 30 69 46 1E 9B 00 F0 73 F8 43 1C BC BF 8B 23
    2B 60 00 2C E3 D0 00 22 00 9B 1A 70 DF E7 00 00
    07 B5 00 93 13 46 0A 46 01 46 03 48 00 68 FF F7
    CB FF 03 B0 5D F8 04 FB 14 00 20 00 2D E9 F0 47
    1F 46 8E 68 82 46 BE 42 0C 46 90 46 0B 68 2C D8
    8A 89 12 F4 90 6F 26 D0 65 69 09 69 05 EB 45 05
    A3 EB 01 09 05 EB D5 75 7B 1C 4B 44 6D 10 9D 42
    38 BF 1D 46 53 05 27 D5 29 46 00 F0 69 FB 06 46
    60 B3 4A 46 21 69 00 F0 D3 FA A3 89 23 F4 90 63
    43 F0 80 03 A3 81 26 61 4E 44 26 60 3E 46 65 61
    A5 EB 09 05 A5 60 BE 42 00 D9 3E 46 32 46 41 46
    20 68 00 F0 CB FA 00 20 A3 68 9B 1B A3 60 23 68
    33 44 23 60 BD E8 F0 87 2A 46 00 F0 B5 FB 06 46
    00 28 E0 D1 50 46 21 69 00 F0 D2 FA 0C 23 CA F8
    00 30 A3 89 4F F0 FF 30 43 F0 40 03 A3 81 E9 E7
    2D E9 F0 4F 98 46 8B 89 07 46 1B 06 0D 46 14 46
    9D B0 0E D5 0B 69 63 B9 40 21 00 F0 21 FB 28 60
    28 61 20 B9 0C 23 3B 60 4F F0 FF 30 D0 E0 40 23
    6B 61 00 23 09 93 20 23 8D F8 29 30 30 23 4F F0
    01 09 CD F8 0C 80 DF F8 A0 81 8D F8 2A 30 23 46
    9A 46 13 F8 01 2B 0A B1 25 2A F9 D1 BA EB 04 0B
    0B D0 5B 46 22 46 29 46 38 46 FF F7 6F FF 01 30
    00 F0 A9 80 09 9A 5A 44 09 92 9A F8 00 30 00 2B
    00 F0 A1 80 00 23 4F F0 FF 32 CD E9 05 23 0A F1
    01 0A 04 93 07 93 8D F8 53 30 1A 93 54 46 05 22
    14 F8 01 1B 50 48 00 F0 3D FA 04 9A D8 B9 D0 06
    44 BF 20 23 8D F8 53 30 11 07 44 BF 2B 23 8D F8
    53 30 9A F8 00 30 2A 2B 15 D0 54 46 00 20 4F F0
    0A 0C 07 9A 21 46 11 F8 01 3B 30 3B 09 2B 4D D9
    B0 B1 07 92 14 E0 A0 EB 08 03 09 FA 03 F3 13 43
    A2 46 04 93 D2 E7 03 9B 19 1D 1B 68 03 91 00 2B
    BB BF 5B 42 42 F0 02 02 07 93 07 93 B8 BF 04 92
    23 78 2E 2B 0C D1 63 78 2A 2B 34 D1 03 9B 02 34
    1A 1D 1B 68 03 92 00 2B B8 BF 4F F0 FF 33 05 93
    DF F8 B8 A0 03 22 50 46 21 78 00 F0 F3 F9 38 B1
    40 22 04 9B A0 EB 0A 00 82 40 13 43 01 34 04 93
    14 F8 01 1B 06 22 26 48 8D F8 28 10 00 F0 E2 F9
    00 28 38 D0 23 4B 1B BB 03 9B 07 33 23 F0 07 03
    08 33 03 93 09 9B 33 44 09 93 68 E7 0C 46 01 20
    0C FB 02 32 A6 E7 00 23 4F F0 0A 0C 19 46 01 34
    05 93 20 46 10 F8 01 2B 30 3A 09 2A 03 D9 00 2B
    C6 D0 05 91 C4 E7 04 46 01 23 0C FB 01 21 F0 E7
    03 AB 00 93 2A 46 38 46 0F 4B 04 A9 AF F3 00 80
    42 1C 06 46 D6 D1 AB 89 5B 06 3F F5 2D AF 09 98
    1D B0 BD E8 F0 8F 03 AB 00 93 2A 46 38 46 06 4B
    04 A9 00 F0 7D F8 EB E7 00 0D 00 00 06 0D 00 00
    0A 0D 00 00 00 00 00 00 FD 03 00 00 2D E9 F0 47
    16 46 99 46 8A 68 0B 69 07 46 93 42 B8 BF 13 46
    33 60 91 F8 43 20 0C 46 DD F8 20 80 0A B1 01 33
    33 60 23 68 99 06 42 BF 33 68 02 33 33 60 25 68
    15 F0 06 05 06 D1 04 F1 19 0A E3 68 32 68 9B 1A
    AB 42 2B DC 94 F8 43 20 13 1E 22 68 18 BF 01 23
    92 06 30 D4 49 46 38 46 04 F1 43 02 C0 47 01 30
    23 D0 23 68 22 69 03 F0 06 03 04 2B 14 BF 00 25
    33 68 4F F0 00 06 08 BF E5 68 04 F1 1A 04 08 BF
    ED 1A 54 F8 12 3C 08 BF 25 EA E5 75 93 42 C4 BF
    9B 1A ED 18 B5 42 1A D1 00 20 08 E0 01 23 52 46
    49 46 38 46 C0 47 01 30 03 D1 4F F0 FF 30 BD E8
    F0 87 01 35 C1 E7 30 20 E1 18 81 F8 43 00 5A 1C
    94 F8 45 10 22 44 02 33 82 F8 43 10 C2 E7 01 23
    22 46 49 46 38 46 C0 47 01 30 E6 D0 01 36 D9 E7
    2D E9 FF 47 0F 7E 91 46 78 2F 80 46 0C 46 9A 46
    0C 9D 01 F1 43 02 07 D8 62 2F 0A D8 00 2F 00 F0
    D5 80 58 2F 00 F0 C1 80 04 F1 42 05 84 F8 42 70
    3A E0 A7 F1 63 03 15 2B F6 D8 01 A1 51 F8 23 F0
    29 08 00 00 3D 08 00 00 B9 07 00 00 B9 07 00 00
    B9 07 00 00 B9 07 00 00 3D 08 00 00 B9 07 00 00
    B9 07 00 00 B9 07 00 00 B9 07 00 00 43 09 00 00
    69 08 00 00 FD 08 00 00 B9 07 00 00 B9 07 00 00
    65 09 00 00 B9 07 00 00 69 08 00 00 B9 07 00 00
    B9 07 00 00 05 09 00 00 2B 68 1A 1D 1B 68 2A 60
    04 F1 42 05 84 F8 42 30 01 23 A0 E0 20 68 2B 68
    07 06 03 F1 04 01 29 60 01 D5 1E 68 03 E0 46 06
    FB D5 B3 F9 00 60 00 2E 03 DA 2D 23 76 42 84 F8
    43 30 0A 23 59 48 12 E0 2B 68 20 68 19 1D 29 60
    05 06 01 D5 1E 68 02 E0 41 06 FB D5 1E 88 6F 2F
    0C BF 08 23 0A 23 51 48 00 21 84 F8 43 10 65 68
    00 2D A8 BF 21 68 A5 60 A4 BF 21 F0 04 01 21 60
    0E B9 00 2D 4B D0 15 46 B6 FB F3 F1 03 FB 11 67
    C7 5D 05 F8 01 7D 37 46 BB 42 0E 46 F4 D9 08 2B
    0B D1 23 68 DE 07 08 D5 23 69 61 68 99 42 DE BF
    30 23 05 F8 01 3C 05 F1 FF 35 52 1B 22 61 4B 46
    21 46 40 46 CD F8 00 A0 03 AA FF F7 DF FE 01 30
    4A D1 4F F0 FF 30 04 B0 BD E8 F0 87 23 68 43 F0
    20 03 23 60 78 27 32 48 84 F8 45 70 23 68 29 68
    1F 06 51 F8 04 6B 02 D4 5F 06 48 BF B6 B2 DF 07
    48 BF 43 F0 20 03 29 60 48 BF 23 60 1E B9 23 68
    23 F0 20 03 23 60 10 23 A6 E7 24 48 E4 E7 15 46
    BD E7 2B 68 26 68 18 1D 61 69 28 60 35 06 1B 68
    01 D5 19 60 02 E0 70 06 FB D5 19 80 00 23 15 46
    23 61 BC E7 2B 68 00 21 1A 1D 2A 60 1D 68 62 68
    28 46 00 F0 2F F8 08 B1 40 1B 60 60 63 68 23 61
    00 23 84 F8 43 30 AA E7 2A 46 49 46 40 46 23 69
    D0 47 01 30 AD D0 23 68 9B 07 13 D4 E0 68 03 9B
    98 42 B8 BF 18 46 A6 E7 01 23 32 46 49 46 40 46
    D0 47 01 30 9D D0 01 35 E3 68 03 99 5B 1A AB 42
    F2 DC EB E7 00 25 04 F1 19 06 F5 E7 11 0D 00 00
    22 0D 00 00 03 46 10 B5 C9 B2 02 44 93 42 18 46
    01 D1 00 20 03 E0 04 78 01 33 8C 42 F6 D1 10 BD
    0A 44 91 42 00 F1 FF 33 00 D1 70 47 10 B5 11 F8
    01 4B 91 42 03 F8 01 4F F9 D1 10 BD 88 42 10 B5
    01 EB 02 04 02 D9 84 42 23 46 07 D8 43 1E A1 42
    08 D0 11 F8 01 2B 03 F8 01 2F F8 E7 01 46 02 44
    8A 42 00 D1 10 BD 13 F8 01 4D 02 F8 01 4D F7 E7
    38 B5 05 46 00 29 40 D0 51 F8 04 3C 0C 1F 00 2B
    B8 BF E4 18 00 F0 10 F9 1C 4A 13 68 33 B9 63 60
    14 60 28 46 BD E8 38 40 00 F0 07 B9 A3 42 08 D9
    20 68 21 18 8B 42 01 BF 19 68 5B 68 09 18 21 60
    ED E7 1A 46 5B 68 0B B1 A3 42 FA D9 11 68 50 18
    A0 42 0B D1 20 68 01 44 50 18 83 42 11 60 E0 D1
    18 68 5B 68 08 44 10 60 53 60 DA E7 02 D9 0C 23
    2B 60 D6 E7 20 68 21 18 8B 42 01 BF 19 68 5B 68
    09 18 21 60 63 60 54 60 CB E7 38 BD 9C 00 20 00
    70 B5 0E 4E 0C 46 31 68 05 46 11 B9 00 F0 BC F8
    30 60 21 46 28 46 00 F0 B7 F8 43 1C 0A D0 C4 1C
    24 F0 03 04 A0 42 07 D0 21 1A 28 46 00 F0 AC F8
    01 30 01 D1 4F F0 FF 34 20 46 70 BD A0 00 20 00
    2D E9 F0 41 CD 1C 25 F0 03 05 08 35 0C 2D 38 BF
    0C 25 00 2D 07 46 01 DB A9 42 05 D9 0C 23 00 26
    3B 60 30 46 BD E8 F0 81 2E 4E 00 F0 9D F8 33 68
    1C 46 34 BB 29 46 38 46 FF F7 C2 FF 43 1C 04 46
    4D D1 34 68 26 46 00 2E 40 D1 23 68 31 46 38 46
    04 EB 03 08 00 F0 78 F8 80 45 3A D1 23 68 03 35
    ED 1A 25 F0 03 05 08 35 0C 2D 38 BF 0C 25 38 46
    29 46 FF F7 A5 FF 01 30 2B D0 23 68 2B 44 23 60
    0E E0 22 68 52 1B 1E D4 0B 2A 16 D9 61 19 A3 42
    25 60 18 BF 59 60 63 68 08 BF 31 60 62 51 4B 60
    38 46 04 F1 0B 06 00 F0 60 F8 26 F0 07 06 23 1D
    F2 1A B6 D0 9B 1B A3 50 B3 E7 62 68 A3 42 0C BF
    32 60 5A 60 EC E7 23 46 64 68 B2 E7 34 46 76 68
    B9 E7 0C 23 38 46 3B 60 00 F0 47 F8 A1 E7 25 60
    DE E7 00 BF 9C 00 20 00 2D E9 F0 41 80 46 14 46
    0E 46 21 B9 11 46 BD E8 F0 41 FF F7 81 BF 2A B9
    FF F7 16 FF 25 46 28 46 BD E8 F0 81 00 F0 2E F8
    84 42 07 46 02 D8 B4 EB 50 0F 12 D8 21 46 40 46
    FF F7 6E FF 05 46 00 28 ED D0 BC 42 22 46 31 46
    28 BF 3A 46 FF F7 D4 FE 31 46 40 46 FF F7 F8 FE
    E1 E7 35 46 DF E7 00 00 38 B5 00 23 05 4D 04 46
    08 46 2B 60 00 F0 12 F8 43 1C 02 D1 2B 68 03 B1
    23 60 38 BD A4 00 20 00 70 47 70 47 51 F8 04 3C
    18 1F 00 2B BC BF 0B 58 C0 18 70 47 04 4A 05 49
    13 68 00 2B 08 BF 0B 46 18 44 10 60 18 46 70 47
    A8 00 20 00 B0 00 20 00 FE E7 00 BF F8 B5 00 BF
    F8 BC 08 BC 9E 46 70 47 F8 B5 00 BF F8 BC 08 BC
    9E 46 70 47 54 65 73 74 3A 20 73 77 6F 00 00 00
    54 68 69 73 20 74 65 73 74 20 73 65 74 73 20 75
    70 20 74 68 65 20 53 57 4F 20 6F 75 74 70 75 74
    20 61 73 20 61 20 55 41 52 54 00 00 18 00 20 00
    23 2D 30 2B 20 00 68 6C 4C 00 65 66 67 45 46 47
    00 30 31 32 33 34 35 36 37 38 39 41 42 43 44 45
    46 00 30 31 32 33 34 35 36 37 38 39 61 62 63 64
    65 66 00 00 00 00 00 00 98 F3 FF 7F 01 00 00 00
    4C 0D 00 00 10 00 20 00 1C 00 00 00 00 87 93 03
    18 00 20 00 00 00 00 00 00 00 00 00 00 00 00 00
    00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
    00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
    00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
    00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
    00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
    00 00 00 00 AD 00 00 00 85 00 00 00 
    """
)

vmem8 = """
@00000000 00 00 22 00 75 01 00 00 71 01 00 00 6D 01 00 00 71 01 00 00 71 01 00
@00000017 00 71 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 71 01
@0000002E 00 00 71 01 00 00 00 00 00 00 71 01 00 00 71 01 00 00 71 01 00 00 03
@00000045 48 04 4B 83 42 02 D0 03 4B 03 B1 18 47 70 47 80 00 20 00 80 00 20 00
@0000005C 00 00 00 00 05 48 06 4B 1B 1A D9 0F 01 EB A3 01 49 10 02 D0 03 4B 03
@00000073 B1 18 47 70 47 80 00 20 00 80 00 20 00 00 00 00 00 10 B5 06 4C 23 78
@0000008A 43 B9 FF F7 DA FF 04 4B 13 B1 04 48 AF F3 00 80 01 23 23 70 10 BD 80
@000000A1 00 20 00 00 00 00 00 34 0D 00 00 08 B5 05 4B 1B B1 05 49 05 48 AF F3
@000000B8 00 80 BD E8 08 40 FF F7 CF BF 00 BF 00 00 00 00 84 00 20 00 34 0D 00
@000000CF 00 A3 F5 80 3A 70 47 00 BF 17 4B 00 2B 08 BF 13 4B 9D 46 FF F7 F5 FF
@000000E6 00 21 8B 46 0F 46 13 48 14 4A 12 1A 00 F0 41 F9 0E 4B 00 2B 00 D0 98
@000000FD 47 0D 4B 00 2B 00 D0 98 47 00 20 00 21 04 00 0D 00 0D 48 00 28 02 D0
@00000114 0C 48 AF F3 00 80 00 F0 09 F9 20 00 29 00 00 F0 9B F8 00 F0 EF F8 00
@0000012B BF 00 00 08 00 00 00 00 00 00 00 00 00 00 00 22 00 80 00 20 00 AC 00
@00000142 20 00 00 00 00 00 00 00 00 00 03 48 04 49 04 4B 05 4A 88 60 1A 60 70
@00000159 47 00 BF 00 00 00 00 00 ED 00 E0 10 00 20 00 00 87 93 03 FE E7 00 BF
@00000170 FE E7 00 BF 08 B5 1F 4B 83 F3 09 88 FF F7 E6 FF 1D 4C 1E 4A A2 42 14
@00000187 D2 0C 32 52 F8 04 3C 94 46 5B B1 00 23 52 E9 03 01 50 F8 23 00 41 F8
@0000019E 23 00 52 F8 04 1C 01 33 8B 42 F4 D3 A4 45 02 F1 0C 02 EB D3 13 4A 13
@000001B5 4B 9A 42 1A D2 00 20 03 F1 FF 3C AC EB 02 0C 02 F1 10 03 2C F0 07 0C
@000001CC 08 32 9C 44 52 F8 04 3C 4B B1 00 23 52 F8 08 1C 41 F8 23 00 52 F8 04
@000001E3 1C 01 33 8B 42 F6 D3 08 32 94 45 EF D1 FF F7 72 FF 00 00 22 00 4C 0D
@000001FA 00 00 40 0D 00 00 4C 0D 00 00 4C 0D 00 00 0E B4 10 B5 C3 B0 45 AB 53
@00000211 F8 04 2B 04 46 4F F4 80 71 02 A8 01 93 00 F0 DF F8 10 F1 03 0C 48 BF
@00000228 00 F1 06 0C 00 28 4F EA AC 0C 0A DD 00 23 4F F4 00 1E 02 AA 52 F8 04
@0000023F 1B 01 33 9C 45 CE F8 04 10 F8 DC 4F F4 00 13 1C 60 43 B0 BD E8 10 40
@00000256 03 B0 70 47 00 BF 2D E9 F8 43 40 F2 71 29 4F F0 02 08 00 27 03 20 1E
@0000026D 49 FF F7 CB FF 03 20 1D 49 FF F7 C7 FF 4F F0 60 42 4F F0 0F 0E 01 20
@00000284 1A 4B 1B 49 C3 F8 10 90 C3 F8 F0 80 C3 F8 04 73 D1 F8 FC 30 17 4D 18
@0000029B 4E 18 4C DF F8 64 C0 43 F0 80 73 C1 F8 FC 30 2E 60 C2 F8 B0 4F C2 F8
@000002B2 40 EE C2 F8 80 CE C2 F8 00 0E 41 21 02 E0 01 31 5B 29 FA D0 D2 F8 80
@000002C9 3E D8 07 F8 D5 D2 F8 00 3E DB 07 F4 D5 13 68 1B B9 00 BF 13 68 00 2B
@000002E0 FB D0 CB B2 13 70 EB E7 C4 0C 00 00 D0 0C 00 00 00 00 04 E0 00 ED 00
@000002F7 E0 00 10 00 E0 FE 03 00 40 55 CE AC C5 0D 00 01 00 08 B5 07 4B 04 46
@0000030E 13 B1 00 21 AF F3 00 80 05 4B 18 68 83 6A 03 B1 98 47 20 46 00 F0 C1
@00000325 FC 00 BF 00 00 00 00 FC 0C 00 00 70 B5 00 26 0C 4D 0D 4C 64 1B A4 10
@0000033C A6 42 09 D1 00 F0 B4 FC 00 26 0A 4D 0A 4C 64 1B A4 10 A6 42 05 D1 70
@00000353 BD 55 F8 04 3B 98 47 01 36 EE E7 55 F8 04 3B 98 47 01 36 F2 E7 78 00
@0000036A 20 00 78 00 20 00 78 00 20 00 7C 00 20 00 03 46 02 44 93 42 00 D1 70
@00000381 47 03 F8 01 1B F9 E7 30 B5 14 46 00 2C 05 46 1A 46 9B B0 05 DA 8B 23
@00000398 03 60 4F F0 FF 30 1B B0 30 BD 4F F4 02 73 AD F8 0C 30 0C BF 23 46 04
@000003AF F1 FF 33 02 93 05 93 4F F6 FF 73 00 91 04 91 AD F8 0E 30 69 46 1E 9B
@000003C6 00 F0 73 F8 43 1C BC BF 8B 23 2B 60 00 2C E3 D0 00 22 00 9B 1A 70 DF
@000003DD E7 00 00 07 B5 00 93 13 46 0A 46 01 46 03 48 00 68 FF F7 CB FF 03 B0
@000003F4 5D F8 04 FB 14 00 20 00 2D E9 F0 47 1F 46 8E 68 82 46 BE 42 0C 46 90
@0000040B 46 0B 68 2C D8 8A 89 12 F4 90 6F 26 D0 65 69 09 69 05 EB 45 05 A3 EB
@00000422 01 09 05 EB D5 75 7B 1C 4B 44 6D 10 9D 42 38 BF 1D 46 53 05 27 D5 29
@00000439 46 00 F0 69 FB 06 46 60 B3 4A 46 21 69 00 F0 D3 FA A3 89 23 F4 90 63
@00000450 43 F0 80 03 A3 81 26 61 4E 44 26 60 3E 46 65 61 A5 EB 09 05 A5 60 BE
@00000467 42 00 D9 3E 46 32 46 41 46 20 68 00 F0 CB FA 00 20 A3 68 9B 1B A3 60
@0000047E 23 68 33 44 23 60 BD E8 F0 87 2A 46 00 F0 B5 FB 06 46 00 28 E0 D1 50
@00000495 46 21 69 00 F0 D2 FA 0C 23 CA F8 00 30 A3 89 4F F0 FF 30 43 F0 40 03
@000004AC A3 81 E9 E7 2D E9 F0 4F 98 46 8B 89 07 46 1B 06 0D 46 14 46 9D B0 0E
@000004C3 D5 0B 69 63 B9 40 21 00 F0 21 FB 28 60 28 61 20 B9 0C 23 3B 60 4F F0
@000004DA FF 30 D0 E0 40 23 6B 61 00 23 09 93 20 23 8D F8 29 30 30 23 4F F0 01
@000004F1 09 CD F8 0C 80 DF F8 A0 81 8D F8 2A 30 23 46 9A 46 13 F8 01 2B 0A B1
@00000508 25 2A F9 D1 BA EB 04 0B 0B D0 5B 46 22 46 29 46 38 46 FF F7 6F FF 01
@0000051F 30 00 F0 A9 80 09 9A 5A 44 09 92 9A F8 00 30 00 2B 00 F0 A1 80 00 23
@00000536 4F F0 FF 32 CD E9 05 23 0A F1 01 0A 04 93 07 93 8D F8 53 30 1A 93 54
@0000054D 46 05 22 14 F8 01 1B 50 48 00 F0 3D FA 04 9A D8 B9 D0 06 44 BF 20 23
@00000564 8D F8 53 30 11 07 44 BF 2B 23 8D F8 53 30 9A F8 00 30 2A 2B 15 D0 54
@0000057B 46 00 20 4F F0 0A 0C 07 9A 21 46 11 F8 01 3B 30 3B 09 2B 4D D9 B0 B1
@00000592 07 92 14 E0 A0 EB 08 03 09 FA 03 F3 13 43 A2 46 04 93 D2 E7 03 9B 19
@000005A9 1D 1B 68 03 91 00 2B BB BF 5B 42 42 F0 02 02 07 93 07 93 B8 BF 04 92
@000005C0 23 78 2E 2B 0C D1 63 78 2A 2B 34 D1 03 9B 02 34 1A 1D 1B 68 03 92 00
@000005D7 2B B8 BF 4F F0 FF 33 05 93 DF F8 B8 A0 03 22 50 46 21 78 00 F0 F3 F9
@000005EE 38 B1 40 22 04 9B A0 EB 0A 00 82 40 13 43 01 34 04 93 14 F8 01 1B 06
@00000605 22 26 48 8D F8 28 10 00 F0 E2 F9 00 28 38 D0 23 4B 1B BB 03 9B 07 33
@0000061C 23 F0 07 03 08 33 03 93 09 9B 33 44 09 93 68 E7 0C 46 01 20 0C FB 02
@00000633 32 A6 E7 00 23 4F F0 0A 0C 19 46 01 34 05 93 20 46 10 F8 01 2B 30 3A
@0000064A 09 2A 03 D9 00 2B C6 D0 05 91 C4 E7 04 46 01 23 0C FB 01 21 F0 E7 03
@00000661 AB 00 93 2A 46 38 46 0F 4B 04 A9 AF F3 00 80 42 1C 06 46 D6 D1 AB 89
@00000678 5B 06 3F F5 2D AF 09 98 1D B0 BD E8 F0 8F 03 AB 00 93 2A 46 38 46 06
@0000068F 4B 04 A9 00 F0 7D F8 EB E7 00 0D 00 00 06 0D 00 00 0A 0D 00 00 00 00
@000006A6 00 00 FD 03 00 00 2D E9 F0 47 16 46 99 46 8A 68 0B 69 07 46 93 42 B8
@000006BD BF 13 46 33 60 91 F8 43 20 0C 46 DD F8 20 80 0A B1 01 33 33 60 23 68
@000006D4 99 06 42 BF 33 68 02 33 33 60 25 68 15 F0 06 05 06 D1 04 F1 19 0A E3
@000006EB 68 32 68 9B 1A AB 42 2B DC 94 F8 43 20 13 1E 22 68 18 BF 01 23 92 06
@00000702 30 D4 49 46 38 46 04 F1 43 02 C0 47 01 30 23 D0 23 68 22 69 03 F0 06
@00000719 03 04 2B 14 BF 00 25 33 68 4F F0 00 06 08 BF E5 68 04 F1 1A 04 08 BF
@00000730 ED 1A 54 F8 12 3C 08 BF 25 EA E5 75 93 42 C4 BF 9B 1A ED 18 B5 42 1A
@00000747 D1 00 20 08 E0 01 23 52 46 49 46 38 46 C0 47 01 30 03 D1 4F F0 FF 30
@0000075E BD E8 F0 87 01 35 C1 E7 30 20 E1 18 81 F8 43 00 5A 1C 94 F8 45 10 22
@00000775 44 02 33 82 F8 43 10 C2 E7 01 23 22 46 49 46 38 46 C0 47 01 30 E6 D0
@0000078C 01 36 D9 E7 2D E9 FF 47 0F 7E 91 46 78 2F 80 46 0C 46 9A 46 0C 9D 01
@000007A3 F1 43 02 07 D8 62 2F 0A D8 00 2F 00 F0 D5 80 58 2F 00 F0 C1 80 04 F1
@000007BA 42 05 84 F8 42 70 3A E0 A7 F1 63 03 15 2B F6 D8 01 A1 51 F8 23 F0 29
@000007D1 08 00 00 3D 08 00 00 B9 07 00 00 B9 07 00 00 B9 07 00 00 B9 07 00 00
@000007E8 3D 08 00 00 B9 07 00 00 B9 07 00 00 B9 07 00 00 B9 07 00 00 43 09 00
@000007FF 00 69 08 00 00 FD 08 00 00 B9 07 00 00 B9 07 00 00 65 09 00 00 B9 07
@00000816 00 00 69 08 00 00 B9 07 00 00 B9 07 00 00 05 09 00 00 2B 68 1A 1D 1B
@0000082D 68 2A 60 04 F1 42 05 84 F8 42 30 01 23 A0 E0 20 68 2B 68 07 06 03 F1
@00000844 04 01 29 60 01 D5 1E 68 03 E0 46 06 FB D5 B3 F9 00 60 00 2E 03 DA 2D
@0000085B 23 76 42 84 F8 43 30 0A 23 59 48 12 E0 2B 68 20 68 19 1D 29 60 05 06
@00000872 01 D5 1E 68 02 E0 41 06 FB D5 1E 88 6F 2F 0C BF 08 23 0A 23 51 48 00
@00000889 21 84 F8 43 10 65 68 00 2D A8 BF 21 68 A5 60 A4 BF 21 F0 04 01 21 60
@000008A0 0E B9 00 2D 4B D0 15 46 B6 FB F3 F1 03 FB 11 67 C7 5D 05 F8 01 7D 37
@000008B7 46 BB 42 0E 46 F4 D9 08 2B 0B D1 23 68 DE 07 08 D5 23 69 61 68 99 42
@000008CE DE BF 30 23 05 F8 01 3C 05 F1 FF 35 52 1B 22 61 4B 46 21 46 40 46 CD
@000008E5 F8 00 A0 03 AA FF F7 DF FE 01 30 4A D1 4F F0 FF 30 04 B0 BD E8 F0 87
@000008FC 23 68 43 F0 20 03 23 60 78 27 32 48 84 F8 45 70 23 68 29 68 1F 06 51
@00000913 F8 04 6B 02 D4 5F 06 48 BF B6 B2 DF 07 48 BF 43 F0 20 03 29 60 48 BF
@0000092A 23 60 1E B9 23 68 23 F0 20 03 23 60 10 23 A6 E7 24 48 E4 E7 15 46 BD
@00000941 E7 2B 68 26 68 18 1D 61 69 28 60 35 06 1B 68 01 D5 19 60 02 E0 70 06
@00000958 FB D5 19 80 00 23 15 46 23 61 BC E7 2B 68 00 21 1A 1D 2A 60 1D 68 62
@0000096F 68 28 46 00 F0 2F F8 08 B1 40 1B 60 60 63 68 23 61 00 23 84 F8 43 30
@00000986 AA E7 2A 46 49 46 40 46 23 69 D0 47 01 30 AD D0 23 68 9B 07 13 D4 E0
@0000099D 68 03 9B 98 42 B8 BF 18 46 A6 E7 01 23 32 46 49 46 40 46 D0 47 01 30
@000009B4 9D D0 01 35 E3 68 03 99 5B 1A AB 42 F2 DC EB E7 00 25 04 F1 19 06 F5
@000009CB E7 11 0D 00 00 22 0D 00 00 03 46 10 B5 C9 B2 02 44 93 42 18 46 01 D1
@000009E2 00 20 03 E0 04 78 01 33 8C 42 F6 D1 10 BD 0A 44 91 42 00 F1 FF 33 00
@000009F9 D1 70 47 10 B5 11 F8 01 4B 91 42 03 F8 01 4F F9 D1 10 BD 88 42 10 B5
@00000A10 01 EB 02 04 02 D9 84 42 23 46 07 D8 43 1E A1 42 08 D0 11 F8 01 2B 03
@00000A27 F8 01 2F F8 E7 01 46 02 44 8A 42 00 D1 10 BD 13 F8 01 4D 02 F8 01 4D
@00000A3E F7 E7 38 B5 05 46 00 29 40 D0 51 F8 04 3C 0C 1F 00 2B B8 BF E4 18 00
@00000A55 F0 10 F9 1C 4A 13 68 33 B9 63 60 14 60 28 46 BD E8 38 40 00 F0 07 B9
@00000A6C A3 42 08 D9 20 68 21 18 8B 42 01 BF 19 68 5B 68 09 18 21 60 ED E7 1A
@00000A83 46 5B 68 0B B1 A3 42 FA D9 11 68 50 18 A0 42 0B D1 20 68 01 44 50 18
@00000A9A 83 42 11 60 E0 D1 18 68 5B 68 08 44 10 60 53 60 DA E7 02 D9 0C 23 2B
@00000AB1 60 D6 E7 20 68 21 18 8B 42 01 BF 19 68 5B 68 09 18 21 60 63 60 54 60
@00000AC8 CB E7 38 BD 9C 00 20 00 70 B5 0E 4E 0C 46 31 68 05 46 11 B9 00 F0 BC
@00000ADF F8 30 60 21 46 28 46 00 F0 B7 F8 43 1C 0A D0 C4 1C 24 F0 03 04 A0 42
@00000AF6 07 D0 21 1A 28 46 00 F0 AC F8 01 30 01 D1 4F F0 FF 34 20 46 70 BD A0
@00000B0D 00 20 00 2D E9 F0 41 CD 1C 25 F0 03 05 08 35 0C 2D 38 BF 0C 25 00 2D
@00000B24 07 46 01 DB A9 42 05 D9 0C 23 00 26 3B 60 30 46 BD E8 F0 81 2E 4E 00
@00000B3B F0 9D F8 33 68 1C 46 34 BB 29 46 38 46 FF F7 C2 FF 43 1C 04 46 4D D1
@00000B52 34 68 26 46 00 2E 40 D1 23 68 31 46 38 46 04 EB 03 08 00 F0 78 F8 80
@00000B69 45 3A D1 23 68 03 35 ED 1A 25 F0 03 05 08 35 0C 2D 38 BF 0C 25 38 46
@00000B80 29 46 FF F7 A5 FF 01 30 2B D0 23 68 2B 44 23 60 0E E0 22 68 52 1B 1E
@00000B97 D4 0B 2A 16 D9 61 19 A3 42 25 60 18 BF 59 60 63 68 08 BF 31 60 62 51
@00000BAE 4B 60 38 46 04 F1 0B 06 00 F0 60 F8 26 F0 07 06 23 1D F2 1A B6 D0 9B
@00000BC5 1B A3 50 B3 E7 62 68 A3 42 0C BF 32 60 5A 60 EC E7 23 46 64 68 B2 E7
@00000BDC 34 46 76 68 B9 E7 0C 23 38 46 3B 60 00 F0 47 F8 A1 E7 25 60 DE E7 00
@00000BF3 BF 9C 00 20 00 2D E9 F0 41 80 46 14 46 0E 46 21 B9 11 46 BD E8 F0 41
@00000C0A FF F7 81 BF 2A B9 FF F7 16 FF 25 46 28 46 BD E8 F0 81 00 F0 2E F8 84
@00000C21 42 07 46 02 D8 B4 EB 50 0F 12 D8 21 46 40 46 FF F7 6E FF 05 46 00 28
@00000C38 ED D0 BC 42 22 46 31 46 28 BF 3A 46 FF F7 D4 FE 31 46 40 46 FF F7 F8
@00000C4F FE E1 E7 35 46 DF E7 00 00 38 B5 00 23 05 4D 04 46 08 46 2B 60 00 F0
@00000C66 12 F8 43 1C 02 D1 2B 68 03 B1 23 60 38 BD A4 00 20 00 70 47 70 47 51
@00000C7D F8 04 3C 18 1F 00 2B BC BF 0B 58 C0 18 70 47 04 4A 05 49 13 68 00 2B
@00000C94 08 BF 0B 46 18 44 10 60 18 46 70 47 A8 00 20 00 B0 00 20 00 FE E7 00
@00000CAB BF F8 B5 00 BF F8 BC 08 BC 9E 46 70 47 F8 B5 00 BF F8 BC 08 BC 9E 46
@00000CC2 70 47 54 65 73 74 3A 20 73 77 6F 00 00 00 54 68 69 73 20 74 65 73 74
@00000CD9 20 73 65 74 73 20 75 70 20 74 68 65 20 53 57 4F 20 6F 75 74 70 75 74
@00000CF0 20 61 73 20 61 20 55 41 52 54 00 00 18 00 20 00 23 2D 30 2B 20 00 68
@00000D07 6C 4C 00 65 66 67 45 46 47 00 30 31 32 33 34 35 36 37 38 39 41 42 43
@00000D1E 44 45 46 00 30 31 32 33 34 35 36 37 38 39 61 62 63 64 65 66 00 00 00
@00000D35 00 00 00 98 F3 FF 7F 01 00 00 00 4C 0D 00 00 10 00 20 00 1C 00 00 00
@00000D4C 00 87 93 03 18 00 20 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
@00000D63 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
@00000D7A 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
@00000D91 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
@00000DA8 00 00 00 00 00 00 00 00 00 00 00 00 AD 00 00 00 85 00 00 00
"""

vmem16 = """
@00000000 0000 0022 0175 0000 0171 0000 016D 0000 0171 0000 0171 0000 0171 0000
@0000000E 0000 0000 0000 0000 0000 0000 0000 0000 0171 0000 0171 0000 0000 0000
@0000001C 0171 0000 0171 0000 0171 0000 4803 4B04 4283 D002 4B03 B103 4718 4770
@0000002A 0080 0020 0080 0020 0000 0000 4805 4B06 1A1B 0FD9 EB01 01A3 1049 D002
@00000038 4B03 B103 4718 4770 0080 0020 0080 0020 0000 0000 B510 4C06 7823 B943
@00000046 F7FF FFDA 4B04 B113 4804 F3AF 8000 2301 7023 BD10 0080 0020 0000 0000
@00000054 0D34 0000 B508 4B05 B11B 4905 4805 F3AF 8000 E8BD 4008 F7FF BFCF BF00
@00000062 0000 0000 0084 0020 0D34 0000 F5A3 3A80 4770 BF00 4B17 2B00 BF08 4B13
@00000070 469D F7FF FFF5 2100 468B 460F 4813 4A14 1A12 F000 F941 4B0E 2B00 D000
@0000007E 4798 4B0D 2B00 D000 4798 2000 2100 0004 000D 480D 2800 D002 480C F3AF
@0000008C 8000 F000 F909 0020 0029 F000 F89B F000 F8EF BF00 0000 0008 0000 0000
@0000009A 0000 0000 0000 0022 0080 0020 00AC 0020 0000 0000 0000 0000 4803 4904
@000000A8 4B04 4A05 6088 601A 4770 BF00 0000 0000 ED00 E000 0010 0020 8700 0393
@000000B6 E7FE BF00 E7FE BF00 B508 4B1F F383 8809 F7FF FFE6 4C1D 4A1E 42A2 D214
@000000C4 320C F852 3C04 4694 B15B 2300 E952 0103 F850 0023 F841 0023 F852 1C04
@000000D2 3301 428B D3F4 45A4 F102 020C D3EB 4A13 4B13 429A D21A 2000 F103 3CFF
@000000E0 EBAC 0C02 F102 0310 F02C 0C07 3208 449C F852 3C04 B14B 2300 F852 1C08
@000000EE F841 0023 F852 1C04 3301 428B D3F6 3208 4594 D1EF F7FF FF72 0000 0022
@000000FC 0D4C 0000 0D40 0000 0D4C 0000 0D4C 0000 B40E B510 B0C3 AB45 F853 2B04
@0000010A 4604 F44F 7180 A802 9301 F000 F8DF F110 0C03 BF48 F100 0C06 2800 EA4F
@00000118 0CAC DD0A 2300 F44F 1E00 AA02 F852 1B04 3301 459C F8CE 1004 DCF8 F44F
@00000126 1300 601C B043 E8BD 4010 B003 4770 BF00 E92D 43F8 F240 2971 F04F 0802
@00000134 2700 2003 491E F7FF FFCB 2003 491D F7FF FFC7 F04F 4260 F04F 0E0F 2001
@00000142 4B1A 491B F8C3 9010 F8C3 80F0 F8C3 7304 F8D1 30FC 4D17 4E18 4C18 F8DF
@00000150 C064 F043 7380 F8C1 30FC 602E F8C2 4FB0 F8C2 EE40 F8C2 CE80 F8C2 0E00
@0000015E 2141 E002 3101 295B D0FA F8D2 3E80 07D8 D5F8 F8D2 3E00 07DB D5F4 6813
@0000016C B91B BF00 6813 2B00 D0FB B2CB 7013 E7EB 0CC4 0000 0CD0 0000 0000 E004
@0000017A ED00 E000 1000 E000 03FE 4000 CE55 C5AC 000D 0001 B508 4B07 4604 B113
@00000188 2100 F3AF 8000 4B05 6818 6A83 B103 4798 4620 F000 FCC1 BF00 0000 0000
@00000196 0CFC 0000 B570 2600 4D0C 4C0D 1B64 10A4 42A6 D109 F000 FCB4 2600 4D0A
@000001A4 4C0A 1B64 10A4 42A6 D105 BD70 F855 3B04 4798 3601 E7EE F855 3B04 4798
@000001B2 3601 E7F2 0078 0020 0078 0020 0078 0020 007C 0020 4603 4402 4293 D100
@000001C0 4770 F803 1B01 E7F9 B530 4614 2C00 4605 461A B09B DA05 238B 6003 F04F
@000001CE 30FF B01B BD30 F44F 7302 F8AD 300C BF0C 4623 F104 33FF 9302 9305 F64F
@000001DC 73FF 9100 9104 F8AD 300E 4669 9B1E F000 F873 1C43 BFBC 238B 602B 2C00
@000001EA D0E3 2200 9B00 701A E7DF 0000 B507 9300 4613 460A 4601 4803 6800 F7FF
@000001F8 FFCB B003 F85D FB04 0014 0020 E92D 47F0 461F 688E 4682 42BE 460C 4690
@00000206 680B D82C 898A F412 6F90 D026 6965 6909 EB05 0545 EBA3 0901 EB05 75D5
@00000214 1C7B 444B 106D 429D BF38 461D 0553 D527 4629 F000 FB69 4606 B360 464A
@00000222 6921 F000 FAD3 89A3 F423 6390 F043 0380 81A3 6126 444E 6026 463E 6165
@00000230 EBA5 0509 60A5 42BE D900 463E 4632 4641 6820 F000 FACB 2000 68A3 1B9B
@0000023E 60A3 6823 4433 6023 E8BD 87F0 462A F000 FBB5 4606 2800 D1E0 4650 6921
@0000024C F000 FAD2 230C F8CA 3000 89A3 F04F 30FF F043 0340 81A3 E7E9 E92D 4FF0
@0000025A 4698 898B 4607 061B 460D 4614 B09D D50E 690B B963 2140 F000 FB21 6028
@00000268 6128 B920 230C 603B F04F 30FF E0D0 2340 616B 2300 9309 2320 F88D 3029
@00000276 2330 F04F 0901 F8CD 800C F8DF 81A0 F88D 302A 4623 469A F813 2B01 B10A
@00000284 2A25 D1F9 EBBA 0B04 D00B 465B 4622 4629 4638 F7FF FF6F 3001 F000 80A9
@00000292 9A09 445A 9209 F89A 3000 2B00 F000 80A1 2300 F04F 32FF E9CD 2305 F10A
@000002A0 0A01 9304 9307 F88D 3053 931A 4654 2205 F814 1B01 4850 F000 FA3D 9A04
@000002AE B9D8 06D0 BF44 2320 F88D 3053 0711 BF44 232B F88D 3053 F89A 3000 2B2A
@000002BC D015 4654 2000 F04F 0C0A 9A07 4621 F811 3B01 3B30 2B09 D94D B1B0 9207
@000002CA E014 EBA0 0308 FA09 F303 4313 46A2 9304 E7D2 9B03 1D19 681B 9103 2B00
@000002D8 BFBB 425B F042 0202 9307 9307 BFB8 9204 7823 2B2E D10C 7863 2B2A D134
@000002E6 9B03 3402 1D1A 681B 9203 2B00 BFB8 F04F 33FF 9305 F8DF A0B8 2203 4650
@000002F4 7821 F000 F9F3 B138 2240 9B04 EBA0 000A 4082 4313 3401 9304 F814 1B01
@00000302 2206 4826 F88D 1028 F000 F9E2 2800 D038 4B23 BB1B 9B03 3307 F023 0307
@00000310 3308 9303 9B09 4433 9309 E768 460C 2001 FB0C 3202 E7A6 2300 F04F 0C0A
@0000031E 4619 3401 9305 4620 F810 2B01 3A30 2A09 D903 2B00 D0C6 9105 E7C4 4604
@0000032C 2301 FB0C 2101 E7F0 AB03 9300 462A 4638 4B0F A904 F3AF 8000 1C42 4606
@0000033A D1D6 89AB 065B F53F AF2D 9809 B01D E8BD 8FF0 AB03 9300 462A 4638 4B06
@00000348 A904 F000 F87D E7EB 0D00 0000 0D06 0000 0D0A 0000 0000 0000 03FD 0000
@00000356 E92D 47F0 4616 4699 688A 690B 4607 4293 BFB8 4613 6033 F891 2043 460C
@00000364 F8DD 8020 B10A 3301 6033 6823 0699 BF42 6833 3302 6033 6825 F015 0506
@00000372 D106 F104 0A19 68E3 6832 1A9B 42AB DC2B F894 2043 1E13 6822 BF18 2301
@00000380 0692 D430 4649 4638 F104 0243 47C0 3001 D023 6823 6922 F003 0306 2B04
@0000038E BF14 2500 6833 F04F 0600 BF08 68E5 F104 041A BF08 1AED F854 3C12 BF08
@0000039C EA25 75E5 4293 BFC4 1A9B 18ED 42B5 D11A 2000 E008 2301 4652 4649 4638
@000003AA 47C0 3001 D103 F04F 30FF E8BD 87F0 3501 E7C1 2030 18E1 F881 0043 1C5A
@000003B8 F894 1045 4422 3302 F882 1043 E7C2 2301 4622 4649 4638 47C0 3001 D0E6
@000003C6 3601 E7D9 E92D 47FF 7E0F 4691 2F78 4680 460C 469A 9D0C F101 0243 D807
@000003D4 2F62 D80A 2F00 F000 80D5 2F58 F000 80C1 F104 0542 F884 7042 E03A F1A7
@000003E2 0363 2B15 D8F6 A101 F851 F023 0829 0000 083D 0000 07B9 0000 07B9 0000
@000003F0 07B9 0000 07B9 0000 083D 0000 07B9 0000 07B9 0000 07B9 0000 07B9 0000
@000003FE 0943 0000 0869 0000 08FD 0000 07B9 0000 07B9 0000 0965 0000 07B9 0000
@0000040C 0869 0000 07B9 0000 07B9 0000 0905 0000 682B 1D1A 681B 602A F104 0542
@0000041A F884 3042 2301 E0A0 6820 682B 0607 F103 0104 6029 D501 681E E003 0646
@00000428 D5FB F9B3 6000 2E00 DA03 232D 4276 F884 3043 230A 4859 E012 682B 6820
@00000436 1D19 6029 0605 D501 681E E002 0641 D5FB 881E 2F6F BF0C 2308 230A 4851
@00000444 2100 F884 1043 6865 2D00 BFA8 6821 60A5 BFA4 F021 0104 6021 B90E 2D00
@00000452 D04B 4615 FBB6 F1F3 FB03 6711 5DC7 F805 7D01 4637 42BB 460E D9F4 2B08
@00000460 D10B 6823 07DE D508 6923 6861 4299 BFDE 2330 F805 3C01 F105 35FF 1B52
@0000046E 6122 464B 4621 4640 F8CD A000 AA03 F7FF FEDF 3001 D14A F04F 30FF B004
@0000047C E8BD 87F0 6823 F043 0320 6023 2778 4832 F884 7045 6823 6829 061F F851
@0000048A 6B04 D402 065F BF48 B2B6 07DF BF48 F043 0320 6029 BF48 6023 B91E 6823
@00000498 F023 0320 6023 2310 E7A6 4824 E7E4 4615 E7BD 682B 6826 1D18 6961 6028
@000004A6 0635 681B D501 6019 E002 0670 D5FB 8019 2300 4615 6123 E7BC 682B 2100
@000004B4 1D1A 602A 681D 6862 4628 F000 F82F B108 1B40 6060 6863 6123 2300 F884
@000004C2 3043 E7AA 462A 4649 4640 6923 47D0 3001 D0AD 6823 079B D413 68E0 9B03
@000004D0 4298 BFB8 4618 E7A6 2301 4632 4649 4640 47D0 3001 D09D 3501 68E3 9903
@000004DE 1A5B 42AB DCF2 E7EB 2500 F104 0619 E7F5 0D11 0000 0D22 0000 4603 B510
@000004EC B2C9 4402 4293 4618 D101 2000 E003 7804 3301 428C D1F6 BD10 440A 4291
@000004FA F100 33FF D100 4770 B510 F811 4B01 4291 F803 4F01 D1F9 BD10 4288 B510
@00000508 EB01 0402 D902 4284 4623 D807 1E43 42A1 D008 F811 2B01 F803 2F01 E7F8
@00000516 4601 4402 428A D100 BD10 F813 4D01 F802 4D01 E7F7 B538 4605 2900 D040
@00000524 F851 3C04 1F0C 2B00 BFB8 18E4 F000 F910 4A1C 6813 B933 6063 6014 4628
@00000532 E8BD 4038 F000 B907 42A3 D908 6820 1821 428B BF01 6819 685B 1809 6021
@00000540 E7ED 461A 685B B10B 42A3 D9FA 6811 1850 42A0 D10B 6820 4401 1850 4283
@0000054E 6011 D1E0 6818 685B 4408 6010 6053 E7DA D902 230C 602B E7D6 6820 1821
@0000055C 428B BF01 6819 685B 1809 6021 6063 6054 E7CB BD38 009C 0020 B570 4E0E
@0000056A 460C 6831 4605 B911 F000 F8BC 6030 4621 4628 F000 F8B7 1C43 D00A 1CC4
@00000578 F024 0403 42A0 D007 1A21 4628 F000 F8AC 3001 D101 F04F 34FF 4620 BD70
@00000586 00A0 0020 E92D 41F0 1CCD F025 0503 3508 2D0C BF38 250C 2D00 4607 DB01
@00000594 42A9 D905 230C 2600 603B 4630 E8BD 81F0 4E2E F000 F89D 6833 461C BB34
@000005A2 4629 4638 F7FF FFC2 1C43 4604 D14D 6834 4626 2E00 D140 6823 4631 4638
@000005B0 EB04 0803 F000 F878 4580 D13A 6823 3503 1AED F025 0503 3508 2D0C BF38
@000005BE 250C 4638 4629 F7FF FFA5 3001 D02B 6823 442B 6023 E00E 6822 1B52 D41E
@000005CC 2A0B D916 1961 42A3 6025 BF18 6059 6863 BF08 6031 5162 604B 4638 F104
@000005DA 060B F000 F860 F026 0607 1D23 1AF2 D0B6 1B9B 50A3 E7B3 6862 42A3 BF0C
@000005E8 6032 605A E7EC 4623 6864 E7B2 4634 6876 E7B9 230C 4638 603B F000 F847
@000005F6 E7A1 6025 E7DE BF00 009C 0020 E92D 41F0 4680 4614 460E B921 4611 E8BD
@00000604 41F0 F7FF BF81 B92A F7FF FF16 4625 4628 E8BD 81F0 F000 F82E 4284 4607
@00000612 D802 EBB4 0F50 D812 4621 4640 F7FF FF6E 4605 2800 D0ED 42BC 4622 4631
@00000620 BF28 463A F7FF FED4 4631 4640 F7FF FEF8 E7E1 4635 E7DF 0000 B538 2300
@0000062E 4D05 4604 4608 602B F000 F812 1C43 D102 682B B103 6023 BD38 00A4 0020
@0000063C 4770 4770 F851 3C04 1F18 2B00 BFBC 580B 18C0 4770 4A04 4905 6813 2B00
@0000064A BF08 460B 4418 6010 4618 4770 00A8 0020 00B0 0020 E7FE BF00 B5F8 BF00
@00000658 BCF8 BC08 469E 4770 B5F8 BF00 BCF8 BC08 469E 4770 6554 7473 203A 7773
@00000666 006F 0000 6854 7369 7420 7365 2074 6573 7374 7520 2070 6874 2065 5753
@00000674 204F 756F 7074 7475 6120 2073 2061 4155 5452 0000 0018 0020 2D23 2B30
@00000682 0020 6C68 004C 6665 4567 4746 3000 3231 3433 3635 3837 4139 4342 4544
@00000690 0046 3130 3332 3534 3736 3938 6261 6463 6665 0000 0000 0000 F398 7FFF
@0000069E 0001 0000 0D4C 0000 0010 0020 001C 0000 8700 0393 0018 0020 0000 0000
@000006AC 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000
@000006BA 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000
@000006C8 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000
@000006D6 0000 0000 0000 0000 00AD 0000 0085 0000
"""

vmem32 = """
@00000000 00220000 00000175 00000171 0000016D 00000171 00000171 00000171
@00000007 00000000 00000000 00000000 00000000 00000171 00000171 00000000
@0000000E 00000171 00000171 00000171 4B044803 D0024283 B1034B03 47704718
@00000015 00200080 00200080 00000000 4B064805 0FD91A1B 01A3EB01 D0021049
@0000001C B1034B03 47704718 00200080 00200080 00000000 4C06B510 B9437823
@00000023 FFDAF7FF B1134B04 F3AF4804 23018000 BD107023 00200080 00000000
@0000002A 00000D34 4B05B508 4905B11B F3AF4805 E8BD8000 F7FF4008 BF00BFCF
@00000031 00000000 00200084 00000D34 3A80F5A3 BF004770 2B004B17 4B13BF08
@00000038 F7FF469D 2100FFF5 460F468B 4A144813 F0001A12 4B0EF941 D0002B00
@0000003F 4B0D4798 D0002B00 20004798 00042100 480D000D D0022800 F3AF480C
@00000046 F0008000 0020F909 F0000029 F000F89B BF00F8EF 00080000 00000000
@0000004D 00000000 00220000 00200080 002000AC 00000000 00000000 49044803
@00000054 4A054B04 601A6088 BF004770 00000000 E000ED00 00200010 03938700
@0000005B BF00E7FE BF00E7FE 4B1FB508 8809F383 FFE6F7FF 4A1E4C1D D21442A2
@00000062 F852320C 46943C04 2300B15B 0103E952 0023F850 0023F841 1C04F852
@00000069 428B3301 45A4D3F4 020CF102 4A13D3EB 429A4B13 2000D21A 3CFFF103
@00000070 0C02EBAC 0310F102 0C07F02C 449C3208 3C04F852 2300B14B 1C08F852
@00000077 0023F841 1C04F852 428B3301 3208D3F6 D1EF4594 FF72F7FF 00220000
@0000007E 00000D4C 00000D40 00000D4C 00000D4C B510B40E AB45B0C3 2B04F853
@00000085 F44F4604 A8027180 F0009301 F110F8DF BF480C03 0C06F100 EA4F2800
@0000008C DD0A0CAC F44F2300 AA021E00 1B04F852 459C3301 1004F8CE F44FDCF8
@00000093 601C1300 E8BDB043 B0034010 BF004770 43F8E92D 2971F240 0802F04F
@0000009A 20032700 F7FF491E 2003FFCB F7FF491D F04FFFC7 F04F4260 20010E0F
@000000A1 491B4B1A 9010F8C3 80F0F8C3 7304F8C3 30FCF8D1 4E184D17 F8DF4C18
@000000A8 F043C064 F8C17380 602E30FC 4FB0F8C2 EE40F8C2 CE80F8C2 0E00F8C2
@000000AF E0022141 295B3101 F8D2D0FA 07D83E80 F8D2D5F8 07DB3E00 6813D5F4
@000000B6 BF00B91B 2B006813 B2CBD0FB E7EB7013 00000CC4 00000CD0 E0040000
@000000BD E000ED00 E0001000 400003FE C5ACCE55 0001000D 4B07B508 B1134604
@000000C4 F3AF2100 4B058000 6A836818 4798B103 F0004620 BF00FCC1 00000000
@000000CB 00000CFC 2600B570 4C0D4D0C 10A41B64 D10942A6 FCB4F000 4D0A2600
@000000D2 1B644C0A 42A610A4 BD70D105 3B04F855 36014798 F855E7EE 47983B04
@000000D9 E7F23601 00200078 00200078 00200078 0020007C 44024603 D1004293
@000000E0 F8034770 E7F91B01 4614B530 46052C00 B09B461A 238BDA05 F04F6003
@000000E7 B01B30FF F44FBD30 F8AD7302 BF0C300C F1044623 930233FF F64F9305
@000000EE 910073FF F8AD9104 4669300E F0009B1E 1C43F873 238BBFBC 2C00602B
@000000F5 2200D0E3 701A9B00 0000E7DF 9300B507 460A4613 48034601 F7FF6800
@000000FC B003FFCB FB04F85D 00200014 47F0E92D 688E461F 42BE4682 4690460C
@00000103 D82C680B F412898A D0266F90 69096965 0545EB05 0901EBA3 75D5EB05
@0000010A 444B1C7B 429D106D 461DBF38 D5270553 F0004629 4606FB69 464AB360
@00000111 F0006921 89A3FAD3 6390F423 0380F043 612681A3 6026444E 6165463E
@00000118 0509EBA5 42BE60A5 463ED900 46414632 F0006820 2000FACB 1B9B68A3
@0000011F 682360A3 60234433 87F0E8BD F000462A 4606FBB5 D1E02800 69214650
@00000126 FAD2F000 F8CA230C 89A33000 30FFF04F 0340F043 E7E981A3 4FF0E92D
@0000012D 898B4698 061B4607 4614460D D50EB09D B963690B F0002140 6028FB21
@00000134 B9206128 603B230C 30FFF04F 2340E0D0 2300616B 23209309 3029F88D
@0000013B F04F2330 F8CD0901 F8DF800C F88D81A0 4623302A F813469A B10A2B01
@00000142 D1F92A25 0B04EBBA 465BD00B 46294622 F7FF4638 3001FF6F 80A9F000
@00000149 445A9A09 F89A9209 2B003000 80A1F000 F04F2300 E9CD32FF F10A2305
@00000150 93040A01 F88D9307 931A3053 22054654 1B01F814 F0004850 9A04FA3D
@00000157 06D0B9D8 2320BF44 3053F88D BF440711 F88D232B F89A3053 2B2A3000
@0000015E 4654D015 F04F2000 9A070C0A F8114621 3B303B01 D94D2B09 9207B1B0
@00000165 EBA0E014 FA090308 4313F303 930446A2 9B03E7D2 681B1D19 2B009103
@0000016C 425BBFBB 0202F042 93079307 9204BFB8 2B2E7823 7863D10C D1342B2A
@00000173 34029B03 681B1D1A 2B009203 F04FBFB8 930533FF A0B8F8DF 46502203
@0000017A F0007821 B138F9F3 9B042240 000AEBA0 43134082 93043401 1B01F814
@00000181 48262206 1028F88D F9E2F000 D0382800 BB1B4B23 33079B03 0307F023
@00000188 93033308 44339B09 E7689309 2001460C 3202FB0C 2300E7A6 0C0AF04F
@0000018F 34014619 46209305 2B01F810 2A093A30 2B00D903 9105D0C6 4604E7C4
@00000196 FB0C2301 E7F02101 9300AB03 4638462A A9044B0F 8000F3AF 46061C42
@0000019D 89ABD1D6 F53F065B 9809AF2D E8BDB01D AB038FF0 462A9300 4B064638
@000001A4 F000A904 E7EBF87D 00000D00 00000D06 00000D0A 00000000 000003FD
@000001AB 47F0E92D 46994616 690B688A 42934607 4613BFB8 F8916033 460C2043
@000001B2 8020F8DD 3301B10A 68236033 BF420699 33026833 68256033 0506F015
@000001B9 F104D106 68E30A19 1A9B6832 DC2B42AB 2043F894 68221E13 2301BF18
@000001C0 D4300692 46384649 0243F104 300147C0 6823D023 F0036922 2B040306
@000001C7 2500BF14 F04F6833 BF080600 F10468E5 BF08041A F8541AED BF083C12
@000001CE 75E5EA25 BFC44293 18ED1A9B D11A42B5 E0082000 46522301 46384649
@000001D5 300147C0 F04FD103 E8BD30FF 350187F0 2030E7C1 F88118E1 1C5A0043
@000001DC 1045F894 33024422 1043F882 2301E7C2 46494622 47C04638 D0E63001
@000001E3 E7D93601 47FFE92D 46917E0F 46802F78 469A460C F1019D0C D8070243
@000001EA D80A2F62 F0002F00 2F5880D5 80C1F000 0542F104 7042F884 F1A7E03A
@000001F1 2B150363 A101D8F6 F023F851 00000829 0000083D 000007B9 000007B9
@000001F8 000007B9 000007B9 0000083D 000007B9 000007B9 000007B9 000007B9
@000001FF 00000943 00000869 000008FD 000007B9 000007B9 00000965 000007B9
@00000206 00000869 000007B9 000007B9 00000905 1D1A682B 602A681B 0542F104
@0000020D 3042F884 E0A02301 682B6820 F1030607 60290104 681ED501 0646E003
@00000214 F9B3D5FB 2E006000 232DDA03 F8844276 230A3043 E0124859 6820682B
@0000021B 60291D19 D5010605 E002681E D5FB0641 2F6F881E 2308BF0C 4851230A
@00000222 F8842100 68651043 BFA82D00 60A56821 F021BFA4 60210104 2D00B90E
@00000229 4615D04B F1F3FBB6 6711FB03 F8055DC7 46377D01 460E42BB 2B08D9F4
@00000230 6823D10B D50807DE 68616923 BFDE4299 F8052330 F1053C01 1B5235FF
@00000237 464B6122 46404621 A000F8CD F7FFAA03 3001FEDF F04FD14A B00430FF
@0000023E 87F0E8BD F0436823 60230320 48322778 7045F884 68296823 F851061F
@00000245 D4026B04 BF48065F 07DFB2B6 F043BF48 60290320 6023BF48 6823B91E
@0000024C 0320F023 23106023 4824E7A6 4615E7E4 682BE7BD 1D186826 60286961
@00000253 681B0635 6019D501 0670E002 8019D5FB 46152300 E7BC6123 2100682B
@0000025A 602A1D1A 6862681D F0004628 B108F82F 60601B40 61236863 F8842300
@00000261 E7AA3043 4649462A 69234640 300147D0 6823D0AD D413079B 9B0368E0
@00000268 BFB84298 E7A64618 46322301 46404649 300147D0 3501D09D 990368E3
@0000026F 42AB1A5B E7EBDCF2 F1042500 E7F50619 00000D11 00000D22 B5104603
@00000276 4402B2C9 46184293 2000D101 7804E003 428C3301 BD10D1F6 4291440A
@0000027D 33FFF100 4770D100 F811B510 42914B01 4F01F803 BD10D1F9 B5104288
@00000284 0402EB01 4284D902 D8074623 42A11E43 F811D008 F8032B01 E7F82F01
@0000028B 44024601 D100428A F813BD10 F8024D01 E7F74D01 4605B538 D0402900
@00000292 3C04F851 2B001F0C 18E4BFB8 F910F000 68134A1C 6063B933 46286014
@00000299 4038E8BD B907F000 D90842A3 18216820 BF01428B 685B6819 60211809
@000002A0 461AE7ED B10B685B D9FA42A3 18506811 D10B42A0 44016820 42831850
@000002A7 D1E06011 685B6818 60104408 E7DA6053 230CD902 E7D6602B 18216820
@000002AE BF01428B 685B6819 60211809 60546063 BD38E7CB 0020009C 4E0EB570
@000002B5 6831460C B9114605 F8BCF000 46216030 F0004628 1C43F8B7 1CC4D00A
@000002BC 0403F024 D00742A0 46281A21 F8ACF000 D1013001 34FFF04F BD704620
@000002C3 002000A0 41F0E92D F0251CCD 35080503 BF382D0C 2D00250C DB014607
@000002CA D90542A9 2600230C 4630603B 81F0E8BD F0004E2E 6833F89D BB34461C
@000002D1 46384629 FFC2F7FF 46041C43 6834D14D 2E004626 6823D140 46384631
@000002D8 0803EB04 F878F000 D13A4580 35036823 F0251AED 35080503 BF382D0C
@000002DF 4638250C F7FF4629 3001FFA5 6823D02B 6023442B 6822E00E D41E1B52
@000002E6 D9162A0B 42A31961 BF186025 68636059 6031BF08 604B5162 F1044638
@000002ED F000060B F026F860 1D230607 D0B61AF2 50A31B9B 6862E7B3 BF0C42A3
@000002F4 605A6032 4623E7EC E7B26864 68764634 230CE7B9 603B4638 F847F000
@000002FB 6025E7A1 BF00E7DE 0020009C 41F0E92D 46144680 B921460E E8BD4611
@00000302 F7FF41F0 B92ABF81 FF16F7FF 46284625 81F0E8BD F82EF000 46074284
@00000309 EBB4D802 D8120F50 46404621 FF6EF7FF 28004605 42BCD0ED 46314622
@00000310 463ABF28 FED4F7FF 46404631 FEF8F7FF 4635E7E1 0000E7DF 2300B538
@00000317 46044D05 602B4608 F812F000 D1021C43 B103682B BD386023 002000A4
@0000031E 47704770 3C04F851 2B001F18 580BBFBC 477018C0 49054A04 2B006813
@00000325 460BBF08 60104418 47704618 002000A8 002000B0 BF00E7FE BF00B5F8
@0000032C BC08BCF8 4770469E BF00B5F8 BC08BCF8 4770469E 74736554 7773203A
@00000333 0000006F 73696854 73657420 65732074 75207374 68742070 57532065
@0000033A 756F204F 74757074 20736120 41552061 00005452 00200018 2B302D23
@00000341 6C680020 6665004C 47464567 32313000 36353433 41393837 45444342
@00000348 31300046 35343332 39383736 64636261 00006665 00000000 7FFFF398
@0000034F 00000001 00000D4C 00200010 0000001C 03938700 00200018 00000000
@00000356 00000000 00000000 00000000 00000000 00000000 00000000 00000000
@0000035D 00000000 00000000 00000000 00000000 00000000 00000000 00000000
@00000364 00000000 00000000 00000000 00000000 00000000 00000000 00000000
@0000036B 00000000 00000000 000000AD 00000085
"""

def test_read_vmem8():
    vmem = VerilogHex(io.StringIO(vmem8))
    assert vmem.size == len(bin8) # must have same number of bytes
    for i in range(vmem.size):
        assert vmem[i] == bin8[i]

def test_read_vmem16():
    vmem = VerilogHex(io.StringIO(vmem16))
    assert vmem.size == len(bin8) # must have same number of bytes
    for i in range(vmem.size):
        assert vmem[i] == bin8[i]

def test_read_vmem32():
    vmem = VerilogHex(io.StringIO(vmem32))
    assert vmem.size == len(bin8) # must have same number of bytes
    for i in range(vmem.size):
        assert vmem[i] == bin8[i]

def test_read_bytes():
    vmem = VerilogHex(bin8)
    for i in range(len(bin8)):
        assert vmem[i] == bin8[i]

def test_read_offset_bytes():
    padding = 0xfe
    bytes = VerilogHex([0,1,2,3], offset=3).tobytes(width_bytes=4, padding=padding)
    print(bytes)
    assert bytes == bytearray([padding, padding, padding, 0, 1, 2, 3, padding])

def test_iterate_over_segment():
    vmem = VerilogHex(bin8)
    for address,data in vmem:
        print(f"address={address} data={data}")