from datetime import datetime
from typing import Optional

from app.schemas.user_role import UserRole
from pydantic import UUID4, BaseModel, EmailStr


# Shared properties
class UserBase(BaseModel):
    email: Optional[EmailStr] = None
    is_active: Optional[bool] = True
    name: Optional[str] = None
    last_name: Optional[str] = None
    phone_number: Optional[str] = None
    account_id: Optional[UUID4] = None


# Properties to receive via API on creation
class UserCreate(UserBase):
    account_id: Optional[UUID4] = None
    password: str


# Properties to receive via API on update
class UserUpdate(UserBase):
    password: Optional[str] = None


class UserInDBBase(UserBase):
    id: UUID4
    user_role: Optional[UserRole]
    created_at: datetime
    updated_at: datetime

    class Config:
        orm_mode = True


# Additional properties to return via API
class User(UserInDBBase):
    pass


# Additional properties stored in DB
class UserInDB(UserInDBBase):
    hashed_password: str