import datetime
from uuid import uuid4

from app.db.base_class import Base
from sqlalchemy import Column, String
from sqlalchemy.dialects.postgresql import UUID
from sqlalchemy.orm import relationship
from sqlalchemy.sql.schema import ForeignKey
from sqlalchemy.sql.sqltypes import Integer


class Address(Base):
    id = Column(
        UUID(as_uuid=True), primary_key=True, index=True, default=uuid4
    )

    postal_code = Column(String(255), index=True, nullable=False)
    state = Column(String(255), index=True, nullable=False)
    city = Column(String(255), index=True, nullable=False)
    district = Column(String(255), index=True, nullable=False)
    street = Column(String(255), index=True, nullable=False)
    number = Column(Integer, nullable=False)
    address_2 = Column(String(255))

    user_id = Column(
        UUID(as_uuid=True), ForeignKey("users.id"), nullable=True
    )
    users = relationship("User", back_populates="address")