/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.embeddedserver.jetty.websocket;

import io.javalin.embeddedserver.jetty.websocket.WebSocketHandler;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@WebSocket
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000eH\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/javalin/embeddedserver/jetty/websocket/WebSocketHandlerRoot;", "", "handlers", "", "Lio/javalin/embeddedserver/jetty/websocket/WebSocketHandler;", "(Ljava/util/List;)V", "findHandler", "session", "Lorg/eclipse/jetty/websocket/api/Session;", "webSocketClose", "", "statusCode", "", "reason", "", "webSocketConnect", "webSocketError", "throwable", "", "webSocketMessage", "message", "javalin"})
public final class WebSocketHandlerRoot {
    private final List<WebSocketHandler> handlers;

    @OnWebSocketConnect
    public final void webSocketConnect(@NotNull Session session) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            WebSocketHandler webSocketHandler2 = this.findHandler(session);
            if (webSocketHandler2 == null) break block0;
            webSocketHandler2.onConnect(session);
        }
    }

    @OnWebSocketMessage
    public final void webSocketMessage(@NotNull Session session, @NotNull String message) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            WebSocketHandler webSocketHandler2 = this.findHandler(session);
            if (webSocketHandler2 == null) break block0;
            webSocketHandler2.onMessage(session, message);
        }
    }

    @OnWebSocketClose
    public final void webSocketClose(@NotNull Session session, int statusCode, @Nullable String reason) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            WebSocketHandler webSocketHandler2 = this.findHandler(session);
            if (webSocketHandler2 == null) break block0;
            webSocketHandler2.onClose(session, statusCode, reason);
        }
    }

    @OnWebSocketError
    public final void webSocketError(@NotNull Session session, @Nullable Throwable throwable) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            WebSocketHandler webSocketHandler2 = this.findHandler(session);
            if (webSocketHandler2 == null) break block0;
            webSocketHandler2.onError(session, throwable);
        }
    }

    private final WebSocketHandler findHandler(Session session) {
        Object v2;
        block1: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)this.handlers;
            for (Object t : iterable2) {
                WebSocketHandler it = (WebSocketHandler)t;
                UpgradeRequest upgradeRequest = session.getUpgradeRequest();
                Intrinsics.checkExpressionValueIsNotNull((Object)upgradeRequest, (String)"session.upgradeRequest");
                URI uRI = upgradeRequest.getRequestURI();
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"session.upgradeRequest.requestURI");
                if (!it.matches(uRI.getPath())) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    public WebSocketHandlerRoot(@NotNull List<? extends WebSocketHandler> handlers) {
        Intrinsics.checkParameterIsNotNull(handlers, (String)"handlers");
        this.handlers = handlers;
    }
}

