/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.embeddedserver.jetty;

import io.javalin.HaltException;
import io.javalin.embeddedserver.Location;
import io.javalin.embeddedserver.StaticFileConfig;
import io.javalin.embeddedserver.StaticResourceHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u000e*\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u000e\u0010\u0018\u001a\u00020\u000e*\u0004\u0018\u00010\u0014H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/javalin/embeddedserver/jetty/JettyResourceHandler;", "Lio/javalin/embeddedserver/StaticResourceHandler;", "staticFileConfig", "", "Lio/javalin/embeddedserver/StaticFileConfig;", "(Ljava/util/List;)V", "handlers", "Lorg/eclipse/jetty/server/handler/gzip/GzipHandler;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getResourcePath", "", "handle", "", "httpRequest", "Ljavax/servlet/http/HttpServletRequest;", "httpResponse", "Ljavax/servlet/http/HttpServletResponse;", "isDirectoryWithWelcomeFile", "Lorg/eclipse/jetty/util/resource/Resource;", "handler", "Lorg/eclipse/jetty/server/handler/ResourceHandler;", "target", "isFile", "javalin"})
public final class JettyResourceHandler
implements StaticResourceHandler {
    private final Logger log;
    private final List<GzipHandler> handlers;

    @NotNull
    public final String getResourcePath(@NotNull StaticFileConfig staticFileConfig) {
        Intrinsics.checkParameterIsNotNull((Object)staticFileConfig, (String)"staticFileConfig");
        String nosuchdir = "Static resource directory with path: '" + staticFileConfig.getPath() + "' does not exist.";
        if (staticFileConfig.getLocation() == Location.CLASSPATH) {
            Resource classPathResource = Resource.newClassPathResource((String)staticFileConfig.getPath());
            if (classPathResource == null) {
                throw (Throwable)new RuntimeException(nosuchdir + " Depending on your setup, empty folders might not get copied to classpath.");
            }
            return classPathResource.toString();
        }
        if (!new File(staticFileConfig.getPath()).exists()) {
            throw (Throwable)new RuntimeException(nosuchdir);
        }
        return staticFileConfig.getPath();
    }

    @Override
    public boolean handle(@NotNull HttpServletRequest httpRequest, @NotNull HttpServletResponse httpResponse) {
        Intrinsics.checkParameterIsNotNull((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkParameterIsNotNull((Object)httpResponse, (String)"httpResponse");
        Object object = httpRequest.getAttribute("jetty-target");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String target = (String)object;
        Object object2 = httpRequest.getAttribute("jetty-request");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.eclipse.jetty.server.Request");
        }
        Request baseRequest = (Request)object2;
        for (GzipHandler gzipHandler : this.handlers) {
            try {
                Handler handler = gzipHandler.getHandler();
                if (handler == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.eclipse.jetty.server.handler.ResourceHandler");
                }
                ResourceHandler resourceHandler = (ResourceHandler)handler;
                Resource resource = resourceHandler.getResource(target);
                if (!this.isFile(resource) && !this.isDirectoryWithWelcomeFile(resource, resourceHandler, target)) continue;
                int maxAge = StringsKt.startsWith$default((String)target, (String)"/immutable", (boolean)false, (int)2, null) ? 31622400 : 0;
                httpResponse.setHeader("Cache-Control", "max-age=" + maxAge);
                gzipHandler.handle(target, baseRequest, httpRequest, httpResponse);
                return true;
            }
            catch (Exception e) {
                this.log.error("Exception occurred while handling static resource", (Throwable)e);
            }
        }
        throw (Throwable)new HaltException(404, "Not found");
    }

    private final boolean isFile(@Nullable Resource $receiver) {
        return $receiver != null && $receiver.exists() && !$receiver.isDirectory();
    }

    private final boolean isDirectoryWithWelcomeFile(@Nullable Resource $receiver, ResourceHandler handler, String target) {
        return $receiver != null && $receiver.isDirectory() && handler.getResource(target + "index.html").exists();
    }

    /*
     * WARNING - void declaration
     */
    public JettyResourceHandler(@NotNull List<StaticFileConfig> staticFileConfig) {
        Collection<GzipHandler> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(staticFileConfig, (String)"staticFileConfig");
        this.log = LoggerFactory.getLogger(JettyResourceHandler.class);
        Iterable iterable = staticFileConfig;
        JettyResourceHandler jettyResourceHandler = this;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void config;
            GzipHandler gzipHandler;
            StaticFileConfig staticFileConfig2 = (StaticFileConfig)item$iv$iv;
            collection = destination$iv$iv;
            GzipHandler $receiver = gzipHandler = new GzipHandler();
            ResourceHandler resourceHandler = new ResourceHandler();
            GzipHandler gzipHandler2 = $receiver;
            ResourceHandler $receiver2 = resourceHandler;
            $receiver2.setResourceBase(this.getResourcePath((StaticFileConfig)config));
            $receiver2.setDirAllowed(false);
            $receiver2.setEtags(true);
            $receiver2.start();
            ResourceHandler resourceHandler2 = resourceHandler;
            gzipHandler2.setHandler((Handler)resourceHandler2);
            this.log.info("Static files enabled: {" + config + "}. Absolute path: '" + this.getResourcePath((StaticFileConfig)config) + '\'');
            GzipHandler gzipHandler3 = gzipHandler;
            collection.add(gzipHandler3);
        }
        collection = (List)destination$iv$iv;
        jettyResourceHandler.handlers = collection;
    }
}

