/*
 * Decompiled with CFR 0.152.
 */
package io.javalin;

import io.javalin.Handler;
import io.javalin.Javalin;
import io.javalin.embeddedserver.jetty.websocket.WebSocketConfig;
import io.javalin.security.Role;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ApiBuilder {
    private static Javalin staticJavalin;
    private static Deque<String> pathDeque;

    static void setStaticJavalin(@NotNull Javalin javalin) {
        staticJavalin = javalin;
    }

    static void clearStaticJavalin() {
        staticJavalin = null;
    }

    public static void path(@NotNull String path, @NotNull EndpointGroup endpointGroup) {
        path = path.startsWith("/") ? path : "/" + path;
        pathDeque.addLast(path);
        endpointGroup.addEndpoints();
        pathDeque.removeLast();
    }

    private static String prefixPath(@NotNull String path) {
        return pathDeque.stream().collect(Collectors.joining("")) + (path.startsWith("/") || path.isEmpty() ? path : "/" + path);
    }

    private static Javalin staticInstance() {
        if (staticJavalin == null) {
            throw new IllegalStateException("The static API can only be called within a routes() call");
        }
        return staticJavalin;
    }

    public static void get(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().get(ApiBuilder.prefixPath(path), handler);
    }

    public static void post(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().post(ApiBuilder.prefixPath(path), handler);
    }

    public static void put(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().put(ApiBuilder.prefixPath(path), handler);
    }

    public static void patch(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().patch(ApiBuilder.prefixPath(path), handler);
    }

    public static void delete(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().delete(ApiBuilder.prefixPath(path), handler);
    }

    public static void before(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().before(ApiBuilder.prefixPath(path), handler);
    }

    public static void after(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().after(ApiBuilder.prefixPath(path), handler);
    }

    public static void get(@NotNull String path, @NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        ApiBuilder.staticInstance().get(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void post(@NotNull String path, @NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        ApiBuilder.staticInstance().post(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void put(@NotNull String path, @NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        ApiBuilder.staticInstance().put(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void patch(@NotNull String path, @NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        ApiBuilder.staticInstance().patch(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void delete(@NotNull String path, @NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        ApiBuilder.staticInstance().delete(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void get(@NotNull Handler handler) {
        ApiBuilder.staticInstance().get(ApiBuilder.prefixPath(""), handler);
    }

    public static void post(@NotNull Handler handler) {
        ApiBuilder.staticInstance().post(ApiBuilder.prefixPath(""), handler);
    }

    public static void put(@NotNull Handler handler) {
        ApiBuilder.staticInstance().put(ApiBuilder.prefixPath(""), handler);
    }

    public static void patch(@NotNull Handler handler) {
        ApiBuilder.staticInstance().patch(ApiBuilder.prefixPath(""), handler);
    }

    public static void delete(@NotNull Handler handler) {
        ApiBuilder.staticInstance().delete(ApiBuilder.prefixPath(""), handler);
    }

    public static void before(@NotNull Handler handler) {
        ApiBuilder.staticInstance().before(ApiBuilder.prefixPath("/*"), handler);
    }

    public static void after(@NotNull Handler handler) {
        ApiBuilder.staticInstance().after(ApiBuilder.prefixPath("/*"), handler);
    }

    public static void get(@NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        ApiBuilder.staticInstance().get(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void post(@NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        ApiBuilder.staticInstance().post(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void put(@NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        ApiBuilder.staticInstance().put(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void patch(@NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        ApiBuilder.staticInstance().patch(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void delete(@NotNull Handler handler, @NotNull List<Role> permittedRoles) {
        ApiBuilder.staticInstance().delete(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void ws(@NotNull String path, @NotNull WebSocketConfig ws) {
        staticJavalin.ws(ApiBuilder.prefixPath(path), ws);
    }

    public static void ws(@NotNull String path, @NotNull Class webSocketClass) {
        staticJavalin.ws(ApiBuilder.prefixPath(path), webSocketClass);
    }

    public static void ws(@NotNull String path, @NotNull Object webSocketObject) {
        staticJavalin.ws(ApiBuilder.prefixPath(path), webSocketObject);
    }

    static {
        pathDeque = new ArrayDeque<String>();
    }

    @FunctionalInterface
    public static interface EndpointGroup {
        public void addEndpoints();
    }
}

