/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.util;

import com.twosigma.beakerx.util.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteStreams {
    private static final int BUF_SIZE = 4096;

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteStreams.copy(in, out);
        return out.toByteArray();
    }

    public static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        byte[] buf = new byte[4096];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static int read(InputStream in, byte[] b, int off, int len) throws IOException {
        int total;
        int result;
        Preconditions.checkNotNull(in);
        Preconditions.checkNotNull(b);
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        for (total = 0; total < len && (result = in.read(b, off + total, len - total)) != -1; total += result) {
        }
        return total;
    }

    public static void closeQuietly(InputStream inputStream) {
        try {
            ByteStreams.close(inputStream, true);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    public static void close(Closeable closeable, boolean swallowIOException) throws IOException {
        block3: {
            if (closeable == null) {
                return;
            }
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (swallowIOException) break block3;
                throw e;
            }
        }
    }
}

