/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.evaluator;

import com.twosigma.beakerx.BeakerXClient;
import com.twosigma.beakerx.BeakerXClientManager;
import com.twosigma.beakerx.ClassLoaderSwitcher;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.autocomplete.MagicCommandAutocompletePatterns;
import com.twosigma.beakerx.evaluator.ClassLoaderService;
import com.twosigma.beakerx.evaluator.ClasspathScanner;
import com.twosigma.beakerx.evaluator.Evaluator;
import com.twosigma.beakerx.evaluator.EvaluatorHooks;
import com.twosigma.beakerx.evaluator.Hook;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.inspect.Inspect;
import com.twosigma.beakerx.inspect.InspectResult;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.AddImportStatus;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.ExecutionOptions;
import com.twosigma.beakerx.kernel.GroupName;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.Imports;
import com.twosigma.beakerx.kernel.PathToJar;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;

public abstract class BaseEvaluator
implements Evaluator {
    public static String INTERUPTED_MSG = "KeyboardInterrupt";
    private boolean interrupting = false;
    protected final String shellId;
    protected final String sessionId;
    private final ClasspathScanner classpathScanner;
    protected String outDir;
    private Inspect inspect;
    protected Classpath classPath;
    protected Imports imports = new Imports(new ArrayList<ImportPath>());
    private final CellExecutor executor;
    private Path tempFolder;
    private BeakerXClient beakerXClient;
    protected MagicCommandAutocompletePatterns autocompletePatterns;
    protected EvaluatorParameters evaluatorParameters;
    private EvaluatorHooks cancelHooks = new EvaluatorHooks();
    private ClassLoaderService classLoaderService = new ClassLoaderService();
    protected ExecutorService executorService;
    protected ExecutorService executorBgkService;
    private ClassLoaderSwitcher classLoaderSwitcher;
    CompletableFuture<TryResult> background;

    public BaseEvaluator(String id, String sId, CellExecutor cellExecutor, TempFolderFactory tempFolderFactory, EvaluatorParameters evaluatorParameters, BeakerXClient beakerXClient, MagicCommandAutocompletePatterns autocompletePatterns, ClasspathScanner classpathScanner, Inspect inspect) {
        this.shellId = id;
        this.sessionId = sId;
        this.executor = cellExecutor;
        this.tempFolder = tempFolderFactory.createTempFolder();
        this.classpathScanner = classpathScanner;
        this.beakerXClient = BeakerXClientManager.register(beakerXClient);
        this.autocompletePatterns = autocompletePatterns;
        this.outDir = this.getOrCreateFile(this.tempFolder.toString() + File.separator + "outDir").getPath();
        this.classPath = new Classpath();
        this.classPath.add(new PathToJar(this.outDir));
        this.inspect = inspect;
        this.executorService = Executors.newCachedThreadPool();
        this.executorBgkService = Executors.newCachedThreadPool();
        this.evaluatorParameters = evaluatorParameters;
        this.init(evaluatorParameters);
    }

    @Override
    public void startEvaluation() {
        this.classLoaderSwitcher = new ClassLoaderSwitcher(this);
        this.classLoaderSwitcher.start();
    }

    @Override
    public void endEvaluation() {
        this.classLoaderSwitcher.end();
    }

    @Override
    public void interruptKernel() {
        this.interrupting = true;
        this.killAllThreads();
    }

    @Override
    public void interruptKernelDone() {
        this.interrupting = false;
    }

    @Override
    public boolean isInterrupting() {
        return this.interrupting;
    }

    @Override
    public TryResult processResult(TryResult result) {
        if (this.interrupting) {
            return TryResult.createError(INTERUPTED_MSG);
        }
        return result;
    }

    protected TryResult evaluate(EvaluationObject seo, Callable<TryResult> callable) {
        try {
            this.background = CompletableFuture.supplyAsync(() -> {
                try {
                    InternalVariable.setValue(seo);
                    Future submit = this.executorService.submit(callable);
                    return (TryResult)submit.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, this.executorBgkService);
            return this.background.get();
        }
        catch (Exception e) {
            return TryResult.createError(e.getLocalizedMessage());
        }
    }

    @Override
    public TryResult evaluate(EvaluationObject seo, String code) {
        return this.evaluate(seo, code, new ExecutionOptions(GroupName.generate()));
    }

    @Override
    public void putEvaluationInToBackground() {
        this.background.complete(TryResult.createResult("Evaluation in the background"));
    }

    protected abstract void addJarToClassLoader(PathToJar var1);

    protected abstract void addImportToClassLoader(ImportPath var1);

    protected abstract void doResetEnvironment();

    protected void doReloadEvaluator() {
    }

    public abstract ClassLoader getClassLoader();

    public ClassLoader getClassLoaderForImport() {
        return this.getClassLoader();
    }

    @Override
    public BeakerXClient getBeakerX() {
        return this.beakerXClient;
    }

    @Override
    public List<Path> addJarsToClasspath(List<PathToJar> paths) {
        LinkedList<Path> addedPaths = new LinkedList<Path>();
        paths.forEach(path -> {
            if (this.addJarToClasspath((PathToJar)path)) {
                addedPaths.add(Paths.get(path.getPath(), new String[0]));
            }
        });
        this.classpathScanner.scan();
        this.doReloadEvaluator();
        return addedPaths;
    }

    private boolean addJarToClasspath(PathToJar path) {
        boolean add = this.classPath.add(path);
        if (add) {
            this.addJarToClassLoader(path);
        }
        return add;
    }

    @Override
    public AddImportStatus addImport(ImportPath anImport) {
        AddImportStatus add = this.imports.add(anImport, this.getClassLoaderForImport());
        if (AddImportStatus.ADDED.equals((Object)add)) {
            this.addImportToClassLoader(anImport);
        }
        return add;
    }

    @Override
    public void removeImport(ImportPath anImport) {
        if (this.removeImportPath(anImport)) {
            this.resetEnvironment();
        }
    }

    protected boolean removeImportPath(ImportPath anImport) {
        return this.imports.remove(anImport);
    }

    @Override
    public Classpath getClasspath() {
        return this.classPath;
    }

    @Override
    public Imports getImports() {
        return this.imports;
    }

    protected void init(EvaluatorParameters kernelParameters) {
        Map<String, Object> params = kernelParameters.getParams();
        this.initClasspath(params);
        this.initImports(params);
    }

    private void initClasspath(Map<String, Object> params) {
        Collection listOfClassPath = (Collection)params.get("classpath");
        if (listOfClassPath != null) {
            for (String line : listOfClassPath) {
                if (line.trim().isEmpty()) continue;
                this.classPath.add(new PathToJar(line));
            }
        }
    }

    private void initImports(Map<String, Object> params) {
        Collection listOfImports = (Collection)params.get("imports");
        ArrayList<ImportPath> importPaths = new ArrayList<ImportPath>();
        if (listOfImports != null) {
            for (String line : listOfImports) {
                if (line.trim().isEmpty()) continue;
                importPaths.add(new ImportPath(line));
            }
            if (this.imports != null) {
                importPaths.addAll(this.imports.getImportPaths());
            }
        }
        this.imports = new Imports(importPaths);
    }

    @Override
    public void updateEvaluatorParameters(EvaluatorParameters kernelParameters) {
        this.init(kernelParameters);
        this.resetEnvironment();
    }

    public TryResult executeTask(Callable<TryResult> codeRunner, ExecutionOptions executionOptions) {
        return this.executor.executeTask(codeRunner, executionOptions);
    }

    @Override
    public void killAllThreads() {
        this.executor.killAllThreads();
    }

    @Override
    public void cancelExecution(GroupName groupName) {
        this.executor.cancelExecution(groupName);
        this.cancelHooks.runHooks();
    }

    @Override
    public void resetEnvironment() {
        this.executor.killAllThreads();
        this.doResetEnvironment();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getOutDir() {
        return this.outDir;
    }

    @Override
    public Path getTempFolder() {
        return this.tempFolder;
    }

    @Override
    public void exit() {
        this.beakerXClient.delBeaker();
        this.removeTempFolder();
    }

    private void removeTempFolder() {
        try {
            FileUtils.deleteQuietly((File)new File(this.getTempFolder().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<?> loadClass(String clazzName) throws ClassNotFoundException {
        return this.classLoaderService.loadClass(clazzName, this.getClassLoader());
    }

    private File getOrCreateFile(String pathToMavenRepo) {
        File theDir = new File(pathToMavenRepo);
        if (!theDir.exists()) {
            try {
                theDir.mkdirs();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return theDir;
    }

    @Override
    public InspectResult inspect(String code, int caretPosition) {
        return this.inspect.doInspect(code, caretPosition, null, this.imports);
    }

    public Inspect getInspect() {
        return this.inspect;
    }

    @Override
    public void registerCancelHook(Hook hook) {
        this.cancelHooks.registerHook(hook);
    }

    @Override
    public boolean checkIfClassExistsInClassloader(String clazzName) {
        return this.classLoaderService.checkIfClassExistsInClassloader(clazzName, this.getClassLoader());
    }
}

