/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.util.concurrent.atomic.AtomicInteger;
import zmq.Utils;
import zmq.ZError;

public class Signaler
implements Closeable {
    private final Pipe.SinkChannel w;
    private final Pipe.SourceChannel r;
    private final Selector selector;
    private final AtomicInteger wcursor = new AtomicInteger(0);
    private int rcursor = 0;

    public Signaler() {
        Pipe pipe;
        try {
            pipe = Pipe.open();
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        this.r = pipe.source();
        this.w = pipe.sink();
        try {
            Utils.unblockSocket(this.w);
            Utils.unblockSocket(this.r);
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        try {
            this.selector = Selector.open();
            this.r.register(this.selector, 1);
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        try {
            this.r.close();
        }
        catch (IOException e) {
            exception = e;
        }
        try {
            this.w.close();
        }
        catch (IOException e) {
            exception = e;
        }
        try {
            this.selector.close();
        }
        catch (IOException e) {
            exception = e;
        }
        if (exception != null) {
            throw exception;
        }
    }

    public SelectableChannel getFd() {
        return this.r;
    }

    public void send() {
        int nbytes = 0;
        ByteBuffer dummy = ByteBuffer.allocate(1);
        do {
            try {
                Thread.interrupted();
                nbytes = this.w.write(dummy);
            }
            catch (IOException e) {
                throw new ZError.IOException(e);
            }
        } while (nbytes == 0);
        assert (nbytes == 1);
        this.wcursor.incrementAndGet();
    }

    public boolean waitEvent(long timeout) {
        int rc = 0;
        try {
            if (timeout == 0L) {
                return this.rcursor < this.wcursor.get();
            }
            rc = timeout < 0L ? this.selector.select(0L) : this.selector.select(timeout);
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        if (rc == 0) {
            return false;
        }
        this.selector.selectedKeys().clear();
        return true;
    }

    public void recv() {
        int nbytes = 0;
        try {
            ByteBuffer dummy = ByteBuffer.allocate(1);
            nbytes = this.r.read(dummy);
            assert (nbytes == 1);
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        ++this.rcursor;
    }
}

