/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.handler;

import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.handler.KernelHandlerWrapper;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import java.io.Serializable;
import java.util.HashMap;

public class CompleteHandler
extends KernelHandler<Message> {
    public static final String STATUS = "status";
    public static final String MATCHES = "matches";
    public static final String CURSOR_END = "cursor_end";
    public static final String CURSOR_START = "cursor_start";
    public static final String CODE = "code";
    public static final String CURSOR_POS = "cursor_pos";

    public CompleteHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    public void handle(Message message) {
        KernelHandlerWrapper.wrapBusyIdle((KernelFunctionality)this.kernel, (Message)message, () -> this.handleMsg(message));
    }

    private void handleMsg(Message message) {
        String code = (String)message.getContent().get(CODE);
        int cursorPos = (Integer)((Serializable)message.getContent().get(CURSOR_POS));
        AutocompleteResult autocomplete = this.kernel.autocomplete(code, cursorPos);
        Message reply = this.createMsg(message, cursorPos, autocomplete);
        this.send(reply);
    }

    private Message createMsg(Message message, int cursorPos, AutocompleteResult autocomplete) {
        Message reply = new Message(new Header(JupyterMessages.COMPLETE_REPLY, message.getHeader().getSession()));
        reply.setIdentities(message.getIdentities());
        reply.setParentHeader(message.getHeader());
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put(STATUS, "ok");
        content.put(MATCHES, autocomplete.getMatches().toArray());
        content.put(CURSOR_END, cursorPos);
        content.put(CURSOR_START, autocomplete.getStartIndex());
        reply.setContent(content);
        return reply;
    }
}

