/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.treemap;

import com.twosigma.beakerx.chart.Chart;
import com.twosigma.beakerx.chart.ChartToJson;
import com.twosigma.beakerx.chart.treemap.Mode;
import com.twosigma.beakerx.chart.treemap.ValueAccessor;
import com.twosigma.beakerx.chart.treemap.util.ColorProvider;
import com.twosigma.beakerx.chart.treemap.util.IToolTipBuilder;
import com.twosigma.beakerx.chart.treemap.util.RandomColorProvider;
import net.sf.jtreemap.swing.TreeMapNode;

public class TreeMap
extends Chart {
    public static final int ROWS_LIMIT = 1000;
    private TreeMapNode root = null;
    private ColorProvider colorProvider = null;
    private IToolTipBuilder toolTipBuilder = null;
    private Mode mode;
    private Double ratio;
    private Boolean sticky;
    private Boolean round;
    private ValueAccessor valueAccessor = ValueAccessor.VALUE;

    public TreeMap(TreeMapNode root) {
        this();
        this.setRoot(root);
    }

    public TreeMap() {
        this.openComm();
        this.setColorProvider(new RandomColorProvider());
        this.setShowLegend(false);
    }

    public TreeMapNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeMapNode newRoot) {
        this.root = newRoot;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.sendModelUpdate(ChartToJson.serializeTreeMapMode(this.mode));
    }

    public Double getRatio() {
        return this.ratio;
    }

    public void setRatio(Double ratio) {
        this.ratio = ratio;
        this.sendModelUpdate(ChartToJson.serializeTreeMapRatio(this.ratio));
    }

    public Boolean getSticky() {
        return this.sticky;
    }

    public void setSticky(Boolean sticky) {
        this.sticky = sticky;
        this.sendModelUpdate(ChartToJson.serializeTreeMapSticky(this.sticky));
    }

    public Boolean getRound() {
        return this.round;
    }

    public void setRound(Boolean round) {
        this.round = round;
        this.sendModelUpdate(ChartToJson.serializeTreeMapRound(this.round));
    }

    public ValueAccessor getValueAccessor() {
        return this.valueAccessor;
    }

    public void setValueAccessor(ValueAccessor valueAccessor) {
        this.valueAccessor = valueAccessor;
        this.sendModelUpdate(ChartToJson.serializeTreeMapValueAccessor(this.valueAccessor));
    }

    public void setColorProvider(ColorProvider newColorProvider) {
        this.colorProvider = newColorProvider;
    }

    public ColorProvider getColorProvider() {
        return this.colorProvider;
    }

    public IToolTipBuilder getToolTipBuilder() {
        return this.toolTipBuilder;
    }

    public void setToolTipBuilder(IToolTipBuilder toolTipBuilder) {
        this.toolTipBuilder = toolTipBuilder;
        this.sendModelUpdate();
    }

    @Override
    public String getModelNameValue() {
        return "PlotModel";
    }

    @Override
    public String getViewNameValue() {
        return "PlotView";
    }
}

