/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.twosigma.beakerx.chart.Color;
import com.twosigma.beakerx.chart.GradientColor;
import com.twosigma.beakerx.chart.categoryplot.CategoryPlot;
import com.twosigma.beakerx.chart.categoryplot.plotitem.CategoryArea;
import com.twosigma.beakerx.chart.categoryplot.plotitem.CategoryBars;
import com.twosigma.beakerx.chart.categoryplot.plotitem.CategoryGraphics;
import com.twosigma.beakerx.chart.categoryplot.plotitem.CategoryLines;
import com.twosigma.beakerx.chart.categoryplot.plotitem.CategoryPoints;
import com.twosigma.beakerx.chart.categoryplot.plotitem.CategoryStems;
import com.twosigma.beakerx.chart.heatmap.HeatMap;
import com.twosigma.beakerx.chart.histogram.Histogram;
import com.twosigma.beakerx.chart.legend.LegendLayout;
import com.twosigma.beakerx.chart.legend.LegendPosition;
import com.twosigma.beakerx.chart.serializer.AreaSerializer;
import com.twosigma.beakerx.chart.serializer.BarsSerializer;
import com.twosigma.beakerx.chart.serializer.CategoryAreasSerializer;
import com.twosigma.beakerx.chart.serializer.CategoryBarsSerializer;
import com.twosigma.beakerx.chart.serializer.CategoryLinesSerializer;
import com.twosigma.beakerx.chart.serializer.CategoryPlotSerializer;
import com.twosigma.beakerx.chart.serializer.CategoryPointsSerializer;
import com.twosigma.beakerx.chart.serializer.CategoryStemsSerializer;
import com.twosigma.beakerx.chart.serializer.ColorSerializer;
import com.twosigma.beakerx.chart.serializer.CombinedPlotSerializer;
import com.twosigma.beakerx.chart.serializer.ConstantBandSerializer;
import com.twosigma.beakerx.chart.serializer.ConstantLineSerializer;
import com.twosigma.beakerx.chart.serializer.CrosshairSerializer;
import com.twosigma.beakerx.chart.serializer.GradientColorSerializer;
import com.twosigma.beakerx.chart.serializer.HeatMapSerializer;
import com.twosigma.beakerx.chart.serializer.HistogramSerializer;
import com.twosigma.beakerx.chart.serializer.LegendPositionSerializer;
import com.twosigma.beakerx.chart.serializer.LineSerializer;
import com.twosigma.beakerx.chart.serializer.PointsSerializer;
import com.twosigma.beakerx.chart.serializer.RastersSerializer;
import com.twosigma.beakerx.chart.serializer.StemsSerializer;
import com.twosigma.beakerx.chart.serializer.TextSerializer;
import com.twosigma.beakerx.chart.serializer.TreeMapNodeSerializer;
import com.twosigma.beakerx.chart.serializer.TreeMapSerializer;
import com.twosigma.beakerx.chart.serializer.XYChartSerializer;
import com.twosigma.beakerx.chart.serializer.YAxisSerializer;
import com.twosigma.beakerx.chart.treemap.Mode;
import com.twosigma.beakerx.chart.treemap.TreeMap;
import com.twosigma.beakerx.chart.treemap.ValueAccessor;
import com.twosigma.beakerx.chart.xychart.CombinedPlot;
import com.twosigma.beakerx.chart.xychart.XYChart;
import com.twosigma.beakerx.chart.xychart.plotitem.Area;
import com.twosigma.beakerx.chart.xychart.plotitem.Bars;
import com.twosigma.beakerx.chart.xychart.plotitem.ConstantBand;
import com.twosigma.beakerx.chart.xychart.plotitem.ConstantLine;
import com.twosigma.beakerx.chart.xychart.plotitem.Crosshair;
import com.twosigma.beakerx.chart.xychart.plotitem.Line;
import com.twosigma.beakerx.chart.xychart.plotitem.PlotOrientationType;
import com.twosigma.beakerx.chart.xychart.plotitem.Points;
import com.twosigma.beakerx.chart.xychart.plotitem.Rasters;
import com.twosigma.beakerx.chart.xychart.plotitem.Stems;
import com.twosigma.beakerx.chart.xychart.plotitem.Text;
import com.twosigma.beakerx.chart.xychart.plotitem.XYGraphics;
import com.twosigma.beakerx.chart.xychart.plotitem.YAxis;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jtreemap.swing.TreeMapNode;

public class ChartToJson {
    private static ObjectMapper mapper;
    private static Map<Class<?>, JsonSerializer> serializerMap;

    public static Map toJson(Object result) {
        try {
            return (Map)ChartToJson.getMapper().convertValue(result, Map.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private static ObjectMapper getMapper() {
        return mapper;
    }

    static Map<Object, Object> serializeLegendPosition(LegendPosition legendPosition) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("legend_position", ChartToJson.toJson(legendPosition));
        return value;
    }

    static Map<Object, Object> serializeLegendLayout(LegendLayout legendLayout) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("legend_layout", legendLayout.toString());
        return value;
    }

    static Map<Object, Object> serializeCustomStyles(List<String> customStyles) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("custom_styles", ChartToJson.toJsonList(customStyles));
        return value;
    }

    static Map<Object, Object> serializeElementStyles(Map<String, String> elementStyles) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("element_styles", ChartToJson.toJson(elementStyles));
        return value;
    }

    static Map<Object, Object> serializeInitHeight(int initHeight) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("init_height", initHeight);
        return value;
    }

    static Map<Object, Object> serializeInitWidth(int initWidth) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("init_width", initWidth);
        return value;
    }

    static Map<Object, Object> serializeTitle(String title) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("chart_title", title);
        return value;
    }

    static Map<Object, Object> serializeOmitCheckboxes(boolean omitCheckboxes) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("omit_checkboxes", omitCheckboxes);
        return value;
    }

    static Map<Object, Object> serializeAutoZoom(boolean autoZoom) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("auto_zoom", autoZoom);
        return value;
    }

    static Map<Object, Object> serializeAutoRangeIncludesZero(boolean autoRangeIncludesZero) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("y_auto_range_includes_zero", autoRangeIncludesZero);
        return value;
    }

    static Map<Object, Object> serializeYBound(YAxis yAxis) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("y_lower_bound", yAxis.getLowerBound());
        value.put("y_upper_bound", yAxis.getUpperBound());
        return value;
    }

    static Map<Object, Object> serializeXLabel(String title) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("domain_axis_label", title);
        return value;
    }

    static Map<Object, Object> serializeYLabel(String title) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("y_label", title);
        return value;
    }

    static Map<Object, Object> serializeXLowerMargin(double margin) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("x_lower_margin", margin);
        return value;
    }

    static Map<Object, Object> serializeXUpperMargin(double margin) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("x_upper_margin", margin);
        return value;
    }

    static Map<Object, Object> serializeAutoRange(Boolean autoRange) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("y_auto_range", autoRange);
        return value;
    }

    static Map<Object, Object> serializeYLowerMargin(Double yLowerMargin) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("y_lower_margin", yLowerMargin);
        return value;
    }

    static Map<Object, Object> serializeUpperMargin(Double upperMargin) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("y_upper_margin", upperMargin);
        return value;
    }

    static Map<Object, Object> serializeCrosshair(Crosshair crosshair) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("crosshair", ChartToJson.toJson(crosshair));
        return value;
    }

    static Map<Object, Object> serializeTimeZone(TimeZone timeZone) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("timezone", ChartToJson.getMapper().convertValue((Object)timeZone, String.class));
        return value;
    }

    static Map<Object, Object> serializeLogY(Boolean logY) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("log_y", logY);
        return value;
    }

    public static Map<Object, Object> serializeHistogramLog(Boolean logY) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("log", logY);
        return value;
    }

    static Map<Object, Object> serializeYAxes(List<YAxis> yAxes) {
        ArrayList<Map> result = new ArrayList<Map>();
        for (YAxis item : yAxes) {
            result.add(ChartToJson.toJson(item));
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("rangeAxes", ChartToJson.toJsonList(result));
        return value;
    }

    public static List toJsonList(Object item) {
        return (List)mapper.convertValue(item, List.class);
    }

    public static Map<Object, Object> serializeHeatmapData(Number[][] data) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("graphics_list", ChartToJson.toJsonList(data));
        return value;
    }

    public static Map<Object, Object> serializeHeatmapGradientColor(GradientColor data) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("color", ChartToJson.getMapper().convertValue((Object)data, Object.class));
        return value;
    }

    public static Map<Object, Object> serializeConstantLines(List<ConstantLine> constantLines) {
        ArrayList<Map> result = new ArrayList<Map>();
        for (ConstantLine item : constantLines) {
            result.add(ChartToJson.toJson(item));
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("constant_lines", ChartToJson.toJsonList(result));
        return value;
    }

    public static Map<Object, Object> serializeXYGraphics(List<XYGraphics> xyGraphics) {
        ArrayList<Map> result = new ArrayList<Map>();
        for (XYGraphics item : xyGraphics) {
            result.add(ChartToJson.toJson(item));
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("graphics_list", ChartToJson.toJsonList(result));
        return value;
    }

    public static Map<Object, Object> serializeConstantBands(List<ConstantBand> constantBands) {
        ArrayList<Map> result = new ArrayList<Map>();
        for (ConstantBand item : constantBands) {
            result.add(ChartToJson.toJson(item));
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("constant_bands", ChartToJson.toJsonList(result));
        return value;
    }

    public static Map<Object, Object> serializeTexts(List<Text> texts) {
        ArrayList<Map> result = new ArrayList<Map>();
        for (Text item : texts) {
            result.add(ChartToJson.toJson(item));
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("texts", ChartToJson.toJsonList(result));
        return value;
    }

    public static Map<Object, Object> serializeRasters(List<Rasters> rasters) {
        ArrayList<Map> result = new ArrayList<Map>();
        for (Rasters item : rasters) {
            result.add(ChartToJson.toJson(item));
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("rasters", ChartToJson.toJsonList(result));
        return value;
    }

    public static Map<Object, Object> serializeXBound(XYChart xyChart) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("x_auto_range", xyChart.getXAutoRange());
        value.put("x_lower_bound", xyChart.getXLowerBound());
        value.put("x_upper_bound", xyChart.getXUpperBound());
        return value;
    }

    public static Map<Object, Object> serializeXAutoRange(boolean xAutoRange) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("x_auto_range", xAutoRange);
        return value;
    }

    public static Map<Object, Object> serializeLogX(boolean logX) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("log_x", logX);
        return value;
    }

    public static Map<Object, Object> serializeXLogBase(double xLogBase) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("x_log_base", xLogBase);
        return value;
    }

    public static Map<Object, Object> serializeLodThreshold(Integer lodThreshold) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("lodThreshold", lodThreshold);
        return value;
    }

    public static Map<Object, Object> serializeXTickLabelsVisible(boolean xtickLabelsVisible) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("x_tickLabels_visible", xtickLabelsVisible);
        return value;
    }

    public static Map<Object, Object> serializeYTickLabelsVisible(boolean ytickLabelsVisible) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("y_tickLabels_visible", ytickLabelsVisible);
        return value;
    }

    public static Map<Object, Object> serializeDisplayMode(Histogram.DisplayMode displayMode) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("displayMode", displayMode.toString());
        return value;
    }

    public static Map<Object, Object> serializeHistogramNames(List<String> names) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("names", ChartToJson.toJsonList(names));
        return value;
    }

    public static Map<Object, Object> serializeHistogramListData(List<List<Number>> listData) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("graphics_list", ChartToJson.toJsonList(listData));
        return value;
    }

    public static Map<Object, Object> serializeHistogramData(List<Number> data) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("graphics_list", ChartToJson.toJsonList(data));
        return value;
    }

    public static Map<Object, Object> serializeColors(List<Color> colors) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Color item : colors) {
            result.add(ChartToJson.getMapper().convertValue((Object)item, String.class));
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("colors", result);
        return value;
    }

    public static Map<Object, Object> serializeColor(Color color) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("color", ChartToJson.getMapper().convertValue((Object)color, String.class));
        return value;
    }

    public static Map<Object, Object> serializeCumulative(boolean cumulative) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("cumulative", cumulative);
        return value;
    }

    public static Map<Object, Object> serializeNormed(boolean normed) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("normed", normed);
        return value;
    }

    public static Map<Object, Object> serializeBinCount(int binCount) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("bin_count", binCount);
        return value;
    }

    public static Map<Object, Object> serializeCategoryNames(List<String> categoryNames) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("categoryNames", categoryNames);
        return value;
    }

    public static Map<Object, Object> serializeCategoryGraphics(List<CategoryGraphics> categoryGraphics) {
        ArrayList<Map> result = new ArrayList<Map>();
        for (CategoryGraphics item : categoryGraphics) {
            result.add(ChartToJson.toJson(item));
        }
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("graphics_list", result);
        return value;
    }

    public static Map<Object, Object> serializePlotOrientationType(PlotOrientationType orientation) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("orientation", orientation.toString());
        return value;
    }

    public static Map<Object, Object> serializeCategoryNamesLabelAngle(double categoryNamesLabelAngle) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("categoryNamesLabelAngle", categoryNamesLabelAngle);
        return value;
    }

    public static Map<Object, Object> serializeCategoryMargin(double categoryMargin) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("category_margin", categoryMargin);
        return value;
    }

    public static Map<Object, Object> serializeTreeMapRound(Boolean round) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("round", round);
        return value;
    }

    public static Map<Object, Object> serializeTreeMapSticky(Boolean sticky) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("sticky", sticky);
        return value;
    }

    public static Map<Object, Object> serializeTreeMapValueAccessor(ValueAccessor valueAccessor) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("valueAccessor", valueAccessor.toString());
        return value;
    }

    public static Map<Object, Object> serializeTreeMapRatio(Double ratio) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("ratio", ratio);
        return value;
    }

    public static Map<Object, Object> serializeTreeMapMode(Mode mode) {
        LinkedHashMap<Object, Object> value = new LinkedHashMap<Object, Object>();
        value.put("mode", mode.getJsName());
        return value;
    }

    static {
        serializerMap = new Hashtable();
        serializerMap.put(Color.class, new ColorSerializer());
        serializerMap.put(XYChart.class, new XYChartSerializer());
        serializerMap.put(CombinedPlot.class, new CombinedPlotSerializer());
        serializerMap.put(Line.class, new LineSerializer());
        serializerMap.put(Points.class, new PointsSerializer());
        serializerMap.put(Bars.class, new BarsSerializer());
        serializerMap.put(Stems.class, new StemsSerializer());
        serializerMap.put(Area.class, new AreaSerializer());
        serializerMap.put(YAxis.class, new YAxisSerializer());
        serializerMap.put(Crosshair.class, new CrosshairSerializer());
        serializerMap.put(LegendPosition.class, new LegendPositionSerializer());
        serializerMap.put(Text.class, new TextSerializer());
        serializerMap.put(ConstantLine.class, new ConstantLineSerializer());
        serializerMap.put(ConstantBand.class, new ConstantBandSerializer());
        serializerMap.put(CategoryArea.class, new CategoryAreasSerializer());
        serializerMap.put(CategoryBars.class, new CategoryBarsSerializer());
        serializerMap.put(CategoryStems.class, new CategoryStemsSerializer());
        serializerMap.put(CategoryPoints.class, new CategoryPointsSerializer());
        serializerMap.put(CategoryLines.class, new CategoryLinesSerializer());
        serializerMap.put(CategoryPlot.class, new CategoryPlotSerializer());
        serializerMap.put(GradientColor.class, new GradientColorSerializer());
        serializerMap.put(Histogram.class, new HistogramSerializer());
        serializerMap.put(HeatMap.class, new HeatMapSerializer());
        serializerMap.put(Rasters.class, new RastersSerializer());
        serializerMap.put(TreeMap.class, new TreeMapSerializer());
        serializerMap.put(TreeMapNode.class, new TreeMapNodeSerializer());
        SimpleModule module = new SimpleModule("ChartSerializer", new Version(1, 0, 0, null));
        serializerMap.forEach((arg_0, arg_1) -> ((SimpleModule)module).addSerializer(arg_0, arg_1));
        mapper = new ObjectMapper();
        mapper.registerModule((Module)module);
    }
}

