/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.widget.FloatWidget;
import java.util.HashMap;

public abstract class BoundedFloatWidget
extends FloatWidget<Double> {
    public static final String STEP = "step";
    public static final String MAX = "max";
    public static final String MIN = "min";
    private Double step = 0.1;
    private Double max = 100.0;
    private Double min = 0.0;

    protected BoundedFloatWidget() {
        this.value = Double.valueOf(0.0);
    }

    @Override
    protected HashMap<String, Object> content(HashMap<String, Object> content) {
        super.content(content);
        content.put(MAX, this.getMax());
        content.put(MIN, this.getMin());
        content.put(STEP, this.getStep());
        return content;
    }

    @Override
    protected Double decorateValue(Double value) {
        if (value > this.getMax()) {
            return this.getMax();
        }
        if (value < this.getMin()) {
            return this.getMin();
        }
        return value;
    }

    public Double getStep() {
        return this.step;
    }

    public void setStep(Object step) {
        this.step = this.getDouble(step);
        this.sendUpdate(STEP, step);
    }

    public Double getMax() {
        return this.max;
    }

    public void setMax(Object max) {
        this.max = this.getDouble(max);
        if ((Double)this.value > this.getMax()) {
            this.setValue(this.getMax());
        }
        this.sendUpdate(MAX, max);
    }

    public Double getMin() {
        return this.min;
    }

    public void setMin(Object min) {
        this.min = this.getDouble(min);
        if ((Double)this.value < this.getMin()) {
            this.setValue(this.getMin());
        }
        this.sendUpdate(MIN, min);
    }
}

