/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.table;

import com.twosigma.beakerx.chart.Color;
import com.twosigma.beakerx.handler.Handler;
import com.twosigma.beakerx.jvm.serialization.BasicObjectSerializer;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.table.CellHighlighter;
import com.twosigma.beakerx.table.ColumnType;
import com.twosigma.beakerx.table.ContextMenuAction;
import com.twosigma.beakerx.table.FontColor;
import com.twosigma.beakerx.table.FontColorProvider;
import com.twosigma.beakerx.table.RowFilter;
import com.twosigma.beakerx.table.RowsToShow;
import com.twosigma.beakerx.table.TableDisplayActions;
import com.twosigma.beakerx.table.TableDisplayAlignmentProvider;
import com.twosigma.beakerx.table.TableDisplayConverter;
import com.twosigma.beakerx.table.TableDisplayKeyValueModel;
import com.twosigma.beakerx.table.TableDisplayListModel;
import com.twosigma.beakerx.table.TableDisplayLoadingMode;
import com.twosigma.beakerx.table.TableDisplayMapModel;
import com.twosigma.beakerx.table.TableDisplayModel;
import com.twosigma.beakerx.table.TableDisplayToJson;
import com.twosigma.beakerx.table.TableDisplayUtils;
import com.twosigma.beakerx.table.TooltipAction;
import com.twosigma.beakerx.table.action.TableActionDetails;
import com.twosigma.beakerx.table.format.TableDisplayStringFormat;
import com.twosigma.beakerx.table.format.TimeStringFormat;
import com.twosigma.beakerx.table.format.ValueStringFormat;
import com.twosigma.beakerx.table.handlers.ValueChangeMsgCallbackHandler;
import com.twosigma.beakerx.table.highlight.TableDisplayCellHighlighter;
import com.twosigma.beakerx.table.highlight.ValueHighlighter;
import com.twosigma.beakerx.table.renderer.TableDisplayCellRenderer;
import com.twosigma.beakerx.util.Preconditions;
import com.twosigma.beakerx.widget.BeakerxWidget;
import com.twosigma.beakerx.widget.ChangeItem;
import com.twosigma.beakerx.widget.CompiledCodeRunner;
import com.twosigma.beakerx.widget.RunWidgetClosure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.collections.map.LinkedMap;

public class TableDisplay
extends BeakerxWidget {
    public static final String VIEW_NAME_VALUE = "TableDisplayView";
    public static final String MODEL_NAME_VALUE = "TableDisplayModel";
    public static final String TABLE_DISPLAY_SUBTYPE = "TableDisplay";
    public static final String LIST_OF_MAPS_SUBTYPE = "ListOfMaps";
    public static final String MATRIX_SUBTYPE = "Matrix";
    public static final String DICTIONARY_SUBTYPE = "Dictionary";
    public static final String THE_LENGTH_OF_TYPES_SHOULD_BE_SAME_AS_NUMBER_OF_COLUMNS = "The length of types should be same as number of columns.";
    public static final String LOAD_MORE_ROWS = "loadMoreRows";
    public int ROWS_LIMIT = 100000;
    public int ROW_LIMIT_TO_INDEX = 10000;
    private String rowLimitMsg = "Note: table is too big to display.\n      The limit is %s rows, but this table has %s rows. \n      The first %s rows are displayed as a preview.";
    private Map<ColumnType, TableDisplayStringFormat> stringFormatForType = new HashMap<ColumnType, TableDisplayStringFormat>();
    private Map<String, TableDisplayStringFormat> stringFormatForColumn = new HashMap<String, TableDisplayStringFormat>();
    private Map<ColumnType, TableDisplayCellRenderer> rendererForType = new HashMap<ColumnType, TableDisplayCellRenderer>();
    private Map<String, TableDisplayCellRenderer> rendererForColumn = new HashMap<String, TableDisplayCellRenderer>();
    private Map<ColumnType, TableDisplayAlignmentProvider> alignmentForType = new HashMap<ColumnType, TableDisplayAlignmentProvider>();
    private Map<String, TableDisplayAlignmentProvider> alignmentForColumn = new HashMap<String, TableDisplayAlignmentProvider>();
    private Map<String, Boolean> columnsFrozen = new HashMap<String, Boolean>();
    private Map<String, Boolean> columnsVisible = new HashMap<String, Boolean>();
    private List<String> columnOrder = new ArrayList<String>();
    private List<TableDisplayCellHighlighter> cellHighlighters = new ArrayList<TableDisplayCellHighlighter>();
    private List<List<String>> tooltips = new ArrayList<List<String>>();
    private Integer dataFontSize;
    private Integer headerFontSize;
    private FontColor fontColor = new FontColor();
    private List<List<?>> filteredValues;
    private boolean headersVertical;
    private String hasIndex;
    private Object doubleClickListener;
    private String doubleClickTag;
    private Map<String, Object> contextMenuListeners = new HashMap<String, Object>();
    private Map<String, String> contextMenuTags = new HashMap<String, String>();
    private TableActionDetails details;
    private TableDisplayActions displayActions = new TableDisplayActions(this);
    private String timeZone;
    private static TableDisplayLoadingMode loadingMode = TableDisplayLoadingMode.ALL;
    private static String timeZoneGlobal;
    public static int PAGE_SIZE;
    private TableDisplayModel model;
    private String loadMoreRows = "loadMoreServerInit";
    private RowsToShow rowsToShow = RowsToShow.SHOW_25;
    private Object fontColorProviderClosure;
    TableDisplayToJson serializer = new TableDisplayToJson();

    @Override
    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    @Override
    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    @Override
    public String getModelModuleValue() {
        return "beakerx_tabledisplay";
    }

    @Override
    public String getViewModuleValue() {
        return "beakerx_tabledisplay";
    }

    public TableDisplay(Map<?, ?> v) {
        this.model = new TableDisplayKeyValueModel(v, new BasicObjectSerializer());
        this.openComm();
        this.init();
        this.model.initValues();
    }

    public TableDisplay(List<List<?>> v, List<String> co, List<String> cl) {
        if (!v.isEmpty() && v.get(0) != null && !v.get(0).isEmpty()) {
            Preconditions.checkState((v.get(0).size() == cl.size() ? 1 : 0) != 0, (String)THE_LENGTH_OF_TYPES_SHOULD_BE_SAME_AS_NUMBER_OF_COLUMNS);
        }
        this.model = new TableDisplayListModel(v, co, cl, new BasicObjectSerializer());
        this.openComm();
        this.init();
        this.model.initValues();
    }

    public TableDisplay(Stream<Map<String, Object>> v, BeakerObjectConverter serializer) {
        this.model = new TableDisplayMapModel(v, serializer);
        this.openComm();
        this.init();
        this.model.initValues();
    }

    public TableDisplay(Stream<Map<String, Object>> v, BeakerObjectConverter serializer, Message message) {
        this.model = new TableDisplayMapModel(v, serializer);
        this.openComm(message);
        this.init();
        this.model.initValues();
    }

    private void init() {
        if (timeZoneGlobal != null) {
            this.setTimeZone(timeZoneGlobal);
        }
    }

    public TableDisplay(Stream<Map<String, Object>> v) {
        this(v, (BeakerObjectConverter)new BasicObjectSerializer());
    }

    public TableDisplay(Collection<Map<String, Object>> v) {
        this(v, (BeakerObjectConverter)new BasicObjectSerializer());
    }

    public TableDisplay(Collection<Map<String, Object>> v, int columnIndex) {
        this(TableDisplayUtils.transformToIndex(v, columnIndex), (BeakerObjectConverter)new BasicObjectSerializer());
        if (this.getColumnNames().size() > 0) {
            this.setHasIndex(this.getColumnNames().get(0));
        }
    }

    public TableDisplay(Map<String, Object>[] v) {
        this(new ArrayList<Map<String, Object>>(Arrays.asList(v)), (BeakerObjectConverter)new BasicObjectSerializer());
    }

    public TableDisplay(Map<String, Object>[] v, Message message) {
        this(new ArrayList<Map<String, Object>>(Arrays.asList(v)), (BeakerObjectConverter)new BasicObjectSerializer(), message);
    }

    public TableDisplay(Collection<Map<String, Object>> v, BeakerObjectConverter serializer) {
        this(v.stream(), serializer);
    }

    public TableDisplay(Collection<Map<String, Object>> v, BeakerObjectConverter serializer, Message message) {
        this(v.stream(), serializer, message);
    }

    public TableDisplay(int rowCount, int columnCount, List<String> columnNames, Element element) {
        this(TableDisplayConverter.convert(rowCount, columnCount, columnNames, element));
    }

    @Override
    protected void addValueChangeMsgCallback() {
        this.getComm().addMsgCallbackList(new Handler[]{new ValueChangeMsgCallbackHandler(() -> this.setLoadMoreRows("loadMoreServerDone"))});
    }

    @Override
    public void stateRequestHandler() {
        super.stateRequestHandler();
        this.sendModel();
    }

    @Override
    protected void openComm() {
        super.openComm();
        this.getComm().addMsgCallbackList(new Handler[]{message -> this.displayActions.handleSetDetails((Message)message)});
        this.getComm().addMsgCallbackList(new Handler[]{message -> this.displayActions.handleOnContextMenu((Message)message)});
        this.getComm().addMsgCallbackList(new Handler[]{message -> this.displayActions.handleDoubleClick((Message)message)});
    }

    public static TableDisplayLoadingMode getLoadingMode() {
        return loadingMode;
    }

    public static void setLoadingMode(TableDisplayLoadingMode lm) {
        loadingMode = lm;
    }

    public String getLoadMoreRows() {
        return this.loadMoreRows;
    }

    void setLoadMoreRows(String loadMoreRows) {
        this.loadMoreRows = loadMoreRows;
        int start = this.model.values.size();
        List<List<?>> values = this.takeNextPage();
        if (this.fontColorProviderClosure != null) {
            List<List<Color>> fontColors = this.createFontColors(this.fontColorProviderClosure, start, this.model.values.size());
            this.sendModelUpdate(this.serializer.serializeValuesWithFonts(values, this.serializer.serializeFontColor(fontColors)));
        } else {
            this.sendModelUpdate(this.serializer.serializeValues(values));
        }
    }

    public List<List<?>> takeNextPage() {
        return this.model.takeNextPage();
    }

    public List<List<?>> takeAllData() {
        return this.model.takeAllData();
    }

    public TimeUnit getStringFormatForTimes() {
        TableDisplayStringFormat tableDisplayStringFormat = this.stringFormatForType.get((Object)ColumnType.Time);
        if (tableDisplayStringFormat instanceof TimeStringFormat) {
            return ((TimeStringFormat)tableDisplayStringFormat).getUnit();
        }
        return null;
    }

    public void setStringFormatForTimes(TimeUnit stringFormatForTimes) {
        this.setStringFormatForType(ColumnType.Time, TableDisplayStringFormat.getTimeFormat(stringFormatForTimes));
    }

    public Map<ColumnType, TableDisplayStringFormat> getStringFormatForType() {
        return this.stringFormatForType;
    }

    public void setStringFormatForType(ColumnType type, TableDisplayStringFormat format) {
        this.stringFormatForType.put(type, format);
        this.sendModelUpdate(this.serializer.serializeStringFormatForType(this.stringFormatForType));
    }

    public Map<String, TableDisplayStringFormat> getStringFormatForColumn() {
        return this.stringFormatForColumn;
    }

    public void setStringFormatForColumn(String column, TableDisplayStringFormat format) {
        this.stringFormatForColumn.put(column, format);
        this.sendModelUpdate(this.serializer.serializeStringFormatForColumn(this.stringFormatForColumn));
    }

    public void setStringFormatForColumn(String column, Object closure) {
        int colIndex = this.model.columns.indexOf(column);
        if (colIndex == -1) {
            throw new IllegalArgumentException("Column " + column + " doesn't exist");
        }
        ArrayList<String> formattedValues = new ArrayList<String>();
        try {
            for (int row = 0; row < this.model.values.size(); ++row) {
                Object value = this.model.values.get(row).get(colIndex);
                Object[] params = new Object[]{value, row, colIndex, this};
                formattedValues.add((String)this.runClosure(closure, params));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not create format using closure.", e);
        }
        this.stringFormatForColumn.put(column, new ValueStringFormat(column, formattedValues));
        this.sendModelUpdate(this.serializer.serializeStringFormatForColumn(this.stringFormatForColumn));
    }

    public Map<ColumnType, TableDisplayCellRenderer> getRendererForType() {
        return this.rendererForType;
    }

    public void setRendererForType(ColumnType type, TableDisplayCellRenderer renderer) {
        this.rendererForType.put(type, renderer);
        this.sendModelUpdate(this.serializer.serializeRendererForType(this.rendererForType));
    }

    public Map<String, TableDisplayCellRenderer> getRendererForColumn() {
        return this.rendererForColumn;
    }

    public void setRendererForColumn(String column, TableDisplayCellRenderer renderer) {
        this.rendererForColumn.put(column, renderer);
        this.sendModelUpdate(this.serializer.serializeRendererForColumn(this.rendererForColumn));
    }

    public Map<ColumnType, TableDisplayAlignmentProvider> getAlignmentForType() {
        return this.alignmentForType;
    }

    public void setAlignmentProviderForType(ColumnType type, TableDisplayAlignmentProvider alignmentProvider) {
        this.alignmentForType.put(type, alignmentProvider);
        this.sendModelUpdate(this.serializer.serializeAlignmentForType(this.alignmentForType));
    }

    public Map<String, TableDisplayAlignmentProvider> getAlignmentForColumn() {
        return this.alignmentForColumn;
    }

    public void setAlignmentProviderForColumn(String column, TableDisplayAlignmentProvider alignmentProvider) {
        this.alignmentForColumn.put(column, alignmentProvider);
        this.sendModelUpdate(this.serializer.serializeAlignmentForColumn(this.alignmentForColumn));
    }

    public Map<String, Boolean> getColumnsFrozen() {
        return this.columnsFrozen;
    }

    public void setColumnFrozen(String column, boolean frozen) {
        this.columnsFrozen.put(column, frozen);
        this.sendModelUpdate(this.serializer.serializeColumnsFrozen(this.columnsFrozen));
    }

    public Map<String, Boolean> getColumnsVisible() {
        return this.columnsVisible;
    }

    public void setColumnVisible(String column, boolean visible) {
        this.columnsVisible.put(column, visible);
        this.sendModelUpdate(this.serializer.serializeColumnsVisible(this.columnsVisible));
    }

    public List<String> getColumnOrder() {
        return this.columnOrder;
    }

    public List<TableDisplayCellHighlighter> getCellHighlighters() {
        return this.cellHighlighters;
    }

    public void addCellHighlighter(TableDisplayCellHighlighter cellHighlighter) {
        this.cellHighlighters.add(cellHighlighter);
        this.sendModelUpdate(this.serializer.serializeCellHighlighters(this.cellHighlighters));
    }

    public void addCellHighlighter(Object closure) {
        try {
            int rowSize = this.model.values.get(0).size();
            for (int colInd = 0; colInd < rowSize; ++colInd) {
                boolean hasHighlightedValues = false;
                ArrayList<Color> columnColors = new ArrayList<Color>();
                for (int rowInd = 0; rowInd < this.model.values.size(); ++rowInd) {
                    Object[] params = new Object[]{rowInd, colInd, this};
                    Color color = (Color)this.runClosure(closure, params);
                    if (color != null) {
                        hasHighlightedValues = true;
                    }
                    columnColors.add(color);
                }
                if (!hasHighlightedValues) continue;
                this.addCellHighlighter(new ValueHighlighter(this.model.columns.get(colInd), columnColors));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set cell highlighter using closure.", e);
        }
    }

    public void addCellHighlighter(CellHighlighter cellHighlighter) {
        try {
            int rowSize = this.model.values.get(0).size();
            for (int colInd = 0; colInd < rowSize; ++colInd) {
                boolean hasHighlightedValues = false;
                ArrayList<Color> columnColors = new ArrayList<Color>();
                for (int rowInd = 0; rowInd < this.model.values.size(); ++rowInd) {
                    Color color = cellHighlighter.apply(rowInd, colInd, this);
                    if (color != null) {
                        hasHighlightedValues = true;
                    }
                    columnColors.add(color);
                }
                if (!hasHighlightedValues) continue;
                this.addCellHighlighter(new ValueHighlighter(this.model.columns.get(colInd), columnColors));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set cell highlighter using closure.", e);
        }
    }

    public void removeAllCellHighlighters() {
        this.cellHighlighters.clear();
        this.sendModelUpdate(this.serializer.serializeCellHighlighters(this.cellHighlighters));
    }

    public void setColumnOrder(List<String> columnOrder) {
        this.columnOrder = columnOrder;
        this.sendModelUpdate(this.serializer.serializeColumnOrder(this.columnOrder));
    }

    public void setToolTip(Object closure) {
        try {
            for (int rowInd = 0; rowInd < this.model.values.size(); ++rowInd) {
                List<?> row = this.model.values.get(rowInd);
                ArrayList<String> rowToolTips = new ArrayList<String>();
                for (int colInd = 0; colInd < row.size(); ++colInd) {
                    Object[] params = new Object[]{rowInd, colInd, this};
                    rowToolTips.add((String)this.runClosure(closure, params));
                }
                this.tooltips.add(rowToolTips);
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set tooltip using closure.", e);
        }
        this.sendModelUpdate(this.serializer.serializeTooltips(this.tooltips));
    }

    public void setTooltip(TooltipAction tooltip) {
        try {
            for (int rowInd = 0; rowInd < this.model.values.size(); ++rowInd) {
                List<?> row = this.model.values.get(rowInd);
                ArrayList<String> rowToolTips = new ArrayList<String>();
                for (int colInd = 0; colInd < row.size(); ++colInd) {
                    rowToolTips.add(tooltip.apply(rowInd, colInd, this));
                }
                this.tooltips.add(rowToolTips);
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set tooltip using closure.", e);
        }
        this.sendModelUpdate(this.serializer.serializeTooltips(this.tooltips));
    }

    public List<List<String>> getTooltips() {
        return this.tooltips;
    }

    public Integer getDataFontSize() {
        return this.dataFontSize;
    }

    public void setDataFontSize(Integer dataFontSize) {
        this.dataFontSize = dataFontSize;
        this.sendModelUpdate(this.serializer.serializeDataFontSize(this.dataFontSize));
    }

    public Integer getHeaderFontSize() {
        return this.headerFontSize;
    }

    public void setHeaderFontSize(Integer headerFontSize) {
        this.headerFontSize = headerFontSize;
        this.sendModelUpdate(this.serializer.serializeHeaderFontSize(this.headerFontSize));
    }

    public FontColor getFontColor() {
        return this.fontColor;
    }

    public void setFontColorProvider(Object closure) {
        this.fontColorProviderClosure = closure;
        this.setFontColorProvider(this.fontColorProviderClosure, 0, this.model.values.size());
    }

    private void setFontColorProvider(Object closure, int start, int end) {
        List<List<Color>> fontColors = this.createFontColors(closure, start, end);
        this.sendModelUpdate(this.serializer.serializeFontColor(fontColors));
    }

    private List<List<Color>> createFontColors(Object closure, int start, int end) {
        if (start == 0) {
            this.fontColor.clear();
        }
        try {
            for (int rowInd = start; rowInd < end; ++rowInd) {
                List<?> row = this.model.values.get(rowInd);
                ArrayList<Color> rowFontColors = new ArrayList<Color>();
                for (int colInd = 0; colInd < row.size(); ++colInd) {
                    Object[] params = new Object[]{rowInd, colInd, this};
                    rowFontColors.add((Color)this.runClosure(closure, params));
                }
                this.fontColor.add(rowFontColors);
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set font color using closure.", e);
        }
        return this.fontColor.get(start, end);
    }

    public void setFontColorProvider(FontColorProvider fontColorProvider) {
        try {
            for (int rowInd = 0; rowInd < this.model.values.size(); ++rowInd) {
                List<?> row = this.model.values.get(rowInd);
                ArrayList<Color> rowFontColors = new ArrayList<Color>();
                for (int colInd = 0; colInd < row.size(); ++colInd) {
                    rowFontColors.add(fontColorProvider.apply(rowInd, colInd, this));
                }
                this.fontColor.add(rowFontColors);
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set font color using closure.", e);
        }
        this.sendModelUpdate(this.serializer.serializeFontColor(this.fontColor.get()));
    }

    public void setRowFilter(Object closure) {
        ArrayList filteredValues = new ArrayList();
        try {
            for (int rowInd = 0; rowInd < this.model.values.size(); ++rowInd) {
                Object[] params = new Object[]{rowInd, this.model.values};
                if (!((Boolean)this.runClosure(closure, params)).booleanValue()) continue;
                filteredValues.add(this.model.values.get(rowInd));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set row filter using closure.", e);
        }
        this.filteredValues = filteredValues;
        this.sendModelUpdate(this.serializer.serializeFilteredValues(this.filteredValues));
    }

    public void setRowFilter(RowFilter rowFilter) {
        ArrayList filteredValues = new ArrayList();
        try {
            for (int rowInd = 0; rowInd < this.model.values.size(); ++rowInd) {
                if (!rowFilter.apply(rowInd, this.model.values).booleanValue()) continue;
                filteredValues.add(this.model.values.get(rowInd));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set row filter using closure.", e);
        }
        this.filteredValues = filteredValues;
        this.sendModelUpdate(this.serializer.serializeFilteredValues(this.filteredValues));
    }

    public void setHeadersVertical(boolean headersVertical) {
        this.headersVertical = headersVertical;
        this.sendModelUpdate(this.serializer.serializeHeadersVertical(this.headersVertical));
    }

    public Boolean getHeadersVertical() {
        return this.headersVertical;
    }

    public void setHasIndex(String hasIndex) {
        this.hasIndex = hasIndex;
        this.sendModelUpdate(this.serializer.serializeHasIndex(this.hasIndex));
    }

    public String getHasIndex() {
        return this.hasIndex;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        this.sendModelUpdate(this.serializer.serializeTimeZone(this.timeZone));
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public static void setTimeZoneGlobally(String tz) {
        timeZoneGlobal = tz;
    }

    public String getTimeZoneGlobally() {
        return timeZoneGlobal;
    }

    public List<List<?>> getFilteredValues() {
        return this.filteredValues;
    }

    public static List<Map<String, Object>> getValuesAsRows(List<List<?>> values, List<String> columns) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        if (columns != null && values != null) {
            for (List<?> value : values) {
                LinkedMap m = new LinkedMap();
                for (int c = 0; c < columns.size(); ++c) {
                    if (value.size() <= c) continue;
                    m.put(columns.get(c), value.get(c));
                }
                rows.add((Map<String, Object>)m);
            }
        } else {
            throw new IllegalArgumentException("Method 'getValuesAsRows' doesn't supported for this table");
        }
        return rows;
    }

    public static List<List<?>> getValuesAsMatrix(List<List<?>> values) {
        return values;
    }

    public static Map<String, Object> getValuesAsDictionary(List<List<?>> values) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (List<?> l : values) {
            m.put(l.get(0).toString(), l.get(1));
        }
        return m;
    }

    public List<Map<String, Object>> getValuesAsRows() {
        return TableDisplay.getValuesAsRows(this.model.values, this.model.columns);
    }

    public List<List<?>> getValuesAsMatrix() {
        return TableDisplay.getValuesAsMatrix(this.model.values);
    }

    public Map<String, Object> getValuesAsDictionary() {
        return TableDisplay.getValuesAsDictionary(this.model.values);
    }

    public List<List<?>> getValues() {
        return this.model.values;
    }

    public List<String> getColumnNames() {
        return this.model.columns;
    }

    public List<String> getTypes() {
        return this.model.classes;
    }

    public String getSubtype() {
        return this.model.subtype;
    }

    public void setDoubleClickAction(String tagName) {
        this.doubleClickListener = null;
        this.doubleClickTag = tagName;
        this.sendModelUpdate(this.serializer.serializeDoubleClickAction(this.doubleClickTag, this.hasDoubleClickAction()));
    }

    public void setDoubleClickAction(Object listener) {
        this.doubleClickListener = listener;
        this.doubleClickTag = null;
        this.sendModelUpdate(this.serializer.serializeDoubleClickAction(this.doubleClickTag, this.hasDoubleClickAction()));
    }

    public void fireDoubleClick(List<Object> params, Message message) {
        if (this.doubleClickListener != null) {
            params.add(this);
            CompiledCodeRunner.runCompiledCode(message, this::doubleClickHandler, params);
            this.sendModel();
        }
    }

    public void fireContextMenuClick(String name, List<Object> params, Message message) {
        Object contextMenuListener = this.contextMenuListeners.get(name);
        if (contextMenuListener != null) {
            params.add(this);
            CompiledCodeRunner.runCompiledCode(message, this::contextMenuClickHandlerCommon, contextMenuListener, params);
            this.sendModel();
        }
    }

    private Object contextMenuClickHandlerCommon(Object ... params) throws Exception {
        Object actionObject = params[0];
        ArrayList other = (ArrayList)params[1];
        if (actionObject instanceof ContextMenuAction) {
            ContextMenuAction action = (ContextMenuAction)actionObject;
            action.apply((Integer)other.get(0), (Integer)other.get(1), this);
        } else {
            Object object = this.runClosure(params[0], other.toArray());
        }
        return MIMEContainer.HIDDEN;
    }

    public String getDoubleClickTag() {
        return this.doubleClickTag;
    }

    private Object doubleClickHandler(Object ... params) throws Exception {
        Object[] values = ((List)params[0]).toArray();
        Object ret = this.runClosure(this.doubleClickListener, values);
        return MIMEContainer.HIDDEN;
    }

    public boolean hasDoubleClickAction() {
        return this.doubleClickListener != null;
    }

    public void addContextMenuItem(String name, Object closure) {
        this.contextMenuListeners.put(name, closure);
    }

    public void addContextMenuItem(String name, String tagName) {
        this.contextMenuTags.put(name, tagName);
    }

    public Set<String> getContextMenuItems() {
        return this.contextMenuListeners.keySet();
    }

    public Map<String, String> getContextMenuTags() {
        return this.contextMenuTags;
    }

    public void setDetails(TableActionDetails details) {
        this.details = details;
    }

    public TableActionDetails getDetails() {
        return this.details;
    }

    protected Object runClosure(Object closure, Object ... params) throws Exception {
        return RunWidgetClosure.runClosure(closure, params);
    }

    @Override
    protected Map serializeToJsonObject() {
        return this.serializer.toJson(this);
    }

    @Override
    protected Map serializeToJsonObject(Object item) {
        return this.serializer.toJson(item);
    }

    public String getRowLimitMsg() {
        return String.format(this.rowLimitMsg, this.ROWS_LIMIT, this.model.values.size(), this.ROW_LIMIT_TO_INDEX);
    }

    public void updateCell(int row, String columnName, Object value) {
        int index = this.getColumnIndex(columnName);
        List<?> rowList = this.model.values.get(row);
        rowList.set(index, value);
    }

    private int getColumnIndex(String columnName) {
        int index = this.model.columns.indexOf(columnName);
        if (index < 0) {
            throw new RuntimeException("There is no given column name: " + columnName);
        }
        return index;
    }

    public void setRowLimitMsg(String rowLimitMsg) {
        this.rowLimitMsg = rowLimitMsg;
    }

    public void setRowsToShow(RowsToShow rows) {
        this.rowsToShow = rows;
        this.sendModelUpdate(this.serializer.serializeRowsToShow(this.rowsToShow));
    }

    public RowsToShow getRowsToShow() {
        return this.rowsToShow;
    }

    @Override
    protected List<ChangeItem> doSendModel() {
        List<ChangeItem> changeItems = super.doSendModel();
        changeItems.add(new ChangeItem(LOAD_MORE_ROWS, (Object)this.getLoadMoreRows()));
        return changeItems;
    }

    static {
        PAGE_SIZE = 1000;
    }

    public static interface Element {
        public String get(int var1, int var2);
    }
}

