/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectSerializer;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.immutable.Seq;

public class ScalaPrimitiveTypeListOfListSerializer
implements ObjectSerializer {
    private static final Logger logger = LoggerFactory.getLogger((String)ScalaPrimitiveTypeListOfListSerializer.class.getName());
    private final BeakerObjectConverter parent;

    public ScalaPrimitiveTypeListOfListSerializer(BeakerObjectConverter p) {
        this.parent = p;
    }

    public boolean canBeUsed(Object obj, boolean expand) {
        if (!expand) {
            return false;
        }
        if (!(obj instanceof Seq)) {
            return false;
        }
        Collection col = JavaConversions.asJavaCollection((Iterable)((Iterable)obj));
        if (col.isEmpty()) {
            return false;
        }
        for (Object o : col) {
            if (!(o instanceof Seq)) {
                return false;
            }
            Collection col2 = JavaConversions.asJavaCollection((Iterable)((Iterable)o));
            for (Object o2 : col2) {
                if (this.parent.isPrimitiveType(o2.getClass().getName())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean writeObject(Object obj, JsonGenerator jgen, boolean expand) throws JsonProcessingException, IOException {
        logger.debug("collection of collections");
        Collection m = JavaConversions.asJavaCollection((Iterable)((Iterable)obj));
        int max = 0;
        for (Object entry : m) {
            Collection e = JavaConversions.asJavaCollection((Iterable)((Iterable)entry));
            if (max >= e.size()) continue;
            max = e.size();
        }
        ArrayList<CallSite> columns = new ArrayList<CallSite>();
        for (int i = 0; i < max; ++i) {
            columns.add((CallSite)((Object)("c" + i)));
        }
        ArrayList values = new ArrayList();
        for (Object entry : m) {
            Collection e = JavaConversions.asJavaCollection((Iterable)((Iterable)entry));
            ArrayList l2 = new ArrayList(e);
            if (l2.size() < max) {
                for (int i = l2.size(); i < max; ++i) {
                    l2.add(null);
                }
            }
            values.add(l2);
        }
        jgen.writeStartObject();
        jgen.writeObjectField("type", (Object)"TableDisplay");
        jgen.writeObjectField("columnNames", columns);
        jgen.writeObjectField("values", values);
        jgen.writeObjectField("subtype", (Object)"Matrix");
        jgen.writeEndObject();
        return true;
    }
}

