/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectSerializer;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;
import scala.collection.Map;

public class ScalaMapSerializer
implements ObjectSerializer {
    private static final Logger logger = LoggerFactory.getLogger((String)ScalaMapSerializer.class.getName());
    private final BeakerObjectConverter parent;

    public ScalaMapSerializer(BeakerObjectConverter p) {
        this.parent = p;
    }

    public boolean canBeUsed(Object obj, boolean expand) {
        return obj instanceof scala.collection.immutable.Map;
    }

    public boolean writeObject(Object obj, JsonGenerator jgen, boolean expand) throws JsonProcessingException, IOException {
        logger.debug("generic map");
        java.util.Map m = JavaConversions.mapAsJavaMap((Map)((Map)obj));
        Set keys = m.keySet();
        for (Object key : keys) {
            if (key != null && key instanceof String) continue;
            jgen.writeObject((Object)obj.toString());
            return true;
        }
        jgen.writeStartObject();
        for (Object key : keys) {
            Object val = m.get(key);
            jgen.writeFieldName(key.toString());
            if (this.parent.writeObject(val, jgen, false)) continue;
            jgen.writeObject((Object)(val != null ? val.toString() : "null"));
        }
        jgen.writeEndObject();
        return true;
    }
}

