/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.AbstractCSVToBean;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvConstraintViolationException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CsvToBean<T>
extends AbstractCSVToBean {
    private List<CsvException> capturedExceptions = null;
    private MappingStrategy<T> mappingStrategy;
    private CSVReader csvReader;
    private CsvToBeanFilter filter = null;
    private boolean throwExceptions = true;

    public List<T> parse(MappingStrategy<T> mapper, Reader reader) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(new CSVReader(reader));
        return this.parse();
    }

    public List<T> parse(MappingStrategy<T> mapper, Reader reader, boolean throwExceptions) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(new CSVReader(reader));
        this.setThrowExceptions(throwExceptions);
        return this.parse();
    }

    public List<T> parse(MappingStrategy<T> mapper, Reader reader, CsvToBeanFilter filter) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(new CSVReader(reader));
        this.setFilter(filter);
        return this.parse();
    }

    public List<T> parse(MappingStrategy<T> mapper, Reader reader, CsvToBeanFilter filter, boolean throwExceptions) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(new CSVReader(reader));
        this.setFilter(filter);
        this.setThrowExceptions(throwExceptions);
        return this.parse();
    }

    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(csv);
        return this.parse();
    }

    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv, boolean throwExceptions) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(csv);
        this.setThrowExceptions(throwExceptions);
        return this.parse();
    }

    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv, CsvToBeanFilter filter) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(csv);
        this.setFilter(filter);
        return this.parse();
    }

    public List<T> parse(MappingStrategy<T> mapper, CSVReader csv, CsvToBeanFilter filter, boolean throwExceptions) {
        this.setMappingStrategy(mapper);
        this.setCsvReader(csv);
        this.setFilter(filter);
        this.setThrowExceptions(throwExceptions);
        return this.parse();
    }

    public List<T> parse() throws IllegalStateException {
        if (this.mappingStrategy == null || this.csvReader == null) {
            throw new IllegalStateException("Both mapping strategy and CSVReader/Reader must be specified!");
        }
        long lineProcessed = 0L;
        Object[] line = null;
        try {
            this.mappingStrategy.captureHeader(this.csvReader);
        }
        catch (Exception e) {
            throw new RuntimeException("Error capturing CSV header!", e);
        }
        try {
            ArrayList list = new ArrayList();
            while (null != (line = this.csvReader.readNext())) {
                ++lineProcessed;
                try {
                    this.processLine(this.mappingStrategy, this.filter, (String[])line, list);
                }
                catch (CsvException e) {
                    CsvException csve = e;
                    csve.setLineNumber(lineProcessed);
                    if (this.throwExceptions) {
                        throw csve;
                    }
                    this.getCapturedExceptions().add(csve);
                }
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing CSV line: " + lineProcessed + " values: " + Arrays.toString(line), e);
        }
    }

    private void processLine(MappingStrategy<T> mapper, CsvToBeanFilter filter, String[] line, List<T> list) throws IllegalAccessException, InvocationTargetException, InstantiationException, IntrospectionException, CsvBadConverterException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        if (filter == null || filter.allowLine(line)) {
            T obj = this.processLine(mapper, line);
            list.add(obj);
        }
    }

    protected T processLine(MappingStrategy<T> mapper, String[] line) throws IllegalAccessException, InvocationTargetException, InstantiationException, IntrospectionException, CsvBadConverterException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        mapper.registerBeginningOfRecordForReading();
        T bean = mapper.createBean();
        for (int col = 0; col < line.length; ++col) {
            if (mapper.isAnnotationDriven()) {
                this.processField(mapper, line, bean, col);
                continue;
            }
            this.processProperty(mapper, line, bean, col);
        }
        mapper.registerEndOfRecordForReading();
        return bean;
    }

    private void processProperty(MappingStrategy<T> mapper, String[] line, T bean, int col) throws IntrospectionException, InstantiationException, IllegalAccessException, InvocationTargetException, CsvBadConverterException {
        PropertyDescriptor prop = mapper.findDescriptor(col);
        if (null != prop) {
            String value = this.checkForTrim(line[col], prop);
            Object obj = this.convertValue(value, prop);
            prop.getWriteMethod().invoke(bean, obj);
        }
    }

    private void processField(MappingStrategy<T> mapper, String[] line, T bean, int col) throws CsvBadConverterException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        BeanField beanField = mapper.findField(col);
        if (beanField != null) {
            String value = line[col];
            beanField.setFieldValue(bean, value);
        }
    }

    @Override
    protected PropertyEditor getPropertyEditor(PropertyDescriptor desc) throws InstantiationException, IllegalAccessException {
        Class<?> cls = desc.getPropertyEditorClass();
        if (null != cls) {
            return (PropertyEditor)cls.newInstance();
        }
        return this.getPropertyEditorValue(desc.getPropertyType());
    }

    public List<CsvException> getCapturedExceptions() {
        if (this.capturedExceptions == null) {
            this.capturedExceptions = new ArrayList<CsvException>();
        }
        return this.capturedExceptions;
    }

    public void setMappingStrategy(MappingStrategy<T> mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    public void setCsvReader(CSVReader csvReader) {
        this.csvReader = csvReader;
    }

    public void setFilter(CsvToBeanFilter filter) {
        this.filter = filter;
    }

    public void setThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }
}

