/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractBeanField;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class BeanFieldDate<T>
extends AbstractBeanField<T> {
    private final String formatString;
    private final String locale;
    private static final String NOT_DATE = "@CsvDate annotation used on non-date field.";

    public BeanFieldDate(Field field, boolean required, String formatString, String locale) {
        super(field, required);
        this.formatString = formatString;
        this.locale = locale;
    }

    private SimpleDateFormat getFormat() {
        SimpleDateFormat sdf;
        if (StringUtils.isNotEmpty((CharSequence)this.locale)) {
            Locale l = Locale.forLanguageTag(this.locale);
            sdf = new SimpleDateFormat(this.formatString, l);
        } else {
            sdf = new SimpleDateFormat(this.formatString);
        }
        return sdf;
    }

    private <U> U convertDate(Object value, Class<U> fieldType) throws CsvDataTypeMismatchException {
        U o;
        if (value instanceof String) {
            try {
                Date d = this.getFormat().parse((String)value);
                o = fieldType.getConstructor(Long.TYPE).newInstance(d.getTime());
            }
            catch (ParseException e) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, fieldType);
                csve.initCause(e);
                throw csve;
            }
            catch (InstantiationException e) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, fieldType);
                csve.initCause(e);
                throw csve;
            }
            catch (IllegalAccessException e) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, fieldType);
                csve.initCause(e);
                throw csve;
            }
            catch (NoSuchMethodException e) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, fieldType);
                csve.initCause(e);
                throw csve;
            }
            catch (InvocationTargetException e) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, fieldType);
                csve.initCause(e);
                throw csve;
            }
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            o = fieldType.cast(this.getFormat().format((Date)value));
        } else {
            throw new CsvDataTypeMismatchException(value, fieldType, NOT_DATE);
        }
        return o;
    }

    private <U> U convertCalendar(Object value, Class<U> fieldType) throws CsvDataTypeMismatchException {
        U o;
        if (value instanceof String) {
            Date d;
            try {
                d = this.getFormat().parse((String)value);
            }
            catch (ParseException e) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, fieldType);
                csve.initCause(e);
                throw csve;
            }
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(d);
            if (fieldType == XMLGregorianCalendar.class) {
                try {
                    o = fieldType.cast(DatatypeFactory.newInstance().newXMLGregorianCalendar(gc));
                }
                catch (DatatypeConfigurationException e) {
                    CsvDataTypeMismatchException ex = new CsvDataTypeMismatchException("It was not possible to initialize an XMLGregorianCalendar.");
                    ex.initCause(e);
                    throw ex;
                }
            } else {
                o = fieldType.cast(gc);
            }
        } else {
            Calendar c;
            if (value instanceof XMLGregorianCalendar) {
                c = ((XMLGregorianCalendar)value).toGregorianCalendar();
            } else if (value instanceof Calendar) {
                c = (Calendar)value;
            } else {
                throw new CsvDataTypeMismatchException(value, fieldType, NOT_DATE);
            }
            o = fieldType.cast(this.getFormat().format(c.getTime()));
        }
        return o;
    }

    private <U> U convertCommon(Object value, Class<U> fieldType) throws CsvDataTypeMismatchException {
        U o;
        Class<Object> conversionClass;
        Class<Object> clazz = conversionClass = fieldType == String.class ? value.getClass() : fieldType;
        if (Date.class.isAssignableFrom(conversionClass)) {
            o = this.convertDate(value, fieldType);
        } else if (Calendar.class.isAssignableFrom(conversionClass) || XMLGregorianCalendar.class.isAssignableFrom(conversionClass)) {
            o = this.convertCalendar(value, fieldType);
        } else {
            throw new CsvDataTypeMismatchException(value, fieldType, NOT_DATE);
        }
        return o;
    }

    @Override
    protected Object convert(String value) throws CsvDataTypeMismatchException {
        return StringUtils.isBlank((CharSequence)value) ? null : this.convertCommon(value, this.field.getType());
    }

    @Override
    protected String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        return value == null ? null : this.convertCommon(value, String.class);
    }
}

