/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.kernel.BeakerXJson;
import com.twosigma.beakerx.widget.SparkUiDefaults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SparkUiDefaultsImpl
implements SparkUiDefaults {
    public static final String SPARK_EXECUTOR_CORES_DEFAULT = "10";
    public static final String SPARK_EXECUTOR_MEMORY_DEFAULT = "8g";
    public static final String SPARK_MASTER_DEFAULT = "local[*]";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String PROPERTIES = "properties";
    public static final String SPARK_OPTIONS = "spark_options";
    public static final String BEAKERX = "beakerx";
    private Map<String, Object> defaults = new HashMap<String, Object>();
    private List<Map<String, Object>> profiles = new ArrayList<Map<String, Object>>();
    private BeakerXJson beakerXJson;
    private String currentProfile = "";

    public SparkUiDefaultsImpl(BeakerXJson beakerXJson) {
        this.beakerXJson = beakerXJson;
    }

    @Override
    public void saveSparkConf(List<Map<String, Object>> profiles) {
        Map map = this.beakerXJson.beakerxJsonAsMap();
        Map sparkOptions = ((Map)map.get(BEAKERX)).getOrDefault(SPARK_OPTIONS, new HashMap());
        sparkOptions.put("profiles", profiles == null ? new ArrayList<Map<String, Object>>() : profiles);
        ((Map)map.get(BEAKERX)).put(SPARK_OPTIONS, sparkOptions);
        this.beakerXJson.save(map);
        this.profiles = profiles;
    }

    @Override
    public void loadDefaults() {
        this.loadProfiles();
        this.defaults = this.getProfileByName(this.currentProfile);
    }

    @Override
    public List<Map<String, Object>> getProfiles() {
        return this.profiles;
    }

    @Override
    public Map<String, Object> getProfileByName(String name) {
        return new HashMap<String, Object>(this.profiles.stream().filter(x -> x.get(NAME).equals(name)).findFirst().orElse(new HashMap()));
    }

    @Override
    public void loadProfiles() {
        Map beakerxJsonAsMap = this.beakerXJson.beakerxJsonAsMap();
        Map sparkOptions = ((Map)beakerxJsonAsMap.get(BEAKERX)).getOrDefault(SPARK_OPTIONS, new HashMap());
        List profiles = (List)sparkOptions.get("profiles");
        this.currentProfile = sparkOptions.getOrDefault("current_profile", "");
        if (profiles == null) {
            HashMap<String, Object> defaultProfile = new HashMap<String, Object>();
            defaultProfile.put(NAME, "");
            defaultProfile.put("spark.master", SPARK_MASTER_DEFAULT);
            defaultProfile.put("spark.executor.cores", SPARK_EXECUTOR_CORES_DEFAULT);
            defaultProfile.put("spark.executor.memory", SPARK_EXECUTOR_MEMORY_DEFAULT);
            defaultProfile.put(PROPERTIES, new ArrayList());
            this.saveProfiles(Arrays.asList(defaultProfile));
        } else {
            this.profiles = profiles;
        }
    }

    @Override
    public void saveProfiles(List<Map<String, Object>> profiles) {
        this.profiles = profiles;
        this.saveSparkConf(profiles);
    }

    @Override
    public void saveCurrentProfileName(String profileName) {
        Map map = this.beakerXJson.beakerxJsonAsMap();
        Map sparkOptions = ((Map)map.get(BEAKERX)).getOrDefault(SPARK_OPTIONS, new HashMap());
        sparkOptions.put("current_profile", profileName);
        ((Map)map.get(BEAKERX)).put(SPARK_OPTIONS, sparkOptions);
        this.beakerXJson.save(map);
        this.currentProfile = profileName;
    }

    @Override
    public String getCurrentProfileName() {
        return this.currentProfile;
    }

    @Override
    public Object get(String key) {
        return this.defaults.get(key);
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.defaults.containsKey(PROPERTIES)) {
            List props = (List)this.defaults.get(PROPERTIES);
            props.forEach(x -> {
                String pname = (String)x.get(NAME);
                String pvalue = (String)x.get(VALUE);
                if (pname != null && !pname.isEmpty() && pvalue != null && !pvalue.isEmpty()) {
                    result.put(pname, pvalue);
                }
            });
        }
        return result;
    }

    @Override
    public void removeSparkConf(String profileName) {
        this.profiles.removeIf(x -> x.get(NAME).equals(profileName));
        this.saveSparkConf(this.profiles);
    }
}

