/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.msg.StacktraceHtmlPrinter;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.scala.magic.command.YarnSparkOptionCommand;
import com.twosigma.beakerx.widget.ErrorPrinter;
import com.twosigma.beakerx.widget.SparkEngineBase;
import com.twosigma.beakerx.widget.SparkEngineWithUI;
import com.twosigma.beakerx.widget.SparkEngineWithUIFactory;
import com.twosigma.beakerx.widget.SparkListenerService;
import com.twosigma.beakerx.widget.SparkSessionBuilder;
import com.twosigma.beakerx.widget.SparkSessionBuilderFactory;
import com.twosigma.beakerx.widget.SparkUIApi;
import com.twosigma.beakerx.widget.SparkVariable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.spark.SparkConf;

public class SparkEngineWithUIImpl
extends SparkEngineBase
implements SparkEngineWithUI {
    public static final String STOP_FROM_SPARK_UI_FORM_BUTTON = "stop_from_spark_ui_form_button";
    private SparkSessionBuilderFactory sparkSessionBuilderFactory;
    private SparkListenerService sparkListenerService;
    private boolean autoStart;

    SparkEngineWithUIImpl(SparkSessionBuilder sparkSessionBuilder, SparkSessionBuilderFactory sparkSessionBuilderFactory, SparkListenerService sparkListenerService) {
        super(sparkSessionBuilder, SparkEngineWithUIImpl.errorPrinter());
        this.sparkSessionBuilderFactory = sparkSessionBuilderFactory;
        this.sparkListenerService = sparkListenerService;
    }

    @Override
    public void configAutoStart() {
        this.autoStart = true;
    }

    @Override
    public void stop() {
        this.stopContext = STOP_FROM_SPARK_UI_FORM_BUTTON;
        this.sparkSessionBuilder.stop();
    }

    @Override
    public void cancelAllJobs() {
        this.sparkSessionBuilder.cancelAllJobs();
    }

    @Override
    public void cancelStage(int stageid) {
        this.sparkSessionBuilder.cancelStage(stageid);
    }

    @Override
    public boolean isAutoStart() {
        return this.autoStart;
    }

    @Override
    public TryResult createSparkContext(KernelFunctionality kernel, SparkUIApi sparkUI, Message parentMessage, Map<String, Object> sparkOptions) {
        TryResult sparkSessionTry;
        this.resetEngine();
        this.sparkSessionBuilder = this.newSessionBuilder(sparkOptions);
        if (this.shouldEnableHive(sparkOptions)) {
            this.sparkSessionBuilder.enableHiveSupport();
        }
        if ((sparkSessionTry = this.createSparkSession()).isError()) {
            return sparkSessionTry;
        }
        this.sparkListenerService.configure(this.sparkSessionBuilder, sparkUI);
        SparkVariable.putSparkSession(this.sparkSessionBuilder.getOrCreate());
        TryResult tryResultSparkContext = this.initSparkContextInShell(kernel, parentMessage);
        if (!tryResultSparkContext.isError()) {
            kernel.registerCancelHook(SparkVariable::cancelAllJobs);
        }
        return tryResultSparkContext;
    }

    private SparkSessionBuilder newSessionBuilder(Map<String, Object> sparkOptions) {
        SparkConf sparkConf = this.newSparkConf(sparkOptions);
        SparkSessionBuilder sparkSessionBuilder = this.sparkSessionBuilderFactory.newInstance(sparkConf);
        sparkSessionBuilder.config("spark.extraListeners", "com.twosigma.beakerx.widget.StartStopSparkListener");
        sparkSessionBuilder.config("beakerx.id", UUID.randomUUID().toString());
        return sparkSessionBuilder;
    }

    private SparkConf newSparkConf(Map<String, Object> sparkOptions) {
        SparkConf sparkConf = this.createSparkConf(sparkOptions);
        this.configureSparkConf(sparkConf);
        this.configureRuntime(sparkConf);
        return sparkConf;
    }

    private void resetEngine() {
        this.stopContext = "stop";
        this.jobLinkFactory(this.createJobLinkFactory());
        this.stageLinkFactory(this.createStageLinkFactory());
        this.sparkUiWebUrlFactory(this.createSparkUiWebUrl());
    }

    private void configureRuntime(SparkConf sparkConf) {
        if (sparkConf.contains("spark.master") && sparkConf.get("spark.master").contains("yarn")) {
            YarnSparkOptionCommand.runtimeConfiguration(this, sparkConf);
        }
    }

    private boolean shouldEnableHive(Map<String, Object> sparkOptions) {
        if (!sparkOptions.isEmpty()) {
            List properties = (List)sparkOptions.get("properties");
            Optional<Object> first = properties.stream().filter(x -> ((Map)x).get("name").equals("spark.sql.catalogImplementation")).findFirst();
            return first.isPresent() && ((Map)first.get()).get("value").equals("hive");
        }
        return false;
    }

    private static ErrorPrinter errorPrinter() {
        return e -> {
            CharSequence[] print = StacktraceHtmlPrinter.print((String[])((String[])Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).toArray(String[]::new)));
            return String.join((CharSequence)System.lineSeparator(), print);
        };
    }

    public static class SparkEngineWithUIFactoryImpl
    implements SparkEngineWithUIFactory {
        @Override
        public SparkEngineWithUI create(SparkSessionBuilder sparkSessionBuilder, SparkSessionBuilderFactory sparkSessionBuilderFactory, SparkListenerService sparkListenerService) {
            return new SparkEngineWithUIImpl(sparkSessionBuilder, sparkSessionBuilderFactory, sparkListenerService);
        }
    }
}

