/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.IndexFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.HasArray;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class EncoderUtil {
    private EncoderUtil() {
    }

    public static Feature encodeIndexFeature(Transformer transformer, Feature feature, List<?> categories, DataType dataType, SkLearnEncoder encoder) {
        ArrayList<Number> indexCategories = new ArrayList<Number>(categories.size());
        block5: for (int i = 0; i < categories.size(); ++i) {
            switch (dataType) {
                case INTEGER: {
                    indexCategories.add(i);
                    continue block5;
                }
                case FLOAT: {
                    indexCategories.add(Float.valueOf(i));
                    continue block5;
                }
                case DOUBLE: {
                    indexCategories.add(Double.valueOf(i));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return EncoderUtil.encodeIndexFeature(transformer, feature, categories, indexCategories, null, null, dataType, encoder);
    }

    public static Feature encodeIndexFeature(Transformer transformer, Feature feature, List<?> categories, List<? extends Number> indexCategories, Number mapMissingTo, Number defaultValue, DataType dataType, SkLearnEncoder encoder) {
        ClassDictUtil.checkSize((Collection[])new Collection[]{categories, indexCategories});
        encoder.toCategorical(feature.getName(), EncoderUtil.filterCategories(categories));
        MapValues mapValues = PMMLUtil.createMapValues((FieldName)feature.getName(), categories, indexCategories).setMapMissingTo((Object)mapMissingTo).setDefaultValue((Object)defaultValue);
        DerivedField derivedField = encoder.createDerivedField(transformer.createFieldName("encoder", feature), OpType.CATEGORICAL, dataType, (Expression)mapValues);
        IndexFeature encodedFeature = new IndexFeature((PMMLEncoder)encoder, (Field)derivedField, indexCategories);
        CategoricalFeature result = new CategoricalFeature((PMMLEncoder)encoder, feature, categories, (Feature)encodedFeature){
            final /* synthetic */ Feature val$encodedFeature;
            {
                this.val$encodedFeature = feature;
                super(x0, x1, x2);
            }

            public ContinuousFeature toContinuousFeature() {
                return this.val$encodedFeature.toContinuousFeature();
            }
        };
        return result;
    }

    public static List<List<?>> transformCategories(List<HasArray> arrays) {
        Function function = new Function<HasArray, List<?>>(){

            public List<?> apply(HasArray hasArray) {
                return hasArray.getArrayContent();
            }
        };
        return Lists.transform(arrays, (Function)function);
    }

    public static <E> List<E> filterCategories(List<E> categories) {
        ArrayList<E> result = new ArrayList<E>(categories.size());
        for (int i = 0; i < categories.size(); ++i) {
            E category = categories.get(i);
            if (ValueUtil.isNaN(category)) continue;
            result.add(category);
        }
        return result;
    }
}

