/*
 * Decompiled with CFR 0.152.
 */
package category_encoders;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MapValues;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ThresholdFeature;
import org.jpmml.converter.TypeUtil;
import org.jpmml.model.ToStringHelper;

public class MapFeature
extends ThresholdFeature {
    private Map<?, ? extends Number> mapping = null;
    private Object missingValue = null;

    public MapFeature(PMMLEncoder encoder, Feature feature, Map<?, ? extends Number> mapping, Object missingValue) {
        this(encoder, feature.getName(), feature.getDataType(), mapping, missingValue);
    }

    public MapFeature(PMMLEncoder encoder, Field<?> field, Map<?, ? extends Number> mapping, Object missingValue) {
        this(encoder, field.getName(), field.getDataType(), mapping, missingValue);
    }

    public MapFeature(PMMLEncoder encoder, FieldName name, DataType dataType, Map<?, ? extends Number> mapping, Object missingValue) {
        super(encoder, name, dataType);
        this.setMapping(mapping);
        this.setMissingValue(missingValue);
    }

    public FieldName getDerivedName() {
        return FieldNameUtil.create((String)"map", (Object[])new Object[]{this.getName()});
    }

    public ContinuousFeature toContinuousFeature() {
        FieldName name = this.getName();
        Map<?, Number> mapping = this.getMapping();
        Object missingValue = this.getMissingValue();
        Supplier<Expression> expressionSupplier = () -> {
            LinkedHashMap validMapping = new LinkedHashMap(mapping);
            Number mapMissingTo = (Number)validMapping.remove(missingValue);
            MapValues mapValues = PMMLUtil.createMapValues((FieldName)name, validMapping).setMapMissingTo((Object)mapMissingTo);
            return mapValues;
        };
        DataType dataType = TypeUtil.getDataType(mapping.values(), (DataType)DataType.DOUBLE);
        return this.toContinuousFeature(this.getDerivedName(), dataType, expressionSupplier);
    }

    public Set<?> getValues(Predicate<Number> predicate) {
        Map<?, Number> mapping = this.getMapping();
        LinkedHashSet result = new LinkedHashSet();
        Set<Map.Entry<?, Number>> entries = mapping.entrySet();
        entries.stream().filter(entry -> predicate.test((Number)entry.getValue())).map(entry -> entry.getKey()).forEach(result::add);
        return result;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.getMapping());
        result = 31 * result + Objects.hash(this.getMissingValue());
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof MapFeature) {
            MapFeature that = (MapFeature)((Object)object);
            return super.equals(object) && Objects.equals(this.getMapping(), that.getMapping()) && Objects.equals(this.getMissingValue(), that.getMissingValue());
        }
        return false;
    }

    protected ToStringHelper toStringHelper() {
        return new ToStringHelper((Object)this).add("mapping", this.getMapping()).add("missingValue", this.getMissingValue());
    }

    public Map<?, ? extends Number> getMapping() {
        return this.mapping;
    }

    private void setMapping(Map<?, ? extends Number> mapping) {
        this.mapping = Objects.requireNonNull(mapping);
    }

    public Object getMissingValue() {
        return this.missingValue;
    }

    private void setMissingValue(Object missingValue) {
        this.missingValue = missingValue;
    }
}

