/*
 * Decompiled with CFR 0.152.
 */
package category_encoders;

import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.NormDiscrete;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ThresholdFeature;
import org.jpmml.model.ToStringHelper;

public class BaseNFeature
extends ThresholdFeature {
    private int base = -1;
    private int index = -1;
    private SetMultimap<Integer, ?> values = null;
    private Object missingValue = null;

    public BaseNFeature(PMMLEncoder encoder, Field<?> field, int base, int index, SetMultimap<Integer, ?> values, Object missingValue) {
        this(encoder, field.getName(), field.getDataType(), base, index, values, missingValue);
    }

    public BaseNFeature(PMMLEncoder encoder, Feature feature, int base, int index, SetMultimap<Integer, ?> values, Object missingValue) {
        this(encoder, feature.getName(), feature.getDataType(), base, index, values, missingValue);
    }

    public BaseNFeature(PMMLEncoder encoder, FieldName name, DataType dataType, int base, int index, SetMultimap<Integer, ?> values, Object missingValue) {
        super(encoder, name, dataType);
        this.setBase(base);
        this.setIndex(index);
        this.setValues(values);
        this.setMissingValue(missingValue);
    }

    public FieldName getDerivedName() {
        return FieldNameUtil.create((String)("base" + this.getBase()), (Object[])new Object[]{this.getName(), this.getIndex()});
    }

    public ContinuousFeature toContinuousFeature() {
        FieldName name = this.getName();
        DataType dataType = this.getDataType();
        int base = this.getBase();
        SetMultimap<Integer, ?> values = this.getValues();
        Object missingValue = this.getMissingValue();
        boolean missingValueAware = values.containsValue(missingValue);
        Supplier<Expression> expressionSupplier = () -> {
            Collection categories;
            Map valueMap = values.asMap();
            if (base == 2 && (categories = (Collection)valueMap.get(1)) != null && categories.size() == 1) {
                Object category = Iterables.getOnlyElement((Iterable)categories);
                if (!missingValueAware) {
                    return new NormDiscrete(name, category);
                }
            }
            Integer missingBaseValue = 0;
            Apply apply = null;
            Apply prevIfApply = null;
            Collection entries = valueMap.entrySet();
            entries = entries.stream().sorted((left, right) -> Integer.compare((Integer)left.getKey(), (Integer)right.getKey())).filter(entry -> (Integer)entry.getKey() > 0).collect(Collectors.toList());
            for (Map.Entry entry2 : entries) {
                Integer baseValue = (Integer)entry2.getKey();
                Collection categories2 = (Collection)entry2.getValue();
                if (missingValueAware) {
                    if (categories2.contains(missingValue)) {
                        categories2.remove(missingValue);
                        missingBaseValue = baseValue;
                    }
                    if (categories2.isEmpty()) continue;
                }
                Apply valueApply = PMMLUtil.createApply((String)(categories2.size() == 1 ? "equal" : "isIn"), (Expression[])new Expression[]{new FieldRef(name)});
                for (Object category : categories2) {
                    valueApply.addExpressions(new Expression[]{PMMLUtil.createConstant(category, (DataType)dataType)});
                }
                Apply ifApply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{valueApply, PMMLUtil.createConstant((Number)baseValue)});
                if (apply == null) {
                    apply = ifApply;
                }
                if (prevIfApply != null) {
                    prevIfApply.addExpressions(new Expression[]{ifApply});
                }
                prevIfApply = ifApply;
            }
            if (apply == null) {
                return PMMLUtil.createConstant((Number)0);
            }
            prevIfApply.addExpressions(new Expression[]{PMMLUtil.createConstant((Number)0)});
            if (missingValueAware) {
                apply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"isNotMissing", (Expression[])new Expression[]{new FieldRef(name)}), apply, PMMLUtil.createConstant((Number)missingBaseValue)});
            }
            return apply;
        };
        return this.toContinuousFeature(this.getDerivedName(), DataType.INTEGER, expressionSupplier);
    }

    public Set<?> getValues(Predicate<Number> predicate) {
        SetMultimap<Integer, ?> values = this.getValues();
        Map valueMap = values.asMap();
        LinkedHashSet result = new LinkedHashSet();
        Set entries = valueMap.entrySet();
        entries.stream().sorted((left, right) -> Integer.compare((Integer)left.getKey(), (Integer)right.getKey())).filter(entry -> predicate.test((Number)entry.getKey())).map(entry -> (Collection)entry.getValue()).forEach(result::addAll);
        return result;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.getBase());
        result = 31 * result + Objects.hash(this.getIndex());
        result = 31 * result + Objects.hash(this.getValues());
        result = 31 * result + Objects.hash(this.getMissingValue());
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof BaseNFeature) {
            BaseNFeature that = (BaseNFeature)((Object)object);
            return super.equals(object) && Objects.equals(this.getBase(), that.getBase()) && Objects.equals(this.getIndex(), that.getIndex()) && Objects.equals(this.getValues(), that.getValues()) && Objects.equals(this.getMissingValue(), that.getMissingValue());
        }
        return false;
    }

    protected ToStringHelper toStringHelper() {
        return super.toStringHelper().add("base", (Object)this.getBase()).add("index", (Object)this.getIndex()).add("values", this.getValues()).add("missingValue", this.getMissingValue());
    }

    public int getBase() {
        return this.base;
    }

    private void setBase(int base) {
        this.base = base;
    }

    public int getIndex() {
        return this.index;
    }

    private void setIndex(int index) {
        this.index = index;
    }

    public SetMultimap<Integer, ?> getValues() {
        return this.values;
    }

    private void setValues(SetMultimap<Integer, ?> values) {
        this.values = Objects.requireNonNull(values);
    }

    public Object getMissingValue() {
        return this.missingValue;
    }

    private void setMissingValue(Object missingValue) {
        this.missingValue = missingValue;
    }
}

