/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.serpent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import net.razorvine.serpent.ComplexNumber;
import net.razorvine.serpent.IDictToInstance;
import net.razorvine.serpent.ast.BigIntNode;
import net.razorvine.serpent.ast.BooleanNode;
import net.razorvine.serpent.ast.BytesNode;
import net.razorvine.serpent.ast.ComplexNumberNode;
import net.razorvine.serpent.ast.DictNode;
import net.razorvine.serpent.ast.DoubleNode;
import net.razorvine.serpent.ast.INode;
import net.razorvine.serpent.ast.INodeVisitor;
import net.razorvine.serpent.ast.IntegerNode;
import net.razorvine.serpent.ast.KeyValueNode;
import net.razorvine.serpent.ast.ListNode;
import net.razorvine.serpent.ast.LongNode;
import net.razorvine.serpent.ast.NoneNode;
import net.razorvine.serpent.ast.SetNode;
import net.razorvine.serpent.ast.StringNode;
import net.razorvine.serpent.ast.TupleNode;

public class ObjectifyVisitor
implements INodeVisitor {
    Stack<Object> generated = new Stack();
    protected IDictToInstance dictConverter = null;

    public ObjectifyVisitor() {
    }

    public ObjectifyVisitor(IDictToInstance dictConverter) {
        this.dictConverter = dictConverter;
    }

    public Object getObject() {
        return this.generated.pop();
    }

    @Override
    public void visit(ComplexNumberNode complex) {
        this.generated.push(new ComplexNumber(complex.real, complex.imaginary));
    }

    @Override
    public void visit(DictNode dict) {
        HashMap<Object, Object> obj = new HashMap<Object, Object>(dict.elements.size());
        for (INode e : dict.elements) {
            KeyValueNode kv = (KeyValueNode)e;
            kv.key.accept(this);
            Object key = this.generated.pop();
            kv.value.accept(this);
            Object value = this.generated.pop();
            obj.put(key, value);
        }
        if (this.dictConverter == null || !obj.containsKey("__class__")) {
            this.generated.push(obj);
        } else {
            Object result;
            try {
                result = this.dictConverter.convert(obj);
            }
            catch (IOException e) {
                throw new RuntimeException("problem converting dict to class", e);
            }
            if (result == null) {
                this.generated.push(obj);
            } else {
                this.generated.push(result);
            }
        }
    }

    @Override
    public void visit(ListNode list) {
        ArrayList<Object> obj = new ArrayList<Object>(list.elements.size());
        for (INode node : list.elements) {
            node.accept(this);
            obj.add(this.generated.pop());
        }
        this.generated.push(obj);
    }

    @Override
    public void visit(NoneNode none) {
        this.generated.push(null);
    }

    @Override
    public void visit(IntegerNode value) {
        this.generated.push(value.value);
    }

    @Override
    public void visit(LongNode value) {
        this.generated.push(value.value);
    }

    @Override
    public void visit(DoubleNode value) {
        this.generated.push(value.value);
    }

    @Override
    public void visit(BooleanNode value) {
        this.generated.push(value.value);
    }

    @Override
    public void visit(StringNode value) {
        this.generated.push(value.value);
    }

    @Override
    public void visit(BytesNode value) {
        this.generated.push(value.value);
    }

    @Override
    public void visit(BigIntNode value) {
        this.generated.push(value.value);
    }

    @Override
    public void visit(SetNode setnode) {
        HashSet<Object> obj = new HashSet<Object>();
        for (INode node : setnode.elements) {
            node.accept(this);
            obj.add(this.generated.pop());
        }
        this.generated.push(obj);
    }

    @Override
    public void visit(TupleNode tuple) {
        Object[] array = new Object[tuple.elements.size()];
        int index = 0;
        for (INode node : tuple.elements) {
            node.accept(this);
            array[index++] = this.generated.pop();
        }
        this.generated.push(array);
    }
}

