/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.visitors.DeepFieldResolver;
import org.jpmml.converter.visitors.FieldDependencyResolver;
import org.jpmml.converter.visitors.FieldUtil;
import org.jpmml.model.visitors.AbstractVisitor;

public class FeatureExpander
extends DeepFieldResolver {
    private Map<Model, Set<FieldName>> features = null;
    private Map<Model, Map<FieldName, Set<Field<?>>>> expandedFeatures = new IdentityHashMap();

    public FeatureExpander(Map<Model, Set<FieldName>> features) {
        this.features = Objects.requireNonNull(features);
    }

    @Override
    public void reset() {
        super.reset();
        this.features.clear();
        this.expandedFeatures.clear();
    }

    public PMMLObject popParent() {
        PMMLObject parent = super.popParent();
        if (parent instanceof Model) {
            Model model = (Model)parent;
            this.processModel(model);
        }
        return parent;
    }

    private void processModel(Model model) {
        Set<DerivedField> extraLocalDerivedFields;
        FieldDependencyResolver fieldDependencyResolver = this.getFieldDependencyResolver();
        MiningModel parentMiningModel = null;
        Set<FieldName> features = this.features.get(model);
        if (features == null) {
            parentMiningModel = this.getParent(this.features.keySet());
            if (parentMiningModel != null) {
                features = this.features.get(parentMiningModel);
            }
            if (features == null) {
                return;
            }
        }
        HashSet<DerivedField> modelFields = this.getFields(new PMMLObject[]{model});
        if ((model instanceof MiningModel || this.hasParent(MiningModel.class)) && !(extraLocalDerivedFields = fieldDependencyResolver.getLocalDerivedFields()).isEmpty()) {
            modelFields = new HashSet<DerivedField>(modelFields);
            modelFields.addAll(extraLocalDerivedFields);
        }
        Collection<Field> featureFields = FieldUtil.selectAll(modelFields, features, true);
        Map<Object, Object> localDerivedFields = Collections.emptyMap();
        LocalTransformations localTransformations = model.getLocalTransformations();
        if (localTransformations != null && localTransformations.hasDerivedFields()) {
            localDerivedFields = FieldUtil.nameMap(localTransformations.getDerivedFields());
        }
        if (parentMiningModel != null) {
            if (localDerivedFields.isEmpty()) {
                return;
            }
            featureFields.retainAll(localDerivedFields.values());
        }
        Map<FieldName, DerivedField> globalDerivedFields = FieldUtil.nameMap(fieldDependencyResolver.getGlobalDerivedFields());
        Map<FieldName, Set<Field<?>>> expandedFields = parentMiningModel != null ? this.ensureExpandedFeatures((Model)parentMiningModel) : this.ensureExpandedFeatures(model);
        for (Field featureField : featureFields) {
            FieldName name = featureField.getName();
            if (featureField instanceof DataField) {
                expandedFields.put(name, Collections.singleton(featureField));
                continue;
            }
            if (featureField instanceof DerivedField) {
                DerivedField derivedField = (DerivedField)featureField;
                HashSet expandedFeatureFields = new HashSet();
                expandedFeatureFields.add((Field<?>)derivedField);
                if (model instanceof MiningModel) {
                    MiningModel miningModel = (MiningModel)model;
                    Segmentation segmentation = miningModel.getSegmentation();
                    final HashSet extraLocalDerivedFields2 = new HashSet();
                    AbstractVisitor visitor = new AbstractVisitor(){

                        public VisitorAction visit(LocalTransformations localTransformations) {
                            if (localTransformations != null && localTransformations.hasDerivedFields()) {
                                extraLocalDerivedFields2.addAll(localTransformations.getDerivedFields());
                            }
                            return VisitorAction.CONTINUE;
                        }
                    };
                    visitor.applyTo((Visitable)segmentation);
                    fieldDependencyResolver.expand(expandedFeatureFields, extraLocalDerivedFields2);
                }
                fieldDependencyResolver.expand(expandedFeatureFields, new HashSet<Object>(localDerivedFields.values()));
                fieldDependencyResolver.expand(expandedFeatureFields, new HashSet<DerivedField>(globalDerivedFields.values()));
                expandedFields.put(name, expandedFeatureFields);
                continue;
            }
            if (featureField instanceof OutputField) {
                expandedFields.put(name, Collections.singleton(featureField));
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    private MiningModel getParent(Set<Model> models) {
        Deque parents = this.getParents();
        for (PMMLObject parent : parents) {
            MiningModel miningModel;
            if (!(parent instanceof MiningModel) || !models.contains(miningModel = (MiningModel)parent)) continue;
            return miningModel;
        }
        return null;
    }

    private Map<FieldName, Set<Field<?>>> ensureExpandedFeatures(Model model) {
        Map<Model, Map<FieldName, Set<Field<?>>>> expandedFeatures = this.getExpandedFeatures();
        Map<FieldName, Set<Field<?>>> result = expandedFeatures.get(model);
        if (result == null) {
            result = new HashMap();
            expandedFeatures.put(model, result);
        }
        return result;
    }

    public Map<FieldName, Set<Field<?>>> getExpandedFeatures(Model model) {
        Map<Model, Map<FieldName, Set<Field<?>>>> expandedFeatures = this.getExpandedFeatures();
        return expandedFeatures.get(model);
    }

    public Map<Model, Set<FieldName>> getFeatures() {
        return this.features;
    }

    public Map<Model, Map<FieldName, Set<Field<?>>>> getExpandedFeatures() {
        return this.expandedFeatures;
    }

    private boolean hasParent(Class<? extends PMMLObject> clazz) {
        Deque parents = this.getParents();
        for (PMMLObject parent : parents) {
            if (!clazz.isInstance(parent)) continue;
            return true;
        }
        return false;
    }
}

