/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.List;
import java.util.ListIterator;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Expression;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.visitors.AbstractVisitor;

public class ExpressionCompactor
extends AbstractVisitor {
    public VisitorAction visit(Apply apply) {
        String function;
        switch (function = apply.getFunction()) {
            case "and": 
            case "or": {
                ExpressionCompactor.inlineNestedExpressions(apply);
                break;
            }
            case "not": {
                ExpressionCompactor.negateExpression(apply);
                break;
            }
            case "concat": {
                ExpressionCompactor.inlineNestedExpressions(apply);
                break;
            }
        }
        return super.visit(apply);
    }

    private static void inlineNestedExpressions(Apply apply) {
        String function = apply.getFunction();
        List expressions = apply.getExpressions();
        if (expressions.size() < 2) {
            throw new IllegalArgumentException();
        }
        ListIterator<Expression> expressionIt = expressions.listIterator();
        while (expressionIt.hasNext()) {
            Apply nestedApply;
            Expression expression = (Expression)expressionIt.next();
            if (!(expression instanceof Apply) || !function.equals((nestedApply = (Apply)expression).getFunction())) continue;
            expressionIt.remove();
            ExpressionCompactor.inlineNestedExpressions(nestedApply);
            List nestedExpressions = nestedApply.getExpressions();
            for (Expression nestedExpression : nestedExpressions) {
                expressionIt.add(nestedExpression);
            }
        }
    }

    private static void negateExpression(Apply apply) {
        Apply nestedApply;
        String negatedFunction;
        List expressions = apply.getExpressions();
        if (expressions.size() != 1) {
            throw new IllegalArgumentException();
        }
        ListIterator<Expression> expressionIt = expressions.listIterator();
        Expression expression = (Expression)expressionIt.next();
        if (expression instanceof Apply && (negatedFunction = ExpressionCompactor.negate((nestedApply = (Apply)expression).getFunction())) != null) {
            expressionIt.remove();
            apply.setFunction(negatedFunction);
            List nestedExpressions = nestedApply.getExpressions();
            for (Expression nestedExpression : nestedExpressions) {
                expressionIt.add(nestedExpression);
            }
        }
    }

    private static String negate(String function) {
        switch (function) {
            case "equal": {
                return "notEqual";
            }
            case "greaterOrEqual": {
                return "lessThan";
            }
            case "greaterThan": {
                return "lessOrEqual";
            }
            case "isMissing": {
                return "isNotMissing";
            }
            case "isNotMissing": {
                return "isMissing";
            }
            case "lessOrEqual": {
                return "greaterThan";
            }
            case "lessThan": {
                return "greaterOrEqual";
            }
            case "notEqual": {
                return "equal";
            }
        }
        return null;
    }
}

