/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.PMML;
import org.dmg.pmml.UnivariateStats;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.visitors.FeatureExpander;
import org.jpmml.converter.visitors.ModelCleanerBattery;
import org.jpmml.converter.visitors.PMMLCleanerBattery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelEncoder
extends PMMLEncoder {
    private List<Model> transformers = new ArrayList<Model>();
    private Map<FieldName, List<Decorator>> decorators = new LinkedHashMap<FieldName, List<Decorator>>();
    private Map<Model, List<FeatureImportance>> featureImportances = new LinkedHashMap<Model, List<FeatureImportance>>();
    private Map<FieldName, UnivariateStats> univariateStats = new LinkedHashMap<FieldName, UnivariateStats>();
    private static final Logger logger = LoggerFactory.getLogger(ModelEncoder.class);

    public PMML encodePMML(Model model) {
        PMML pmml = this.encodePMML();
        List<Model> transformers = this.getTransformers();
        if (transformers.size() > 0) {
            ArrayList<Model> models = new ArrayList<Model>(transformers);
            if (model != null) {
                models.add(model);
            }
            model = MiningModelUtil.createModelChain(models);
        }
        if (model != null) {
            pmml.addModels(new Model[]{model});
            ModelCleanerBattery modelCleanerBattery = new ModelCleanerBattery();
            modelCleanerBattery.applyTo((Visitable)pmml);
            MiningSchema miningSchema = model.getMiningSchema();
            List miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                UnivariateStats univariateStats;
                FieldName name = miningField.getName();
                DataField dataField = this.getDataField(name);
                if (dataField == null) {
                    throw new IllegalArgumentException("Field " + name.getValue() + " is not referentiable");
                }
                List<Decorator> decorators = this.getDecorators(name);
                if (decorators != null) {
                    for (Decorator decorator : decorators) {
                        decorator.decorate(miningField);
                    }
                }
                if ((univariateStats = this.getUnivariateStats(name)) == null) continue;
                ModelStats modelStats = ModelUtil.ensureModelStats(model);
                modelStats.addUnivariateStats(new UnivariateStats[]{univariateStats});
            }
            this.encodeFeatureImportances(pmml);
        }
        PMMLCleanerBattery pmmlCleanerBattery = new PMMLCleanerBattery();
        pmmlCleanerBattery.applyTo((Visitable)pmml);
        return pmml;
    }

    public List<Model> getTransformers() {
        return this.transformers;
    }

    public void addTransformer(Model transformer) {
        this.transformers.add(transformer);
    }

    public List<Decorator> getDecorators(FieldName name) {
        return this.decorators.get(name);
    }

    public void addDecorator(DataField dataField, Decorator decorator) {
        this.addDecorator(dataField.getName(), decorator);
    }

    public void addDecorator(FieldName name, Decorator decorator) {
        List<Decorator> decorators = this.decorators.get(name);
        if (decorators == null) {
            decorators = new ArrayList<Decorator>();
            this.decorators.put(name, decorators);
        }
        decorators.add(decorator);
    }

    public void addFeatureImportance(Feature feature, Number importance) {
        this.addFeatureImportance(null, feature, importance);
    }

    public void addFeatureImportance(Model model, Feature feature, Number importance) {
        List<FeatureImportance> featureImportances = this.featureImportances.get(model);
        if (featureImportances == null) {
            featureImportances = new ArrayList<FeatureImportance>();
            this.featureImportances.put(model, featureImportances);
        }
        featureImportances.add(new FeatureImportance(feature, importance));
    }

    public void transferFeatureImportances(Model model) {
        this.transferFeatureImportances(null, model);
    }

    public void transferFeatureImportances(Model left, Model right) {
        List<FeatureImportance> featureImportances = this.featureImportances.remove(left);
        if (featureImportances != null && !featureImportances.isEmpty()) {
            this.featureImportances.put(right, featureImportances);
        }
    }

    public Map<Model, List<FeatureImportance>> getFeatureImportances() {
        return this.featureImportances;
    }

    public UnivariateStats getUnivariateStats(FieldName name) {
        return this.univariateStats.get(name);
    }

    public void putUnivariateStats(UnivariateStats univariateStats) {
        this.putUnivariateStats(univariateStats.getField(), univariateStats);
    }

    public void putUnivariateStats(FieldName name, UnivariateStats univariateStats) {
        this.univariateStats.put(name, univariateStats);
    }

    private void encodeFeatureImportances(PMML pmml) {
        Map<Model, List<FeatureImportance>> modelFeatureImportances = this.getFeatureImportances();
        if (modelFeatureImportances.isEmpty()) {
            return;
        }
        if (modelFeatureImportances.containsKey(null)) {
            throw new IllegalStateException();
        }
        Map<Model, Set<FieldName>> expandableFeatures = modelFeatureImportances.entrySet().stream().collect(Collectors.toMap(entry -> (Model)entry.getKey(), entry -> ((List)entry.getValue()).stream().map(featureImportance -> featureImportance.getFeature().getName()).collect(Collectors.toSet())));
        FeatureExpander featureExpander = new FeatureExpander(expandableFeatures);
        featureExpander.applyTo((Visitable)pmml);
        Set<Map.Entry<Model, List<FeatureImportance>>> entries = modelFeatureImportances.entrySet();
        for (Map.Entry entry2 : entries) {
            Model model = (Model)entry2.getKey();
            List featureImportances = (List)entry2.getValue();
            MathContext mathContext = model.getMathContext();
            Map<FieldName, Set<Field<?>>> featureFields = featureExpander.getExpandedFeatures(model);
            if (featureFields == null) {
                throw new IllegalArgumentException();
            }
            ArrayListMultimap fieldImportances = ArrayListMultimap.create();
            for (FeatureImportance featureImportance : featureImportances) {
                FieldName name = featureImportance.getFeature().getName();
                Number importance2 = featureImportance.getImportance();
                if (ValueUtil.isZero(importance2)) continue;
                Set<Field<?>> fields = featureFields.get(name);
                if (fields == null) {
                    logger.warn("Unused feature '" + name.getValue() + "' has non-zero importance");
                    continue;
                }
                Number fieldImportance = ValueUtil.divide(mathContext, importance2, fields.size());
                for (Field<?> field : fields) {
                    FieldName fieldName = field.getName();
                    fieldImportances.put((Object)fieldName, (Object)fieldImportance);
                }
            }
            MiningSchema miningSchema = model.getMiningSchema();
            if (miningSchema == null || !miningSchema.hasMiningFields()) continue;
            List miningFields = miningSchema.getMiningFields();
            block6: for (MiningField miningField : miningFields) {
                FieldName name = miningField.getName();
                MiningField.UsageType usageType = miningField.getUsageType();
                switch (usageType) {
                    case ACTIVE: {
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                List fieldImportance = fieldImportances.get((Object)name);
                if (fieldImportance == null) continue;
                miningField.setImportance(ValueUtil.sum(mathContext, fieldImportance));
            }
            ArrayList<FieldName> names = new ArrayList<FieldName>();
            ArrayList<Number> importances = new ArrayList<Number>();
            for (FeatureImportance featureImportance : featureImportances) {
                names.add(FeatureUtil.getName(featureImportance.getFeature()));
                importances.add(featureImportance.getImportance());
            }
            LinkedHashMap<String, ArrayList<Object>> nativeFeatureImportances = new LinkedHashMap<String, ArrayList<Object>>();
            nativeFeatureImportances.put("data:name", names);
            nativeFeatureImportances.put("data:importance", importances);
            List nonZeroImportances = importances.stream().filter(importance -> !ValueUtil.isZero(importance)).collect(Collectors.toList());
            InlineTable inlineTable = PMMLUtil.createInlineTable(nativeFeatureImportances).addExtensions(new Extension[]{PMMLUtil.createExtension("numberOfImportances", String.valueOf(importances.size()))}).addExtensions(new Extension[]{PMMLUtil.createExtension("numberOfNonZeroImportances", String.valueOf(nonZeroImportances.size()))}).addExtensions(new Extension[]{PMMLUtil.createExtension("sumOfImportances", String.valueOf(ValueUtil.sum(mathContext, importances)))});
            if (!nonZeroImportances.isEmpty()) {
                Comparator<Number> comparator = new Comparator<Number>(){

                    @Override
                    public int compare(Number left, Number right) {
                        return Double.compare(left.doubleValue(), right.doubleValue());
                    }
                };
                inlineTable.addExtensions(new Extension[]{PMMLUtil.createExtension("minImportance", String.valueOf(Collections.min(nonZeroImportances, comparator)))}).addExtensions(new Extension[]{PMMLUtil.createExtension("maxImportance", String.valueOf(Collections.max(nonZeroImportances, comparator)))});
            }
            miningSchema.addExtensions(new Extension[]{PMMLUtil.createExtension("X-FeatureImportances", inlineTable)});
        }
    }

    private static class FeatureImportance {
        private Feature feature = null;
        private Number importance = null;

        private FeatureImportance(Feature feature, Number importance) {
            this.setFeature(feature);
            this.setImportance(importance);
        }

        public Feature getFeature() {
            return this.feature;
        }

        private void setFeature(Feature feature) {
            this.feature = feature;
        }

        public Number getImportance() {
            return this.importance;
        }

        private void setImportance(Number importance) {
            this.importance = importance;
        }
    }
}

