""""""
#------------------------------------------------------------------------------
# Description    : SCPI interface
# Git repository : https://gitlab.com/qblox/packages/software/qblox_instruments.git
# Copyright (C) Qblox BV (2020)
#------------------------------------------------------------------------------


#------------------------------------------------------------------------------
# THIS FILE IS AUTOMATICALLY GENERATED. DO NOT MODIFY THIS FILE MANUALLY!
#------------------------------------------------------------------------------


#-- include --------------------------------------------------------------------

import sys
import struct
import re

#Add IEEE488.2 support
from ieee488_2.ieee488_2 import ieee488_2

#-- class ----------------------------------------------------------------------

class cluster_scpi_ifc(ieee488_2):
    """
    This interface provides an API for the mandatory and required SCPI calls and adds
    Pulsar related functionality (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).
    """

    #---------------------------------------------------------------------------
    def __init__(self, transport_inst, debug = 0):
        """
        Creates SCPI interface object.

        Parameters
        ----------
        transport_inst : :class:`~ieee488_2.transport`
            Transport class responsible for the lowest level of communication (e.g. ethernet).
        debug : int
            Debug level (0 = normal, 1 = no version check, >1 = no version or error checking).

        Returns
        ----------
        :class:`~cluster.cluster_scpi_ifc`
            SCPI interface object.

        Raises
        ----------
        Exception
            Debug level is 0 and there is a version mismatch.
        """

        #Store parameters for later use.
        self._debug = debug

        #Initialize parent class.
        super(cluster_scpi_ifc, self).__init__(transport_inst)

        if self._debug == 0:
            try:
                #Check if build is compatible.
                build     = self._read("*IDN?").split(',')[-1]
                build_ref = "fwVersion=0.1.0 fwBuild=01/10/2021-08:22:03 fwHash=0x794D29A8 fwDirty=0 kmodVersion=0.1.0 kmodBuild=01/10/2021-08:22:03 kmodHash=0x794D29A8 kmodDirty=0 swVersion=0.1.0 swBuild=01/10/2021-08:22:03 swHash=0x794D29A8 swDirty=0"
                if build != build_ref:
                    build     = re.split(' |=', build)
                    build_ref = re.split(' |=', build_ref)
                    raise Exception("Error: cluster_scpi_ifc version is not compatible with device version:\n" + \
                                    "\n" + \
                                    "                        pulsar_qcm_scpi_ifc: device version:\n" + \
                                    "Firmware;      Version: {}                {}\n".format(    build_ref[1],  build[1])  + \
                                    "               Date:    {}  {}\n".format(                  build_ref[3],  build[3])  + \
                                    "               Hash:    {}           {}\n".format(         build_ref[5],  build[5])  + \
                                    "               Dirty:   {}                    {}\n".format(build_ref[7],  build[7])  + \
                                    "Kernel module; Version: {}                {}\n".format(    build_ref[9],  build[9])  + \
                                    "               Date:    {}  {}\n".format(                  build_ref[11], build[11]) + \
                                    "               Hash:    {}           {}\n".format(         build_ref[13], build[13]) + \
                                    "               Dirty:   {}                    {}\n".format(build_ref[15], build[15]) + \
                                    "Application;   Version: {}                {}\n".format(    build_ref[17], build[17]) + \
                                    "               Date:    {}  {}\n".format(                  build_ref[19], build[19]) + \
                                    "               Hash:    {}           {}\n".format(         build_ref[21], build[21]) + \
                                    "               Dirty:   {}                    {}\n".format(build_ref[23], build[23]) + \
                                    "\n" + \
                                    "Please update your device's firmware or the Qblox Instruments package.")

                #Clear SCPI error queue.
                while int(self._read('SYSTem:ERRor:COUNt?')) != 0:
                    self._read('SYSTem:ERRor:NEXT?')
            except Exception:
                raise

    #---------------------------------------------------------------------------
    def _get_idn(self):
        """
        Get device identity and build information.

        Parameters
        ----------

        Returns
        ----------
        str
            Concatinated list of strings separated by the semicolon character. The IDN consists of four strings respectively ordered as:

            - Manufacturer
            - Model
            - Serial number
            - Build information

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('*IDN?')

            return var0
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def reset(self):
        """
        Reset device and clear all status and event registers (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            self._write('*RST')
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def clear(self):
        """
        Clear all status and event registers (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            self._write('*CLS')
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_status_byte(self):
        """
        Get status byte register. Register is only cleared when feeding registers are cleared (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------
        int
            Status byte register.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('*STB?')

            return int(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def set_service_request_enable(self, reg):
        """
        Set service request enable register (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------
        reg : int
           Service request enable register.

        Returns
        ----------

        Raises
        ----------
        Exception
            Invalid input parameter type.
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #Check input types.
        self._check_in_type(locals(), ['int'])

        #SCPI call
        try:
            self._write('*SRE {}'.format(reg))
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_service_request_enable(self):
        """
        Get service request enable register. The register is cleared after reading it (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------
        int
           Service request enable register.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('*SRE?')

            return int(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def set_standard_event_status_enable(self, reg):
        """
        Get standard event status enable register. The register is cleared after reading it (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------
        int
           Standard event status enable register.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #Check input types.
        self._check_in_type(locals(), ['int'])

        #SCPI call
        try:
            self._write('*ESE {}'.format(reg))
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_standard_event_status_enable(self):
        """
        Set standard event status enable register (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------
        reg : int
           Standard event status enable register.

        Returns
        ----------

        Raises
        ----------
        Exception
            Invalid input parameter type.
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('*ESE?')

            return int(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_standard_event_status(self):
        """
        Get standard event status register. The register is cleared after reading it (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------
        int
           Standard event status register.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('*ESR?')

            return int(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def set_operation_complete(self):
        """
        Set device in operation complete query active state (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            self._write('*OPC')
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_operation_complete(self):
        """
        Get operation complete state (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------
        bool
           Operation complete state (False = running, True = completed).

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('*OPC?')

            return bool(int(var0))
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def test(self):
        """
        Run self-test. Currently not implemented (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------
        bool
           Test result (False = failed, True = success).

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('*TST?')

            return bool(int(var0))
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def wait(self):
        """
        Wait until operations completed before continuing (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            self._write('*WAI')
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_system_error(self):
        """
        Get system error from queue (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------
        str
           System error description string.
        """

        #SCPI call
        try:
            var0 = self._read('SYSTem:ERRor:NEXT?')

            return var0
        except:
            raise

    #---------------------------------------------------------------------------
    def get_num_system_error(self):
        """
        Get number of system errors (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------
        int
           Current number of number of system errors.
        """

        #SCPI call
        try:
            var0 = self._read('SYSTem:ERRor:COUNt?')

            return int(var0)
        except:
            raise

    #---------------------------------------------------------------------------
    def get_system_version(self):
        """
        Get SCPI system version (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------
        str
           SCPI system version.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('SYSTem:VERSion?')

            return var0
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def preset_system_status(self):
        """
        Preset system status registers. Connects general system status flags for PLL unlock and temperature out-of-range indications
        to event status enable, status questionable temperature and status questionable frequency registers respectively
        (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            self._write('STATus:PRESet')
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_questionable_condition(self):
        """
        Get status questionable condition register (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------
        int
            Status questionable condition register.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:QUEStionable:CONDition?')

            return int(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_questionable_event(self):
        """
        Get status questionable event register (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------
        int
            Status questionable event register.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:QUEStionable:EVENt?')

            return int(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def set_questionable_enable(self, reg):
        """
        Set status questionable enable register (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------
        reg : int
            Status questionable enable register.

        Returns
        ----------

        Raises
        ----------
        Exception
            Invalid input parameter type.
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #Check input types.
        self._check_in_type(locals(), ['int'])

        #SCPI call
        try:
            self._write('STATus:QUEStionable:ENABle {}'.format(reg))
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_questionable_enable(self):
        """
        Get status questionable enable register (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------
        int
            Status questionable enable register.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:QUEStionable:ENABle?')

            return int(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_operation_condition(self):
        """
        Get status operation condition register  (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------
        int
            Status operation condition register.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:OPERation:CONDition?')

            return int(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_operation_events(self):
        """
        Get status operation event register  (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------
        int
            Status operation event register.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:OPERation:EVENt?')

            return int(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def set_operation_enable(self, reg):
        """
        Set status operation enable register  (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------
        reg : int
            Status operation enable register.

        Returns
        ----------

        Raises
        ----------
        Exception
            Invalid input parameter type.
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #Check input types.
        self._check_in_type(locals(), ['int'])

        #SCPI call
        try:
            self._write('STATus:OPERation:ENABle {}'.format(reg))
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_operation_enable(self):
        """
        Get status operation enable register  (see `SCPI <https://www.ivifoundation.org/docs/scpi-99.pdf>`_).

        Parameters
        ----------

        Returns
        ----------
        int
            Status operation enable register.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:OPERation:ENABle?')

            return int(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def _get_scpi_commands(self):
        """
        Get SCPI commands.

        Parameters
        ----------

        Returns
        ----------
        str
            Concatinated list of strings separated by the semicolon character. Each command consists of nine sections respectively order as:

            - SCPI command pattern
            - SCPI input type
            - SCPI output type
            - Python function
            - Python input types (comma separated)
            - Python input variable names (comma separated)
            - Python output types (comma separated)
            - User access level (0 = public, >=1 = private)
            - Comment

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('*CMDS?')

            return var0
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def _get_system_status(self):
        """
        Get general system state.

        Parameters
        ----------

        Returns
        ----------
        str
            Concatinated list of strings separated by the semicolon character. Status is indicated by one status string and an optional number of flags respectively ordered as:

            :Status:

                - OKAY: System is okay.
                - CRITICAL: An error indicated by the flags occured, but has been resolved.
                - ERROR: An error indicated by the flags is occuring.

            :Flags:

                - CARRIER_PLL_UNLOCK: Carrier board PLL is unlocked.
                - FPGA_PLL_UNLOCK: FPGA PLL is unlocked.
                - LO_PLL_UNLOCK: LO PLL is unlocked.
                - FPGA_TEMP_OR: FPGA temperature is out-of-range.
                - CARRIER_TEMP_OR: Carrier board temperature is out-of-range.
                - AFE_TEMP_OR: Analog frontend board temperature is out-of-range.
                - LO_TEMP_OR: Local oscillator board temperature is out-of-range.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:GENeral:STATE?')

            return var0
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_current_fpga_temperature(self):
        """
        Get current FPGA junction temperature (inside device).

        Parameters
        ----------

        Returns
        ----------
        float
            Current FPGA junction temperature.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:QUEStionable:TEMPerature:FPGA:CURRent?')

            return float(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_maximum_fpga_temperature(self):
        """
        Get maximum FPGA junction temperature since boot or clear (inside device).

        Parameters
        ----------

        Returns
        ----------
        float
            Maximum FPGA junction temperature.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:QUEStionable:TEMPerature:FPGA:MAXimum?')

            return float(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_current_carrier_temperature(self):
        """
        Get current carrier board temperature (inside device).

        Parameters
        ----------

        Returns
        ----------
        float
            Current carrier board temperature.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:QUEStionable:TEMPerature:CARRier:CURRent?')

            return float(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_maximum_carrier_temperature(self):
        """
        Get maximum carrier board temperature since boot or clear (inside device).

        Parameters
        ----------

        Returns
        ----------
        float
            Maximum carrier board temperature.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:QUEStionable:TEMPerature:CARRier:MAXimum?')

            return float(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def _set_reference_source(self, internal):
        """
        Set reference (10MHz) clock source.

        Parameters
        ----------
        internal : bool
            Reference clock source (False = External, True = Internal).

        Returns
        ----------

        Raises
        ----------
        Exception
            Invalid input parameter type.
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #Check input types.
        self._check_in_type(locals(), ['bool'])

        #SCPI call
        try:
            self._write('STATus:QUEStionable:FREQuency:REFerence:SRC {}'.format(0 if internal == False else 1))
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def _get_reference_source(self):
        """
        Get reference (10MHz) clock source.

        Parameters
        ----------

        Returns
        ----------
        bool
            Reference clock source (False = External, True = Internal).

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:QUEStionable:FREQuency:REFerence:SRC?')

            return bool(int(var0))
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def _get_modules_present(self):
        """
        Get an indication of module presence for each slot of the Cluster.

        Parameters
        ----------

        Returns
        ----------
        int
            Module present indication where each bit represents a single slot and the LSB is slot 1 (False = not present, True = present).

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('BP:MODules?')

            return var0
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_current_bp_temperature_0(self):
        """
        Get the current backplane board temperature from sensor 0 (inside device).

        Parameters
        ----------

        Returns
        ----------
        float
            Current backplane temperature from sensor 0.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:QUEStionable:TEMPerature:BP0:CURRent?')

            return float(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_maximum_bp_temperature_0(self):
        """
        Get maximum backplane board temperature from sensor 0 since boot or clear (inside device).

        Parameters
        ----------

        Returns
        ----------
        float
            Maximum backplane board temperature from sensor 0.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:QUEStionable:TEMPerature:BP0:MAXimum?')

            return float(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_current_bp_temperature_1(self):
        """
        Get the current backplane board temperature from sensor 1 (inside device).

        Parameters
        ----------

        Returns
        ----------
        float
            Current backplane temperature from sensor 1.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:QUEStionable:TEMPerature:BP1:CURRent?')

            return float(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_maximum_bp_temperature_1(self):
        """
        Get maximum backplane board temperature from sensor 1 since boot or clear (inside device).

        Parameters
        ----------

        Returns
        ----------
        float
            Maximum backplane board temperature from sensor 1.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:QUEStionable:TEMPerature:BP1:MAXimum?')

            return float(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_current_bp_temperature_2(self):
        """
        Get the current backplane board temperature from sensor 2 (inside device).

        Parameters
        ----------

        Returns
        ----------
        float
            Current backplane temperature from sensor 2.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:QUEStionable:TEMPerature:BP2:CURRent?')

            return float(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_maximum_bp_temperature_2(self):
        """
        Get maximum backplane board temperature from sensor 2 since boot or clear (inside device).

        Parameters
        ----------

        Returns
        ----------
        float
            Maximum backplane board temperature from sensor 2.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('STATus:QUEStionable:TEMPerature:BP2:MAXimum?')

            return float(var0)
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #-----------------------------------------------------------------------
    def _check_in_type(self, in_arg_dict, in_type_list):
        """
        Checks input argument types against reference types.

        Parameters
        ----------
        in_arg_dict : dict
            Dictionary with input arguments created by locals().
        in_type_list : list
            List of reference input argument types.

        Returns
        ----------

        Raises
        ----------
        Exception
            Input argument type mismatch.
        """

        if self._debug <= 1:
            del in_arg_dict['self']
            in_val_list  = [in_arg_dict[name] for name in in_arg_dict]
            for i, (in_val, in_type) in enumerate(zip(in_val_list, in_type_list)):
                if str(type(in_val).__name__) == "list" or str(type(in_val).__name__) == "ndarray":
                    if len(in_val) > 0:
                        in_val = in_val[0]
                    else:
                        raise Exception("Error: unexpected type for input argument {}, expected {} but got empty {}.".format(i, in_type, str(type(in_val).__name__)))
                if str(type(in_val).__name__)[:len(in_type)] != in_type:
                    raise Exception("Error: unexpected type for input argument {}, expected {} but got {}.".format(i, in_type, str(type(in_val).__name__)))

    #---------------------------------------------------------------------------
    def _check_error_queue(self, err=None):
        """
        Check system error for errors. Empties and prints the complete error queue.

        Parameters
        ----------
        err : Exception
            Exception to reraise.

        Returns
        ----------

        Raises
        ----------
        Exception
            An error was found in system error or an exception was passed as input argument.
        """

        if self._debug <= 1:
            errors = [str(err)] if err is not None else []
            while int(self._read('SYSTem:ERRor:COUNt?')) != 0:
                errors.append(','.join(self._read('SYSTem:ERRor:NEXT?').split(',')[1:]))

            if len(errors) > 0:
                if err is not None:
                    err_type = type(err)
                else:
                    err_type = Exception
                raise err_type('\n'.join(errors)).with_traceback(sys.exc_info()[2]) from None
