# Generated by Django 5.0.2 on 2024-02-29 21:36

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="App",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "name",
                    models.CharField(help_text="Descriptive and unique name of the app", max_length=25, unique=True),
                ),
                (
                    "slug",
                    models.SlugField(
                        help_text="Unique slug for the app, it must be url friendly and please avoid to change it",
                        unique=True,
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        help_text="Description of the app, it will appear on the authorize UI", max_length=255
                    ),
                ),
                (
                    "algorithm",
                    models.CharField(
                        choices=[
                            ("HMAC_SHA256", "HMAC-SHA256"),
                            ("HMAC_SHA512", "HMAC_SHA512"),
                            ("ED25519", "ED25519"),
                        ],
                        default="HMAC_SHA512",
                        max_length=11,
                    ),
                ),
                (
                    "strategy",
                    models.CharField(
                        choices=[("JWT", "Json Web Token"), ("SIGNATURE", "Signature")], default="JWT", max_length=9
                    ),
                ),
                (
                    "schema",
                    models.CharField(
                        choices=[("LINK", "Link")],
                        default="LINK",
                        help_text="Schema to use for the auth process to r2epresent how the apps will communicate",
                        max_length=4,
                    ),
                ),
                (
                    "agreement_version",
                    models.IntegerField(default=1, help_text="Version of the agreement, based in the scopes"),
                ),
                ("private_key", models.CharField(blank=True, max_length=255)),
                ("public_key", models.CharField(blank=True, default=None, max_length=255, null=True)),
                (
                    "require_an_agreement",
                    models.BooleanField(
                        default=True, help_text="If true, the user will be required to accept an agreement"
                    ),
                ),
                (
                    "users_path",
                    models.CharField(
                        blank=True,
                        default="/v1/auth/app/user/",
                        help_text="URL path to consult the users",
                        max_length=200,
                    ),
                ),
                ("webhook_url", models.URLField(help_text="URL to receive webhooks")),
                ("redirect_url", models.URLField(help_text="URL to redirect the user after the authorization")),
                ("app_url", models.URLField(help_text="URL to the app")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name="OptionalScopeSet",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
            ],
        ),
        migrations.CreateModel(
            name="Scope",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "name",
                    models.CharField(
                        help_text="Descriptive and unique name that appears on the authorize UI",
                        max_length=25,
                        unique=True,
                    ),
                ),
                (
                    "slug",
                    models.CharField(help_text="{action}:{data} for example read:repo", max_length=15, unique=True),
                ),
                ("description", models.CharField(help_text="Description of the scope", max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name="FirstPartyCredentials",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("app", models.JSONField(blank=True, default=dict, help_text="Credentials in each app")),
                (
                    "health_status",
                    models.JSONField(blank=True, default=dict, help_text="Health status of each credentials"),
                ),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="credentials",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="FirstPartyWebhookLog",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "type",
                    models.CharField(blank=True, default="unknown", help_text="Type of the webhook", max_length=50),
                ),
                (
                    "user_id",
                    models.IntegerField(
                        blank=True, default=None, help_text="User ID who triggered the webhook", null=True
                    ),
                ),
                (
                    "external_id",
                    models.IntegerField(
                        blank=True, default=None, help_text="External ID where the webhook was triggered", null=True
                    ),
                ),
                ("url", models.URLField(blank=True, default=None, help_text="URL to consult the content", null=True)),
                ("data", models.JSONField(blank=True, default=dict, help_text="Data received", null=True)),
                (
                    "processed",
                    models.BooleanField(blank=True, default=False, help_text="If true, the webhook has been processed"),
                ),
                (
                    "attempts",
                    models.IntegerField(blank=True, default=0, help_text="Number of attempts to process the webhook"),
                ),
                (
                    "status",
                    models.CharField(
                        blank=True,
                        choices=[("PENDING", "Pending"), ("DONE", "Done"), ("ERROR", "Error")],
                        default="PENDING",
                        max_length=9,
                    ),
                ),
                ("status_text", models.CharField(blank=True, default=None, max_length=255, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "app",
                    models.ForeignKey(
                        help_text="App that triggered or will receive the webhook",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="linked_services.app",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="LegacyKey",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "algorithm",
                    models.CharField(
                        choices=[
                            ("HMAC_SHA256", "HMAC-SHA256"),
                            ("HMAC_SHA512", "HMAC_SHA512"),
                            ("ED25519", "ED25519"),
                        ],
                        max_length=11,
                    ),
                ),
                (
                    "strategy",
                    models.CharField(choices=[("JWT", "Json Web Token"), ("SIGNATURE", "Signature")], max_length=9),
                ),
                ("schema", models.CharField(choices=[("LINK", "Link")], max_length=4)),
                ("private_key", models.CharField(blank=True, max_length=255)),
                ("public_key", models.CharField(blank=True, default=None, max_length=255, null=True)),
                ("webhook_url", models.URLField()),
                ("redirect_url", models.URLField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "app",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE, related_name="legacy_key", to="linked_services.app"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="AppUserAgreement",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "agreement_version",
                    models.IntegerField(default=1, help_text="Version of the agreement that was accepted"),
                ),
                ("agreed_at", models.DateTimeField()),
                ("app", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="linked_services.app")),
                ("user", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                (
                    "optional_scope_set",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="app_user_agreement",
                        to="linked_services.optionalscopeset",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="optionalscopeset",
            name="optional_scopes",
            field=models.ManyToManyField(blank=True, to="linked_services.scope"),
        ),
        migrations.CreateModel(
            name="AppRequiredScope",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("agreed_at", models.DateTimeField(auto_now_add=True)),
                (
                    "app",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="m2m_required_scopes",
                        to="linked_services.app",
                    ),
                ),
                (
                    "scope",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="m2m_required_scopes",
                        to="linked_services.scope",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="AppOptionalScope",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("agreed_at", models.DateTimeField(auto_now_add=True)),
                (
                    "app",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="m2m_optional_scopes",
                        to="linked_services.app",
                    ),
                ),
                (
                    "scope",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="m2m_optional_scopes",
                        to="linked_services.scope",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="app",
            name="optional_scopes",
            field=models.ManyToManyField(
                blank=True,
                related_name="app_optional_scopes",
                through="linked_services.AppOptionalScope",
                to="linked_services.scope",
            ),
        ),
        migrations.AddField(
            model_name="app",
            name="required_scopes",
            field=models.ManyToManyField(
                blank=True,
                related_name="app_required_scopes",
                through="linked_services.AppRequiredScope",
                to="linked_services.scope",
            ),
        ),
    ]
