"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster = exports.ClusterProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const provider_aws_1 = require("@cdktf/provider-aws");
const cdktf_1 = require("cdktf");
const constructs_1 = require("constructs");
const _1 = require(".");
const awsEcs = require("./imports/modules/terraform-aws-modules/ecs/aws");
const awsVpc = require("./imports/modules/terraform-aws-modules/vpc/aws");
const AZ = provider_aws_1.DataSources.DataAwsAvailabilityZones;
/**
 * @stability stable
 */
class ClusterProps {
}
exports.ClusterProps = ClusterProps;
_a = JSII_RTTI_SYMBOL_1;
ClusterProps[_a] = { fqn: "@pahud/cdktf-aws-ecs.ClusterProps", version: "0.1.82" };
/**
 * @stability stable
 */
class Cluster extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _c, _d;
        super(scope, id);
        this.props = props;
        this.region = (_c = props.region) !== null && _c !== void 0 ? _c : 'us-east-1';
        new provider_aws_1.AwsProvider(this, 'aws', { region: this.region });
        this.clusterName = (_d = props.name) !== null && _d !== void 0 ? _d : `${id}-cluster`;
        // no private subnets given
        if (!props.vpcSubnets) {
            const vpc = this._createVpc();
            this.vpc = vpc;
            this.vpcId = cdktf_1.Token.asString(vpc.vpcIdOutput);
            this.vpcSubnets = cdktf_1.Token.asList(vpc.privateSubnetsOutput);
        }
        else {
            this.vpcSubnets = props.vpcSubnets;
        }
        // cluster
        new awsEcs.TerraformAwsModulesEcsAws(this, 'Cluster', {
            name: this.clusterName,
        });
    }
    _createContainerServiceforEC2Role(id) {
        const role = new provider_aws_1.IAM.IamRole(this, `${id}-ecs-instance-role`, {
            name: `${id}-ecs-instance-role`,
            // name: 'ecs-instance-role',
            assumeRolePolicy: JSON.stringify({
                Version: '2012-10-17',
                Statement: [
                    {
                        Action: 'sts:AssumeRole',
                        Effect: 'Allow',
                        Sid: '',
                        Principal: {
                            Service: 'ec2.amazonaws.com',
                        },
                    },
                ],
            }),
        });
        new provider_aws_1.IAM.IamPolicyAttachment(this, `${id}AmazonEC2ContainerServiceforEC2RoleAttachment`, {
            name: 'AmazonEC2ContainerServiceforEC2RoleAttachment',
            policyArn: 'arn:aws:iam::aws:policy/service-role/AmazonEC2ContainerServiceforEC2Role',
            roles: [role.name],
        });
        new provider_aws_1.IAM.IamPolicyAttachment(this, `${id}AmazonSSMManagedInstanceCoreAttachment`, {
            name: 'AmazonSSMManagedInstanceCoreAttachment',
            policyArn: 'arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore',
            roles: [role.name],
        });
        return role;
    }
    _createIamInstanceProfile(id, roleName) {
        return new provider_aws_1.IAM.IamInstanceProfile(this, `${id}InstanceProfile`, {
            role: roleName,
        });
    }
    _createVpc() {
        const vpc = new awsVpc.TerraformAwsModulesVpcAws(this, 'Vpc', {
            cidr: '10.0.0.0/16',
            azs: new AZ(this, 'AZs', {
                state: 'available',
            }).names,
            publicSubnets: ['10.0.1.0/24', '10.0.2.0/24', '10.0.3.0/24'],
            privateSubnets: ['10.0.11.0/24', '10.0.12.0/24', '10.0.13.0/24'],
            singleNatGateway: true,
            enableNatGateway: true,
            oneNatGatewayPerAz: false,
        });
        return vpc;
    }
    _createLaunchTemplate(id, instanceProfileArn, image) {
        var _c, _d;
        return new provider_aws_1.EC2.LaunchTemplate(this, `${id}LT`, {
            imageId: (_c = image === null || image === void 0 ? void 0 : image.amiId) !== null && _c !== void 0 ? _c : new _1.EcsOptimizedAmi(this, {
                generation: _1.AmazonLinuxGeneration.AMAZON_LINUX_2,
            }).amiId,
            iamInstanceProfile: { arn: instanceProfileArn },
            instanceType: (_d = this.props.instanceType) !== null && _d !== void 0 ? _d : 't3.large',
        });
    }
    /**
     * @stability stable
     */
    addAsgCapacity(id, options) {
        var _c, _d, _e;
        const instanceRole = this._createContainerServiceforEC2Role(id);
        const instanceProfile = this._createIamInstanceProfile(id, instanceRole.name);
        const lt = this._createLaunchTemplate(id, instanceProfile.arn, options.machineImage);
        // default userData
        let userData = `#!/bin/bash\necho ECS_CLUSTER=${this.clusterName} > /etc/ecs/ecs.config`;
        // if bottlerocket image
        if (options.machineImage && isBottleRocketImage(options.machineImage)) {
            userData = `[settings.ecs]\ncluster = "${this.clusterName}"`;
        }
        let b64userdata = Buffer.from(userData).toString('base64');
        lt.addOverride('user_data', b64userdata);
        const minCapacity = (_c = options.minCapacity) !== null && _c !== void 0 ? _c : 0;
        const desiredCapacity = (_d = options.desiredCapacity) !== null && _d !== void 0 ? _d : minCapacity;
        const maxCapacity = ((_e = options.maxCapacity) !== null && _e !== void 0 ? _e : (desiredCapacity > 0)) ?
            desiredCapacity : 1;
        const asg = new provider_aws_1.AutoScaling.AutoscalingGroup(this, `${id}-ASG`, {
            maxSize: maxCapacity,
            desiredCapacity: desiredCapacity,
            minSize: minCapacity,
            vpcZoneIdentifier: this.vpcSubnets,
            launchTemplate: {
                id: lt.id,
                version: '$Latest',
            },
        });
        new provider_aws_1.ECS.EcsCapacityProvider(this, `${id}EcsCapacityProvider`, {
            name: `cp-${id}`,
            autoScalingGroupProvider: {
                autoScalingGroupArn: asg.arn,
            },
        });
    }
}
exports.Cluster = Cluster;
_b = JSII_RTTI_SYMBOL_1;
Cluster[_b] = { fqn: "@pahud/cdktf-aws-ecs.Cluster", version: "0.1.82" };
function isBottleRocketImage(image) {
    return image instanceof _1.BottleRocketImage;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2x1c3Rlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9jbHVzdGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsc0RBQWdIO0FBQ2hILGlDQUE4QjtBQUM5QiwyQ0FBdUM7QUFDdkMsd0JBQWdHO0FBQ2hHLDBFQUEwRTtBQUMxRSwwRUFBMEU7QUFFMUUsTUFBTSxFQUFFLEdBQUcsMEJBQVcsQ0FBQyx3QkFBd0IsQ0FBQzs7OztBQUVoRCxNQUFhLFlBQVk7O0FBQXpCLG9DQVFDOzs7Ozs7QUFTRCxNQUFhLE9BQVEsU0FBUSxzQkFBUzs7OztJQU9wQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFFBQXNCLEVBQUU7O1FBQ2hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDbkIsSUFBSSxDQUFDLE1BQU0sU0FBRyxLQUFLLENBQUMsTUFBTSxtQ0FBSSxXQUFXLENBQUM7UUFDMUMsSUFBSSwwQkFBVyxDQUFDLElBQUksRUFBRSxLQUFLLEVBQUUsRUFBRSxNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDLENBQUM7UUFFdEQsSUFBSSxDQUFDLFdBQVcsU0FBRyxLQUFLLENBQUMsSUFBSSxtQ0FBSSxHQUFHLEVBQUUsVUFBVSxDQUFDO1FBRWpELDJCQUEyQjtRQUMzQixJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsRUFBRTtZQUNyQixNQUFNLEdBQUcsR0FBRyxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUM7WUFDOUIsSUFBSSxDQUFDLEdBQUcsR0FBRyxHQUFHLENBQUM7WUFDZixJQUFJLENBQUMsS0FBSyxHQUFHLGFBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLFdBQVcsQ0FBQyxDQUFDO1lBQzdDLElBQUksQ0FBQyxVQUFVLEdBQUcsYUFBSyxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsb0JBQW9CLENBQUMsQ0FBQztTQUMxRDthQUFNO1lBQ0wsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVyxDQUFDO1NBQ3JDO1FBRUQsVUFBVTtRQUNWLElBQUksTUFBTSxDQUFDLHlCQUF5QixDQUFDLElBQUksRUFBRSxTQUFTLEVBQUU7WUFDcEQsSUFBSSxFQUFFLElBQUksQ0FBQyxXQUFXO1NBQ3ZCLENBQUMsQ0FBQztJQUNMLENBQUM7SUFDTyxpQ0FBaUMsQ0FBQyxFQUFVO1FBQ2xELE1BQU0sSUFBSSxHQUFHLElBQUksa0JBQUcsQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLEdBQUcsRUFBRSxvQkFBb0IsRUFBRTtZQUM1RCxJQUFJLEVBQUUsR0FBRyxFQUFFLG9CQUFvQjtZQUMvQiw2QkFBNkI7WUFDN0IsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQztnQkFDL0IsT0FBTyxFQUFFLFlBQVk7Z0JBQ3JCLFNBQVMsRUFBRTtvQkFDVDt3QkFDRSxNQUFNLEVBQUUsZ0JBQWdCO3dCQUN4QixNQUFNLEVBQUUsT0FBTzt3QkFDZixHQUFHLEVBQUUsRUFBRTt3QkFDUCxTQUFTLEVBQUU7NEJBQ1QsT0FBTyxFQUFFLG1CQUFtQjt5QkFDN0I7cUJBQ0Y7aUJBQ0Y7YUFDRixDQUFDO1NBQ0gsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxrQkFBRyxDQUFDLG1CQUFtQixDQUFDLElBQUksRUFBRSxHQUFHLEVBQUUsK0NBQStDLEVBQUU7WUFDdEYsSUFBSSxFQUFFLCtDQUErQztZQUNyRCxTQUFTLEVBQUUsMEVBQTBFO1lBQ3JGLEtBQUssRUFBRSxDQUFDLElBQUksQ0FBQyxJQUFLLENBQUM7U0FDcEIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxrQkFBRyxDQUFDLG1CQUFtQixDQUFDLElBQUksRUFBRSxHQUFHLEVBQUUsd0NBQXdDLEVBQUU7WUFDL0UsSUFBSSxFQUFFLHdDQUF3QztZQUM5QyxTQUFTLEVBQUUsc0RBQXNEO1lBQ2pFLEtBQUssRUFBRSxDQUFDLElBQUksQ0FBQyxJQUFLLENBQUM7U0FDcEIsQ0FBQyxDQUFDO1FBQ0gsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBQ08seUJBQXlCLENBQUMsRUFBVSxFQUFFLFFBQWdCO1FBQzVELE9BQU8sSUFBSSxrQkFBRyxDQUFDLGtCQUFrQixDQUFDLElBQUksRUFBRSxHQUFHLEVBQUUsaUJBQWlCLEVBQUU7WUFDOUQsSUFBSSxFQUFFLFFBQVE7U0FDZixDQUFDLENBQUM7SUFDTCxDQUFDO0lBQ08sVUFBVTtRQUNoQixNQUFNLEdBQUcsR0FBRyxJQUFJLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQyxJQUFJLEVBQUUsS0FBSyxFQUFFO1lBQzVELElBQUksRUFBRSxhQUFhO1lBQ25CLEdBQUcsRUFBRSxJQUFJLEVBQUUsQ0FBQyxJQUFJLEVBQUUsS0FBSyxFQUFFO2dCQUN2QixLQUFLLEVBQUUsV0FBVzthQUNuQixDQUFDLENBQUMsS0FBSztZQUNSLGFBQWEsRUFBRSxDQUFDLGFBQWEsRUFBRSxhQUFhLEVBQUUsYUFBYSxDQUFDO1lBQzVELGNBQWMsRUFBRSxDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsY0FBYyxDQUFDO1lBQ2hFLGdCQUFnQixFQUFFLElBQUk7WUFDdEIsZ0JBQWdCLEVBQUUsSUFBSTtZQUN0QixrQkFBa0IsRUFBRSxLQUFLO1NBQzFCLENBQUMsQ0FBQztRQUNILE9BQU8sR0FBRyxDQUFDO0lBQ2IsQ0FBQztJQUNPLHFCQUFxQixDQUFDLEVBQVUsRUFBRSxrQkFBMEIsRUFBRSxLQUF3Qjs7UUFDNUYsT0FBTyxJQUFJLGtCQUFHLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSxHQUFHLEVBQUUsSUFBSSxFQUFFO1lBQzdDLE9BQU8sUUFBRSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsS0FBSyxtQ0FBSSxJQUFJLGtCQUFlLENBQUMsSUFBSSxFQUFFO2dCQUNqRCxVQUFVLEVBQUUsd0JBQXFCLENBQUMsY0FBYzthQUNqRCxDQUFDLENBQUMsS0FBSztZQUNSLGtCQUFrQixFQUFFLEVBQUUsR0FBRyxFQUFFLGtCQUFrQixFQUFFO1lBQy9DLFlBQVksUUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksbUNBQUksVUFBVTtTQUNwRCxDQUFDLENBQUM7SUFDTCxDQUFDOzs7O0lBQ00sY0FBYyxDQUFDLEVBQVUsRUFBRSxPQUEyQjs7UUFDM0QsTUFBTSxZQUFZLEdBQUcsSUFBSSxDQUFDLGlDQUFpQyxDQUFDLEVBQUUsQ0FBQyxDQUFDO1FBQ2hFLE1BQU0sZUFBZSxHQUFHLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxFQUFFLEVBQUUsWUFBWSxDQUFDLElBQUssQ0FBQyxDQUFDO1FBQy9FLE1BQU0sRUFBRSxHQUFHLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxFQUFFLEVBQUUsZUFBZSxDQUFDLEdBQUcsRUFBRSxPQUFPLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDckYsbUJBQW1CO1FBQ25CLElBQUksUUFBUSxHQUFHLGlDQUFpQyxJQUFJLENBQUMsV0FBVyx3QkFBd0IsQ0FBQztRQUN6Rix3QkFBd0I7UUFDeEIsSUFBSSxPQUFPLENBQUMsWUFBWSxJQUFJLG1CQUFtQixDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsRUFBRTtZQUNyRSxRQUFRLEdBQUcsOEJBQThCLElBQUksQ0FBQyxXQUFXLEdBQUcsQ0FBQztTQUM5RDtRQUVELElBQUksV0FBVyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQzNELEVBQUUsQ0FBQyxXQUFXLENBQUMsV0FBVyxFQUFFLFdBQVcsQ0FBQyxDQUFDO1FBRXpDLE1BQU0sV0FBVyxTQUFHLE9BQU8sQ0FBQyxXQUFXLG1DQUFJLENBQUMsQ0FBQztRQUM3QyxNQUFNLGVBQWUsU0FBRyxPQUFPLENBQUMsZUFBZSxtQ0FBSSxXQUFXLENBQUM7UUFDL0QsTUFBTSxXQUFXLEdBQUcsT0FBQSxPQUFPLENBQUMsV0FBVyxtQ0FBSSxDQUFDLGVBQWUsR0FBRyxDQUFDLENBQUMsRUFBQyxDQUFDO1lBQ2hFLGVBQWUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBRXRCLE1BQU0sR0FBRyxHQUFHLElBQUksMEJBQVcsQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLEVBQUUsR0FBRyxFQUFFLE1BQU0sRUFBRTtZQUM5RCxPQUFPLEVBQUUsV0FBVztZQUNwQixlQUFlLEVBQUUsZUFBZTtZQUNoQyxPQUFPLEVBQUUsV0FBVztZQUNwQixpQkFBaUIsRUFBRSxJQUFJLENBQUMsVUFBVTtZQUNsQyxjQUFjLEVBQUU7Z0JBQ2QsRUFBRSxFQUFFLEVBQUUsQ0FBQyxFQUFFO2dCQUNULE9BQU8sRUFBRSxTQUFTO2FBQ25CO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxrQkFBRyxDQUFDLG1CQUFtQixDQUFDLElBQUksRUFBRSxHQUFHLEVBQUUscUJBQXFCLEVBQUU7WUFDNUQsSUFBSSxFQUFFLE1BQU0sRUFBRSxFQUFFO1lBQ2hCLHdCQUF3QixFQUFFO2dCQUN4QixtQkFBbUIsRUFBRSxHQUFHLENBQUMsR0FBRzthQUM3QjtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBNUhILDBCQTZIQzs7O0FBRUQsU0FBUyxtQkFBbUIsQ0FBQyxLQUF1QjtJQUNsRCxPQUFPLEtBQUssWUFBWSxvQkFBaUIsQ0FBQztBQUM1QyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQXdzUHJvdmlkZXIsIEF1dG9TY2FsaW5nLCBFQ1MgYXMgZWNzLCBFQzIgYXMgZWMyLCBJQU0gYXMgaWFtLCBEYXRhU291cmNlcyB9IGZyb20gJ0BjZGt0Zi9wcm92aWRlci1hd3MnO1xuaW1wb3J0IHsgVG9rZW4gfSBmcm9tICdjZGt0Zic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IEFtYXpvbkxpbnV4R2VuZXJhdGlvbiwgQm90dGxlUm9ja2V0SW1hZ2UsIEVjc09wdGltaXplZEFtaSwgSUVjc01hY2hpbmVJbWFnZSB9IGZyb20gJy4nO1xuaW1wb3J0ICogYXMgYXdzRWNzIGZyb20gJy4vaW1wb3J0cy9tb2R1bGVzL3RlcnJhZm9ybS1hd3MtbW9kdWxlcy9lY3MvYXdzJztcbmltcG9ydCAqIGFzIGF3c1ZwYyBmcm9tICcuL2ltcG9ydHMvbW9kdWxlcy90ZXJyYWZvcm0tYXdzLW1vZHVsZXMvdnBjL2F3cyc7XG5cbmNvbnN0IEFaID0gRGF0YVNvdXJjZXMuRGF0YUF3c0F2YWlsYWJpbGl0eVpvbmVzO1xuXG5leHBvcnQgY2xhc3MgQ2x1c3RlclByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZWdpb24/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IG5hbWU/OiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaW5zdGFuY2VUeXBlPzogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZwY1N1Ym5ldHM/OiBzdHJpbmdbXTtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBBc2dDYXBhY2l0eU9wdGlvbnMge1xuICByZWFkb25seSBtYXhDYXBhY2l0eT86IG51bWJlcjtcbiAgcmVhZG9ubHkgbWluQ2FwYWNpdHk/OiBudW1iZXI7XG4gIHJlYWRvbmx5IGRlc2lyZWRDYXBhY2l0eT86IG51bWJlcjtcbiAgcmVhZG9ubHkgbWFjaGluZUltYWdlPzogSUVjc01hY2hpbmVJbWFnZTtcbn1cblxuZXhwb3J0IGNsYXNzIENsdXN0ZXIgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICByZWFkb25seSByZWdpb246IHN0cmluZztcbiAgcmVhZG9ubHkgY2x1c3Rlck5hbWU6IHN0cmluZztcbiAgcmVhZG9ubHkgdnBjPzogYW55O1xuICByZWFkb25seSB2cGNJZD86IHN0cmluZztcbiAgcHJpdmF0ZSByZWFkb25seSB2cGNTdWJuZXRzOiBzdHJpbmdbXTtcbiAgcHJpdmF0ZSByZWFkb25seSBwcm9wczogQ2x1c3RlclByb3BzO1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2x1c3RlclByb3BzID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuICAgIHRoaXMucmVnaW9uID0gcHJvcHMucmVnaW9uID8/ICd1cy1lYXN0LTEnO1xuICAgIG5ldyBBd3NQcm92aWRlcih0aGlzLCAnYXdzJywgeyByZWdpb246IHRoaXMucmVnaW9uIH0pO1xuXG4gICAgdGhpcy5jbHVzdGVyTmFtZSA9IHByb3BzLm5hbWUgPz8gYCR7aWR9LWNsdXN0ZXJgO1xuXG4gICAgLy8gbm8gcHJpdmF0ZSBzdWJuZXRzIGdpdmVuXG4gICAgaWYgKCFwcm9wcy52cGNTdWJuZXRzKSB7XG4gICAgICBjb25zdCB2cGMgPSB0aGlzLl9jcmVhdGVWcGMoKTtcbiAgICAgIHRoaXMudnBjID0gdnBjO1xuICAgICAgdGhpcy52cGNJZCA9IFRva2VuLmFzU3RyaW5nKHZwYy52cGNJZE91dHB1dCk7XG4gICAgICB0aGlzLnZwY1N1Ym5ldHMgPSBUb2tlbi5hc0xpc3QodnBjLnByaXZhdGVTdWJuZXRzT3V0cHV0KTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy52cGNTdWJuZXRzID0gcHJvcHMudnBjU3VibmV0cyE7XG4gICAgfVxuXG4gICAgLy8gY2x1c3RlclxuICAgIG5ldyBhd3NFY3MuVGVycmFmb3JtQXdzTW9kdWxlc0Vjc0F3cyh0aGlzLCAnQ2x1c3RlcicsIHtcbiAgICAgIG5hbWU6IHRoaXMuY2x1c3Rlck5hbWUsXG4gICAgfSk7XG4gIH1cbiAgcHJpdmF0ZSBfY3JlYXRlQ29udGFpbmVyU2VydmljZWZvckVDMlJvbGUoaWQ6IHN0cmluZyk6IGlhbS5JYW1Sb2xlIHtcbiAgICBjb25zdCByb2xlID0gbmV3IGlhbS5JYW1Sb2xlKHRoaXMsIGAke2lkfS1lY3MtaW5zdGFuY2Utcm9sZWAsIHtcbiAgICAgIG5hbWU6IGAke2lkfS1lY3MtaW5zdGFuY2Utcm9sZWAsXG4gICAgICAvLyBuYW1lOiAnZWNzLWluc3RhbmNlLXJvbGUnLFxuICAgICAgYXNzdW1lUm9sZVBvbGljeTogSlNPTi5zdHJpbmdpZnkoe1xuICAgICAgICBWZXJzaW9uOiAnMjAxMi0xMC0xNycsXG4gICAgICAgIFN0YXRlbWVudDogW1xuICAgICAgICAgIHtcbiAgICAgICAgICAgIEFjdGlvbjogJ3N0czpBc3N1bWVSb2xlJyxcbiAgICAgICAgICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICAgICAgICAgIFNpZDogJycsXG4gICAgICAgICAgICBQcmluY2lwYWw6IHtcbiAgICAgICAgICAgICAgU2VydmljZTogJ2VjMi5hbWF6b25hd3MuY29tJyxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSxcbiAgICAgICAgXSxcbiAgICAgIH0pLFxuICAgIH0pO1xuICAgIG5ldyBpYW0uSWFtUG9saWN5QXR0YWNobWVudCh0aGlzLCBgJHtpZH1BbWF6b25FQzJDb250YWluZXJTZXJ2aWNlZm9yRUMyUm9sZUF0dGFjaG1lbnRgLCB7XG4gICAgICBuYW1lOiAnQW1hem9uRUMyQ29udGFpbmVyU2VydmljZWZvckVDMlJvbGVBdHRhY2htZW50JyxcbiAgICAgIHBvbGljeUFybjogJ2Fybjphd3M6aWFtOjphd3M6cG9saWN5L3NlcnZpY2Utcm9sZS9BbWF6b25FQzJDb250YWluZXJTZXJ2aWNlZm9yRUMyUm9sZScsXG4gICAgICByb2xlczogW3JvbGUubmFtZSFdLFxuICAgIH0pO1xuICAgIG5ldyBpYW0uSWFtUG9saWN5QXR0YWNobWVudCh0aGlzLCBgJHtpZH1BbWF6b25TU01NYW5hZ2VkSW5zdGFuY2VDb3JlQXR0YWNobWVudGAsIHtcbiAgICAgIG5hbWU6ICdBbWF6b25TU01NYW5hZ2VkSW5zdGFuY2VDb3JlQXR0YWNobWVudCcsXG4gICAgICBwb2xpY3lBcm46ICdhcm46YXdzOmlhbTo6YXdzOnBvbGljeS9BbWF6b25TU01NYW5hZ2VkSW5zdGFuY2VDb3JlJyxcbiAgICAgIHJvbGVzOiBbcm9sZS5uYW1lIV0sXG4gICAgfSk7XG4gICAgcmV0dXJuIHJvbGU7XG4gIH1cbiAgcHJpdmF0ZSBfY3JlYXRlSWFtSW5zdGFuY2VQcm9maWxlKGlkOiBzdHJpbmcsIHJvbGVOYW1lOiBzdHJpbmcpOiBpYW0uSWFtSW5zdGFuY2VQcm9maWxlIHtcbiAgICByZXR1cm4gbmV3IGlhbS5JYW1JbnN0YW5jZVByb2ZpbGUodGhpcywgYCR7aWR9SW5zdGFuY2VQcm9maWxlYCwge1xuICAgICAgcm9sZTogcm9sZU5hbWUsXG4gICAgfSk7XG4gIH1cbiAgcHJpdmF0ZSBfY3JlYXRlVnBjKCkge1xuICAgIGNvbnN0IHZwYyA9IG5ldyBhd3NWcGMuVGVycmFmb3JtQXdzTW9kdWxlc1ZwY0F3cyh0aGlzLCAnVnBjJywge1xuICAgICAgY2lkcjogJzEwLjAuMC4wLzE2JyxcbiAgICAgIGF6czogbmV3IEFaKHRoaXMsICdBWnMnLCB7XG4gICAgICAgIHN0YXRlOiAnYXZhaWxhYmxlJyxcbiAgICAgIH0pLm5hbWVzLFxuICAgICAgcHVibGljU3VibmV0czogWycxMC4wLjEuMC8yNCcsICcxMC4wLjIuMC8yNCcsICcxMC4wLjMuMC8yNCddLFxuICAgICAgcHJpdmF0ZVN1Ym5ldHM6IFsnMTAuMC4xMS4wLzI0JywgJzEwLjAuMTIuMC8yNCcsICcxMC4wLjEzLjAvMjQnXSxcbiAgICAgIHNpbmdsZU5hdEdhdGV3YXk6IHRydWUsXG4gICAgICBlbmFibGVOYXRHYXRld2F5OiB0cnVlLFxuICAgICAgb25lTmF0R2F0ZXdheVBlckF6OiBmYWxzZSxcbiAgICB9KTtcbiAgICByZXR1cm4gdnBjO1xuICB9XG4gIHByaXZhdGUgX2NyZWF0ZUxhdW5jaFRlbXBsYXRlKGlkOiBzdHJpbmcsIGluc3RhbmNlUHJvZmlsZUFybjogc3RyaW5nLCBpbWFnZT86IElFY3NNYWNoaW5lSW1hZ2UpOiBlYzIuTGF1bmNoVGVtcGxhdGUge1xuICAgIHJldHVybiBuZXcgZWMyLkxhdW5jaFRlbXBsYXRlKHRoaXMsIGAke2lkfUxUYCwge1xuICAgICAgaW1hZ2VJZDogaW1hZ2U/LmFtaUlkID8/IG5ldyBFY3NPcHRpbWl6ZWRBbWkodGhpcywge1xuICAgICAgICBnZW5lcmF0aW9uOiBBbWF6b25MaW51eEdlbmVyYXRpb24uQU1BWk9OX0xJTlVYXzIsXG4gICAgICB9KS5hbWlJZCxcbiAgICAgIGlhbUluc3RhbmNlUHJvZmlsZTogeyBhcm46IGluc3RhbmNlUHJvZmlsZUFybiB9LFxuICAgICAgaW5zdGFuY2VUeXBlOiB0aGlzLnByb3BzLmluc3RhbmNlVHlwZSA/PyAndDMubGFyZ2UnLFxuICAgIH0pO1xuICB9XG4gIHB1YmxpYyBhZGRBc2dDYXBhY2l0eShpZDogc3RyaW5nLCBvcHRpb25zOiBBc2dDYXBhY2l0eU9wdGlvbnMpIHtcbiAgICBjb25zdCBpbnN0YW5jZVJvbGUgPSB0aGlzLl9jcmVhdGVDb250YWluZXJTZXJ2aWNlZm9yRUMyUm9sZShpZCk7XG4gICAgY29uc3QgaW5zdGFuY2VQcm9maWxlID0gdGhpcy5fY3JlYXRlSWFtSW5zdGFuY2VQcm9maWxlKGlkLCBpbnN0YW5jZVJvbGUubmFtZSEpO1xuICAgIGNvbnN0IGx0ID0gdGhpcy5fY3JlYXRlTGF1bmNoVGVtcGxhdGUoaWQsIGluc3RhbmNlUHJvZmlsZS5hcm4sIG9wdGlvbnMubWFjaGluZUltYWdlKTtcbiAgICAvLyBkZWZhdWx0IHVzZXJEYXRhXG4gICAgbGV0IHVzZXJEYXRhID0gYCMhL2Jpbi9iYXNoXFxuZWNobyBFQ1NfQ0xVU1RFUj0ke3RoaXMuY2x1c3Rlck5hbWV9ID4gL2V0Yy9lY3MvZWNzLmNvbmZpZ2A7XG4gICAgLy8gaWYgYm90dGxlcm9ja2V0IGltYWdlXG4gICAgaWYgKG9wdGlvbnMubWFjaGluZUltYWdlICYmIGlzQm90dGxlUm9ja2V0SW1hZ2Uob3B0aW9ucy5tYWNoaW5lSW1hZ2UpKSB7XG4gICAgICB1c2VyRGF0YSA9IGBbc2V0dGluZ3MuZWNzXVxcbmNsdXN0ZXIgPSBcIiR7dGhpcy5jbHVzdGVyTmFtZX1cImA7XG4gICAgfVxuXG4gICAgbGV0IGI2NHVzZXJkYXRhID0gQnVmZmVyLmZyb20odXNlckRhdGEpLnRvU3RyaW5nKCdiYXNlNjQnKTtcbiAgICBsdC5hZGRPdmVycmlkZSgndXNlcl9kYXRhJywgYjY0dXNlcmRhdGEpO1xuXG4gICAgY29uc3QgbWluQ2FwYWNpdHkgPSBvcHRpb25zLm1pbkNhcGFjaXR5ID8/IDA7XG4gICAgY29uc3QgZGVzaXJlZENhcGFjaXR5ID0gb3B0aW9ucy5kZXNpcmVkQ2FwYWNpdHkgPz8gbWluQ2FwYWNpdHk7XG4gICAgY29uc3QgbWF4Q2FwYWNpdHkgPSBvcHRpb25zLm1heENhcGFjaXR5ID8/IChkZXNpcmVkQ2FwYWNpdHkgPiAwKSA/XG4gICAgICBkZXNpcmVkQ2FwYWNpdHkgOiAxO1xuXG4gICAgY29uc3QgYXNnID0gbmV3IEF1dG9TY2FsaW5nLkF1dG9zY2FsaW5nR3JvdXAodGhpcywgYCR7aWR9LUFTR2AsIHtcbiAgICAgIG1heFNpemU6IG1heENhcGFjaXR5LFxuICAgICAgZGVzaXJlZENhcGFjaXR5OiBkZXNpcmVkQ2FwYWNpdHksXG4gICAgICBtaW5TaXplOiBtaW5DYXBhY2l0eSxcbiAgICAgIHZwY1pvbmVJZGVudGlmaWVyOiB0aGlzLnZwY1N1Ym5ldHMsXG4gICAgICBsYXVuY2hUZW1wbGF0ZToge1xuICAgICAgICBpZDogbHQuaWQsXG4gICAgICAgIHZlcnNpb246ICckTGF0ZXN0JyxcbiAgICAgIH0sXG4gICAgfSk7XG4gICAgbmV3IGVjcy5FY3NDYXBhY2l0eVByb3ZpZGVyKHRoaXMsIGAke2lkfUVjc0NhcGFjaXR5UHJvdmlkZXJgLCB7XG4gICAgICBuYW1lOiBgY3AtJHtpZH1gLFxuICAgICAgYXV0b1NjYWxpbmdHcm91cFByb3ZpZGVyOiB7XG4gICAgICAgIGF1dG9TY2FsaW5nR3JvdXBBcm46IGFzZy5hcm4sXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59XG5cbmZ1bmN0aW9uIGlzQm90dGxlUm9ja2V0SW1hZ2UoaW1hZ2U6IElFY3NNYWNoaW5lSW1hZ2UpIHtcbiAgcmV0dXJuIGltYWdlIGluc3RhbmNlb2YgQm90dGxlUm9ja2V0SW1hZ2U7XG59XG4iXX0=