from test_all import test_function, test_dependencies

from tests.data.geolayers import (
    geolayer_fr_dept_data_only,
    geolayer_fr_dept_data_and_geometry,
)

from tests.data.fields_metadata import geolayer_data_fields_metadata_complete

from geoformat.conversion.feature_conversion import feature_serialize

from geoformat.conversion.geolayer_conversion import (
    create_geolayer_from_i_feat_list,
    reproject_geolayer,
)

create_geolayer_from_i_feat_list_parameters = {
    0: {
        "geolayer": geolayer_fr_dept_data_only,
        "i_feat_list": 0,
        "serialize": False,
        "reset_i_feat": True,
        "return_value": {
            "metadata": {
                "fields": geolayer_data_fields_metadata_complete,
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY",
            },
            "features": {0: {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}}},
        },
    },
    1: {
        "geolayer": geolayer_fr_dept_data_only,
        "i_feat_list": [0],
        "serialize": False,
        "reset_i_feat": True,
        "return_value": {
            "metadata": {
                "fields": geolayer_data_fields_metadata_complete,
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY",
            },
            "features": {0: {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}}},
        },
    },
    2: {
        "geolayer": geolayer_fr_dept_data_only,
        "i_feat_list": [0, 95],
        "serialize": False,
        "reset_i_feat": True,
        "return_value": {
            "metadata": {
                "fields": geolayer_data_fields_metadata_complete,
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY",
            },
            "features": {
                0: {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}},
                1: {"attributes": {"CODE_DEPT": "93", "NOM_DEPT": "SEINE-SAINT-DENIS"}},
            },
        },
    },
    3: {
        "geolayer": geolayer_fr_dept_data_only,
        "i_feat_list": [0, 95],
        "serialize": False,
        "reset_i_feat": False,
        "return_value": {
            "metadata": {
                "fields": geolayer_data_fields_metadata_complete,
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY",
            },
            "features": {
                0: {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}},
                95: {
                    "attributes": {"CODE_DEPT": "93", "NOM_DEPT": "SEINE-SAINT-DENIS"}
                },
            },
        },
    },
    4: {
        "geolayer": geolayer_fr_dept_data_only,
        "i_feat_list": [0, 95],
        "serialize": True,
        "reset_i_feat": False,
        "return_value": {
            "metadata": {
                "fields": geolayer_data_fields_metadata_complete,
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY",
            },
            "features": {
                0: feature_serialize(
                    {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}}
                ),
                95: feature_serialize(
                    {"attributes": {"CODE_DEPT": "93", "NOM_DEPT": "SEINE-SAINT-DENIS"}}
                ),
            },
        },
    },
}

reproject_geolayer_parameters = {
    0: {
        "geolayer": geolayer_fr_dept_data_and_geometry,
        "out_crs": 4326,
        "in_crs": None,
        "return_value": {'metadata': {'name': 'FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_AND_GEOMETRY', 'fields': {'CODE_DEPT': {'type': 'String', 'width': 2, 'index': 0}, 'NOM_DEPT': {'type': 'String', 'width': 23, 'index': 1}}, 'geometry_ref': {'type': {'Polygon', 'MultiPolygon'}, 'crs': 4326}}, 'features': {0: {'geometry': {'type': 'Polygon', 'bbox': (438084.30000010587, 6248690.800002651, 554722.8000000587, 6333950.700002438), 'coordinates': [[[0.6068109749570959, 43.31088599158559], [0.6559378827169787, 43.31720926544656], [0.7175914463388231, 43.37663081008268], [0.8205416805525511, 43.41697502257897], [0.9172511345137198, 43.40633268927779], [0.9780837577086212, 43.362651706544284], [1.0181843408377875, 43.47333809239016], [1.201337008485553, 43.594812955020245], [1.1475492440427306, 43.634175893376046], [1.0876957388199562, 43.644975031688936], [0.9539831166064948, 43.78737246570894], [0.9061557706747253, 43.78433052070788], [0.8994393128667497, 43.864698458132814], [0.8628924476067095, 43.92328916304656], [0.7600848328151361, 43.94224249346582], [0.8604173969632195, 44.04078542270124], [0.7757831291372466, 44.03591070642866], [0.7418847912050018, 44.06519923501583], [0.666591773846917, 44.02514596559472], [0.5979775801101934, 44.07822724921209], [0.539030952371026, 44.05372241953208], [0.4595156323439905, 44.055237448974076], [0.4424499147549645, 44.02876198332598], [0.30409006822726997, 43.993057181274395], [0.1895751311264972, 44.01464171001979], [0.07604560969926165, 43.983143136582996], [0.07664688901342062, 43.91647114312968], [0.03255676418092499, 43.90018804605394], [-0.07359844651969293, 43.94504687607575], [-0.179109059517904, 43.93791976442846], [-0.23393876198189914, 43.89106775010974], [-0.19099217321599454, 43.87518333615964], [-0.19414330237233957, 43.737016685694776], [-0.23258236946731695, 43.71408748429121], [-0.24283655874306653, 43.584976209013746], [-0.17641328064610662, 43.59640400157074], [-0.0967829732087741, 43.58240589763179], [-0.015780894995830342, 43.60465738319832], [-0.0019248187812945813, 43.56554046143878], [0.056081443916198466, 43.518807249853], [0.11212423457670412, 43.51736991981866], [0.13798238183895745, 43.43291627195171], [0.1820312140000643, 43.37118267445086], [0.2772545000281141, 43.38579092290556], [0.49803381879209696, 43.326180572401476], [0.6068109749570959, 43.31088599158559]]]}, 'attributes': {'CODE_DEPT': '32', 'NOM_DEPT': 'GERS'}}, 1: {'geometry': {'type': 'Polygon', 'bbox': (449163.9000000953, 6324802.500002467, 547193.100000056, 6410676.300002238), 'coordinates': [[[1.0751408247250984, 44.57732478356566], [0.9791284687246188, 44.6436104555417], [0.8699961633462002, 44.59730727091498], [0.8170042739845027, 44.62700147643919], [0.827000964251777, 44.6918895790769], [0.657434416631217, 44.67784707846922], [0.6304884773468272, 44.70652766853696], [0.41470651574900597, 44.646337117152974], [0.36557538473802126, 44.662211036636265], [0.3354490861907097, 44.73743575883081], [0.2973255098237864, 44.76228467395244], [0.15300384600842049, 44.73048103978566], [0.13372640074632103, 44.6824441037855], [0.1826776591534788, 44.661072124007056], [0.153607862533407, 44.61612295595815], [0.04056782018280711, 44.553046617799], [-0.01545369989301612, 44.505062787136126], [-0.010552396185254522, 44.41854340374255], [0.018233646559888655, 44.389878791845156], [-0.08575207965012982, 44.337610049886734], [-0.034811250980738076, 44.296725798024674], [-0.06662475964814253, 44.24675799222613], [-0.1406884798527575, 44.22640474768996], [-0.12915451548994408, 44.15240992875165], [-0.004232390832891391, 44.149995950868565], [0.034593843822210965, 44.130652403429636], [0.13510828700872454, 44.12422070347961], [0.10082062971801486, 44.08677044167006], [0.0626980132929106, 44.00084249917973], [0.07604560969926165, 43.983143136582996], [0.1895751311264972, 44.01464171001979], [0.30409006822726997, 43.993057181274395], [0.4424499147549645, 44.02876198332598], [0.4595156323439905, 44.055237448974076], [0.539030952371026, 44.05372241953208], [0.5979775801101934, 44.07822724921209], [0.666591773846917, 44.02514596559472], [0.7418847912050018, 44.06519923501583], [0.7528835731451483, 44.1022698127059], [0.8687736555079509, 44.12632969467479], [0.9190898187097761, 44.23827002933668], [0.9499239562135774, 44.27644247710561], [0.8734701152053466, 44.323308108557846], [0.887330777155981, 44.36637485759445], [1.049803151007229, 44.36263857861537], [1.0640838318649115, 44.37851326503546], [1.0090253989657338, 44.48004110906175], [1.01316664592295, 44.536127142275056], [1.0751408247250984, 44.57732478356566]]]}, 'attributes': {'CODE_DEPT': '47', 'NOM_DEPT': 'LOT-ET-GARONNE'}}, 2: {'geometry': {'type': 'Polygon', 'bbox': (837307.6999999549, 6403479.700002258, 965006.099999906, 6534231.700001889), 'coordinates': [[[4.800493926884063, 45.29836066114302], [4.880237763487564, 45.29745400935145], [4.98919148345871, 45.3440466408362], [5.054318727576238, 45.31905467974741], [5.121425532367964, 45.24833591809071], [5.176540876984405, 45.24840204491137], [5.188573507748233, 45.17126853879264], [5.179384657685968, 45.08331022009434], [5.388382939418145, 45.03613916354614], [5.4497888352441555, 45.070783659173394], [5.483609211781887, 45.02278614732915], [5.483647138020397, 44.92229059824829], [5.464158754968865, 44.79242749679314], [5.627084872571889, 44.75246442874933], [5.759044078047862, 44.696070284154175], [5.801469996094522, 44.70677851287007], [5.850398663313627, 44.75074454418589], [5.915233300411789, 44.754705804536144], [5.949519247847449, 44.80453012289723], [6.030210546238997, 44.83809609775428], [6.056342958572753, 44.815908261733725], [6.136224190737252, 44.864072791226555], [6.25054409332542, 44.85265497741966], [6.302846745398275, 44.8732598816747], [6.355361452664248, 44.85477898991752], [6.358840060670484, 44.94128447146308], [6.318198197576597, 45.003856776770746], [6.203927022398642, 45.012469165084894], [6.229388123209471, 45.10875005580748], [6.260566197557925, 45.12684791386638], [6.189207693158913, 45.16373228327807], [6.1256964814234856, 45.24427026883595], [6.131944929909637, 45.28828721598462], [6.1844503207792245, 45.31794850760677], [6.177450938299201, 45.39316148783131], [6.121272339213555, 45.438897845399346], [6.049753851710851, 45.437919529651154], [5.966169653050878, 45.49230872138147], [5.8797384015593375, 45.406796712103855], [5.782081150720108, 45.44065533936717], [5.73637233564262, 45.47254042424711], [5.623748035268077, 45.613268326764235], [5.54554159780885, 45.71359345746494], [5.42264142008713, 45.80712379566383], [5.434944676804955, 45.831093776494356], [5.353827195805032, 45.88327273564147], [5.309169396437732, 45.85493340191014], [5.266894883868228, 45.78936901099023], [5.191532760208242, 45.77168800093884], [5.101067478338776, 45.813378082643716], [5.094526879742293, 45.7394533595093], [5.131048366350085, 45.70770885564481], [5.03514874052416, 45.63720294798385], [4.901457719834113, 45.60626780465852], [4.808696981728117, 45.57230056989166], [4.868481734036511, 45.523440212041656], [4.756935570818616, 45.455707349780305], [4.755996992712002, 45.36567226076606], [4.800493926884063, 45.29836066114302]]]}, 'attributes': {'CODE_DEPT': '38', 'NOM_DEPT': 'ISERE'}}, 3: {'geometry': {'type': 'Polygon', 'bbox': (597332.4000000085, 6993758.30000057, 712382.9999999988, 7101576.600000292), 'coordinates': [[[2.0677120276110013, 51.006505154674734], [1.915776261224724, 50.98408464073439], [1.7288531641107563, 50.93789161558701], [1.66409466424442, 50.89013244897838], [1.5806383872468288, 50.8673456889386], [1.6042134740274945, 50.79187042767518], [1.5607115203796043, 50.6996764042099], [1.5854134517805323, 50.53735245678956], [1.5577890976332032, 50.40471793677033], [1.6415439209955998, 50.35215320245149], [1.6707155098465685, 50.331010399908095], [1.7787842601942676, 50.36186618073267], [1.9180007470953697, 50.3117787753595], [1.9461316429137003, 50.28742804274709], [2.077820295455588, 50.2488212597536], [2.0957483707167435, 50.20554490564382], [2.2738282654200974, 50.226839899630434], [2.3702049076387826, 50.209770358333444], [2.4517852065078483, 50.23030237701513], [2.495690327572777, 50.19456202412894], [2.389777056686568, 50.15548482145538], [2.414507925852589, 50.100642406879025], [2.4766865519087604, 50.13699947000749], [2.551329915710551, 50.141605436872034], [2.5760198137336725, 50.11341281006871], [2.857843650412817, 50.077393119013884], [2.87653264314694, 50.04217932425911], [3.090253620620082, 50.0537405551461], [3.0957569207512843, 50.12420173434517], [3.1561320895920617, 50.1837151514849], [3.173376482382538, 50.24110767126835], [2.993078464231492, 50.379846956524474], [3.037672306035308, 50.441640098051245], [3.0207925423124586, 50.48176905741164], [2.9647097377674005, 50.51277802080956], [2.898951858432468, 50.501557815670935], [2.8259824668620874, 50.52538845143164], [2.8051660601438893, 50.60327122820495], [2.8404494526472543, 50.656566351404415], [2.769040910019394, 50.66367813930791], [2.713850503520111, 50.631292253556424], [2.630516060197486, 50.61795150536654], [2.495948921017839, 50.63124494194659], [2.4077924267844706, 50.67276560280949], [2.3408910264767204, 50.740906325444854], [2.2134304216785434, 50.81054861627207], [2.183904561046441, 50.88345246926367], [2.0976005370808024, 50.99842720037966], [2.0677120276110013, 51.006505154674734]]]}, 'attributes': {'CODE_DEPT': '62', 'NOM_DEPT': 'PAS-DE-CALAIS'}}, 4: {'geometry': {'type': 'Polygon', 'bbox': (774574.399999991, 6905214.700000814, 873032.1999999789, 7008458.800000535), 'coordinates': [[[4.047972977986833, 49.40564229477001], [4.1431697526129865, 49.404187032451034], [4.248308184547379, 49.38225617649833], [4.306756525620348, 49.32779732812255], [4.422583188651027, 49.28064492916811], [4.575868215345435, 49.2966511893251], [4.6251041072703405, 49.23565606344571], [4.686074799511885, 49.256759043814334], [4.826941205469511, 49.23576093817319], [4.894206220282045, 49.2590743389563], [4.950989232683009, 49.236865846314195], [5.051180998120573, 49.27405171211627], [5.02643699972715, 49.33591387471795], [5.1158969719764285, 49.42192447313757], [5.062396105126221, 49.499153471717584], [5.1182787291737935, 49.59307211739976], [5.162975033383015, 49.56353425623241], [5.311756637860765, 49.55928995634333], [5.393536658328508, 49.617087738514805], [5.350332008544782, 49.63085901370024], [5.269179131226729, 49.69607357002533], [5.166194556636604, 49.69291647768698], [5.093503384949335, 49.76373048636149], [5.0631826435981315, 49.76192871160778], [4.873874799688421, 49.82079506109401], [4.854192609787468, 49.86478713530524], [4.883307650501965, 49.89617895096], [4.8501895621955295, 49.946473039075464], [4.790903141595086, 49.95839770924098], [4.8685301585153855, 50.09762527597456], [4.8795515528000335, 50.152029766635124], [4.824292330401957, 50.160731428908065], [4.762161208292364, 50.13639695684066], [4.683190239835277, 50.06492226523267], [4.688865972729299, 49.995498425950466], [4.5930596502126235, 49.985507148105626], [4.510410432978068, 49.94668308725439], [4.446940783287938, 49.937504593983924], [4.3336466349033955, 49.963560807669346], [4.233068423333532, 49.95782375746413], [4.248507144358832, 49.856522649606475], [4.2095885412487295, 49.78178059628209], [4.250088858677235, 49.75710160234474], [4.1270215461885265, 49.67792125135548], [4.099316041330109, 49.62847816384557], [4.031390794494156, 49.61428997231127], [4.076570889635557, 49.57112749861901], [4.040711745102367, 49.50853465721909], [4.047972977986833, 49.40564229477001]]]}, 'attributes': {'CODE_DEPT': '08', 'NOM_DEPT': 'ARDENNES'}}, 5: {'geometry': {'type': 'Polygon', 'bbox': (728997.8999999948, 6759096.300001229, 837934.5999999736, 6845890.600000978), 'coordinates': [[[3.4147915595010963, 48.390273038835076], [3.498152764099384, 48.36909719474052], [3.6168043332338455, 48.27133989892491], [3.6216038851697063, 48.225740470572575], [3.667869602845747, 48.13921190362745], [3.74029124579523, 48.16970783295086], [3.8049683849961107, 48.10254956016535], [3.850029315571996, 47.983792407228414], [3.9020865465480417, 47.93917007405486], [4.1117857473984065, 47.926995657533396], [4.199158053352665, 47.969941402526324], [4.293424106945006, 47.92567623485384], [4.3090036167800365, 47.96117328279331], [4.448998378066956, 47.957154747586976], [4.5599688756782095, 47.97142319627397], [4.582678644289108, 48.02946360188037], [4.704238250439468, 48.02023237622195], [4.688818526238873, 48.073127919265815], [4.730610406781701, 48.11820899819217], [4.8193072949588815, 48.103192423478745], [4.850099917169891, 48.14175885540109], [4.858919933219105, 48.263638491502725], [4.80973775993872, 48.34735980335423], [4.716095686333966, 48.39485512883844], [4.653455248176321, 48.47054866780406], [4.670183207291811, 48.53188730233758], [4.614026636401956, 48.55380713072681], [4.545406992928757, 48.52525227165607], [4.40306312166006, 48.56126039350177], [4.315905486866125, 48.615578923340706], [4.325594012298644, 48.700277029545035], [4.166386793257749, 48.70745423754145], [4.080262439820496, 48.70106898078487], [4.001695483416846, 48.66387541822405], [3.9492266572894197, 48.60343162809795], [3.822742058660398, 48.51610441782203], [3.730879401425958, 48.53746785522521], [3.634028277746641, 48.54129826319994], [3.5556137492385345, 48.62028467658828], [3.5038535314822115, 48.60480913448515], [3.423442380707056, 48.53356269241414], [3.3919598867876517, 48.42432215347003], [3.4147915595010963, 48.390273038835076]]]}, 'attributes': {'CODE_DEPT': '10', 'NOM_DEPT': 'AUBE'}}, 6: {'geometry': {'type': 'Polygon', 'bbox': (992637.5999998839, 6272481.700002606, 1077560.2999998543, 6370071.400002356), 'coordinates': [[[6.88742990090296, 44.3610478380362], [6.796090992510112, 44.31610570751239], [6.7239938850023835, 44.24984330468271], [6.686536427072904, 44.169253930861075], [6.755280297628581, 44.07860658695586], [6.7457139505011225, 44.043235362043276], [6.836004210977611, 43.99060185096192], [6.851891862245591, 43.95479401195963], [6.913088787529998, 43.92796536503895], [6.884610185550847, 43.889120756894144], [6.830709312232405, 43.918363011486576], [6.745556290785884, 43.872108256875045], [6.697323345466608, 43.87365480225305], [6.636395800176684, 43.78895056709553], [6.753535969205428, 43.73816698047843], [6.7608013983957, 43.66648795918865], [6.798740654261998, 43.62818033606136], [6.908012993627823, 43.599079187947034], [6.884230099335205, 43.50253572781932], [6.933726236453416, 43.48006801088512], [6.971832403990881, 43.54544860181745], [7.040446281575285, 43.54158089325744], [7.126469292853879, 43.60527535172142], [7.167667333361662, 43.657403419865986], [7.241890731724425, 43.68848477342185], [7.3202910753685595, 43.69132686392653], [7.52851338181802, 43.790515150532556], [7.49543979690812, 43.864354891259204], [7.559218845189717, 43.89729463231819], [7.567109183508682, 43.94367801378092], [7.6485944611311, 43.97410878308102], [7.66498657284555, 44.03066821354596], [7.716933970025214, 44.081761260593446], [7.670852285754872, 44.15374050304125], [7.505741191835107, 44.14365239533765], [7.426949388266545, 44.112879446091384], [7.28196596662422, 44.14345130550786], [7.188914616489549, 44.19780338462867], [7.071037600740727, 44.23294982802467], [7.008054894297458, 44.236431060527096], [6.9934468208164935, 44.28089142785258], [6.88742990090296, 44.3610478380362]]]}, 'attributes': {'CODE_DEPT': '06', 'NOM_DEPT': 'ALPES-MARITIMES'}}, 7: {'geometry': {'type': 'Polygon', 'bbox': (753778.7999999836, 6460771.900002093, 837457.1999999543, 6575508.300001766), 'coordinates': [[[3.6940178008729885, 45.93073235641245], [3.7543707578917007, 45.88603083611288], [3.6997580221432105, 45.783181674804794], [3.7808499481107716, 45.72434927186403], [3.823453198078696, 45.63241694241687], [3.903596234209209, 45.59902246632493], [3.9543484081584332, 45.55596268333556], [3.9751057509236483, 45.4482695491395], [3.8991877616127324, 45.410307649293486], [3.897408424881887, 45.357083781715666], [3.97965057221058, 45.37513435596753], [4.024824051546119, 45.34288771363736], [4.177926371804464, 45.3926048786864], [4.308199323181691, 45.37098690693714], [4.366534405291163, 45.33699593440981], [4.362548869116956, 45.26439535681795], [4.418571110077435, 45.275424101661145], [4.483134616383878, 45.2364464819279], [4.602422910281466, 45.25170405771366], [4.614497435388505, 45.30983662841346], [4.679512199699748, 45.34611232691197], [4.755996992712002, 45.36567226076606], [4.756935570818616, 45.455707349780305], [4.722336796597094, 45.49429755062873], [4.661741865018663, 45.48675363928725], [4.614858045826018, 45.575468343903765], [4.519766458935654, 45.57325450372865], [4.410284239143385, 45.63205080632742], [4.365516200673114, 45.69851909472677], [4.391252031699621, 45.75493472371277], [4.383032288498641, 45.863993859081276], [4.3239261660748465, 45.900501336627656], [4.293912264205216, 45.95339953385292], [4.3060957589784294, 46.02122907041076], [4.280409632428633, 46.05294444469341], [4.321566636697418, 46.12922273900984], [4.438590902796802, 46.167878829695425], [4.388079599211451, 46.2197885167151], [4.282499756804287, 46.15695001476925], [4.261021127340282, 46.178750806087656], [4.132418427256319, 46.17782633253056], [4.104090700200876, 46.198394922849005], [3.988786873539471, 46.16980977454088], [3.972545422490283, 46.20271202778812], [3.8901323277345163, 46.214490641438694], [3.8995333931893303, 46.27590543921822], [3.804886833081295, 46.254857087118516], [3.789761994058612, 46.154851332057206], [3.8218687105012137, 46.087983889770236], [3.80676406021388, 46.045622930292026], [3.8254431917706766, 45.99596774333176], [3.788909241913359, 45.973858692630216], [3.708883724363123, 45.97378454864049], [3.6940178008729885, 45.93073235641245]]]}, 'attributes': {'CODE_DEPT': '42', 'NOM_DEPT': 'LOIRE'}}, 8: {'geometry': {'type': 'Polygon', 'bbox': (491362.4000000901, 6181124.600002802, 621363.1000000321, 6314318.000002484), 'coordinates': [[[0.6068109749570959, 43.31088599158559], [0.616280054756598, 43.28903679046815], [0.5515684940570379, 43.236102503746885], [0.5518748957180646, 43.209147130092994], [0.4419985587106286, 43.13127313187037], [0.5322696523895433, 43.093864488407355], [0.5630044583601449, 43.01746794817719], [0.6274179241908862, 43.00010287323438], [0.5759351469518764, 42.87082592303985], [0.4773013441230268, 42.87810749616219], [0.45889951642403815, 42.82814521426843], [0.45509422507364955, 42.72806064199966], [0.47774954032737066, 42.69999034279803], [0.6822635276176596, 42.7089682536353], [0.644540504562064, 42.78307646581698], [0.6590147498491514, 42.8385294654611], [0.708377779630982, 42.86140184526942], [0.8583056667230173, 42.825719089084565], [0.8324133769327763, 42.91998800205094], [0.8749113719387422, 42.957775746315384], [0.9791013887263271, 42.974430961914464], [1.0070461604480831, 43.00759100643923], [0.9851687313481595, 43.0670562815733], [1.0388356827344094, 43.100552820032334], [1.0589125480141455, 43.14182620134694], [1.124082084454217, 43.156907404761874], [1.2087344680123453, 43.11795105080999], [1.2274806300813905, 43.183893105810554], [1.3146078107375305, 43.189994724436794], [1.374373433475401, 43.213745765705475], [1.2933102990704721, 43.28533747712766], [1.343651969634677, 43.315606054765574], [1.4253606535844838, 43.256571535866804], [1.4637105789844818, 43.21060079806063], [1.5475200495883703, 43.275674269255795], [1.6372035311274429, 43.255115354491736], [1.6884197209147513, 43.27355372810057], [1.7477325973047735, 43.34374010112299], [1.8134240645221509, 43.34140359698674], [1.8040846789340412, 43.39168480485624], [1.8587429714302222, 43.44382089121744], [1.9101007956285108, 43.40405939980924], [2.0291328387973606, 43.4368979648422], [2.0181412825331915, 43.470350219604434], [1.882609451533412, 43.520928759682526], [1.824800921390716, 43.580831766261205], [1.6877710936117412, 43.63070037401996], [1.7308693816067124, 43.65775037692852], [1.7064455963184257, 43.71621951436262], [1.6604214137506874, 43.741834024882195], [1.6447876270393127, 43.80025749535751], [1.5910292905659658, 43.81548843933609], [1.555463245486847, 43.86831540012963], [1.5556171726831822, 43.91831715512148], [1.4478772809200224, 43.87355299852193], [1.3568133196337087, 43.884191550556004], [1.3608901489958334, 43.82107440669033], [1.2191934244058247, 43.770777524259024], [1.1445976144149483, 43.82229820079692], [0.9539831166064948, 43.78737246570894], [1.0876957388199562, 43.644975031688936], [1.1475492440427306, 43.634175893376046], [1.201337008485553, 43.594812955020245], [1.0181843408377875, 43.47333809239016], [0.9780837577086212, 43.362651706544284], [0.9172511345137198, 43.40633268927779], [0.8205416805525511, 43.41697502257897], [0.7175914463388231, 43.37663081008268], [0.6559378827169787, 43.31720926544656], [0.6068109749570959, 43.31088599158559]]]}, 'attributes': {'CODE_DEPT': '31', 'NOM_DEPT': 'HAUTE-GARONNE'}}, 9: {'geometry': {'type': 'Polygon', 'bbox': (748048.8999999872, 6562706.600001801, 887343.0999999508, 6673494.900001479), 'coordinates': [[[4.388079599211451, 46.2197885167151], [4.405813600867752, 46.29606050757105], [4.503987529872384, 46.26712984788548], [4.618551541036953, 46.264793087551574], [4.693107175516045, 46.30219481477724], [4.730529789085251, 46.17837212771996], [4.780213475718984, 46.17667702271943], [4.810994882268941, 46.259921516975695], [4.8882077017045455, 46.40298160185772], [4.891817622919295, 46.43991436571949], [4.940023082647429, 46.51719845218093], [5.052374107055715, 46.484872844561956], [5.201145108499203, 46.50820950515938], [5.215064143095116, 46.468359273121635], [5.310560613770374, 46.44676642071993], [5.415741925117894, 46.473138659412896], [5.3591908796398755, 46.52256096352789], [5.441107903009741, 46.63754001470951], [5.391088772820641, 46.72869554592405], [5.370244880835241, 46.826171259428975], [5.459286424114921, 46.85524478563496], [5.316959409128447, 46.90405615619236], [5.2632646167758095, 46.93591076096915], [5.255236339191405, 46.97988809464055], [5.106281375832607, 46.955765202475504], [5.049303736126249, 46.98158693341572], [4.728129651701317, 46.91937462593796], [4.623230215613321, 46.940820236785605], [4.493691403385164, 47.02837155710412], [4.406283415170732, 47.049999892555036], [4.405487083945716, 47.08164281958388], [4.259600310936345, 47.114326250580596], [4.209834279044644, 47.15541168354451], [4.181888404407953, 47.15050513981919], [4.115967069915809, 47.12333757652637], [4.06142733788571, 47.12104166410022], [4.038726355028209, 47.08001003428521], [4.072015136934213, 47.054494829385675], [4.039401951235417, 46.98511001230659], [4.037221978317054, 46.918155606841886], [4.093851364443379, 46.874734333229235], [4.056234450174583, 46.8432723767359], [4.062709832615211, 46.78936469128218], [3.9919591863262935, 46.77675109754475], [3.9233937335663804, 46.738872659809324], [3.797329518692337, 46.7015026371452], [3.73619002089105, 46.75247120098582], [3.629423683496518, 46.74945902193758], [3.6379005417614154, 46.707208771712104], [3.6969523102437005, 46.66058216583629], [3.7432867634118914, 46.56756978217597], [3.8017563441985818, 46.51989955458831], [3.834005903932969, 46.53113227681361], [3.8904705648097098, 46.481250929951884], [3.957937642803863, 46.48975562185937], [3.9980416518372484, 46.46546757106017], [3.9772154801510964, 46.39922459383986], [3.9866257932147806, 46.31919378739565], [3.8995333931893303, 46.27590543921822], [3.8901323277345163, 46.214490641438694], [3.972545422490283, 46.20271202778812], [3.988786873539471, 46.16980977454088], [4.104090700200876, 46.198394922849005], [4.132418427256319, 46.17782633253056], [4.261021127340282, 46.178750806087656], [4.282499756804287, 46.15695001476925], [4.388079599211451, 46.2197885167151]]]}, 'attributes': {'CODE_DEPT': '71', 'NOM_DEPT': 'SAONE-ET-LOIRE'}}, 10: {'attributes': {'CODE_DEPT': '53', 'NOM_DEPT': 'MAYENNE'}, 'geometry': {'type': 'Polygon', 'coordinates': [[[-1.0701645143702028, 48.5084938142048], [-1.0827940655347768, 48.43305823169245], [-1.045019529962301, 48.32772783001587], [-1.1000610480389637, 48.259280121227064], [-1.049606089398749, 48.08980493061712], [-1.0232833455698913, 48.068911203167616], [-1.0212610284765595, 47.99494016249541], [-1.1026711686637312, 47.989062782913926], [-1.1539940378788567, 47.96582099565702], [-1.1891839990021345, 47.86797794678786], [-1.2382517343256672, 47.80999146298689], [-1.1426272844041534, 47.774442466941096], [-1.0999157158854127, 47.78196684125323], [-0.9786565126647918, 47.761990588095294], [-0.9520300471637968, 47.796497072213384], [-0.8392941203736599, 47.75227330319133], [-0.741707658432875, 47.73810748628326], [-0.6108182423666888, 47.73568882742977], [-0.4604118623353681, 47.76509086787278], [-0.38170327004272336, 47.76056283995018], [-0.38820058256862766, 47.80531865640709], [-0.44785891788114673, 47.832216379468825], [-0.37067332986759555, 47.88002461791639], [-0.384840280948404, 47.93084465849811], [-0.2826331784456293, 47.95819180740859], [-0.34166482709193685, 48.043095522813545], [-0.23094244360355717, 48.058985357501875], [-0.2171740033885255, 48.106959664577076], [-0.24992127138834194, 48.157106805256824], [-0.1468370673865552, 48.20500891985261], [-0.16309583433799704, 48.25554245624931], [-0.13797809431803368, 48.361355595694256], [-0.05453120471342507, 48.38200345783028], [-0.05189625619319167, 48.453259769855784], [-0.14871347253945771, 48.45806753463183], [-0.16938268000563234, 48.53697035218057], [-0.20693829348513584, 48.5629447591783], [-0.2782279440483006, 48.506988913226], [-0.3676233888648984, 48.49294431514273], [-0.43075405116635984, 48.51181992420755], [-0.5050654278707287, 48.50579601257741], [-0.551717783599479, 48.473117087367115], [-0.6539938321279776, 48.4442821157106], [-0.757281139754533, 48.43655146992741], [-0.8603629154348665, 48.50145849653701], [-0.9563792193607092, 48.51661807961013], [-1.0039987501163443, 48.48917056001381], [-1.0701645143702028, 48.5084938142048]]]}}, 11: {'geometry': {'type': 'Polygon', 'bbox': (434480.3000000837, 6459163.500002107, 540666.4000000486, 6562343.900001808), 'coordinates': [[[-0.10293687953014628, 45.96965998523801], [-0.1316644506664795, 45.911020629982204], [-0.11540038254695609, 45.87066390237831], [-0.15309474428582787, 45.795737000339294], [-0.22174528634311572, 45.77574564408546], [-0.2731191101089057, 45.80655862747699], [-0.41583863552489897, 45.74166865754338], [-0.4089294944559104, 45.656179885078146], [-0.375919653128293, 45.60891920266458], [-0.2967152234141238, 45.56449387379335], [-0.2461560346224069, 45.49164146613398], [-0.2674239730736353, 45.45567770932366], [-0.2497593835924425, 45.40874172938648], [-0.2808959166071477, 45.359870837250334], [-0.22670231706753854, 45.32143289837579], [-0.1087860702850694, 45.288951578180324], [-0.11538526357329242, 45.24807269185139], [-0.04416800947411755, 45.247891172634034], [0.004330746876935129, 45.19163255561608], [0.05343044144838288, 45.22685497556189], [0.1277244971104147, 45.20911196586834], [0.26660921262945225, 45.29774875681216], [0.24932982871876333, 45.363043281591956], [0.30784894042745536, 45.460870365593415], [0.356537146854989, 45.46547909899263], [0.4962604525540854, 45.54448805439057], [0.49964715509464425, 45.617259300459516], [0.6006928771045719, 45.67214440425983], [0.6297424639524403, 45.714569989772734], [0.7148884001268344, 45.76311968057411], [0.7164398059782184, 45.805617938664106], [0.7822321483214062, 45.82108209588085], [0.8629055339639642, 45.919755494447834], [0.9425919960124768, 45.957436078431286], [0.925625498473504, 46.010453963771695], [0.8179096763959531, 46.047878116483744], [0.8234337839606, 46.128581728488335], [0.7469045366399738, 46.13857472178206], [0.6874528960648791, 46.09725460634651], [0.539972847134275, 46.0855581225283], [0.5064169377082234, 46.13195354986705], [0.4026555090199833, 46.062675603922386], [0.27980614406674986, 46.060966262312796], [0.197353505216163, 46.095550041529755], [0.07297225926176307, 46.093895909585044], [0.019272784617025578, 46.05284782935703], [-0.03199529342543973, 46.05592180291532], [-0.04143104082306048, 45.993479981491], [-0.10293687953014628, 45.96965998523801]]]}, 'attributes': {'CODE_DEPT': '16', 'NOM_DEPT': 'CHARENTE'}}, 12: {'geometry': {'type': 'Polygon', 'bbox': (343011.6000000426, 6826524.800001056, 423497.90000004787, 6969661.300000665), 'coordinates': [[[-0.8409353560137907, 48.75222016384713], [-0.9670546190041174, 48.786077720222416], [-1.089472833338895, 48.78151488426321], [-1.1326273918673369, 48.84885164217853], [-1.071180513900955, 48.870285157631265], [-0.9427299538328541, 48.967706984883456], [-0.8690886128916927, 49.06790310100597], [-0.8865942987279143, 49.129434041438124], [-0.9314549410204003, 49.145574313402285], [-0.900872906858209, 49.20297333587008], [-1.0226729579413112, 49.203385416252566], [-1.113423375217576, 49.26132689824705], [-1.1395424010513033, 49.3098708597634], [-1.1196225402660498, 49.35556798985948], [-1.163952010716086, 49.36665848651647], [-1.1825295039826558, 49.42401948473226], [-1.3063594927131794, 49.53892734054786], [-1.3041977944390666, 49.57368192357966], [-1.2295992003173177, 49.624650090584815], [-1.287842477634032, 49.69259317372232], [-1.4211576721789967, 49.70370298114806], [-1.5415745541135997, 49.654110262854196], [-1.6783876038065517, 49.661232646588175], [-1.9422451867330155, 49.72555529335993], [-1.9461788272965428, 49.674348301554], [-1.8603000418191251, 49.65019279205301], [-1.8410273136069877, 49.57173433703609], [-1.8856955118557919, 49.54039147247258], [-1.826772491313197, 49.45291724938543], [-1.8198285811721875, 49.3904836803323], [-1.7111682644583075, 49.32509928439525], [-1.5988432590535941, 49.169205064282544], [-1.6094115242692342, 49.079278117717536], [-1.5607059456223316, 49.00148291033306], [-1.5643431050154524, 48.921584069525686], [-1.5941451540783478, 48.83471201978299], [-1.5744067767391576, 48.751849448395745], [-1.5049438127030457, 48.687403463344886], [-1.3931950000571627, 48.65052438368423], [-1.449162081876617, 48.623418209167006], [-1.5710871213263624, 48.626445743066476], [-1.5189153941473388, 48.566594219597484], [-1.489947435142363, 48.48937484762061], [-1.377245885097968, 48.45828455073839], [-1.272248493564724, 48.533924823069405], [-1.2065557263083735, 48.542205944555754], [-1.0701645143702028, 48.5084938142048], [-1.0039987501163443, 48.48917056001381], [-0.9563792193607092, 48.51661807961013], [-0.8603629154348665, 48.50145849653701], [-0.7741715461672711, 48.56267832834257], [-0.7526143435139788, 48.617618520546905], [-0.7989559815697852, 48.71018883782028], [-0.8409353560137907, 48.75222016384713]]]}, 'attributes': {'CODE_DEPT': '50', 'NOM_DEPT': 'MANCHE'}}, 13: {'geometry': {'type': 'Polygon', 'bbox': (587215.6000000172, 6818024.90000106, 643162.6000000093, 6887345.000000862), 'coordinates': [[[1.5015238197988672, 48.94105360616862], [1.5572502545823872, 48.89157660949543], [1.5912030850964913, 48.81486963941434], [1.5795458299182854, 48.70181187350343], [1.602498423421542, 48.66376910929475], [1.7092527874670105, 48.57802434627667], [1.765329716198042, 48.56937104101408], [1.801445837919035, 48.466087959629114], [1.9221489648373706, 48.45760028607871], [1.9674261909808524, 48.53307136185833], [2.0175740602972905, 48.55759738743778], [2.0200056963818716, 48.64208882253288], [2.0822212746064093, 48.6858518071185], [2.111889242882012, 48.739560198041474], [2.226559327154523, 48.77610203163561], [2.1515778037276108, 48.81702039835412], [2.152869141422736, 48.87333985215582], [2.200591009269504, 48.908679329904004], [2.20585834678071, 48.949740742229906], [2.084914920835883, 49.014678714923626], [2.0247730444607908, 48.998755806202006], [1.9378021652564332, 49.02177632638558], [1.823950363006381, 49.07636122205329], [1.7234571618642336, 49.044976575520174], [1.673689127007117, 49.07815117319748], [1.608796070629922, 49.07789415355113], [1.5217661561843232, 49.06854572685726], [1.4577625828068002, 49.02629104623368], [1.5015238197988672, 48.94105360616862]]]}, 'attributes': {'CODE_DEPT': '78', 'NOM_DEPT': 'YVELINES'}}, 14: {'geometry': {'type': 'Polygon', 'bbox': (904021.0999999507, 6611179.900001672, 1006570.4999999271, 6724946.800001346), 'coordinates': [[[6.806992048333124, 47.56280181879932], [6.780972040773945, 47.536415287244694], [6.685554362876692, 47.562955627817985], [6.646719240296148, 47.53526063807287], [6.581776153124798, 47.53987013332599], [6.553562523020688, 47.49279726216728], [6.401377017027884, 47.520299753462304], [6.3343537374171, 47.50596607054921], [6.26232858266319, 47.43056987327868], [6.080045800270595, 47.3540364749941], [5.989355047833263, 47.327623386354006], [5.941374552825448, 47.34425359386968], [5.698725742766405, 47.26499677497711], [5.720409103677725, 47.21993674300861], [5.811467446057153, 47.169053816064604], [5.816084496368168, 47.134339348805725], [5.768548742190094, 47.08943503996258], [5.815050562004315, 47.020339093417896], [5.968560305501437, 46.98044449059878], [5.9640723607092, 46.94807945340025], [6.005778412779798, 46.87305283721094], [6.151793978046817, 46.8206673698074], [6.203329933961531, 46.77268138485174], [6.180271003478624, 46.741575238392684], [6.069828479910839, 46.68952488534495], [6.103767023618833, 46.64981840997855], [6.048566902902154, 46.607722856127914], [6.138108547029271, 46.557660399034106], [6.110748015678899, 46.57631320344649], [6.285329368806656, 46.691241021954795], [6.4381074734988255, 46.76174754330362], [6.431004694945304, 46.812411693948846], [6.464570889525094, 46.89020983338602], [6.43266944042617, 46.92860208537256], [6.518800213651558, 46.97085825240524], [6.640345422140114, 47.002757402096954], [6.714049325938046, 47.04912442357017], [6.73990764041836, 47.10805653932851], [6.858349567867173, 47.16438347703844], [6.882433031143577, 47.20161558472108], [6.954974253198658, 47.242940903153446], [6.993126569921013, 47.29554511881353], [7.062193873000224, 47.344157922732585], [7.016179011339007, 47.37183616717559], [6.917301026972028, 47.3561773266483], [6.940536510867673, 47.43337372142234], [6.907609859823659, 47.49454608019354], [6.905669627634238, 47.54736152102865], [6.806992048333124, 47.56280181879932]]]}, 'attributes': {'CODE_DEPT': '25', 'NOM_DEPT': 'DOUBS'}}, 15: {'geometry': {'type': 'Polygon', 'bbox': (838676.7999999775, 6816262.700001069, 906432.9999999686, 6949056.900000696), 'coordinates': [[[5.765154701602298, 48.49649260852762], [5.776211888772464, 48.540359251581435], [5.716089821783749, 48.561424169831746], [5.7617670452603855, 48.60939047861274], [5.757709339561898, 48.6956983342433], [5.71403634947959, 48.74453330887042], [5.780971762726474, 48.826749431299106], [5.747161790828688, 48.915257872650564], [5.800245290300756, 48.946746057604365], [5.823066740236894, 49.023106618165144], [5.818638375145696, 49.08617366651453], [5.76336075838886, 49.1078799656107], [5.7444679167795965, 49.15659587124916], [5.765544232834611, 49.19808862805665], [5.719044394768754, 49.215986946434604], [5.7317860065833734, 49.31134319109833], [5.688147604064061, 49.41510555458638], [5.634565984546506, 49.43743606552824], [5.529099312496952, 49.40737462727894], [5.461779526865532, 49.45269148820623], [5.47091013059277, 49.497205021307316], [5.426918930815695, 49.59734749374859], [5.393536658328508, 49.617087738514805], [5.311756637860765, 49.55928995634333], [5.162975033383015, 49.56353425623241], [5.1182787291737935, 49.59307211739976], [5.062396105126221, 49.499153471717584], [5.1158969719764285, 49.42192447313757], [5.02643699972715, 49.33591387471795], [5.051180998120573, 49.27405171211627], [4.950989232683009, 49.236865846314195], [4.9397619983736725, 49.185068204591545], [4.992117611940037, 49.11490008828468], [5.007681402681856, 49.034951950784894], [5.036321445219877, 49.02433254955411], [5.030128675561755, 48.95690245548527], [4.9362093920054075, 48.92214239513739], [4.888760929797641, 48.81720971455143], [4.990124563499123, 48.74183736488204], [4.988427677798424, 48.684418562247224], [5.005925627052494, 48.63403550117788], [5.070888258264775, 48.59572522100363], [5.118346103266605, 48.595510860548025], [5.208425883036941, 48.53861075459186], [5.349469998299744, 48.48198867903505], [5.4700481951761715, 48.42092912175581], [5.615963788740979, 48.43974531397395], [5.765154701602298, 48.49649260852762]]]}, 'attributes': {'CODE_DEPT': '55', 'NOM_DEPT': 'MEUSE'}}, 16: {'geometry': {'type': 'Polygon', 'bbox': (361697.30000012426, 6349285.200002406, 486169.1000000766, 6505244.800001987), 'coordinates': [[[0.2973255098237864, 44.76228467395244], [0.24175347207714265, 44.85689385892581], [0.17043367429958511, 44.82668350830176], [0.08302335597727074, 44.83122106182406], [-0.01544784730246714, 44.85771651694373], [0.03436214413600705, 44.91546925454329], [0.007378970051310477, 44.947298811504815], [0.07329671773303767, 45.07012096510989], [0.046060081710580396, 45.11322788942688], [-0.04020033978963981, 45.10238433596349], [-0.0877028308704419, 45.12138883628677], [-0.15295329411286374, 45.088807215890796], [-0.25508698029919, 45.114085277381534], [-0.34233753875966594, 45.167558376604845], [-0.3940718179854251, 45.16477966588993], [-0.4291954727294859, 45.279473994648164], [-0.5595072006432491, 45.29770833934146], [-0.5944806728104978, 45.321142824588456], [-0.7526821734869668, 45.321769940978704], [-0.7740181405098181, 45.36920881364397], [-0.8410572249719399, 45.435083368260905], [-1.0257418763479111, 45.57469303281359], [-1.0911993078778197, 45.562409624997784], [-1.157040252187611, 45.47037006217623], [-1.1623411294779706, 45.297866853837064], [-1.2229024029196511, 44.86482614411409], [-1.222955997695758, 44.70957693396094], [-1.160522506721864, 44.774663536811275], [-1.0363572283194804, 44.693563588536506], [-1.0053645293063393, 44.64804090229057], [-1.0807942554045624, 44.64060270635644], [-1.1915395677551643, 44.66072655577181], [-1.227400657614333, 44.57575101363349], [-1.2602820243561468, 44.53950655090701], [-1.2538901028077136, 44.467604212346195], [-1.1064909647292611, 44.50277289133715], [-1.0851664955491238, 44.532194571677685], [-0.9806969914576474, 44.482878935537535], [-1.0074534242441229, 44.4376523913387], [-0.9191704541834166, 44.443344362596065], [-0.8452736279017048, 44.418974549624686], [-0.7307029568976166, 44.446374662072614], [-0.6287774027434521, 44.443192240874644], [-0.6276476111842922, 44.398145662533665], [-0.528103107297291, 44.36465404326292], [-0.5176354697700609, 44.33911112646842], [-0.43183954131517804, 44.32257705443095], [-0.38338729038705477, 44.28631066773667], [-0.38961736206091657, 44.20948462715681], [-0.27211852903661043, 44.19380924623565], [-0.22344709828329368, 44.2058982638019], [-0.19411335198198013, 44.26904045949542], [-0.1406884798527575, 44.22640474768996], [-0.06662475964814253, 44.24675799222613], [-0.034811250980738076, 44.296725798024674], [-0.08575207965012982, 44.337610049886734], [0.018233646559888655, 44.389878791845156], [-0.010552396185254522, 44.41854340374255], [-0.01545369989301612, 44.505062787136126], [0.04056782018280711, 44.553046617799], [0.153607862533407, 44.61612295595815], [0.1826776591534788, 44.661072124007056], [0.13372640074632103, 44.6824441037855], [0.15300384600842049, 44.73048103978566], [0.2973255098237864, 44.76228467395244]]]}, 'attributes': {'CODE_DEPT': '33', 'NOM_DEPT': 'GIRONDE'}}, 17: {'geometry': {'type': 'Polygon', 'bbox': (396867.2000000489, 6857101.400000965, 512505.0000000287, 6928957.800000754), 'coordinates': [[[0.2972244202906157, 49.429861637295424], [0.21994001130961982, 49.42676180480031], [0.11038005889157869, 49.39426193748103], [-0.013368582587023795, 49.32120348155407], [-0.09959949005983877, 49.29760052806226], [-0.22569330389903036, 49.28181693022947], [-0.4148485981637226, 49.33558104325528], [-0.5153140242090203, 49.345016169896276], [-0.7222488013847791, 49.34700416595227], [-0.85116563037548, 49.362544751776724], [-0.9393846923333822, 49.3950422085724], [-1.0782173743324166, 49.388493505424975], [-1.1196225402660498, 49.35556798985948], [-1.1395424010513033, 49.3098708597634], [-1.113423375217576, 49.26132689824705], [-1.0226729579413112, 49.203385416252566], [-0.900872906858209, 49.20297333587008], [-0.9314549410204003, 49.145574313402285], [-0.8865942987279143, 49.129434041438124], [-0.8690886128916927, 49.06790310100597], [-0.9427299538328541, 48.967706984883456], [-1.071180513900955, 48.870285157631265], [-1.1326273918673369, 48.84885164217853], [-1.089472833338895, 48.78151488426321], [-0.9670546190041174, 48.786077720222416], [-0.8409353560137907, 48.75222016384713], [-0.71467861188995, 48.79986774273136], [-0.4637527288822014, 48.87136647589269], [-0.41151869249428263, 48.87014004742435], [-0.3462445710154035, 48.82199914076007], [-0.3059210867390902, 48.85830715301278], [-0.14634308820607453, 48.83444909950848], [-0.058807463588442944, 48.85358688784485], [0.05639799250069023, 48.90246403867087], [0.12760760912750327, 48.9522190708013], [0.15647487005382918, 48.92478758357601], [0.2756400197144905, 48.96474519881211], [0.3337726147565286, 48.942883562795664], [0.41281453288908837, 48.95062636770782], [0.4367513532066128, 49.008190235697356], [0.37767980975475246, 49.04945033021295], [0.4248747928572133, 49.130194368109024], [0.3946880087410215, 49.1501174749373], [0.38278674411941915, 49.264016474825524], [0.3230231728621308, 49.29699256483409], [0.2972244202906157, 49.429861637295424]]]}, 'attributes': {'CODE_DEPT': '14', 'NOM_DEPT': 'CALVADOS'}}, 18: {'geometry': {'type': 'Polygon', 'bbox': (878315.099999967, 6752777.700001265, 1011125.3999999412, 6831653.50000104), 'coordinates': [[[5.884726375202077, 47.926047148585354], [5.947521018814729, 47.979710391362566], [6.0022620475735735, 47.95608969904078], [6.072563808399438, 48.015666213333816], [6.15605787526197, 48.00694405924032], [6.167984818891343, 47.95235039238136], [6.237987058178877, 47.93284210199929], [6.366146412024702, 47.96194479078652], [6.431707255957784, 47.94381595263883], [6.478601854176571, 47.88552177370396], [6.542152823586114, 47.902610565311726], [6.601781921638083, 47.944398619135384], [6.645533181556613, 47.90402110648561], [6.784821909572191, 47.84962275518452], [6.823538854548164, 47.81305372460474], [6.846179818400713, 47.822945197015315], [6.920034363859817, 47.850287916338964], [6.9002133351392665, 47.89119137272693], [6.943356419805964, 47.99795794687724], [7.0018837438588974, 48.022399095831126], [7.058912798901163, 48.137266371556045], [7.133555808547297, 48.2459405500217], [7.1982815370299456, 48.310467861035285], [7.1219084409759965, 48.33329037922002], [7.097427065168082, 48.40564467454505], [7.1231653690285635, 48.51359226557106], [6.982986004562884, 48.47905957980011], [6.890810652427115, 48.41809431515708], [6.815166528707746, 48.398846200580046], [6.699498339648206, 48.413087540770555], [6.584971476704243, 48.460509163634704], [6.566974228865648, 48.41903184703233], [6.178419125638963, 48.39759887801264], [6.1167237857285315, 48.35403844101338], [5.961559100039155, 48.34989070448248], [5.856069666360069, 48.506844385600004], [5.765154701602298, 48.49649260852762], [5.615963788740979, 48.43974531397395], [5.4700481951761715, 48.42092912175581], [5.408721169498743, 48.383100190451266], [5.482149185087855, 48.35620132428276], [5.640901189478501, 48.24235420494444], [5.7108437679155655, 48.21992832819694], [5.6843187075882495, 48.14504209498634], [5.630534001339328, 48.0839862152433], [5.696798789098752, 48.077229566418524], [5.777747898583658, 48.0313619232788], [5.787280985479234, 47.95259697311846], [5.850003923490581, 47.96283504724517], [5.884726375202077, 47.926047148585354]]]}, 'attributes': {'CODE_DEPT': '88', 'NOM_DEPT': 'VOSGES'}}, 19: {'geometry': {'type': 'Polygon', 'bbox': (607114.3000000231, 6591411.800001717, 706033.1999999984, 6725640.400001325), 'coordinates': [[[2.2392136309887465, 47.620978307879966], [2.1279686465889998, 47.584697964594135], [2.195636277413897, 47.54857375641661], [2.238219079131483, 47.47234293194599], [2.1016927309861235, 47.386782556882636], [2.1389909561599825, 47.2854862202643], [1.9970384773235634, 47.265439340276224], [1.940816059215001, 47.290130782877135], [1.9040800791132246, 47.21565536643795], [1.8390792420529527, 47.21930815773429], [1.8421086266284747, 47.178029354432915], [1.77458130936527, 47.130846812692184], [1.8827218498344331, 47.10194954564286], [1.96641397939093, 47.12541751372794], [2.0483748812476152, 47.10601550210716], [2.0514877607984485, 47.04001604864955], [2.0933838995940373, 47.01573583573], [2.070698616355421, 46.93399643786311], [2.1262038890477335, 46.87986509549622], [2.048810332345124, 46.829448268143665], [2.1153606164888155, 46.77435860147472], [2.065751312591214, 46.742494802064954], [2.1407244355816926, 46.695553715403406], [2.1856288615493806, 46.60286242584111], [2.158700190947214, 46.55734628168224], [2.2043972607989812, 46.48439997524811], [2.151671606709124, 46.45796019235819], [2.1677857181383846, 46.42406650081814], [2.2810476101300576, 46.420405373181076], [2.2857578150118907, 46.4535191502933], [2.352003555650292, 46.51221134727485], [2.482928804775826, 46.5326974446441], [2.5366520207790546, 46.51969984591665], [2.614955459722656, 46.55328003970232], [2.5966478252098466, 46.63721956981655], [2.7049751251942706, 46.73938730526566], [2.774488053228389, 46.71890739681208], [2.827616388160227, 46.73528787880113], [2.9599146908207157, 46.80387657677336], [3.0320681893946824, 46.79491118852599], [3.0680947893123323, 46.877676731330396], [3.0502941730720203, 46.91063036589826], [3.0793297925031697, 46.95511875370015], [3.0757376737966906, 47.01914457943626], [3.0232152406674615, 47.0626168735247], [3.0280852399597813, 47.12906768514305], [2.9816846477683376, 47.22199695725166], [2.9834041014118906, 47.25976318039044], [2.8734906167112504, 47.348395958835304], [2.928902314704163, 47.4445667358034], [2.8746252064056805, 47.5204231125567], [2.8064837781833747, 47.494459329036964], [2.7680263231364868, 47.52352727566695], [2.7193534234556664, 47.49216663238495], [2.658459112358834, 47.48789924167962], [2.5998924219801753, 47.55368570340882], [2.4913582937968672, 47.56829543765222], [2.437347231323109, 47.6097781148652], [2.3730210260695963, 47.58552457239426], [2.2862379812937745, 47.62896236890434], [2.2392136309887465, 47.620978307879966]]]}, 'attributes': {'CODE_DEPT': '18', 'NOM_DEPT': 'CHER'}}, 20: {'geometry': {'type': 'Polygon', 'bbox': (768276.2999999755, 6352552.800002385, 848816.399999948, 6475559.3000020515), 'coordinates': [[[3.998162987763964, 44.45979755586332], [4.068441217053273, 44.405113572942064], [4.051451662788466, 44.317323657117086], [4.142867700090412, 44.313350855400145], [4.25884619798255, 44.264785576428054], [4.288416558058853, 44.31465868784345], [4.336073225463423, 44.339522743700364], [4.5035362130646455, 44.340188451230844], [4.55869985714841, 44.302444632604974], [4.649223666100485, 44.27035986501103], [4.6506150134375535, 44.329805791511355], [4.667367377491741, 44.43066448441984], [4.698652294124969, 44.45230946012685], [4.693639580520507, 44.54223067415186], [4.710266499941698, 44.581549114708444], [4.779060115885165, 44.65469880413619], [4.76621554467615, 44.77862679935865], [4.822513080923934, 44.81708784467803], [4.886589299843448, 44.936651630533625], [4.837672652853049, 45.00479181394793], [4.812473966213053, 45.164481831518785], [4.800493926884063, 45.29836066114302], [4.755996992712002, 45.36567226076606], [4.679512199699748, 45.34611232691197], [4.614497435388505, 45.30983662841346], [4.602422910281466, 45.25170405771366], [4.483134616383878, 45.2364464819279], [4.4432627898030574, 45.140832955911634], [4.376558944791765, 45.14435959050196], [4.375306064703462, 45.10483231156172], [4.289827924670836, 44.99730682920303], [4.221702631142119, 44.96133612938681], [4.156154791813548, 44.87333360834139], [4.039638866980703, 44.87316201331418], [4.0283748583288785, 44.834081003006226], [3.937001123548729, 44.79541721729978], [3.862527190139651, 44.74386343467101], [3.9051719910706293, 44.59270804776968], [3.9451489956301886, 44.57379092180423], [3.998162987763964, 44.45979755586332]]]}, 'attributes': {'CODE_DEPT': '07', 'NOM_DEPT': 'ARDECHE'}}, 21: {'geometry': {'type': 'Polygon', 'coordinates': [[[4.047972977986833, 49.40564229477001], [4.040711745102367, 49.50853465721909], [4.076570889635557, 49.57112749861901], [4.031390794494156, 49.61428997231127], [4.099316041330109, 49.62847816384557], [4.1270215461885265, 49.67792125135548], [4.250088858677235, 49.75710160234474], [4.2095885412487295, 49.78178059628209], [4.248507144358832, 49.856522649606475], [4.233068423333532, 49.95782375746413], [4.140895251736091, 49.97875959900575], [4.087128504749609, 49.969187585423256], [3.9803763118726985, 49.995376086949776], [3.923501465982154, 50.02643067661838], [3.7463798889650577, 50.05360423498406], [3.715184685025503, 50.06927463597468], [3.6136399192005855, 50.025418579188496], [3.54484649487849, 50.053793955280256], [3.4913598357111555, 50.01885605080664], [3.352982036655549, 50.03585934468007], [3.2801740988851327, 50.01518255081814], [3.2305405050170397, 50.03130959187674], [3.1727072271768164, 50.011994944690635], [3.1926752854802194, 49.9774646962746], [3.117968662907868, 49.91427637799499], [3.078694114076548, 49.82241521579585], [3.1184031553047866, 49.70596856016259], [3.0977762246810094, 49.656683091243586], [3.1314803354793224, 49.543377651804036], [3.0957783548212805, 49.51340305902506], [3.1605832452848968, 49.45158976267774], [3.0937834703774705, 49.43374686814669], [3.0953874973379834, 49.37711907479379], [2.97439031593416, 49.30233884823801], [3.0268878942941857, 49.27553205720364], [3.0640875194145396, 49.192738575710244], [3.1396578896700365, 49.152576953647774], [3.071884293834167, 49.11755421882924], [3.16523032905892, 49.099650858000736], [3.171683982224406, 49.01412318431705], [3.3047494707754015, 48.948764278958], [3.3302994547269797, 48.908706088655926], [3.4032194510047127, 48.86468651933575], [3.4851874436586847, 48.85190849438655], [3.5285764431169526, 48.912141028966566], [3.6015984944904185, 48.944072041330806], [3.646307433571441, 49.04058839071644], [3.600004656260228, 49.12069184513826], [3.622246623748465, 49.15110369338968], [3.704392046963459, 49.181373023481946], [3.6469532050746403, 49.31515350352492], [3.8474771401321166, 49.364586629449846], [3.9244337055179415, 49.406181771301206], [4.035496373111564, 49.359904159442664], [4.047972977986833, 49.40564229477001]]]}, 'attributes': {'CODE_DEPT': '02', 'NOM_DEPT': 'AISNE'}}, 22: {'geometry': {'type': 'Polygon', 'bbox': (314107.40000015876, 6194685.200002778, 457776.50000009924, 6283529.400002572), 'coordinates': [[[-1.5248665484221002, 43.529701346690175], [-1.5973846756448367, 43.43749281443983], [-1.6391097857903005, 43.40836090393245], [-1.7620275386554012, 43.375891589094934], [-1.7297463174854615, 43.29567717164454], [-1.6657616159233777, 43.3140776879948], [-1.6089349856953186, 43.25212549943685], [-1.5647156489015603, 43.28791168353558], [-1.5053245319871684, 43.29278486875212], [-1.3827862891090412, 43.253294314283245], [-1.383829083654522, 43.19081965347411], [-1.4139466293353427, 43.12917821198426], [-1.471735353863028, 43.08109307328772], [-1.4351852539528474, 43.04503271460899], [-1.3547480564678596, 43.02846729741793], [-1.343293307886626, 43.09537933451577], [-1.2642856059829313, 43.04456744579195], [-1.2311433515565389, 43.05449581378497], [-1.0064443208237903, 42.98899399788984], [-0.9464504061324416, 42.954061274088964], [-0.8100187374291915, 42.951433076654574], [-0.7516391053014931, 42.96693889977157], [-0.729761530231332, 42.89655917866081], [-0.5438135992737796, 42.793161075971256], [-0.509645724461578, 42.82539255578599], [-0.4397499421861347, 42.796462278453106], [-0.3925972910093655, 42.799558533888266], [-0.3134428634980887, 42.849375059707675], [-0.32708213440188894, 42.91578162376447], [-0.2815909254844988, 42.93356279018245], [-0.291551876667032, 42.98776781593251], [-0.22395152380116093, 43.033687539644006], [-0.19098404402245037, 43.111200014851946], [-0.14613235140227143, 43.12823595997721], [-0.11770146168361151, 43.180326663081985], [-0.01700753125072415, 43.270453175935074], [-0.046122416801734574, 43.300855792904095], [0.009598314167785659, 43.42210994370394], [-0.0690310020330968, 43.4373492706762], [-0.04013178615003942, 43.51260540210091], [-0.0967829732087741, 43.58240589763179], [-0.17641328064610662, 43.59640400157074], [-0.24283655874306653, 43.584976209013746], [-0.30369046804673383, 43.56027685025606], [-0.40604194753689593, 43.56822563862113], [-0.4482922578476383, 43.59608922647162], [-0.5571744316529481, 43.542797175106294], [-0.670807186170969, 43.5667169721835], [-0.7153911507395094, 43.54111406021413], [-0.7817805196343679, 43.56416715906691], [-0.8966906468904682, 43.55048921576576], [-0.9933935609538049, 43.50538804684222], [-1.109247829938908, 43.51412989565146], [-1.1708199655376668, 43.54560988391769], [-1.2911822396099, 43.49820457476763], [-1.4177740978933993, 43.49776692584465], [-1.4766198669954693, 43.53918405640505], [-1.5248665484221002, 43.529701346690175]]]}, 'attributes': {'CODE_DEPT': '64', 'NOM_DEPT': 'PYRENEES-ATLANTIQUES'}}, 23: {'geometry': {'type': 'Polygon', 'bbox': (518605.20000003977, 6677557.600001468, 642856.0000000128, 6782681.400001166), 'coordinates': [[[2.2392136309887465, 47.620978307879966], [2.2025585077490706, 47.67814460516372], [1.9424229848119665, 47.67563077912316], [1.8436947697611497, 47.686353216011], [1.7985957016041196, 47.63843148089742], [1.7399382527750797, 47.66153396919209], [1.697352800232305, 47.73839348418297], [1.5478779921036054, 47.76976159023594], [1.5337009096463898, 47.82052592916732], [1.588137738369647, 47.87642659620688], [1.5254235639039055, 47.929113580216004], [1.5201238283340495, 47.98227847700274], [1.3086281518302285, 47.953853799784625], [1.2096430686639745, 47.96850051669979], [1.1212335165894016, 48.039115919496666], [1.1122333320073277, 48.08072912595507], [1.0085477409246673, 48.08312677901138], [0.997330007937029, 48.12749350968228], [0.8412172317044133, 48.10306240933596], [0.7974846748199693, 48.037554414552474], [0.8458005593594112, 47.941401463859776], [0.7598746908928189, 47.89822684022159], [0.7745788175007332, 47.839687295150405], [0.7126298064021267, 47.79003621973886], [0.5805178732790726, 47.71232800972914], [0.6144311990931562, 47.69421364606964], [0.7353105618986358, 47.695401801856676], [0.8595037193186882, 47.669207269910096], [0.9190111731399371, 47.63260906010327], [1.0333525357335176, 47.60701157047619], [1.0763363652479017, 47.56322155433425], [1.0452908534068053, 47.53148801134605], [1.1323641891067446, 47.446466657485615], [1.107483394852318, 47.41132542515624], [1.1228353402815723, 47.3540166709069], [1.108127082601409, 47.298398043931414], [1.1620645187006389, 47.27219609172917], [1.2235368646048153, 47.29408083062269], [1.2769082168277979, 47.25470690394851], [1.3266655450453901, 47.18622542473183], [1.4484622479605176, 47.23796792122444], [1.5924281213159726, 47.27667661630462], [1.7058305011298702, 47.26587806829796], [1.8390792420529527, 47.21930815773429], [1.9040800791132246, 47.21565536643795], [1.940816059215001, 47.290130782877135], [1.9970384773235634, 47.265439340276224], [2.1389909561599825, 47.2854862202643], [2.1016927309861235, 47.386782556882636], [2.238219079131483, 47.47234293194599], [2.195636277413897, 47.54857375641661], [2.1279686465889998, 47.584697964594135], [2.2392136309887465, 47.620978307879966]]]}, 'attributes': {'CODE_DEPT': '41', 'NOM_DEPT': 'LOIR-ET-CHER'}}, 24: {'geometry': {'type': 'Polygon', 'bbox': (909643.199999973, 6833381.500001036, 1038623.699999949, 6939384.60000073), 'coordinates': [[[7.0793597709732445, 48.536417612714544], [7.167909935894841, 48.52759644356372], [7.256281654444216, 48.58867550766629], [7.283044927480475, 48.63810720118507], [7.242487615031405, 48.69154313192023], [7.311900506296782, 48.76730084432443], [7.149408408912649, 48.84470403838557], [7.126799106595454, 48.80114235821405], [7.054514540544792, 48.81370438623761], [7.045342890531057, 48.87154914038007], [6.964601688658045, 48.90452526766878], [6.989216409797389, 48.95992878869148], [7.054911912536332, 49.03061918772984], [7.107657105402385, 49.04411352332804], [7.17424027072314, 49.00636568135154], [7.29304884880289, 48.9734164509209], [7.326851980608823, 48.943372742034434], [7.446887904100118, 48.96577914856757], [7.538259039250205, 48.93296158495443], [7.578392137539887, 48.95740241812128], [7.635285449703197, 49.05416135519033], [7.53900482020311, 49.09206519191522], [7.439951314813092, 49.18079327996591], [7.365078240855516, 49.17183619633042], [7.298652796709715, 49.11745711802521], [7.247787410384872, 49.127981558041625], [7.06609408447456, 49.114583919911865], [7.0107044484055985, 49.18812137478714], [6.935411827637277, 49.222156387097606], [6.835378369933186, 49.2113238524707], [6.834537718950125, 49.15146671248141], [6.738512367681463, 49.163661139139315], [6.688137831919716, 49.224445572838164], [6.669191900827953, 49.28060494671162], [6.565838515282849, 49.347350170371804], [6.587074296882194, 49.384935828832845], [6.55223458161226, 49.42334910854837], [6.430122344093009, 49.476398147346536], [6.3919627145854445, 49.4644647328811], [6.296571041016303, 49.48010694492541], [6.2564130269948715, 49.51002255848146], [6.15688690583847, 49.50438979858011], [6.123493803074783, 49.4737561743855], [5.988987531307046, 49.45333363562849], [5.97176953371951, 49.49131664377085], [5.893401083719672, 49.49690975012321], [5.942619950432161, 49.45289553697136], [5.928530586493156, 49.37550729351067], [6.029385386695151, 49.23047199222701], [5.987627297222746, 49.20961691714645], [6.026149940244402, 49.16511893600301], [5.931603285178867, 49.10910433833667], [5.935399690626693, 49.071852219751314], [6.0449969560102, 49.01041872050658], [6.043435324319258, 48.977477915984394], [6.116898532084445, 48.96783320585781], [6.132207146051101, 48.93472094775403], [6.2719777673374155, 48.93313559709069], [6.338947107825572, 48.834058199842104], [6.355030133568448, 48.78165892452694], [6.554148775117041, 48.75409250997109], [6.5989655709524815, 48.715690797796334], [6.658407329856349, 48.708047286296704], [6.692283881384656, 48.67284039539553], [6.754672851450039, 48.66938665044198], [6.844053536871701, 48.62597500457003], [6.982882241286177, 48.61186293046636], [7.0793597709732445, 48.536417612714544]]]}, 'attributes': {'CODE_DEPT': '57', 'NOM_DEPT': 'MOSELLE'}}, 25: {'geometry': {'type': 'Polygon', 'bbox': (464624.4000000593, 6554736.200001831, 562772.8000000388, 6677880.4000014765), 'coordinates': [[[0.197353505216163, 46.095550041529755], [0.27980614406674986, 46.060966262312796], [0.4026555090199833, 46.062675603922386], [0.5064169377082234, 46.13195354986705], [0.539972847134275, 46.0855581225283], [0.6874528960648791, 46.09725460634651], [0.7469045366399738, 46.13857472178206], [0.8234337839606, 46.128581728488335], [0.7963255053030069, 46.21096277430393], [0.9072715939898943, 46.285257481169175], [1.0058867393780466, 46.28097399864584], [1.0269954429337316, 46.34303442800402], [1.1297576486963086, 46.36046628124314], [1.1772799568053671, 46.38395162215298], [1.2126902380833458, 46.43222161336166], [1.151604534776636, 46.44923617581203], [1.1459353661062854, 46.50640188056713], [1.0147644249831804, 46.567763998822045], [0.9420237588365904, 46.58079210842132], [0.8943018154002155, 46.62573665182292], [0.9247556936578996, 46.692793352316095], [0.8674688807081565, 46.74821910504852], [0.811901784063939, 46.7945079647172], [0.790328495561799, 46.852391083185985], [0.7043243920507868, 46.90329335315587], [0.692569282364634, 46.974307063017875], [0.5669489614197064, 47.002270374441686], [0.5983482495759445, 46.95676414686087], [0.5061414593305561, 46.959247361736196], [0.43870966025366004, 46.92958207105911], [0.3007362572498841, 46.97382765864786], [0.29823142261819774, 47.05391872520874], [0.17422061595767963, 47.07127519606648], [0.1361309026819461, 47.121580554147556], [0.07637120084195272, 47.12393194888828], [0.05382761471070627, 47.16373008265531], [-0.010736625571349077, 47.15750952036687], [-0.04416541443323664, 47.09324258439813], [-0.10212095637964697, 47.06479719081804], [-0.08769647758766945, 47.02313333571297], [-0.009032410299881494, 46.9074770060593], [-0.0203163360693799, 46.81265392500657], [0.0007042720140899882, 46.71623331657771], [-0.040426190194720726, 46.6637170238073], [0.0259896380281596, 46.59474350677765], [-0.031351255287516346, 46.524981019415726], [-0.017092824348942017, 46.41132239451375], [0.034219979012944976, 46.37349679947998], [0.03760223980806839, 46.32552885451106], [0.07821800902702712, 46.30493353892288], [0.1375978499402633, 46.34939518270104], [0.177368795982455, 46.328113140597], [0.12883677213786587, 46.26723154899875], [0.11283682536372723, 46.21093260957406], [0.1551113740904502, 46.15716824459698], [0.21492180826491522, 46.13884556432997], [0.197353505216163, 46.095550041529755]]]}, 'attributes': {'CODE_DEPT': '86', 'NOM_DEPT': 'VIENNE'}}, 26: {'geometry': {'type': 'Polygon', 'bbox': (460931.20000008226, 6388334.100002295, 577773.9000000425, 6515544.000001942), 'coordinates': [[[0.6297424639524403, 45.714569989772734], [0.6006928771045719, 45.67214440425983], [0.49964715509464425, 45.617259300459516], [0.4962604525540854, 45.54448805439057], [0.356537146854989, 45.46547909899263], [0.30784894042745536, 45.460870365593415], [0.24932982871876333, 45.363043281591956], [0.26660921262945225, 45.29774875681216], [0.1277244971104147, 45.20911196586834], [0.05343044144838288, 45.22685497556189], [0.004330746876935129, 45.19163255561608], [-0.04020033978963981, 45.10238433596349], [0.046060081710580396, 45.11322788942688], [0.07329671773303767, 45.07012096510989], [0.007378970051310477, 44.947298811504815], [0.03436214413600705, 44.91546925454329], [-0.01544784730246714, 44.85771651694373], [0.08302335597727074, 44.83122106182406], [0.17043367429958511, 44.82668350830176], [0.24175347207714265, 44.85689385892581], [0.2973255098237864, 44.76228467395244], [0.3354490861907097, 44.73743575883081], [0.36557538473802126, 44.662211036636265], [0.41470651574900597, 44.646337117152974], [0.6304884773468272, 44.70652766853696], [0.657434416631217, 44.67784707846922], [0.827000964251777, 44.6918895790769], [0.8170042739845027, 44.62700147643919], [0.8699961633462002, 44.59730727091498], [0.9791284687246188, 44.6436104555417], [1.0751408247250984, 44.57732478356566], [1.1537937079861713, 44.63940626971528], [1.1466718447537783, 44.67034606645634], [1.2245500554542503, 44.68426634892967], [1.287782139460227, 44.714781096530565], [1.364102971342699, 44.811568186415315], [1.3614038259537624, 44.84079526684306], [1.4419204827421668, 44.87757922298141], [1.4132990300005654, 44.99938624261534], [1.4482615439322117, 45.01931315867412], [1.3864424774272142, 45.10288137852406], [1.2965184989870582, 45.14018882562906], [1.2774962889939254, 45.242082419122035], [1.2271194403372112, 45.27197997099901], [1.3227969726587214, 45.38265936136428], [1.2596039598397974, 45.39834890279054], [1.2531518386328941, 45.44421907802489], [1.1197844789851379, 45.48778292627882], [1.0358490435954526, 45.600209290253204], [0.9345523684647934, 45.61158201050324], [0.8115003322647287, 45.57587064346199], [0.7515297126109174, 45.61832385402009], [0.7758431349260257, 45.667569572341854], [0.6297424639524403, 45.714569989772734]]]}, 'attributes': {'CODE_DEPT': '24', 'NOM_DEPT': 'DORDOGNE'}}, 27: {'geometry': {'type': 'Polygon', 'bbox': (871407.6999999562, 6576892.300001767, 944366.999999935, 6692352.700001431), 'coordinates': [[[5.310560613770374, 46.44676642071993], [5.307691028342544, 46.41681731886727], [5.377044586181938, 46.38135905559838], [5.373462288620209, 46.3522363046852], [5.4377951138533165, 46.315112971225524], [5.4730553115738125, 46.265063763323525], [5.542037828826234, 46.270201908707485], [5.649339135998929, 46.339491033036424], [5.714717731644378, 46.30876884774597], [5.725183003095842, 46.26072920479401], [5.849846074176258, 46.262063603326204], [5.908938421371525, 46.28395162005961], [5.986841317727858, 46.36487308875812], [6.06400848181829, 46.41622698893158], [6.073927085793577, 46.463946006284715], [6.156435507165684, 46.545468173119765], [6.138108547029271, 46.557660399034106], [6.048566902902154, 46.607722856127914], [6.103767023618833, 46.64981840997855], [6.069828479910839, 46.68952488534495], [6.180271003478624, 46.741575238392684], [6.203329933961531, 46.77268138485174], [6.151793978046817, 46.8206673698074], [6.005778412779798, 46.87305283721094], [5.9640723607092, 46.94807945340025], [5.968560305501437, 46.98044449059878], [5.815050562004315, 47.020339093417896], [5.768548742190094, 47.08943503996258], [5.816084496368168, 47.134339348805725], [5.811467446057153, 47.169053816064604], [5.720409103677725, 47.21993674300861], [5.698725742766405, 47.26499677497711], [5.602110210787403, 47.26053058451158], [5.518538729512593, 47.304186619469625], [5.488282961724511, 47.28934747033418], [5.47662851608292, 47.21602767128052], [5.439973300314684, 47.144397191390645], [5.386011880946294, 47.08197711021486], [5.322186205925132, 47.07298220144247], [5.310049747453534, 47.01802089675744], [5.255236339191405, 46.97988809464055], [5.2632646167758095, 46.93591076096915], [5.316959409128447, 46.90405615619236], [5.459286424114921, 46.85524478563496], [5.370244880835241, 46.826171259428975], [5.391088772820641, 46.72869554592405], [5.441107903009741, 46.63754001470951], [5.3591908796398755, 46.52256096352789], [5.415741925117894, 46.473138659412896], [5.310560613770374, 46.44676642071993]]]}, 'attributes': {'CODE_DEPT': '39', 'NOM_DEPT': 'JURA'}}, 28: {'geometry': {'type': 'Polygon', 'bbox': (519117.00000006985, 6298479.3000025265, 619220.100000031, 6366276.5000023525), 'coordinates': [[[1.8820828575359034, 44.3400652488443], [1.6995029158165786, 44.313814281404596], [1.6516207663148532, 44.28680580678524], [1.5691379539986454, 44.29839388706534], [1.5205387676670996, 44.263269755581995], [1.3803681196871471, 44.22485773308447], [1.2813793816235723, 44.23578619286313], [1.1079385683846075, 44.32740288340593], [1.0640838318649115, 44.37851326503546], [1.049803151007229, 44.36263857861537], [0.887330777155981, 44.36637485759445], [0.8734701152053466, 44.323308108557846], [0.9499239562135774, 44.27644247710561], [0.9190898187097761, 44.23827002933668], [0.8687736555079509, 44.12632969467479], [0.7528835731451483, 44.1022698127059], [0.7418847912050018, 44.06519923501583], [0.7757831291372466, 44.03591070642866], [0.8604173969632195, 44.04078542270124], [0.7600848328151361, 43.94224249346582], [0.8628924476067095, 43.92328916304656], [0.8994393128667497, 43.864698458132814], [0.9061557706747253, 43.78433052070788], [0.9539831166064948, 43.78737246570894], [1.1445976144149483, 43.82229820079692], [1.2191934244058247, 43.770777524259024], [1.3608901489958334, 43.82107440669033], [1.3568133196337087, 43.884191550556004], [1.4478772809200224, 43.87355299852193], [1.5556171726831822, 43.91831715512148], [1.552291489752299, 43.96302664758986], [1.6185715580365616, 43.97400163616608], [1.6913900365689174, 44.02434074044882], [1.6589585652250585, 44.11641211601683], [1.7455400915583983, 44.116267124994934], [1.777520207459107, 44.09681615657601], [1.841703958817319, 44.143691099981], [1.9196921618272458, 44.16294029634065], [1.990170712650344, 44.14945256348443], [1.976683004728593, 44.17992355171292], [1.902198887202942, 44.20432736443674], [1.9704438024330744, 44.276436279434094], [1.901390505373501, 44.279116463416905], [1.8820828575359034, 44.3400652488443]]]}, 'attributes': {'CODE_DEPT': '82', 'NOM_DEPT': 'TARN-ET-GARONNE'}}, 29: {'geometry': {'type': 'Polygon', 'bbox': (374866.6000000779, 6660135.3000015365, 491930.9000000467, 6754022.100001265), 'coordinates': [[[-0.8919599503022396, 46.97581784960789], [-0.7738774456713031, 47.00425220913205], [-0.7130578012324342, 46.986072210051866], [-0.6199767888274338, 46.9933220656585], [-0.5654683969778367, 47.019426143811984], [-0.5595318719263798, 47.06188673077483], [-0.495340243761372, 47.08238521770847], [-0.4007795061579291, 47.07077103460962], [-0.24153794845204718, 47.10572466544681], [-0.18483982751841338, 47.108336996905216], [-0.10212095637964697, 47.06479719081804], [-0.04416541443323664, 47.09324258439813], [-0.010736625571349077, 47.15750952036687], [0.05382761471070627, 47.16373008265531], [0.07897484723536348, 47.2828247550667], [0.18528045906678395, 47.424733449390764], [0.2201092524013729, 47.50195329713316], [0.20150312551615193, 47.54432775642865], [0.23000172635318558, 47.608398291933725], [0.15160368312924277, 47.581534768491814], [0.051659308485924815, 47.60651520171707], [-0.004507638464451783, 47.64768842380694], [-0.07183106759512486, 47.65800746667544], [-0.13503673265540259, 47.63251997721371], [-0.1931572478064973, 47.64791658039038], [-0.2330603877794416, 47.707562003167425], [-0.33407702419886187, 47.721165759995365], [-0.38170327004272336, 47.76056283995018], [-0.4604118623353681, 47.76509086787278], [-0.6108182423666888, 47.73568882742977], [-0.741707658432875, 47.73810748628326], [-0.8392941203736599, 47.75227330319133], [-0.9520300471637968, 47.796497072213384], [-0.9786565126647918, 47.761990588095294], [-1.0999157158854127, 47.78196684125323], [-1.1426272844041534, 47.774442466941096], [-1.2382517343256672, 47.80999146298689], [-1.245882346289053, 47.77671754769666], [-1.2545772523262646, 47.73364175152335], [-1.174929569150147, 47.69456501384606], [-1.1382017900650392, 47.61945704786123], [-1.0068639898836451, 47.58905339489957], [-1.04590950407258, 47.56335191106957], [-1.172416066194653, 47.573007547192], [-1.1572331855798583, 47.510083069606296], [-0.967482555917903, 47.49280029691797], [-0.9464433335100002, 47.386466852357906], [-1.0178737847602017, 47.36506226318966], [-1.1676096980775446, 47.3658872351569], [-1.2998771573086003, 47.337623665323264], [-1.305108502227792, 47.30316997819655], [-1.254174750571894, 47.249856282378325], [-1.197721609765016, 47.25058116645219], [-1.1632160710080464, 47.177784087549064], [-1.2352482689031186, 47.138781593625], [-1.231145713608837, 47.10995454752673], [-1.1154625363954844, 47.06256455498828], [-1.148570488753439, 47.02954516258661], [-1.055403108514476, 47.00568547430046], [-0.9334603151811857, 47.008908043397604], [-0.8919599503022396, 46.97581784960789]]]}, 'attributes': {'CODE_DEPT': '49', 'NOM_DEPT': 'MAINE-ET-LOIRE'}}, 30: {'geometry': {'type': 'Polygon', 'bbox': (798995.1999999703, 6485556.600002024, 865784.4999999475, 6579430.300001755), 'coordinates': [[[5.101067478338776, 45.813378082643716], [4.923799133458053, 45.80399936996719], [4.8645021533563355, 45.90461654376237], [4.7290969212308775, 45.94909221230223], [4.7546312797683195, 45.973622014972776], [4.739530214170902, 46.04720888365033], [4.750325275584826, 46.09414996659717], [4.797433206939167, 46.14070146436191], [4.780213475718984, 46.17667702271943], [4.730529789085251, 46.17837212771996], [4.693107175516045, 46.30219481477724], [4.618551541036953, 46.264793087551574], [4.503987529872384, 46.26712984788548], [4.405813600867752, 46.29606050757105], [4.388079599211451, 46.2197885167151], [4.438590902796802, 46.167878829695425], [4.321566636697418, 46.12922273900984], [4.280409632428633, 46.05294444469341], [4.3060957589784294, 46.02122907041076], [4.293912264205216, 45.95339953385292], [4.3239261660748465, 45.900501336627656], [4.383032288498641, 45.863993859081276], [4.391252031699621, 45.75493472371277], [4.365516200673114, 45.69851909472677], [4.410284239143385, 45.63205080632742], [4.519766458935654, 45.57325450372865], [4.614858045826018, 45.575468343903765], [4.661741865018663, 45.48675363928725], [4.722336796597094, 45.49429755062873], [4.756935570818616, 45.455707349780305], [4.868481734036511, 45.523440212041656], [4.808696981728117, 45.57230056989166], [4.901457719834113, 45.60626780465852], [5.03514874052416, 45.63720294798385], [5.131048366350085, 45.70770885564481], [5.094526879742293, 45.7394533595093], [5.101067478338776, 45.813378082643716]]]}, 'attributes': {'CODE_DEPT': '69', 'NOM_DEPT': 'RHONE'}}, 31: {'geometry': {'type': 'Polygon', 'bbox': (503908.00000002584, 6843337.50000099, 610930.7000000123, 6933754.900000739), 'coordinates': [[[1.7139375433100612, 49.409224988875955], [1.6593030583878117, 49.398986085408076], [1.5754225666575004, 49.44014397973678], [1.4121220377546606, 49.45649644273733], [1.3452333638981184, 49.44805852415384], [1.2721366387570645, 49.346289233402395], [1.1602558424773866, 49.34199415674212], [1.1339935379714459, 49.309842058204126], [1.048148843409499, 49.29788323231811], [1.0133166256832076, 49.25226297654121], [0.9214023473164955, 49.338552546249524], [0.9181193706199343, 49.38546058454825], [0.7648660757667759, 49.41958304774309], [0.665291415034114, 49.40200234792396], [0.5818886055232176, 49.43363577760692], [0.5249403531988147, 49.47786858988066], [0.3389828243594632, 49.44093130607368], [0.2972244202906157, 49.429861637295424], [0.3230231728621308, 49.29699256483409], [0.38278674411941915, 49.264016474825524], [0.3946880087410215, 49.1501174749373], [0.4248747928572133, 49.130194368109024], [0.37767980975475246, 49.04945033021295], [0.4367513532066128, 49.008190235697356], [0.41281453288908837, 48.95062636770782], [0.3861893489650427, 48.91041450586637], [0.4573579962478973, 48.8797624818295], [0.552503008373062, 48.87553783158533], [0.610293808614185, 48.831314149046584], [0.7335062460350482, 48.78336423504], [0.7749590431141302, 48.73752726459962], [0.7305886446296782, 48.70520779867271], [0.8148191028635929, 48.670167960202036], [0.8767072376479738, 48.71549244583088], [1.0316566693561064, 48.73058345602126], [1.1847306025015367, 48.772630163271536], [1.3195484140595366, 48.76096509556615], [1.3769640090609687, 48.79176905229479], [1.3621810029001888, 48.83417900338667], [1.4683503712150046, 48.892217344506555], [1.5015238197988672, 48.94105360616862], [1.4577625828068002, 49.02629104623368], [1.5217661561843232, 49.06854572685726], [1.608796070629922, 49.07789415355113], [1.6557774397127956, 49.1301621703505], [1.6757368125175736, 49.21186705776954], [1.7043642065965872, 49.23220177517624], [1.710479333974457, 49.264464162192816], [1.7756288406360832, 49.299693721359404], [1.7594117559881142, 49.368149815405616], [1.7139375433100612, 49.409224988875955]]]}, 'attributes': {'CODE_DEPT': '27', 'NOM_DEPT': 'EURE'}}, 32: {'geometry': {'type': 'Polygon', 'bbox': (607709.4000000342, 6288228.600002549, 736139.9999999859, 6426924.700002184), 'coordinates': [[[1.990170712650344, 44.14945256348443], [2.106128564722785, 44.19439456191692], [2.152470897558622, 44.19771468052582], [2.3892137722320053, 44.093490850148044], [2.410210271943262, 44.05584863724657], [2.459937005782879, 44.05139799957905], [2.522933752458295, 43.981282401194164], [2.4993471763625212, 43.95058625773131], [2.554997490001796, 43.92137993374893], [2.564162540693876, 43.8413310887232], [2.6813058930169467, 43.74396360331519], [2.742838073038075, 43.72904476801747], [2.813673557986314, 43.76171872931423], [2.9211070453325663, 43.73611367807573], [2.9354629666803715, 43.69466778518896], [2.98535037366361, 43.70851625233063], [3.060740509271366, 43.69307728703755], [3.0598559764719786, 43.831647379945494], [3.203111724562128, 43.81387268634433], [3.275074750407491, 43.89835231151913], [3.358359441304462, 43.91383289325508], [3.4507554815828207, 44.02078728434542], [3.328910418620988, 44.07902990387489], [3.3360602348274, 44.15867236265559], [3.373648044830684, 44.17075587210572], [3.3577995033411128, 44.19791043423504], [3.2298475773263053, 44.22625501460899], [3.1252288254578002, 44.28446357369589], [3.1542516260589815, 44.30837023621571], [3.119711177226503, 44.38337811871582], [3.13573609856136, 44.45487023109913], [3.068542786200033, 44.50348970314479], [3.083593896775788, 44.55901439443305], [2.981676986530433, 44.64467661262439], [2.9232644794453155, 44.728638923157135], [2.9345215070232764, 44.77919827286605], [2.8795722036394493, 44.80301061014638], [2.8496583078406252, 44.871489339969614], [2.8019551055054883, 44.87362935290207], [2.738254293313791, 44.941222184736795], [2.7064349149756604, 44.90722612216468], [2.6026810523917403, 44.84316760837649], [2.5993575445949, 44.79280887269856], [2.562709168390778, 44.77575324565901], [2.5561238131207125, 44.72128489545452], [2.4350033478315978, 44.638877643596295], [2.3267857957506486, 44.669692455972545], [2.208413991565611, 44.6438441016835], [2.207475285530841, 44.6155316765299], [2.153816544170514, 44.57190145626477], [2.0573690252842423, 44.582905559661995], [1.9314678023099077, 44.5063942771541], [1.83959954163412, 44.47590016897012], [1.8820828575359034, 44.3400652488443], [1.901390505373501, 44.279116463416905], [1.9704438024330744, 44.276436279434094], [1.902198887202942, 44.20432736443674], [1.976683004728593, 44.17992355171292], [1.990170712650344, 44.14945256348443]]]}, 'attributes': {'CODE_DEPT': '12', 'NOM_DEPT': 'AVEYRON'}}, 33: {'geometry': {'type': 'Polygon', 'bbox': (574729.8000000368, 6509220.700001954, 668605.1000000095, 6592907.500001715), 'coordinates': [[[2.1677857181383846, 46.42406650081814], [2.088941803334241, 46.40890318674812], [1.9930823669027027, 46.43091738935587], [1.8195004176655627, 46.43003833895096], [1.7277108990817456, 46.388958713661], [1.6448464161558112, 46.38681584908523], [1.5223068332769558, 46.426524994500525], [1.415190510113751, 46.347218495873015], [1.4437697350516507, 46.30589420737533], [1.3749003074212898, 46.215451100952365], [1.4527947858284078, 46.179754612070326], [1.5491757848158927, 46.035410141538826], [1.532500175591522, 45.95280423814574], [1.6087196458716781, 45.93341242644046], [1.6023984681707664, 45.857465158579075], [1.6766374034760072, 45.835114020235785], [1.7727491731275808, 45.84282757445299], [1.8808988285366517, 45.79771481845652], [1.875140102478583, 45.73277978898966], [1.8987307791829435, 45.69827755120417], [2.0176087689830706, 45.75549036080031], [2.1135454727593443, 45.7247750650252], [2.1743533542862306, 45.732215961682584], [2.1939584682323856, 45.69904710388091], [2.3377545093277403, 45.680604829561815], [2.3491828014700613, 45.70947892430512], [2.4358558482207813, 45.6992750614443], [2.4921255582417543, 45.73767009540711], [2.4341187302759346, 45.769857352447296], [2.3880204308712214, 45.827375905124306], [2.4425852582122802, 45.863012555807416], [2.492225410180823, 45.86402992467924], [2.594418920141694, 45.98944187163362], [2.5490476236021444, 46.114071399553694], [2.5653790586982077, 46.14303218282909], [2.51631108338946, 46.2394395827726], [2.478940668864652, 46.28114777459818], [2.3918607677139923, 46.329982476677564], [2.3230243720211274, 46.32927925675381], [2.2810476101300576, 46.420405373181076], [2.1677857181383846, 46.42406650081814]]]}, 'attributes': {'CODE_DEPT': '23', 'NOM_DEPT': 'CREUSE'}}, 34: {'geometry': {'type': 'Polygon', 'bbox': (589164.5000000226, 6709782.20000137, 709584.899999998, 6802433.8000011025), 'coordinates': [[[2.936314411640624, 48.163391744163064], [2.7989445730680167, 48.16827665011802], [2.7065470696044738, 48.124819245820426], [2.5381092459271755, 48.1406481032753], [2.506191747348858, 48.23853573046795], [2.4237635277023717, 48.26029732659773], [2.402664267131608, 48.320719459436084], [2.369810541415244, 48.308672482875544], [2.1813499926674265, 48.313745436024654], [1.994084718059379, 48.28658587795807], [1.9654790051841278, 48.25546624531193], [1.8656712589157687, 48.083857198730676], [1.7448338583126364, 48.066144349606134], [1.624592871969399, 48.06722274292949], [1.5941156652809603, 48.030699920759346], [1.5129757558119397, 48.028721780858234], [1.5201238283340495, 47.98227847700274], [1.5254235639039055, 47.929113580216004], [1.588137738369647, 47.87642659620688], [1.5337009096463898, 47.82052592916732], [1.5478779921036054, 47.76976159023594], [1.697352800232305, 47.73839348418297], [1.7399382527750797, 47.66153396919209], [1.7985957016041196, 47.63843148089742], [1.8436947697611497, 47.686353216011], [1.9424229848119665, 47.67563077912316], [2.2025585077490706, 47.67814460516372], [2.2392136309887465, 47.620978307879966], [2.2862379812937745, 47.62896236890434], [2.3730210260695963, 47.58552457239426], [2.437347231323109, 47.6097781148652], [2.4913582937968672, 47.56829543765222], [2.5998924219801753, 47.55368570340882], [2.658459112358834, 47.48789924167962], [2.7193534234556664, 47.49216663238495], [2.7680263231364868, 47.52352727566695], [2.8064837781833747, 47.494459329036964], [2.8746252064056805, 47.5204231125567], [2.914297452553034, 47.565970182735285], [2.9765380120036067, 47.56942879711261], [2.937999037836789, 47.598884707750514], [2.9231098081748264, 47.680559698484025], [2.8585180302225814, 47.71199289202641], [2.8566660682192713, 47.76092647079024], [2.9350577707343026, 47.76324627617625], [3.023798094359226, 47.78655467901546], [3.0102926272319244, 47.90471697202151], [3.0501042789379826, 47.911447449150145], [3.1284501214452565, 47.97097324036124], [3.088317798651479, 48.05393639482615], [3.0504714242752176, 48.072334131140266], [3.0294654865478936, 48.13320717201311], [2.936314411640624, 48.163391744163064]]]}, 'attributes': {'CODE_DEPT': '45', 'NOM_DEPT': 'LOIRET'}}, 35: {'geometry': {'type': 'Polygon', 'bbox': (878352.0999999599, 6687710.700001444, 986155.499999935, 6772821.300001199), 'coordinates': [[[6.823538854548164, 47.81305372460474], [6.784821909572191, 47.84962275518452], [6.645533181556613, 47.90402110648561], [6.601781921638083, 47.944398619135384], [6.542152823586114, 47.902610565311726], [6.478601854176571, 47.88552177370396], [6.431707255957784, 47.94381595263883], [6.366146412024702, 47.96194479078652], [6.237987058178877, 47.93284210199929], [6.167984818891343, 47.95235039238136], [6.15605787526197, 48.00694405924032], [6.072563808399438, 48.015666213333816], [6.0022620475735735, 47.95608969904078], [5.947521018814729, 47.979710391362566], [5.884726375202077, 47.926047148585354], [5.821435400588566, 47.868176059732946], [5.76119123886598, 47.8593344921856], [5.690283323540387, 47.818603890805136], [5.676611542335574, 47.7791582554239], [5.709213007321315, 47.744817354995476], [5.6900664799156155, 47.684838881520605], [5.596682241448043, 47.671686031739085], [5.4825679194907515, 47.68460287491283], [5.4063428720210265, 47.673400744490415], [5.374078595885573, 47.604541652802524], [5.425863186006295, 47.63211377458535], [5.477547427463132, 47.60872207291233], [5.496859255517603, 47.544144504783], [5.447063511552308, 47.496253655362246], [5.3992024955272315, 47.49901446301566], [5.451397515008267, 47.38406251346723], [5.518538729512593, 47.304186619469625], [5.602110210787403, 47.26053058451158], [5.698725742766405, 47.26499677497711], [5.941374552825448, 47.34425359386968], [5.989355047833263, 47.327623386354006], [6.080045800270595, 47.3540364749941], [6.26232858266319, 47.43056987327868], [6.3343537374171, 47.50596607054921], [6.401377017027884, 47.520299753462304], [6.553562523020688, 47.49279726216728], [6.581776153124798, 47.53987013332599], [6.646719240296148, 47.53526063807287], [6.685554362876692, 47.562955627817985], [6.780972040773945, 47.536415287244694], [6.806992048333124, 47.56280181879932], [6.780404771904785, 47.62526070546138], [6.757638483670511, 47.74787796649103], [6.823538854548164, 47.81305372460474]]]}, 'attributes': {'CODE_DEPT': '70', 'NOM_DEPT': 'HAUTE-SAONE'}}, 36: {'geometry': {'type': 'Polygon', 'bbox': (652488.5000000148, 6465307.100002078, 776221.1999999749, 6572856.000001771), 'coordinates': [[[3.6940178008729885, 45.93073235641245], [3.5884696050346547, 46.02413780633841], [3.4635034430082112, 46.017936870152816], [3.419029561174583, 46.074292455805036], [3.371595622264062, 46.055060948494486], [3.166531859715606, 46.065677976513456], [2.971756635840471, 46.12178012989878], [2.9095928618303137, 46.203493810710896], [2.9371457775851466, 46.24291746827502], [2.8557252864968374, 46.25548612990178], [2.810275114252155, 46.196212623621925], [2.733052145656418, 46.223324326165525], [2.6406912317167386, 46.118477661719055], [2.5653790586982077, 46.14303218282909], [2.5490476236021444, 46.114071399553694], [2.594418920141694, 45.98944187163362], [2.492225410180823, 45.86402992467924], [2.4425852582122802, 45.863012555807416], [2.3880204308712214, 45.827375905124306], [2.4341187302759346, 45.769857352447296], [2.4921255582417543, 45.73767009540711], [2.528364779747827, 45.681924336473784], [2.514296706686258, 45.63953208017773], [2.46534961788347, 45.600822875828726], [2.5163323173042995, 45.55342661392318], [2.5084086971130826, 45.478498798744894], [2.651429936294738, 45.442655051563015], [2.714857227145231, 45.38155782083139], [2.8523786840571645, 45.39234069238325], [2.9215557561638335, 45.36577511746247], [2.9486247512965202, 45.30912583525689], [3.016710134630249, 45.28712067830814], [3.1034981328800555, 45.35437310008839], [3.1680632240379363, 45.352259807508055], [3.290691872112179, 45.401821892426085], [3.4567465988864985, 45.40028672539175], [3.501320580432494, 45.427578687052645], [3.625846869344361, 45.33834565932035], [3.667209012708465, 45.37619709113052], [3.7722554467335283, 45.349191883525606], [3.8083099578489272, 45.391611966842156], [3.897408424881887, 45.357083781715666], [3.8991877616127324, 45.410307649293486], [3.9751057509236483, 45.4482695491395], [3.9543484081584332, 45.55596268333556], [3.903596234209209, 45.59902246632493], [3.823453198078696, 45.63241694241687], [3.7808499481107716, 45.72434927186403], [3.6997580221432105, 45.783181674804794], [3.7543707578917007, 45.88603083611288], [3.6940178008729885, 45.93073235641245]]]}, 'attributes': {'CODE_DEPT': '63', 'NOM_DEPT': 'PUY-DE-DOME'}}, 37: {'geometry': {'type': 'Polygon', 'bbox': (583816.2000000454, 6255615.400002628, 694795.5000000021, 6344664.200002406), 'coordinates': [[[1.5556171726831822, 43.91831715512148], [1.555463245486847, 43.86831540012963], [1.5910292905659658, 43.81548843933609], [1.6447876270393127, 43.80025749535751], [1.6604214137506874, 43.741834024882195], [1.7064455963184257, 43.71621951436262], [1.7308693816067124, 43.65775037692852], [1.6877710936117412, 43.63070037401996], [1.824800921390716, 43.580831766261205], [1.882609451533412, 43.520928759682526], [2.0181412825331915, 43.470350219604434], [2.0291328387973606, 43.4368979648422], [2.0728007398118375, 43.39568694741014], [2.224167733501991, 43.43176717254877], [2.259100479380118, 43.45992952515688], [2.4036304838758644, 43.41867070093128], [2.4331017858919792, 43.43517605493282], [2.5657873980365586, 43.4229597441041], [2.6060811779610433, 43.431093773006495], [2.6595399785833935, 43.480163558005835], [2.658651329156613, 43.525794099032666], [2.615607192520078, 43.56663335506628], [2.6432637215975134, 43.65014616249515], [2.711169474843746, 43.645596783987564], [2.754523557193863, 43.61413878643591], [2.9159815194674086, 43.6600207453723], [2.9354629666803715, 43.69466778518896], [2.9211070453325663, 43.73611367807573], [2.813673557986314, 43.76171872931423], [2.742838073038075, 43.72904476801747], [2.6813058930169467, 43.74396360331519], [2.564162540693876, 43.8413310887232], [2.554997490001796, 43.92137993374893], [2.4993471763625212, 43.95058625773131], [2.522933752458295, 43.981282401194164], [2.459937005782879, 44.05139799957905], [2.410210271943262, 44.05584863724657], [2.3892137722320053, 44.093490850148044], [2.152470897558622, 44.19771468052582], [2.106128564722785, 44.19439456191692], [1.990170712650344, 44.14945256348443], [1.9196921618272458, 44.16294029634065], [1.841703958817319, 44.143691099981], [1.777520207459107, 44.09681615657601], [1.7455400915583983, 44.116267124994934], [1.6589585652250585, 44.11641211601683], [1.6913900365689174, 44.02434074044882], [1.6185715580365616, 43.97400163616608], [1.552291489752299, 43.96302664758986], [1.5556171726831822, 43.91831715512148]]]}, 'attributes': {'CODE_DEPT': '81', 'NOM_DEPT': 'TARN'}}, 38: {'geometry': {'type': 'Polygon', 'bbox': (487453.2000000271, 6907663.900000811, 612313.8000000101, 6997484.700000563), 'coordinates': [[[1.7838370588623418, 49.7583075010794], [1.7270555289768355, 49.82888410523527], [1.678450674227239, 49.91813416150288], [1.4564621593341678, 50.03783334266402], [1.3797050374151874, 50.06501467639243], [1.1943823852499293, 49.96803785452345], [1.0659015382478352, 49.92561385767935], [0.9631874837108039, 49.919857551525], [0.7697293792067511, 49.87209561354354], [0.5729399803584816, 49.84972067060625], [0.32055875091141817, 49.74154748099047], [0.2116632434482728, 49.714468642629264], [0.1545347165457167, 49.648642302689645], [0.0656068775498632, 49.51257112098537], [0.1212453831412706, 49.463190908138515], [0.3389828243594632, 49.44093130607368], [0.5249403531988147, 49.47786858988066], [0.5818886055232176, 49.43363577760692], [0.665291415034114, 49.40200234792396], [0.7648660757667759, 49.41958304774309], [0.9181193706199343, 49.38546058454825], [0.9214023473164955, 49.338552546249524], [1.0133166256832076, 49.25226297654121], [1.048148843409499, 49.29788323231811], [1.1339935379714459, 49.309842058204126], [1.1602558424773866, 49.34199415674212], [1.2721366387570645, 49.346289233402395], [1.3452333638981184, 49.44805852415384], [1.4121220377546606, 49.45649644273733], [1.5754225666575004, 49.44014397973678], [1.6593030583878117, 49.398986085408076], [1.7139375433100612, 49.409224988875955], [1.766345027141405, 49.4661503637365], [1.719232660445319, 49.508223020119125], [1.7451334451250173, 49.5317376936539], [1.7045819685135708, 49.605398925870894], [1.7252046142437363, 49.672634359616865], [1.6895758821118128, 49.694785646272834], [1.7838370588623418, 49.7583075010794]]]}, 'attributes': {'CODE_DEPT': '76', 'NOM_DEPT': 'SEINE-MARITIME'}}, 39: {'geometry': {'type': 'Polygon', 'bbox': (822210.4999999779, 6725365.600001331, 915393.7999999551, 6844875.900000985), 'coordinates': [[[4.670183207291811, 48.53188730233758], [4.653455248176321, 48.47054866780406], [4.716095686333966, 48.39485512883844], [4.80973775993872, 48.34735980335423], [4.858919933219105, 48.263638491502725], [4.850099917169891, 48.14175885540109], [4.8193072949588815, 48.103192423478745], [4.730610406781701, 48.11820899819217], [4.688818526238873, 48.073127919265815], [4.704238250439468, 48.02023237622195], [4.789083695644796, 48.007829382573114], [4.786512602874469, 47.96420222558574], [4.852043179350451, 47.95623862322436], [4.9540942495981195, 47.866768148099524], [4.982400768988487, 47.80034738345197], [4.949610301299182, 47.76500253040031], [4.979107142832903, 47.68776283651176], [5.108878229414663, 47.64968494441669], [5.173597037303846, 47.65256871238266], [5.23923227423911, 47.616130098992706], [5.374078595885573, 47.604541652802524], [5.4063428720210265, 47.673400744490415], [5.4825679194907515, 47.68460287491283], [5.596682241448043, 47.671686031739085], [5.6900664799156155, 47.684838881520605], [5.709213007321315, 47.744817354995476], [5.676611542335574, 47.7791582554239], [5.690283323540387, 47.818603890805136], [5.76119123886598, 47.8593344921856], [5.821435400588566, 47.868176059732946], [5.884726375202077, 47.926047148585354], [5.850003923490581, 47.96283504724517], [5.787280985479234, 47.95259697311846], [5.777747898583658, 48.0313619232788], [5.696798789098752, 48.077229566418524], [5.630534001339328, 48.0839862152433], [5.6843187075882495, 48.14504209498634], [5.7108437679155655, 48.21992832819694], [5.640901189478501, 48.24235420494444], [5.482149185087855, 48.35620132428276], [5.408721169498743, 48.383100190451266], [5.4700481951761715, 48.42092912175581], [5.349469998299744, 48.48198867903505], [5.208425883036941, 48.53861075459186], [5.118346103266605, 48.595510860548025], [5.070888258264775, 48.59572522100363], [5.005925627052494, 48.63403550117788], [4.988427677798424, 48.684418562247224], [4.9112683198753935, 48.68871245200531], [4.841961389732739, 48.649667045531814], [4.849256143140029, 48.62363257093909], [4.769195892207036, 48.58868831064457], [4.799180099828291, 48.529779876263504], [4.670183207291811, 48.53188730233758]]]}, 'attributes': {'CODE_DEPT': '52', 'NOM_DEPT': 'HAUTE-MARNE'}}, 40: {'geometry': {'type': 'Polygon', 'bbox': (726344.2999999899, 6263118.800002612, 847769.4999999425, 6373918.100002329), 'coordinates': [[[4.649223666100485, 44.27035986501103], [4.55869985714841, 44.302444632604974], [4.5035362130646455, 44.340188451230844], [4.336073225463423, 44.339522743700364], [4.288416558058853, 44.31465868784345], [4.25884619798255, 44.264785576428054], [4.142867700090412, 44.313350855400145], [4.051451662788466, 44.317323657117086], [4.068441217053273, 44.405113572942064], [3.998162987763964, 44.45979755586332], [3.944362317344653, 44.399567503492385], [3.8859181039452233, 44.38799905234699], [3.952331315351652, 44.328389996777126], [3.922858913740669, 44.305217941025745], [3.9513171396124562, 44.24779542988908], [3.9526044819739092, 44.17079372606867], [3.862104986455047, 44.13007375244107], [3.7969951126604835, 44.12738907948696], [3.678640671819198, 44.18275878035759], [3.6377691613510246, 44.17548804418238], [3.633491144032294, 44.12269533049063], [3.4397298934659633, 44.12909826593232], [3.373648044830684, 44.17075587210572], [3.3360602348274, 44.15867236265559], [3.328910418620988, 44.07902990387489], [3.4507554815828207, 44.02078728434542], [3.358359441304462, 43.91383289325508], [3.4244480676686226, 43.9115981684474], [3.5307009207380955, 43.855624713961724], [3.5754482408134063, 43.86552224087749], [3.6235886150953553, 43.91697856675764], [3.726990344828379, 43.96901626259547], [3.787325021892116, 43.96687037520123], [3.824905456819552, 43.91929773950891], [3.830797043559706, 43.86642403487079], [3.917385092127717, 43.885593220663814], [4.002046166191344, 43.81146444231592], [4.144780927023585, 43.73388653553421], [4.194441206758988, 43.65430382623312], [4.150215691493674, 43.58556246815695], [4.1010416754063925, 43.55437094640871], [4.13912342859037, 43.53189642273357], [4.13766421830876, 43.48194592546537], [4.230283393392478, 43.46018543272649], [4.238105541141803, 43.497626917839995], [4.409349673740097, 43.561127800636186], [4.427028042117802, 43.62067757183961], [4.487236861293796, 43.69923776661928], [4.5930322483013235, 43.68746240297304], [4.654821446467849, 43.806408691630295], [4.641909591242105, 43.86747754714173], [4.739060856654237, 43.92405947349065], [4.842093969959471, 43.986474548464955], [4.787978024928094, 44.065054097470245], [4.707458356688191, 44.10367246401253], [4.722074664233515, 44.18742154948275], [4.649223666100485, 44.27035986501103]]]}, 'attributes': {'CODE_DEPT': '30', 'NOM_DEPT': 'GARD'}}, 41: {'geometry': {'type': 'Polygon', 'bbox': (990508.299999954, 6789869.300001165, 1081448.299999941, 6895577.800000864), 'coordinates': [[[7.1982815370299456, 48.310467861035285], [7.275183721811301, 48.3052347870644], [7.348562541549848, 48.24719461957468], [7.476943375699937, 48.203536684298435], [7.470560946722399, 48.16101452404043], [7.519368638022094, 48.12611186664675], [7.577312855212314, 48.120368521818186], [7.667802806274932, 48.22391081447789], [7.703140260600039, 48.3088120928765], [7.73988076758838, 48.321748229095604], [7.735975751999303, 48.40415792791916], [7.768185493209042, 48.489658145885635], [7.805195566047562, 48.51357147162407], [7.804169862129346, 48.592334654361416], [7.839817246895408, 48.641373985119756], [7.963140045094564, 48.72135309730477], [7.9717451577555725, 48.757628209866056], [8.09632056331982, 48.81038371016163], [8.14793847273242, 48.90380819881706], [8.214337990422152, 48.97509304801685], [8.091376040143567, 48.98925821692837], [7.934626827531662, 49.057809150319585], [7.868785609773861, 49.034157073278124], [7.800436670933279, 49.06411681073709], [7.732229514556393, 49.04436019364183], [7.635285449703197, 49.05416135519033], [7.578392137539887, 48.95740241812128], [7.538259039250205, 48.93296158495443], [7.446887904100118, 48.96577914856757], [7.326851980608823, 48.943372742034434], [7.29304884880289, 48.9734164509209], [7.17424027072314, 49.00636568135154], [7.107657105402385, 49.04411352332804], [7.054911912536332, 49.03061918772984], [6.989216409797389, 48.95992878869148], [6.964601688658045, 48.90452526766878], [7.045342890531057, 48.87154914038007], [7.054514540544792, 48.81370438623761], [7.126799106595454, 48.80114235821405], [7.149408408912649, 48.84470403838557], [7.311900506296782, 48.76730084432443], [7.242487615031405, 48.69154313192023], [7.283044927480475, 48.63810720118507], [7.256281654444216, 48.58867550766629], [7.167909935894841, 48.52759644356372], [7.0793597709732445, 48.536417612714544], [7.1231653690285635, 48.51359226557106], [7.097427065168082, 48.40564467454505], [7.1219084409759965, 48.33329037922002], [7.1982815370299456, 48.310467861035285]]]}, 'attributes': {'CODE_DEPT': '67', 'NOM_DEPT': 'BAS-RHIN'}}, 42: {'geometry': {'type': 'Polygon', 'bbox': (593467.3000000443, 6174169.900002814, 719561.0999999918, 6262595.80000261), 'coordinates': [[[3.24056113717041, 43.21280863308419], [3.2010265503923754, 43.24916714805378], [3.1472079664155532, 43.24700506844506], [3.004740938100306, 43.28853825294436], [3.004349268167806, 43.3201311415977], [2.8327620472635995, 43.32241280561742], [2.772248225673249, 43.25778564580627], [2.6016030790296316, 43.29870698639696], [2.5399619094859687, 43.346221862319766], [2.5657873980365586, 43.4229597441041], [2.4331017858919792, 43.43517605493282], [2.4036304838758644, 43.41867070093128], [2.259100479380118, 43.45992952515688], [2.224167733501991, 43.43176717254877], [2.0728007398118375, 43.39568694741014], [2.0291328387973606, 43.4368979648422], [1.9101007956285108, 43.40405939980924], [1.8587429714302222, 43.44382089121744], [1.8040846789340412, 43.39168480485624], [1.8134240645221509, 43.34140359698674], [1.7477325973047735, 43.34374010112299], [1.6884197209147513, 43.27355372810057], [1.7238440687530254, 43.224524250769115], [1.7100564477992013, 43.18969803410906], [1.8247721988689323, 43.14581388915543], [1.9494758652019253, 43.11949443816388], [1.9411328732906326, 43.052715472626794], [1.9851004481943353, 43.02627232234244], [1.9869209142233524, 42.87101168756068], [1.8804739886198156, 42.85266926902656], [1.9081798281291236, 42.76766704348015], [1.955395663529541, 42.73670079860324], [2.057204243184995, 42.75622286126001], [2.1758741195218594, 42.68279522431071], [2.166053682054993, 42.66391836976537], [2.322006120391769, 42.70779157620252], [2.357535079462851, 42.73412195489046], [2.327116045977923, 42.83744277583194], [2.4524747607108766, 42.83693276356485], [2.5090117260388043, 42.8498316897036], [2.6975776462485945, 42.83043106598879], [2.7400003158100112, 42.837574151817094], [2.789053819259419, 42.895988728811666], [2.8652738803519484, 42.91834143726111], [2.917114990593263, 42.88486022074895], [3.0434985865888815, 42.83815011921819], [3.060589297455898, 42.91705990494522], [3.0428431893335772, 42.9601537879993], [3.1172205062222833, 43.10183913719133], [3.24056113717041, 43.21280863308419]]]}, 'attributes': {'CODE_DEPT': '11', 'NOM_DEPT': 'AUDE'}}, 43: {'geometry': {'type': 'Polygon', 'bbox': (655720.9000000084, 6780535.000001167, 740951.9999999929, 6890862.900000851), 'coordinates': [[[2.936314411640624, 48.163391744163064], [3.0051556578134635, 48.20767000036064], [3.043627253848888, 48.272022357627314], [3.0495188960927044, 48.36012035558039], [3.167737573570585, 48.371860839541355], [3.3651592673815314, 48.372280687121055], [3.4147915595010963, 48.390273038835076], [3.3919598867876517, 48.42432215347003], [3.423442380707056, 48.53356269241414], [3.5038535314822115, 48.60480913448515], [3.5556137492385345, 48.62028467658828], [3.460426313142606, 48.65300999880743], [3.4769636430994466, 48.699358067133204], [3.4358089868027415, 48.753571716354905], [3.4851874436586847, 48.85190849438655], [3.4032194510047127, 48.86468651933575], [3.3302994547269797, 48.908706088655926], [3.3047494707754015, 48.948764278958], [3.171683982224406, 49.01412318431705], [3.16523032905892, 49.099650858000736], [3.071884293834167, 49.11755421882924], [3.0085155429257675, 49.09151015781777], [2.735012683493696, 49.060449825264335], [2.633272965218076, 49.108376218976154], [2.5905242793946224, 49.079654846745605], [2.55306064485419, 49.00981711745223], [2.602598431431983, 48.92935660279411], [2.5626221662429587, 48.888884130538436], [2.592280488308802, 48.80743667582849], [2.6136476481340414, 48.76102719230643], [2.5716603184420737, 48.69201409166007], [2.5336160068074505, 48.6573313888409], [2.5437765144069613, 48.60384977115981], [2.4995246743322403, 48.52523904801557], [2.504749755053753, 48.43944601613285], [2.533731834361712, 48.41125114634581], [2.4298322285044196, 48.36201578313258], [2.402664267131608, 48.320719459436084], [2.4237635277023717, 48.26029732659773], [2.506191747348858, 48.23853573046795], [2.5381092459271755, 48.1406481032753], [2.7065470696044738, 48.124819245820426], [2.7989445730680167, 48.16827665011802], [2.936314411640624, 48.163391744163064]]]}, 'attributes': {'CODE_DEPT': '77', 'NOM_DEPT': 'SEINE-ET-MARNE'}}, 44: {'geometry': {'type': 'Polygon', 'bbox': (583879.5000000115, 6942514.300000707, 713832.6999999986, 7030025.100000476), 'coordinates': [[[3.090253620620082, 50.0537405551461], [2.87653264314694, 50.04217932425911], [2.857843650412817, 50.077393119013884], [2.5760198137336725, 50.11341281006871], [2.551329915710551, 50.141605436872034], [2.4766865519087604, 50.13699947000749], [2.414507925852589, 50.100642406879025], [2.389777056686568, 50.15548482145538], [2.495690327572777, 50.19456202412894], [2.4517852065078483, 50.23030237701513], [2.3702049076387826, 50.209770358333444], [2.2738282654200974, 50.226839899630434], [2.0957483707167435, 50.20554490564382], [2.077820295455588, 50.2488212597536], [1.9461316429137003, 50.28742804274709], [1.9180007470953697, 50.3117787753595], [1.7787842601942676, 50.36186618073267], [1.6707155098465685, 50.331010399908095], [1.6415439209955998, 50.35215320245149], [1.5509358115042573, 50.35032330174563], [1.5379477347729347, 50.28266847459979], [1.5902673346965246, 50.25595102356094], [1.478714399387514, 50.16491841312994], [1.453881224461018, 50.11032909894591], [1.3797050374151874, 50.06501467639243], [1.4564621593341678, 50.03783334266402], [1.678450674227239, 49.91813416150288], [1.7270555289768355, 49.82888410523527], [1.7838370588623418, 49.7583075010794], [1.8938643249004963, 49.69898823077294], [1.933209822166273, 49.71962996350131], [2.121409706926089, 49.688074091756725], [2.2471685906926684, 49.70164087682517], [2.3731456632291623, 49.65626624027031], [2.504748899250395, 49.63946726892116], [2.571493337841171, 49.597080627026244], [2.670723151725744, 49.581411971799525], [2.6891419821315017, 49.625601863486416], [2.7994949073615056, 49.62058605182692], [2.793612422958185, 49.65595422264364], [2.915712813038834, 49.70267238897875], [3.1184031553047866, 49.70596856016259], [3.078694114076548, 49.82241521579585], [3.117968662907868, 49.91427637799499], [3.1926752854802194, 49.9774646962746], [3.1727072271768164, 50.011994944690635], [3.090253620620082, 50.0537405551461]]]}, 'attributes': {'CODE_DEPT': '80', 'NOM_DEPT': 'SOMME'}}, 45: {'geometry': {'type': 'Polygon', 'bbox': (708104.1999999973, 6405343.300002245, 816369.7999999607, 6481030.400002034), 'coordinates': [[[3.1034981328800555, 45.35437310008839], [3.1179979977042014, 45.284187297622296], [3.222465248668949, 45.271971446584864], [3.2880332175079103, 45.120424409579364], [3.3257851579159827, 45.09513611769889], [3.2972503187682016, 45.03607778789884], [3.3471986847617563, 45.014233878924244], [3.3613425807398936, 44.97141170967906], [3.412834742275399, 44.944842501975934], [3.4179705141646854, 44.90076835769564], [3.4757737071599757, 44.81537151910519], [3.589348917106291, 44.83219404802301], [3.5943359966689914, 44.87542977006513], [3.6595223843815874, 44.8699386445054], [3.6663649146430073, 44.82877808873485], [3.7406507355868404, 44.83869734813907], [3.862527190139651, 44.74386343467101], [3.937001123548729, 44.79541721729978], [4.0283748583288785, 44.834081003006226], [4.039638866980703, 44.87316201331418], [4.156154791813548, 44.87333360834139], [4.221702631142119, 44.96133612938681], [4.289827924670836, 44.99730682920303], [4.375306064703462, 45.10483231156172], [4.376558944791765, 45.14435959050196], [4.4432627898030574, 45.140832955911634], [4.483134616383878, 45.2364464819279], [4.418571110077435, 45.275424101661145], [4.362548869116956, 45.26439535681795], [4.366534405291163, 45.33699593440981], [4.308199323181691, 45.37098690693714], [4.177926371804464, 45.3926048786864], [4.024824051546119, 45.34288771363736], [3.97965057221058, 45.37513435596753], [3.897408424881887, 45.357083781715666], [3.8083099578489272, 45.391611966842156], [3.7722554467335283, 45.349191883525606], [3.667209012708465, 45.37619709113052], [3.625846869344361, 45.33834565932035], [3.501320580432494, 45.427578687052645], [3.4567465988864985, 45.40028672539175], [3.290691872112179, 45.401821892426085], [3.1680632240379363, 45.352259807508055], [3.1034981328800555, 45.35437310008839]]]}, 'attributes': {'CODE_DEPT': '43', 'NOM_DEPT': 'HAUTE-LOIRE'}}, 46: {'geometry': {'type': 'Polygon', 'bbox': (732040.0999999946, 6824301.40000104, 848914.8999999773, 6923412.200000763), 'coordinates': [[[4.047972977986833, 49.40564229477001], [4.035496373111564, 49.359904159442664], [3.9244337055179415, 49.406181771301206], [3.8474771401321166, 49.364586629449846], [3.6469532050746403, 49.31515350352492], [3.704392046963459, 49.181373023481946], [3.622246623748465, 49.15110369338968], [3.600004656260228, 49.12069184513826], [3.646307433571441, 49.04058839071644], [3.6015984944904185, 48.944072041330806], [3.5285764431169526, 48.912141028966566], [3.4851874436586847, 48.85190849438655], [3.4358089868027415, 48.753571716354905], [3.4769636430994466, 48.699358067133204], [3.460426313142606, 48.65300999880743], [3.5556137492385345, 48.62028467658828], [3.634028277746641, 48.54129826319994], [3.730879401425958, 48.53746785522521], [3.822742058660398, 48.51610441782203], [3.9492266572894197, 48.60343162809795], [4.001695483416846, 48.66387541822405], [4.080262439820496, 48.70106898078487], [4.166386793257749, 48.70745423754145], [4.325594012298644, 48.700277029545035], [4.315905486866125, 48.615578923340706], [4.40306312166006, 48.56126039350177], [4.545406992928757, 48.52525227165607], [4.614026636401956, 48.55380713072681], [4.670183207291811, 48.53188730233758], [4.799180099828291, 48.529779876263504], [4.769195892207036, 48.58868831064457], [4.849256143140029, 48.62363257093909], [4.841961389732739, 48.649667045531814], [4.9112683198753935, 48.68871245200531], [4.988427677798424, 48.684418562247224], [4.990124563499123, 48.74183736488204], [4.888760929797641, 48.81720971455143], [4.9362093920054075, 48.92214239513739], [5.030128675561755, 48.95690245548527], [5.036321445219877, 49.02433254955411], [5.007681402681856, 49.034951950784894], [4.992117611940037, 49.11490008828468], [4.9397619983736725, 49.185068204591545], [4.950989232683009, 49.236865846314195], [4.894206220282045, 49.2590743389563], [4.826941205469511, 49.23576093817319], [4.686074799511885, 49.256759043814334], [4.6251041072703405, 49.23565606344571], [4.575868215345435, 49.2966511893251], [4.422583188651027, 49.28064492916811], [4.306756525620348, 49.32779732812255], [4.248308184547379, 49.38225617649833], [4.1431697526129865, 49.404187032451034], [4.047972977986833, 49.40564229477001]]]}, 'attributes': {'CODE_DEPT': '51', 'NOM_DEPT': 'MARNE'}}, 47: {'geometry': {'type': 'Polygon', 'bbox': (428150.0000001159, 6178840.6000028085, 506455.20000008016, 6283050.700002572), 'coordinates': [[[-0.3134428634980887, 42.849375059707675], [-0.14599159174135176, 42.768466932454174], [-0.10610940781291786, 42.72082372641465], [-0.01063758464629181, 42.684385085093275], [0.1757204586573474, 42.73648479569695], [0.25988295627208224, 42.71581111366553], [0.29282224858132516, 42.674924581801044], [0.3596287954835796, 42.72339183232163], [0.4292757338727024, 42.69074972940043], [0.47774954032737066, 42.69999034279803], [0.45509422507364955, 42.72806064199966], [0.45889951642403815, 42.82814521426843], [0.4773013441230268, 42.87810749616219], [0.5759351469518764, 42.87082592303985], [0.6274179241908862, 43.00010287323438], [0.5630044583601449, 43.01746794817719], [0.5322696523895433, 43.093864488407355], [0.4419985587106286, 43.13127313187037], [0.5518748957180646, 43.209147130092994], [0.5515684940570379, 43.236102503746885], [0.616280054756598, 43.28903679046815], [0.6068109749570959, 43.31088599158559], [0.49803381879209696, 43.326180572401476], [0.2772545000281141, 43.38579092290556], [0.1820312140000643, 43.37118267445086], [0.13798238183895745, 43.43291627195171], [0.11212423457670412, 43.51736991981866], [0.056081443916198466, 43.518807249853], [-0.0019248187812945813, 43.56554046143878], [-0.015780894995830342, 43.60465738319832], [-0.0967829732087741, 43.58240589763179], [-0.04013178615003942, 43.51260540210091], [-0.0690310020330968, 43.4373492706762], [0.009598314167785659, 43.42210994370394], [-0.046122416801734574, 43.300855792904095], [-0.01700753125072415, 43.270453175935074], [-0.11770146168361151, 43.180326663081985], [-0.14613235140227143, 43.12823595997721], [-0.19098404402245037, 43.111200014851946], [-0.22395152380116093, 43.033687539644006], [-0.291551876667032, 42.98776781593251], [-0.2815909254844988, 42.93356279018245], [-0.32708213440188894, 42.91578162376447], [-0.3134428634980887, 42.849375059707675]]]}, 'attributes': {'CODE_DEPT': '65', 'NOM_DEPT': 'HAUTES-PYRENEES'}}, 48: {'geometry': {'type': 'Polygon', 'bbox': (541672.6000000585, 6348642.700002397, 637121.800000023, 6439627.500002151), 'coordinates': [[[1.0751408247250984, 44.57732478356566], [1.01316664592295, 44.536127142275056], [1.0090253989657338, 44.48004110906175], [1.0640838318649115, 44.37851326503546], [1.1079385683846075, 44.32740288340593], [1.2813793816235723, 44.23578619286313], [1.3803681196871471, 44.22485773308447], [1.5205387676670996, 44.263269755581995], [1.5691379539986454, 44.29839388706534], [1.6516207663148532, 44.28680580678524], [1.6995029158165786, 44.313814281404596], [1.8820828575359034, 44.3400652488443], [1.83959954163412, 44.47590016897012], [1.9314678023099077, 44.5063942771541], [2.0573690252842423, 44.582905559661995], [2.153816544170514, 44.57190145626477], [2.207475285530841, 44.6155316765299], [2.1694177928364127, 44.638066191426034], [2.1534919160094748, 44.753107579025304], [2.171636274864375, 44.79002439871239], [2.0942123106720874, 44.87201148950678], [2.0629142919730623, 44.97650640551568], [1.9081561620078975, 44.978426771844745], [1.8239145263410472, 44.92768244845702], [1.7506251087427585, 44.954959479535844], [1.6509837683346413, 45.02501608647886], [1.5357253751118871, 45.04628038727674], [1.4482615439322117, 45.01931315867412], [1.4132990300005654, 44.99938624261534], [1.4419204827421668, 44.87757922298141], [1.3614038259537624, 44.84079526684306], [1.364102971342699, 44.811568186415315], [1.287782139460227, 44.714781096530565], [1.2245500554542503, 44.68426634892967], [1.1466718447537783, 44.67034606645634], [1.1537937079861713, 44.63940626971528], [1.0751408247250984, 44.57732478356566]]]}, 'attributes': {'CODE_DEPT': '46', 'NOM_DEPT': 'LOT'}}, 49: {'geometry': {'type': 'Polygon', 'bbox': (899977.8999999232, 6293054.100002545, 1014122.199999877, 6403290.200002269), 'coordinates': [[[6.636395800176684, 43.78895056709553], [6.697323345466608, 43.87365480225305], [6.745556290785884, 43.872108256875045], [6.830709312232405, 43.918363011486576], [6.884610185550847, 43.889120756894144], [6.913088787529998, 43.92796536503895], [6.851891862245591, 43.95479401195963], [6.836004210977611, 43.99060185096192], [6.7457139505011225, 44.043235362043276], [6.755280297628581, 44.07860658695586], [6.686536427072904, 44.169253930861075], [6.7239938850023835, 44.24984330468271], [6.796090992510112, 44.31610570751239], [6.88742990090296, 44.3610478380362], [6.8819574044011205, 44.477252952765745], [6.854013487274841, 44.529129653944274], [6.933506639572193, 44.5759517467791], [6.948335091404861, 44.65481629914683], [6.914488202179286, 44.65949945810221], [6.839801667428219, 44.60858882906445], [6.772207133133649, 44.58890871380483], [6.684305299896707, 44.54130010645845], [6.632376327558709, 44.44712877640482], [6.562444503095603, 44.44549275371164], [6.413884950226282, 44.4692899596284], [6.362000081358195, 44.52207257904401], [6.233718236049833, 44.4638309183279], [6.262481962582939, 44.41225003856598], [6.228221718294847, 44.3817003919971], [6.155615049010708, 44.46195982298566], [6.071139333430846, 44.45053588827675], [5.9536703829504924, 44.395059266699306], [5.912323479912073, 44.27153166809458], [5.82391188904594, 44.2789019553126], [5.881793583616446, 44.21099866254289], [5.755494196596879, 44.210207765237946], [5.6760373255434615, 44.19143313185903], [5.63959354437225, 44.16758605191373], [5.576187167563138, 44.18804165094914], [5.543986124993945, 44.136390782725556], [5.498787806458752, 44.11571934778844], [5.502636785327954, 44.06343920865502], [5.543656674317525, 44.02870768768531], [5.51208954255573, 43.94600228564655], [5.607126670731597, 43.91377284375335], [5.578189791221216, 43.82992112219797], [5.654445137414141, 43.82511098585945], [5.757332977582704, 43.72940911375542], [5.781343238677484, 43.75565738832385], [5.901207402568148, 43.73258459518493], [6.036131813943926, 43.694163340855255], [6.182886008281907, 43.76217559136379], [6.216709972579084, 43.79951197699887], [6.356960735074888, 43.736367664887325], [6.413483066219063, 43.76036041847228], [6.4144280526034985, 43.791594458434275], [6.5247619833224295, 43.80636597788814], [6.636395800176684, 43.78895056709553]]]}, 'attributes': {'CODE_DEPT': '04', 'NOM_DEPT': 'ALPES-DE-HAUTE-PROVENCE'}}, 50: {'geometry': {'type': 'Polygon', 'bbox': (442127.900000055, 6722018.100001343, 542578.400000031, 6823412.100001052), 'coordinates': [[[0.6144311990931562, 47.69421364606964], [0.5805178732790726, 47.71232800972914], [0.7126298064021267, 47.79003621973886], [0.7745788175007332, 47.839687295150405], [0.7598746908928189, 47.89822684022159], [0.8458005593594112, 47.941401463859776], [0.7974846748199693, 48.037554414552474], [0.8412172317044133, 48.10306240933596], [0.8824911871126113, 48.161763238455556], [0.7976558384942257, 48.19445221756441], [0.7378268325294973, 48.18907227443458], [0.6832238274745249, 48.248585603870666], [0.5359730618565093, 48.24984731425016], [0.4875722818038879, 48.307800269645206], [0.3826045470591676, 48.33382739377157], [0.36395898803578647, 48.45163268084123], [0.2958599914991128, 48.48017405402528], [0.11624508246972828, 48.43555379653748], [0.062488371910724295, 48.38221653184688], [-0.002558831894627075, 48.39731388623217], [-0.05453120471342507, 48.38200345783028], [-0.13797809431803368, 48.361355595694256], [-0.16309583433799704, 48.25554245624931], [-0.1468370673865552, 48.20500891985261], [-0.24992127138834194, 48.157106805256824], [-0.2171740033885255, 48.106959664577076], [-0.23094244360355717, 48.058985357501875], [-0.34166482709193685, 48.043095522813545], [-0.2826331784456293, 47.95819180740859], [-0.384840280948404, 47.93084465849811], [-0.37067332986759555, 47.88002461791639], [-0.44785891788114673, 47.832216379468825], [-0.38820058256862766, 47.80531865640709], [-0.38170327004272336, 47.76056283995018], [-0.33407702419886187, 47.721165759995365], [-0.2330603877794416, 47.707562003167425], [-0.1931572478064973, 47.64791658039038], [-0.13503673265540259, 47.63251997721371], [-0.07183106759512486, 47.65800746667544], [-0.004507638464451783, 47.64768842380694], [0.051659308485924815, 47.60651520171707], [0.15160368312924277, 47.581534768491814], [0.23000172635318558, 47.608398291933725], [0.3789609617763965, 47.569104055270486], [0.45663070361835567, 47.6388264115843], [0.542891970097039, 47.65620713810867], [0.6144311990931562, 47.69421364606964]]]}, 'attributes': {'CODE_DEPT': '72', 'NOM_DEPT': 'SARTHE'}}, 51: {'geometry': {'type': 'MultiPolygon', 'coordinates': [[[[-3.2354453135683303, 47.32381750417188], [-3.086556315866053, 47.28307372555509], [-3.0931183741107304, 47.31513470944217], [-3.155860890833796, 47.36108442086488], [-3.2487748311646665, 47.379576048214616], [-3.2354453135683303, 47.32381750417188]]], [[[-3.5230042934996066, 47.84914685715857], [-3.5299269866083165, 47.78246448850768], [-3.452760568692726, 47.695341637300814], [-3.3442177923412864, 47.70836269956608], [-3.208127827120783, 47.6634208285362], [-3.2097530809913435, 47.64069004036757], [-3.123258986370401, 47.569508156886485], [-2.975177828281593, 47.576071697749526], [-2.8511507321351166, 47.61902226485759], [-2.77857375285652, 47.61915856972313], [-2.701950798992519, 47.58991904582013], [-2.7305385199390986, 47.54248870669774], [-2.8136159976601767, 47.552972982703686], [-2.871566103275048, 47.532183584787376], [-2.8002084412292914, 47.48727462509061], [-2.664337299385734, 47.51863653795232], [-2.537129650340701, 47.52567909144418], [-2.4412239148217294, 47.49623958284173], [-2.458489165173328, 47.44812172073537], [-2.312868292914679, 47.46446874949351], [-2.1073336439134778, 47.53105690026967], [-2.097035597340285, 47.631359844030904], [-2.131472084919134, 47.72224026217332], [-2.0897121808782697, 47.73856050587445], [-2.049526070392867, 47.8169173979452], [-2.1162985684590634, 47.88095628990024], [-2.079088544973961, 47.91952249841043], [-2.1368653813504146, 47.979116800921744], [-2.2395935242179426, 47.999461627992105], [-2.279595013670352, 48.02636073133588], [-2.2332446439270153, 48.075627876360535], [-2.287278430400509, 48.13374556347385], [-2.3713647531616733, 48.12210300840669], [-2.4089048721706594, 48.16861132667282], [-2.49481856978248, 48.15784478551255], [-2.5747859613042996, 48.070410038491524], [-2.6311897590265905, 48.035479312779835], [-2.670050948442368, 48.047883952925766], [-2.652301006956971, 48.119324663861974], [-2.781951132488675, 48.120579730854125], [-3.0335402161271037, 48.19936064624241], [-3.116373512585391, 48.20636380948965], [-3.1552540693335693, 48.158490943543626], [-3.2722443396278273, 48.14001476485908], [-3.33675473563501, 48.17112526547111], [-3.5648389737333277, 48.185746943072594], [-3.695838514922977, 48.15221175123511], [-3.695020686823403, 48.093494659480534], [-3.6402315330750725, 47.98524271313111], [-3.5552758457516056, 47.99309847047771], [-3.4848124678130397, 47.966889784603126], [-3.392624522513051, 47.95445115827384], [-3.4034429894056712, 47.87011455487806], [-3.5230042934996066, 47.84914685715857]]]]}, 'attributes': {'CODE_DEPT': '56', 'NOM_DEPT': 'MORBIHAN'}}, 52: {'geometry': {'type': 'Polygon', 'bbox': (534094.1000000313, 6762847.800001221, 625387.4000000142, 6872272.800000905), 'coordinates': [[[0.8148191028635929, 48.670167960202036], [0.8506421037670122, 48.58262673082052], [0.9665513231299335, 48.52274528509245], [0.9422407728065412, 48.399001153466926], [0.8833710269390447, 48.35667269478065], [0.7854319060188932, 48.34042724029942], [0.7621929543543114, 48.30687661402512], [0.830483470832425, 48.21071322673855], [0.7976558384942257, 48.19445221756441], [0.8824911871126113, 48.161763238455556], [0.8412172317044133, 48.10306240933596], [0.997330007937029, 48.12749350968228], [1.0085477409246673, 48.08312677901138], [1.1122333320073277, 48.08072912595507], [1.1212335165894016, 48.039115919496666], [1.2096430686639745, 47.96850051669979], [1.3086281518302285, 47.953853799784625], [1.5201238283340495, 47.98227847700274], [1.5129757558119397, 48.028721780858234], [1.5941156652809603, 48.030699920759346], [1.624592871969399, 48.06722274292949], [1.7448338583126364, 48.066144349606134], [1.8656712589157687, 48.083857198730676], [1.9654790051841278, 48.25546624531193], [1.994084718059379, 48.28658587795807], [1.9765777946992389, 48.399384474494646], [1.9305557503485928, 48.404124841843824], [1.9221489648373706, 48.45760028607871], [1.801445837919035, 48.466087959629114], [1.765329716198042, 48.56937104101408], [1.7092527874670105, 48.57802434627667], [1.602498423421542, 48.66376910929475], [1.5795458299182854, 48.70181187350343], [1.5912030850964913, 48.81486963941434], [1.5572502545823872, 48.89157660949543], [1.5015238197988672, 48.94105360616862], [1.4683503712150046, 48.892217344506555], [1.3621810029001888, 48.83417900338667], [1.3769640090609687, 48.79176905229479], [1.3195484140595366, 48.76096509556615], [1.1847306025015367, 48.772630163271536], [1.0316566693561064, 48.73058345602126], [0.8767072376479738, 48.71549244583088], [0.8148191028635929, 48.670167960202036]]]}, 'attributes': {'CODE_DEPT': '28', 'NOM_DEPT': 'EURE-ET-LOIR'}}, 53: {'geometry': {'type': 'Polygon', 'bbox': (1159341.799999797, 6050135.700003077, 1233465.899999756, 6158598.900002873), 'coordinates': [[[9.402268324411988, 41.8586982422724], [9.329200877550077, 41.83681486608324], [9.227497390904741, 41.85558903234797], [9.221084024655989, 42.0275969605392], [9.160818391906192, 42.02601714338066], [9.119729450195365, 42.10777443178623], [9.07218689177604, 42.13021371520025], [9.04565931380628, 42.2069234314084], [8.904766989145307, 42.253859280701064], [8.819561377056067, 42.31755804188299], [8.640801666424288, 42.373436353833135], [8.573411068108614, 42.381405712050416], [8.689105710448825, 42.263523971751304], [8.616716018939044, 42.25545987317005], [8.570335354249012, 42.230300263765095], [8.590170524060465, 42.16388769237896], [8.6605051108979, 42.10358657526475], [8.71025694439948, 42.09582422568574], [8.741332481964943, 42.04090929509718], [8.65641983419225, 42.00934596433846], [8.668873449917275, 41.98243065721414], [8.59769539752256, 41.95324306386655], [8.64145251301252, 41.90988911486005], [8.721430218965407, 41.90925797590231], [8.754903133430052, 41.93256867906016], [8.803137234079097, 41.89138353772907], [8.771293565923225, 41.81123955107434], [8.684518163125169, 41.747002267405335], [8.717235397872976, 41.72277126801705], [8.914509146058741, 41.68972719719787], [8.877266064638947, 41.65245090152453], [8.793074221956438, 41.62955272381404], [8.788528375117986, 41.55773356360875], [8.841680682750065, 41.54654924536316], [8.938397598811326, 41.48966696643918], [9.082197812197029, 41.441977672838874], [9.09553200430217, 41.41243171053331], [9.219681605069644, 41.36821448934], [9.228899383902924, 41.425302802667254], [9.265877253287043, 41.46599484844734], [9.287551136639262, 41.5302255321191], [9.340900099192766, 41.55924531057797], [9.327204087148893, 41.6163597070917], [9.387496558130868, 41.65736235225344], [9.407323413987857, 41.767639126591654], [9.402268324411988, 41.8586982422724]]]}, 'attributes': {'CODE_DEPT': '2A', 'NOM_DEPT': 'CORSE-DU-SUD'}}, 54: {'geometry': {'type': 'Polygon', 'bbox': (878534.0999999767, 6809622.900001093, 1004384.8999999457, 6942685.000000716), 'coordinates': [[[5.47091013059277, 49.497205021307316], [5.461779526865532, 49.45269148820623], [5.529099312496952, 49.40737462727894], [5.634565984546506, 49.43743606552824], [5.688147604064061, 49.41510555458638], [5.7317860065833734, 49.31134319109833], [5.719044394768754, 49.215986946434604], [5.765544232834611, 49.19808862805665], [5.7444679167795965, 49.15659587124916], [5.76336075838886, 49.1078799656107], [5.818638375145696, 49.08617366651453], [5.823066740236894, 49.023106618165144], [5.800245290300756, 48.946746057604365], [5.747161790828688, 48.915257872650564], [5.780971762726474, 48.826749431299106], [5.71403634947959, 48.74453330887042], [5.757709339561898, 48.6956983342433], [5.7617670452603855, 48.60939047861274], [5.716089821783749, 48.561424169831746], [5.776211888772464, 48.540359251581435], [5.765154701602298, 48.49649260852762], [5.856069666360069, 48.506844385600004], [5.961559100039155, 48.34989070448248], [6.1167237857285315, 48.35403844101338], [6.178419125638963, 48.39759887801264], [6.566974228865648, 48.41903184703233], [6.584971476704243, 48.460509163634704], [6.699498339648206, 48.413087540770555], [6.815166528707746, 48.398846200580046], [6.890810652427115, 48.41809431515708], [6.982986004562884, 48.47905957980011], [7.1231653690285635, 48.51359226557106], [7.0793597709732445, 48.536417612714544], [6.982882241286177, 48.61186293046636], [6.844053536871701, 48.62597500457003], [6.754672851450039, 48.66938665044198], [6.692283881384656, 48.67284039539553], [6.658407329856349, 48.708047286296704], [6.5989655709524815, 48.715690797796334], [6.554148775117041, 48.75409250997109], [6.355030133568448, 48.78165892452694], [6.338947107825572, 48.834058199842104], [6.2719777673374155, 48.93313559709069], [6.132207146051101, 48.93472094775403], [6.116898532084445, 48.96783320585781], [6.043435324319258, 48.977477915984394], [6.0449969560102, 49.01041872050658], [5.935399690626693, 49.071852219751314], [5.931603285178867, 49.10910433833667], [6.026149940244402, 49.16511893600301], [5.987627297222746, 49.20961691714645], [6.029385386695151, 49.23047199222701], [5.928530586493156, 49.37550729351067], [5.942619950432161, 49.45289553697136], [5.893401083719672, 49.49690975012321], [5.793930405166044, 49.55124020374713], [5.7152789345945125, 49.5393397855389], [5.659768488051474, 49.55287086490548], [5.47091013059277, 49.497205021307316]]]}, 'attributes': {'CODE_DEPT': '54', 'NOM_DEPT': 'MEURTHE-ET-MOSELLE'}}, 55: {'geometry': {'type': 'Polygon', 'bbox': (414934.20000005106, 6790042.700001144, 549859.0000000268, 6877306.500000899), 'coordinates': [[[0.41281453288908837, 48.95062636770782], [0.3337726147565286, 48.942883562795664], [0.2756400197144905, 48.96474519881211], [0.15647487005382918, 48.92478758357601], [0.12760760912750327, 48.9522190708013], [0.05639799250069023, 48.90246403867087], [-0.058807463588442944, 48.85358688784485], [-0.14634308820607453, 48.83444909950848], [-0.3059210867390902, 48.85830715301278], [-0.3462445710154035, 48.82199914076007], [-0.41151869249428263, 48.87014004742435], [-0.4637527288822014, 48.87136647589269], [-0.71467861188995, 48.79986774273136], [-0.8409353560137907, 48.75222016384713], [-0.7989559815697852, 48.71018883782028], [-0.7526143435139788, 48.617618520546905], [-0.7741715461672711, 48.56267832834257], [-0.8603629154348665, 48.50145849653701], [-0.757281139754533, 48.43655146992741], [-0.6539938321279776, 48.4442821157106], [-0.551717783599479, 48.473117087367115], [-0.5050654278707287, 48.50579601257741], [-0.43075405116635984, 48.51181992420755], [-0.3676233888648984, 48.49294431514273], [-0.2782279440483006, 48.506988913226], [-0.20693829348513584, 48.5629447591783], [-0.16938268000563234, 48.53697035218057], [-0.14871347253945771, 48.45806753463183], [-0.05189625619319167, 48.453259769855784], [-0.05453120471342507, 48.38200345783028], [-0.002558831894627075, 48.39731388623217], [0.062488371910724295, 48.38221653184688], [0.11624508246972828, 48.43555379653748], [0.2958599914991128, 48.48017405402528], [0.36395898803578647, 48.45163268084123], [0.3826045470591676, 48.33382739377157], [0.4875722818038879, 48.307800269645206], [0.5359730618565093, 48.24984731425016], [0.6832238274745249, 48.248585603870666], [0.7378268325294973, 48.18907227443458], [0.7976558384942257, 48.19445221756441], [0.830483470832425, 48.21071322673855], [0.7621929543543114, 48.30687661402512], [0.7854319060188932, 48.34042724029942], [0.8833710269390447, 48.35667269478065], [0.9422407728065412, 48.399001153466926], [0.9665513231299335, 48.52274528509245], [0.8506421037670122, 48.58262673082052], [0.8148191028635929, 48.670167960202036], [0.7305886446296782, 48.70520779867271], [0.7749590431141302, 48.73752726459962], [0.7335062460350482, 48.78336423504], [0.610293808614185, 48.831314149046584], [0.552503008373062, 48.87553783158533], [0.4573579962478973, 48.8797624818295], [0.3861893489650427, 48.91041450586637], [0.41281453288908837, 48.95062636770782]]]}, 'attributes': {'CODE_DEPT': '61', 'NOM_DEPT': 'ORNE'}}, 56: {'geometry': {'type': 'Polygon', 'bbox': (833932.999999959, 6504924.000001975, 943609.5999999304, 6603737.100001686), 'coordinates': [[[5.310560613770374, 46.44676642071993], [5.215064143095116, 46.468359273121635], [5.201145108499203, 46.50820950515938], [5.052374107055715, 46.484872844561956], [4.940023082647429, 46.51719845218093], [4.891817622919295, 46.43991436571949], [4.8882077017045455, 46.40298160185772], [4.810994882268941, 46.259921516975695], [4.780213475718984, 46.17667702271943], [4.797433206939167, 46.14070146436191], [4.750325275584826, 46.09414996659717], [4.739530214170902, 46.04720888365033], [4.7546312797683195, 45.973622014972776], [4.7290969212308775, 45.94909221230223], [4.8645021533563355, 45.90461654376237], [4.923799133458053, 45.80399936996719], [5.101067478338776, 45.813378082643716], [5.191532760208242, 45.77168800093884], [5.266894883868228, 45.78936901099023], [5.309169396437732, 45.85493340191014], [5.353827195805032, 45.88327273564147], [5.434944676804955, 45.831093776494356], [5.42264142008713, 45.80712379566383], [5.54554159780885, 45.71359345746494], [5.623748035268077, 45.613268326764235], [5.68918710219464, 45.648501612399514], [5.704119379498134, 45.71092632945925], [5.7761608991802635, 45.729222395584365], [5.78685622417971, 45.82295599649888], [5.831226413621035, 45.938459578293276], [5.809643351753075, 45.989799603818724], [5.807622444833504, 46.06393497838283], [5.832300912634431, 46.105995858563126], [5.956063159932632, 46.13208943594275], [6.033127717153323, 46.23799614420538], [6.124247271884754, 46.25101201647224], [6.102638404712804, 46.285063966079505], [6.1697416603127335, 46.36793686221594], [6.06400848181829, 46.41622698893158], [5.986841317727858, 46.36487308875812], [5.908938421371525, 46.28395162005961], [5.849846074176258, 46.262063603326204], [5.725183003095842, 46.26072920479401], [5.714717731644378, 46.30876884774597], [5.649339135998929, 46.339491033036424], [5.542037828826234, 46.270201908707485], [5.4730553115738125, 46.265063763323525], [5.4377951138533165, 46.315112971225524], [5.373462288620209, 46.3522363046852], [5.377044586181938, 46.38135905559838], [5.307691028342544, 46.41681731886727], [5.310560613770374, 46.44676642071993]]]}, 'attributes': {'CODE_DEPT': '01', 'NOM_DEPT': 'AIN'}}, 57: {'geometry': {'type': 'Polygon', 'bbox': (522873.2000000755, 6164532.000002834, 632373.2000000293, 6247681.500002648), 'coordinates': [[[0.8583056667230173, 42.825719089084565], [0.9273318147672923, 42.789260220632244], [1.0751084975718936, 42.785350960627355], [1.161848153380759, 42.711046329846056], [1.2302117813358224, 42.727586080760815], [1.3250261279091804, 42.723903970602294], [1.3895996264494759, 42.685082877157555], [1.4350544962266254, 42.60607634725265], [1.549248343808621, 42.65577628584995], [1.6014701367981332, 42.6280393270752], [1.6873586751619767, 42.6239041279916], [1.7861250110638967, 42.57362343207799], [1.8744850028357225, 42.58140598425574], [1.9717596461471247, 42.616920493794225], [2.0005149149001977, 42.66156483553949], [2.166053682054993, 42.66391836976537], [2.1758741195218594, 42.68279522431071], [2.057204243184995, 42.75622286126001], [1.955395663529541, 42.73670079860324], [1.9081798281291236, 42.76766704348015], [1.8804739886198156, 42.85266926902656], [1.9869209142233524, 42.87101168756068], [1.9851004481943353, 43.02627232234244], [1.9411328732906326, 43.052715472626794], [1.9494758652019253, 43.11949443816388], [1.8247721988689323, 43.14581388915543], [1.7100564477992013, 43.18969803410906], [1.7238440687530254, 43.224524250769115], [1.6884197209147513, 43.27355372810057], [1.6372035311274429, 43.255115354491736], [1.5475200495883703, 43.275674269255795], [1.4637105789844818, 43.21060079806063], [1.4253606535844838, 43.256571535866804], [1.343651969634677, 43.315606054765574], [1.2933102990704721, 43.28533747712766], [1.374373433475401, 43.213745765705475], [1.3146078107375305, 43.189994724436794], [1.2274806300813905, 43.183893105810554], [1.2087344680123453, 43.11795105080999], [1.124082084454217, 43.156907404761874], [1.0589125480141455, 43.14182620134694], [1.0388356827344094, 43.100552820032334], [0.9851687313481595, 43.0670562815733], [1.0070461604480831, 43.00759100643923], [0.9791013887263271, 42.974430961914464], [0.8749113719387422, 42.957775746315384], [0.8324133769327763, 42.91998800205094], [0.8583056667230173, 42.825719089084565]]]}, 'attributes': {'CODE_DEPT': '09', 'NOM_DEPT': 'ARIEGE'}}, 58: {'geometry': {'type': 'Polygon', 'bbox': (560988.4000000468, 6426078.100002187, 663287.6000000116, 6517796.40000193), 'coordinates': [[[1.2531518386328941, 45.44421907802489], [1.2596039598397974, 45.39834890279054], [1.3227969726587214, 45.38265936136428], [1.2271194403372112, 45.27197997099901], [1.2774962889939254, 45.242082419122035], [1.2965184989870582, 45.14018882562906], [1.3864424774272142, 45.10288137852406], [1.4482615439322117, 45.01931315867412], [1.5357253751118871, 45.04628038727674], [1.6509837683346413, 45.02501608647886], [1.7506251087427585, 44.954959479535844], [1.8239145263410472, 44.92768244845702], [1.9081561620078975, 44.978426771844745], [2.0629142919730623, 44.97650640551568], [2.132978967739458, 44.98552052019752], [2.09515947189117, 45.05602988503961], [2.1717556853734434, 45.08149587397568], [2.21369697618154, 45.16019264015236], [2.195361138057307, 45.22085230029842], [2.2714136874802597, 45.29015191925769], [2.3504794408656373, 45.32755821486311], [2.378246243484016, 45.414305790766505], [2.4418608930121475, 45.38425846985713], [2.4874679068775096, 45.418838410808995], [2.5084086971130826, 45.478498798744894], [2.5163323173042995, 45.55342661392318], [2.46534961788347, 45.600822875828726], [2.514296706686258, 45.63953208017773], [2.528364779747827, 45.681924336473784], [2.4921255582417543, 45.73767009540711], [2.4358558482207813, 45.6992750614443], [2.3491828014700613, 45.70947892430512], [2.3377545093277403, 45.680604829561815], [2.1939584682323856, 45.69904710388091], [2.1743533542862306, 45.732215961682584], [2.1135454727593443, 45.7247750650252], [2.0176087689830706, 45.75549036080031], [1.8987307791829435, 45.69827755120417], [1.8713480467629338, 45.66465827008339], [1.7838678002323443, 45.680363378073274], [1.637663451137719, 45.580351909123976], [1.5571958047036878, 45.54936632471635], [1.4803697950912305, 45.565943138308214], [1.4120589140520188, 45.52808103157582], [1.3500778792847676, 45.46688830500584], [1.2870567570435636, 45.48993789201237], [1.2531518386328941, 45.44421907802489]]]}, 'attributes': {'CODE_DEPT': '19', 'NOM_DEPT': 'CORREZE'}}, 59: {'geometry': {'type': 'Polygon', 'bbox': (987690.6999999384, 6711033.600001389, 1044907.7999999225, 6809400.400001105), 'coordinates': [[[6.846179818400713, 47.822945197015315], [6.863475516127668, 47.78516087450236], [7.015960767929834, 47.7432327394991], [7.0463147529081755, 47.67150171049488], [7.004983231421509, 47.61938273175806], [7.086270201422719, 47.592562199673935], [7.130345969302942, 47.50302658240902], [7.1730769339875815, 47.44718259366282], [7.246297061693767, 47.42220209989128], [7.301734408679474, 47.43781547828918], [7.403411294214605, 47.43552354218886], [7.5067536714993555, 47.49563386054376], [7.503407577023023, 47.541980294952374], [7.584705904821392, 47.577264323429596], [7.59279821775334, 47.60177705410432], [7.5223457901007045, 47.662321489865825], [7.513752001020269, 47.70281805791821], [7.548078387714245, 47.73958664485912], [7.53125975560987, 47.7867580927562], [7.556704620769355, 47.87994110575864], [7.622090012011824, 47.972273158298435], [7.571623278915892, 48.030379632553476], [7.577312855212314, 48.120368521818186], [7.519368638022094, 48.12611186664675], [7.470560946722399, 48.16101452404043], [7.476943375699937, 48.203536684298435], [7.348562541549848, 48.24719461957468], [7.275183721811301, 48.3052347870644], [7.1982815370299456, 48.310467861035285], [7.133555808547297, 48.2459405500217], [7.058912798901163, 48.137266371556045], [7.0018837438588974, 48.022399095831126], [6.943356419805964, 47.99795794687724], [6.9002133351392665, 47.89119137272693], [6.920034363859817, 47.850287916338964], [6.846179818400713, 47.822945197015315]]]}, 'attributes': {'CODE_DEPT': '68', 'NOM_DEPT': 'HAUT-RHIN'}}, 60: {'geometry': {'type': 'Polygon', 'bbox': (476861.20000005513, 6629764.700001611, 576079.4000000309, 6735350.200001305), 'coordinates': [[[1.3266655450453901, 47.18622542473183], [1.2769082168277979, 47.25470690394851], [1.2235368646048153, 47.29408083062269], [1.1620645187006389, 47.27219609172917], [1.108127082601409, 47.298398043931414], [1.1228353402815723, 47.3540166709069], [1.107483394852318, 47.41132542515624], [1.1323641891067446, 47.446466657485615], [1.0452908534068053, 47.53148801134605], [1.0763363652479017, 47.56322155433425], [1.0333525357335176, 47.60701157047619], [0.9190111731399371, 47.63260906010327], [0.8595037193186882, 47.669207269910096], [0.7353105618986358, 47.695401801856676], [0.6144311990931562, 47.69421364606964], [0.542891970097039, 47.65620713810867], [0.45663070361835567, 47.6388264115843], [0.3789609617763965, 47.569104055270486], [0.23000172635318558, 47.608398291933725], [0.20150312551615193, 47.54432775642865], [0.2201092524013729, 47.50195329713316], [0.18528045906678395, 47.424733449390764], [0.07897484723536348, 47.2828247550667], [0.05382761471070627, 47.16373008265531], [0.07637120084195272, 47.12393194888828], [0.1361309026819461, 47.121580554147556], [0.17422061595767963, 47.07127519606648], [0.29823142261819774, 47.05391872520874], [0.3007362572498841, 46.97382765864786], [0.43870966025366004, 46.92958207105911], [0.5061414593305561, 46.959247361736196], [0.5983482495759445, 46.95676414686087], [0.5669489614197064, 47.002270374441686], [0.692569282364634, 46.974307063017875], [0.7043243920507868, 46.90329335315587], [0.790328495561799, 46.852391083185985], [0.811901784063939, 46.7945079647172], [0.8674688807081565, 46.74821910504852], [0.9888132945329698, 46.76154066839271], [1.0498776400419196, 46.980640418735526], [1.0776154683629746, 47.01584239818827], [1.1614221724181906, 47.03962297281958], [1.2730568495660926, 47.037834138185595], [1.3116729094606134, 47.09697527344035], [1.365360999707624, 47.12205127770922], [1.3266655450453901, 47.18622542473183]]]}, 'attributes': {'CODE_DEPT': '37', 'NOM_DEPT': 'INDRE-ET-LOIRE'}}, 61: {'geometry': {'type': 'Polygon', 'bbox': (634421.5000000035, 6986161.900000591, 788005.7999999913, 7110430.10000027), 'coordinates': [[[2.0677120276110013, 51.006505154674734], [2.0976005370808024, 50.99842720037966], [2.183904561046441, 50.88345246926367], [2.2134304216785434, 50.81054861627207], [2.3408910264767204, 50.740906325444854], [2.4077924267844706, 50.67276560280949], [2.495948921017839, 50.63124494194659], [2.630516060197486, 50.61795150536654], [2.713850503520111, 50.631292253556424], [2.769040910019394, 50.66367813930791], [2.8404494526472543, 50.656566351404415], [2.8051660601438893, 50.60327122820495], [2.8259824668620874, 50.52538845143164], [2.898951858432468, 50.501557815670935], [2.9647097377674005, 50.51277802080956], [3.0207925423124586, 50.48176905741164], [3.037672306035308, 50.441640098051245], [2.993078464231492, 50.379846956524474], [3.173376482382538, 50.24110767126835], [3.1561320895920617, 50.1837151514849], [3.0957569207512843, 50.12420173434517], [3.090253620620082, 50.0537405551461], [3.1727072271768164, 50.011994944690635], [3.2305405050170397, 50.03130959187674], [3.2801740988851327, 50.01518255081814], [3.352982036655549, 50.03585934468007], [3.4913598357111555, 50.01885605080664], [3.54484649487849, 50.053793955280256], [3.6136399192005855, 50.025418579188496], [3.715184685025503, 50.06927463597468], [3.7463798889650577, 50.05360423498406], [3.923501465982154, 50.02643067661838], [3.9803763118726985, 49.995376086949776], [4.087128504749609, 49.969187585423256], [4.140895251736091, 49.97875959900575], [4.162223866832849, 50.048984846947924], [4.227998848506976, 50.0663716441179], [4.199886857285581, 50.13107752153304], [4.126926892460068, 50.13501086615994], [4.160120194753327, 50.202535967152805], [4.221850100147641, 50.2569526030574], [4.136656244682008, 50.27430028767412], [4.037614330208127, 50.342949130962005], [3.967898522087576, 50.35036640689913], [3.889799951126813, 50.32998024473762], [3.852755582095813, 50.35159288087616], [3.747403815562772, 50.35092914841262], [3.694426981658981, 50.31582758313083], [3.658270970690328, 50.371341179611775], [3.6642184777732343, 50.453174658802986], [3.613009891798258, 50.4924694652765], [3.4739635628750074, 50.53356175115673], [3.3738916027191275, 50.491824935733376], [3.2865173191905384, 50.5275758381365], [3.248509229627794, 50.63804120854452], [3.2583710099316026, 50.700649521314936], [3.1912194219619847, 50.72440644617065], [3.1519976780893755, 50.782343296693874], [3.0613770323899683, 50.780500851248156], [2.938073313612885, 50.74434123804409], [2.8983800599236966, 50.694236112980164], [2.813275390169948, 50.71694763018353], [2.717481067754576, 50.813607735175225], [2.6349827331217086, 50.812756418772004], [2.599594701801672, 50.85333434261119], [2.6326872836805335, 50.9460051993682], [2.5759824197772865, 51.01375274756831], [2.543034614375203, 51.088542812197964], [2.4247542826080695, 51.05562611742251], [2.3478396554296364, 51.05983236212976], [2.1097003640363865, 51.00382398081887], [2.0677120276110013, 51.006505154674734]]]}, 'attributes': {'CODE_DEPT': '59', 'NOM_DEPT': 'NORD'}}, 62: {'geometry': {'type': 'Polygon', 'bbox': (981470.1999999387, 6711078.800001388, 1010785.5999999286, 6753957.700001263), 'coordinates': [[[7.130345969302942, 47.50302658240902], [7.086270201422719, 47.592562199673935], [7.004983231421509, 47.61938273175806], [7.0463147529081755, 47.67150171049488], [7.015960767929834, 47.7432327394991], [6.863475516127668, 47.78516087450236], [6.846179818400713, 47.822945197015315], [6.823538854548164, 47.81305372460474], [6.757638483670511, 47.74787796649103], [6.780404771904785, 47.62526070546138], [6.806992048333124, 47.56280181879932], [6.905669627634238, 47.54736152102865], [6.907609859823659, 47.49454608019354], [6.940536510867673, 47.43337372142234], [6.9989628186755155, 47.45229903123539], [6.983118836626173, 47.493302817356295], [7.079276690803702, 47.48886399588566], [7.130345969302942, 47.50302658240902]]]}, 'attributes': {'CODE_DEPT': '90', 'NOM_DEPT': 'TERRITOIRE DE BELFORT'}}, 63: {'geometry': {'type': 'Polygon', 'bbox': (282805.7000000984, 6649967.800001572, 402393.3000000701, 6756672.500001258), 'coordinates': [[[-1.245882346289053, 47.77671754769666], [-1.3528642478531776, 47.79769264008963], [-1.390427968841582, 47.8282808011693], [-1.5934074072820477, 47.776050091798155], [-1.6548203169539597, 47.712592802370295], [-1.7724163023563166, 47.69845339610201], [-1.8640133393104226, 47.70698467056552], [-1.9690539759076375, 47.688369032584816], [-2.097035597340285, 47.631359844030904], [-2.1073336439134778, 47.53105690026967], [-2.312868292914679, 47.46446874949351], [-2.458489165173328, 47.44812172073537], [-2.5341025675524804, 47.38296506335946], [-2.513805375083308, 47.29837226752572], [-2.447540278501031, 47.26175565750243], [-2.3983809001599146, 47.28144600128063], [-2.301643363345211, 47.23640440230942], [-2.1873645299124607, 47.28061948954126], [-2.1583713304619323, 47.20905347869719], [-2.1670644777818073, 47.16618049901816], [-2.2268232180853564, 47.130940362387484], [-2.0534725301465024, 47.09412159709032], [-1.9804144867428743, 47.0289064940757], [-1.9432276192598639, 46.99471092059498], [-1.8309821821134142, 46.93203372415455], [-1.751062300240369, 46.92959568215281], [-1.689761273986443, 46.89049286319811], [-1.5485110748777007, 46.86007983436473], [-1.5007668577856454, 46.883891152829825], [-1.553563697237001, 46.98150474523176], [-1.5523222833408639, 47.01834875737963], [-1.4821311833973978, 47.037861989589345], [-1.4561316296061408, 46.9262728543553], [-1.372985770094949, 46.952184466609765], [-1.3786124689367807, 47.03085386698659], [-1.2946349782361026, 47.03948346966519], [-1.271206708715037, 47.08389319899781], [-1.148570488753439, 47.02954516258661], [-1.1154625363954844, 47.06256455498828], [-1.231145713608837, 47.10995454752673], [-1.2352482689031186, 47.138781593625], [-1.1632160710080464, 47.177784087549064], [-1.197721609765016, 47.25058116645219], [-1.254174750571894, 47.249856282378325], [-1.305108502227792, 47.30316997819655], [-1.2998771573086003, 47.337623665323264], [-1.1676096980775446, 47.3658872351569], [-1.0178737847602017, 47.36506226318966], [-0.9464433335100002, 47.386466852357906], [-0.967482555917903, 47.49280029691797], [-1.1572331855798583, 47.510083069606296], [-1.172416066194653, 47.573007547192], [-1.04590950407258, 47.56335191106957], [-1.0068639898836451, 47.58905339489957], [-1.1382017900650392, 47.61945704786123], [-1.174929569150147, 47.69456501384606], [-1.2545772523262646, 47.73364175152335], [-1.245882346289053, 47.77671754769666]]]}, 'attributes': {'CODE_DEPT': '44', 'NOM_DEPT': 'LOIRE-ATLANTIQUE'}}, 64: {'geometry': {'type': 'Polygon', 'bbox': (689262.3000000024, 6692939.9000014225, 799826.7999999784, 6810077.50000108), 'coordinates': [[[2.9765380120036067, 47.56942879711261], [3.0256381393798466, 47.55875277695222], [3.10199661377424, 47.58795617120518], [3.122046633548593, 47.54104902333157], [3.2046491761957805, 47.522966343587036], [3.2354769572493565, 47.48917911094726], [3.307051239784071, 47.49471952596054], [3.3463147218972584, 47.47243811385125], [3.397288000265388, 47.50886749595521], [3.487879079980051, 47.49392259510358], [3.513504992889226, 47.527668013758365], [3.5806168100615214, 47.4978632363306], [3.5801133565565157, 47.46490071650617], [3.6789914842274656, 47.445533677890616], [3.7147823454353084, 47.4068346666404], [3.7856341851420208, 47.39054233152033], [3.9706779602609212, 47.378314438290566], [3.9730845789314024, 47.332712785374405], [4.106085850126875, 47.339255985508295], [4.066060118363545, 47.40725128721289], [4.119426533664949, 47.44355339332813], [4.11550026231875, 47.515008579609585], [4.17512808182493, 47.553259163229534], [4.212381292101605, 47.62796570433968], [4.268422869492533, 47.68140992396884], [4.2581642665265, 47.727402970861355], [4.332471702607339, 47.75651131040829], [4.324394417243652, 47.84715746363825], [4.2610008241447535, 47.84385063868308], [4.293424106945006, 47.92567623485384], [4.199158053352665, 47.969941402526324], [4.1117857473984065, 47.926995657533396], [3.9020865465480417, 47.93917007405486], [3.850029315571996, 47.983792407228414], [3.8049683849961107, 48.10254956016535], [3.74029124579523, 48.16970783295086], [3.667869602845747, 48.13921190362745], [3.6216038851697063, 48.225740470572575], [3.6168043332338455, 48.27133989892491], [3.498152764099384, 48.36909719474052], [3.4147915595010963, 48.390273038835076], [3.3651592673815314, 48.372280687121055], [3.167737573570585, 48.371860839541355], [3.0495188960927044, 48.36012035558039], [3.043627253848888, 48.272022357627314], [3.0051556578134635, 48.20767000036064], [2.936314411640624, 48.163391744163064], [3.0294654865478936, 48.13320717201311], [3.0504714242752176, 48.072334131140266], [3.088317798651479, 48.05393639482615], [3.1284501214452565, 47.97097324036124], [3.0501042789379826, 47.911447449150145], [3.0102926272319244, 47.90471697202151], [3.023798094359226, 47.78655467901546], [2.9350577707343026, 47.76324627617625], [2.8566660682192713, 47.76092647079024], [2.8585180302225814, 47.71199289202641], [2.9231098081748264, 47.680559698484025], [2.937999037836789, 47.598884707750514], [2.9765380120036067, 47.56942879711261]]]}, 'attributes': {'CODE_DEPT': '89', 'NOM_DEPT': 'YONNE'}}, 65: {'geometry': {'type': 'MultiPolygon', 'bbox': (306739.2000000799, 6738013.600001321, 400464.5000000602, 6855953.00000098), 'coordinates': [[[[-2.006894935706841, 48.5661129019979], [-2.0486879074738513, 48.63697592733373], [-2.1237080247752878, 48.60441002857454], [-2.0759838668732145, 48.5676791967517], [-2.006894935706841, 48.5661129019979]]], [[[-1.0701645143702028, 48.5084938142048], [-1.2065557263083735, 48.542205944555754], [-1.272248493564724, 48.533924823069405], [-1.377245885097968, 48.45828455073839], [-1.489947435142363, 48.48937484762061], [-1.5189153941473388, 48.566594219597484], [-1.5710871213263624, 48.626445743066476], [-1.76415180087166, 48.603560368616066], [-1.8450734275301919, 48.6163682505842], [-1.8716564802790987, 48.64741056212522], [-1.8561321209072548, 48.70485450482966], [-1.9698282134951812, 48.6863231253415], [-2.0289596768793032, 48.64691471299467], [-1.948036901044388, 48.538807904896906], [-1.912490070435076, 48.51884141990099], [-1.9548327221541812, 48.317109845306696], [-2.014100529199394, 48.27953190981906], [-2.0532925486538467, 48.29832786131652], [-2.110118931164645, 48.25290348209337], [-2.1869612472272935, 48.24637857004592], [-2.2247373292770813, 48.17059701878943], [-2.287278430400509, 48.13374556347385], [-2.2332446439270153, 48.075627876360535], [-2.279595013670352, 48.02636073133588], [-2.2395935242179426, 47.999461627992105], [-2.1368653813504146, 47.979116800921744], [-2.079088544973961, 47.91952249841043], [-2.1162985684590634, 47.88095628990024], [-2.049526070392867, 47.8169173979452], [-2.0897121808782697, 47.73856050587445], [-2.131472084919134, 47.72224026217332], [-2.097035597340285, 47.631359844030904], [-1.9690539759076375, 47.688369032584816], [-1.8640133393104226, 47.70698467056552], [-1.7724163023563166, 47.69845339610201], [-1.6548203169539597, 47.712592802370295], [-1.5934074072820477, 47.776050091798155], [-1.390427968841582, 47.8282808011693], [-1.3528642478531776, 47.79769264008963], [-1.245882346289053, 47.77671754769666], [-1.2382517343256672, 47.80999146298689], [-1.1891839990021345, 47.86797794678786], [-1.1539940378788567, 47.96582099565702], [-1.1026711686637312, 47.989062782913926], [-1.0212610284765595, 47.99494016249541], [-1.0232833455698913, 48.068911203167616], [-1.049606089398749, 48.08980493061712], [-1.1000610480389637, 48.259280121227064], [-1.045019529962301, 48.32772783001587], [-1.0827940655347768, 48.43305823169245], [-1.0701645143702028, 48.5084938142048]]]]}, 'attributes': {'CODE_DEPT': '35', 'NOM_DEPT': 'ILLE-ET-VILAINE'}}, 66: {'geometry': {'type': 'Polygon', 'bbox': (334282.70000014844, 6275534.700002595, 470768.600000088, 6389853.100002306), 'coordinates': [[[-1.5248665484221002, 43.529701346690175], [-1.4766198669954693, 43.53918405640505], [-1.4177740978933993, 43.49776692584465], [-1.2911822396099, 43.49820457476763], [-1.1708199655376668, 43.54560988391769], [-1.109247829938908, 43.51412989565146], [-0.9933935609538049, 43.50538804684222], [-0.8966906468904682, 43.55048921576576], [-0.7817805196343679, 43.56416715906691], [-0.7153911507395094, 43.54111406021413], [-0.670807186170969, 43.5667169721835], [-0.5571744316529481, 43.542797175106294], [-0.4482922578476383, 43.59608922647162], [-0.40604194753689593, 43.56822563862113], [-0.30369046804673383, 43.56027685025606], [-0.24283655874306653, 43.584976209013746], [-0.23258236946731695, 43.71408748429121], [-0.19414330237233957, 43.737016685694776], [-0.19099217321599454, 43.87518333615964], [-0.23393876198189914, 43.89106775010974], [-0.179109059517904, 43.93791976442846], [-0.07359844651969293, 43.94504687607575], [0.03255676418092499, 43.90018804605394], [0.07664688901342062, 43.91647114312968], [0.07604560969926165, 43.983143136582996], [0.0626980132929106, 44.00084249917973], [0.10082062971801486, 44.08677044167006], [0.13510828700872454, 44.12422070347961], [0.034593843822210965, 44.130652403429636], [-0.004232390832891391, 44.149995950868565], [-0.12915451548994408, 44.15240992875165], [-0.1406884798527575, 44.22640474768996], [-0.19411335198198013, 44.26904045949542], [-0.22344709828329368, 44.2058982638019], [-0.27211852903661043, 44.19380924623565], [-0.38961736206091657, 44.20948462715681], [-0.38338729038705477, 44.28631066773667], [-0.43183954131517804, 44.32257705443095], [-0.5176354697700609, 44.33911112646842], [-0.528103107297291, 44.36465404326292], [-0.6276476111842922, 44.398145662533665], [-0.6287774027434521, 44.443192240874644], [-0.7307029568976166, 44.446374662072614], [-0.8452736279017048, 44.418974549624686], [-0.9191704541834166, 44.443344362596065], [-1.0074534242441229, 44.4376523913387], [-0.9806969914576474, 44.482878935537535], [-1.0851664955491238, 44.532194571677685], [-1.1064909647292611, 44.50277289133715], [-1.2538901028077136, 44.467604212346195], [-1.3123241886692378, 44.144802425789784], [-1.3749866629484853, 43.91378891976503], [-1.4365038283323686, 43.71056513002188], [-1.448204124676214, 43.64227785427411], [-1.5248665484221002, 43.529701346690175]]]}, 'attributes': {'CODE_DEPT': '40', 'NOM_DEPT': 'LANDES'}}, 67: {'geometry': {'type': 'Polygon', 'bbox': (124277.10000010568, 6761104.000001276, 223352.10000009876, 6867490.700000975), 'coordinates': [[[-3.6591438196705726, 48.65920978068336], [-3.660936253648766, 48.69406986743352], [-3.8323800958932193, 48.71193803705031], [-3.864417712752576, 48.67033253739846], [-3.9494602787296564, 48.652859530177146], [-3.975748942975551, 48.699033371438986], [-4.186935690423403, 48.68646122791495], [-4.272767520288336, 48.64958226193913], [-4.351408108864256, 48.67611752116847], [-4.4627626687883355, 48.627102278372654], [-4.5614755513739285, 48.623803539462266], [-4.630604970514316, 48.57769163688516], [-4.730582004767841, 48.55634921053221], [-4.7754733948519, 48.49100463763031], [-4.793344007924671, 48.41623318233541], [-4.760909970272354, 48.37274934623393], [-4.608723907528041, 48.33788748523839], [-4.424948261340764, 48.397597431917745], [-4.441760780702185, 48.35361514080612], [-4.302158218411379, 48.34377660540236], [-4.30803032884924, 48.29716811392344], [-4.38449955320125, 48.275155727113344], [-4.423777088962563, 48.291668243167024], [-4.566613794720501, 48.286343567289286], [-4.5640238131019215, 48.232230611582196], [-4.448362289029716, 48.235630356768205], [-4.301125453787073, 48.191446905097344], [-4.2717344631091825, 48.13305570981134], [-4.306988535338466, 48.0891826157327], [-4.374400199477132, 48.11016030592404], [-4.488600722253488, 48.086471142269296], [-4.668222169685978, 48.070200318653285], [-4.72303043310844, 48.03359626570833], [-4.453570861423827, 47.9817743919044], [-4.362572451765144, 47.889262907304484], [-4.3624185212011595, 47.79574368618671], [-4.192310067833884, 47.79738016645037], [-4.163559448578026, 47.84918510805773], [-4.077726475728434, 47.866526585168934], [-4.041588845349635, 47.84599945335797], [-3.9115007019573893, 47.87028016364022], [-3.902476125408803, 47.83593985815641], [-3.8006004190720035, 47.787632394585984], [-3.732543627824175, 47.8029267390027], [-3.6808401232958046, 47.77678956846737], [-3.532308891348817, 47.7682788561134], [-3.5230042934996066, 47.84914685715857], [-3.4034429894056712, 47.87011455487806], [-3.392624522513051, 47.95445115827384], [-3.4848124678130397, 47.966889784603126], [-3.5552758457516056, 47.99309847047771], [-3.6402315330750725, 47.98524271313111], [-3.695020686823403, 48.093494659480534], [-3.695838514922977, 48.15221175123511], [-3.5648389737333277, 48.185746943072594], [-3.5184407178728905, 48.28227314703523], [-3.55678682574261, 48.33551998788199], [-3.5545842830629746, 48.37776678484624], [-3.59041542299311, 48.42892323447733], [-3.6040613963215824, 48.496439468782384], [-3.5538598863227366, 48.540920771753676], [-3.6493779946144076, 48.61015334623436], [-3.6591438196705726, 48.65920978068336]]]}, 'attributes': {'CODE_DEPT': '29', 'NOM_DEPT': 'FINISTERE'}}, 68: {'geometry': {'type': 'Polygon', 'bbox': (916991.9999999349, 6514709.9000019515, 1013274.7999999039, 6596473.600001719), 'coordinates': [[[6.802516663522652, 45.77837197402202], [6.81807863673278, 45.83497696816754], [6.939604939153821, 45.846732106422444], [6.991719912014906, 45.868199872091495], [7.043893795018055, 45.92208520277864], [7.01824561421289, 45.98418643361584], [6.951511564566567, 46.049956099423994], [6.8914542235903, 46.08449157208843], [6.898381393099357, 46.122562070394125], [6.81473216290061, 46.129696461365256], [6.803660834214749, 46.20434524954359], [6.864509851829646, 46.28299076988357], [6.782637056089519, 46.33688407311208], [6.795664927569208, 46.393092558626826], [6.722868985320351, 46.407553897804995], [6.545175304790925, 46.39472735936461], [6.3900361566872315, 46.34016563406093], [6.326997851713536, 46.37112568338632], [6.2799119246622785, 46.351094432713545], [6.237797813525851, 46.277334258516746], [6.295655645057157, 46.22605896768262], [6.232071540724356, 46.20547030935738], [6.17507237787808, 46.158149899601725], [5.956063159932632, 46.13208943594275], [5.832300912634431, 46.105995858563126], [5.807622444833504, 46.06393497838283], [5.809643351753075, 45.989799603818724], [5.831226413621035, 45.938459578293276], [5.862101395990038, 45.93240229486188], [5.87342650248464, 45.8380955581268], [5.913209603821916, 45.80414083870233], [6.042939005987317, 45.73909595131257], [6.166233910329838, 45.75571563232783], [6.189714169774869, 45.70416174969227], [6.239679907775352, 45.685404763162644], [6.330635270345084, 45.69553113948386], [6.383851558657904, 45.778055295582284], [6.423672125473555, 45.80244240743697], [6.4705596799701395, 45.88469229739344], [6.509087472467453, 45.908632873298934], [6.552237633503553, 45.82687986970043], [6.6017329724955784, 45.79541992331821], [6.661192099251396, 45.79890547186778], [6.711938518958688, 45.72291967208878], [6.802516663522652, 45.77837197402202]]]}, 'attributes': {'CODE_DEPT': '74', 'NOM_DEPT': 'HAUTE-SAVOIE'}}, 69: {'geometry': {'type': 'Polygon', 'bbox': (605400.9000000112, 6884542.30000087, 711647.6999999984, 6962826.200000654), 'coordinates': [[[1.7043642065965872, 49.23220177517624], [1.7421373979981685, 49.18015527803753], [1.795468686327552, 49.1852591252518], [1.8852389528169071, 49.162637864554874], [1.9968226136719949, 49.17644980801165], [2.080887804244836, 49.20977574825314], [2.252488213818398, 49.15288152247387], [2.310929044686543, 49.18640655834875], [2.346257050814552, 49.16181582457663], [2.440902617873646, 49.14580320715759], [2.5905242793946224, 49.079654846745605], [2.633272965218076, 49.108376218976154], [2.735012683493696, 49.060449825264335], [3.0085155429257675, 49.09151015781777], [3.071884293834167, 49.11755421882924], [3.1396578896700365, 49.152576953647774], [3.0640875194145396, 49.192738575710244], [3.0268878942941857, 49.27553205720364], [2.97439031593416, 49.30233884823801], [3.0953874973379834, 49.37711907479379], [3.0937834703774705, 49.43374686814669], [3.1605832452848968, 49.45158976267774], [3.0957783548212805, 49.51340305902506], [3.1314803354793224, 49.543377651804036], [3.0977762246810094, 49.656683091243586], [3.1184031553047866, 49.70596856016259], [2.915712813038834, 49.70267238897875], [2.793612422958185, 49.65595422264364], [2.7994949073615056, 49.62058605182692], [2.6891419821315017, 49.625601863486416], [2.670723151725744, 49.581411971799525], [2.571493337841171, 49.597080627026244], [2.504748899250395, 49.63946726892116], [2.3731456632291623, 49.65626624027031], [2.2471685906926684, 49.70164087682517], [2.121409706926089, 49.688074091756725], [1.933209822166273, 49.71962996350131], [1.8938643249004963, 49.69898823077294], [1.7838370588623418, 49.7583075010794], [1.6895758821118128, 49.694785646272834], [1.7252046142437363, 49.672634359616865], [1.7045819685135708, 49.605398925870894], [1.7451334451250173, 49.5317376936539], [1.719232660445319, 49.508223020119125], [1.766345027141405, 49.4661503637365], [1.7139375433100612, 49.409224988875955], [1.7594117559881142, 49.368149815405616], [1.7756288406360832, 49.299693721359404], [1.710479333974457, 49.264464162192816], [1.7043642065965872, 49.23220177517624]]]}, 'attributes': {'CODE_DEPT': '60', 'NOM_DEPT': 'OISE'}}, 70: {'geometry': {'type': 'Polygon', 'coordinates': [[[1.608796070629922, 49.07789415355113], [1.673689127007117, 49.07815117319748], [1.7234571618642336, 49.044976575520174], [1.823950363006381, 49.07636122205329], [1.9378021652564332, 49.02177632638558], [2.0247730444607908, 48.998755806202006], [2.084914920835883, 49.014678714923626], [2.20585834678071, 48.949740742229906], [2.200591009269504, 48.908679329904004], [2.2909735732251617, 48.950966788090646], [2.366443627637154, 48.974176668580746], [2.4594899596115933, 48.95504632684678], [2.55306064485419, 49.00981711745223], [2.5905242793946224, 49.079654846745605], [2.440902617873646, 49.14580320715759], [2.346257050814552, 49.16181582457663], [2.310929044686543, 49.18640655834875], [2.252488213818398, 49.15288152247387], [2.080887804244836, 49.20977574825314], [1.9968226136719949, 49.17644980801165], [1.8852389528169071, 49.162637864554874], [1.795468686327552, 49.1852591252518], [1.7421373979981685, 49.18015527803753], [1.7043642065965872, 49.23220177517624], [1.6757368125175736, 49.21186705776954], [1.6557774397127956, 49.1301621703505], [1.608796070629922, 49.07789415355113]]]}, 'attributes': {'CODE_DEPT': '95', 'NOM_DEPT': "VAL-D'OISE"}}, 71: {'geometry': {'type': 'Polygon', 'bbox': (690449.1000000023, 6617690.400001641, 793165.4999999772, 6720847.300001339), 'coordinates': [[[4.106085850126875, 47.339255985508295], [3.9730845789314024, 47.332712785374405], [3.9706779602609212, 47.378314438290566], [3.7856341851420208, 47.39054233152033], [3.7147823454353084, 47.4068346666404], [3.6789914842274656, 47.445533677890616], [3.5801133565565157, 47.46490071650617], [3.5806168100615214, 47.4978632363306], [3.513504992889226, 47.527668013758365], [3.487879079980051, 47.49392259510358], [3.397288000265388, 47.50886749595521], [3.3463147218972584, 47.47243811385125], [3.307051239784071, 47.49471952596054], [3.2354769572493565, 47.48917911094726], [3.2046491761957805, 47.522966343587036], [3.122046633548593, 47.54104902333157], [3.10199661377424, 47.58795617120518], [3.0256381393798466, 47.55875277695222], [2.9765380120036067, 47.56942879711261], [2.914297452553034, 47.565970182735285], [2.8746252064056805, 47.5204231125567], [2.928902314704163, 47.4445667358034], [2.8734906167112504, 47.348395958835304], [2.9834041014118906, 47.25976318039044], [2.9816846477683376, 47.22199695725166], [3.0280852399597813, 47.12906768514305], [3.0232152406674615, 47.0626168735247], [3.0757376737966906, 47.01914457943626], [3.0793297925031697, 46.95511875370015], [3.0502941730720203, 46.91063036589826], [3.0680947893123323, 46.877676731330396], [3.0320681893946824, 46.79491118852599], [3.049065356287102, 46.758078941893714], [3.2155498733945853, 46.68289184476872], [3.2697920192933188, 46.71674092869], [3.3467088070518343, 46.684416345410945], [3.4341330414396496, 46.711906067614436], [3.487153284024355, 46.65825255471402], [3.550392218815862, 46.71586467208164], [3.629423683496518, 46.74945902193758], [3.73619002089105, 46.75247120098582], [3.797329518692337, 46.7015026371452], [3.9233937335663804, 46.738872659809324], [3.9919591863262935, 46.77675109754475], [4.062709832615211, 46.78936469128218], [4.056234450174583, 46.8432723767359], [4.093851364443379, 46.874734333229235], [4.037221978317054, 46.918155606841886], [4.039401951235417, 46.98511001230659], [4.072015136934213, 47.054494829385675], [4.038726355028209, 47.08001003428521], [4.06142733788571, 47.12104166410022], [4.115967069915809, 47.12333757652637], [4.181888404407953, 47.15050513981919], [4.209834279044644, 47.15541168354451], [4.230655226496763, 47.19895127921229], [4.178052285148682, 47.25028786310226], [4.135479914723283, 47.23739632414042], [4.106085850126875, 47.339255985508295]]]}, 'attributes': {'CODE_DEPT': '58', 'NOM_DEPT': 'NIEVRE'}}, 72: {'geometry': {'type': 'Polygon', 'bbox': (780392.7999999812, 6648014.700001555, 890264.8999999544, 6771079.900001195), 'coordinates': [[[5.255236339191405, 46.97988809464055], [5.310049747453534, 47.01802089675744], [5.322186205925132, 47.07298220144247], [5.386011880946294, 47.08197711021486], [5.439973300314684, 47.144397191390645], [5.47662851608292, 47.21602767128052], [5.488282961724511, 47.28934747033418], [5.518538729512593, 47.304186619469625], [5.451397515008267, 47.38406251346723], [5.3992024955272315, 47.49901446301566], [5.447063511552308, 47.496253655362246], [5.496859255517603, 47.544144504783], [5.477547427463132, 47.60872207291233], [5.425863186006295, 47.63211377458535], [5.374078595885573, 47.604541652802524], [5.23923227423911, 47.616130098992706], [5.173597037303846, 47.65256871238266], [5.108878229414663, 47.64968494441669], [4.979107142832903, 47.68776283651176], [4.949610301299182, 47.76500253040031], [4.982400768988487, 47.80034738345197], [4.9540942495981195, 47.866768148099524], [4.852043179350451, 47.95623862322436], [4.786512602874469, 47.96420222558574], [4.789083695644796, 48.007829382573114], [4.704238250439468, 48.02023237622195], [4.582678644289108, 48.02946360188037], [4.5599688756782095, 47.97142319627397], [4.448998378066956, 47.957154747586976], [4.3090036167800365, 47.96117328279331], [4.293424106945006, 47.92567623485384], [4.2610008241447535, 47.84385063868308], [4.324394417243652, 47.84715746363825], [4.332471702607339, 47.75651131040829], [4.2581642665265, 47.727402970861355], [4.268422869492533, 47.68140992396884], [4.212381292101605, 47.62796570433968], [4.17512808182493, 47.553259163229534], [4.11550026231875, 47.515008579609585], [4.119426533664949, 47.44355339332813], [4.066060118363545, 47.40725128721289], [4.106085850126875, 47.339255985508295], [4.135479914723283, 47.23739632414042], [4.178052285148682, 47.25028786310226], [4.230655226496763, 47.19895127921229], [4.209834279044644, 47.15541168354451], [4.259600310936345, 47.114326250580596], [4.405487083945716, 47.08164281958388], [4.406283415170732, 47.049999892555036], [4.493691403385164, 47.02837155710412], [4.623230215613321, 46.940820236785605], [4.728129651701317, 46.91937462593796], [5.049303736126249, 46.98158693341572], [5.106281375832607, 46.955765202475504], [5.255236339191405, 46.97988809464055]]]}, 'attributes': {'CODE_DEPT': '21', 'NOM_DEPT': "COTE-D'OR"}}, 73: {'geometry': {'type': 'Polygon', 'bbox': (620310.8000000145, 6798947.800001114, 668471.5000000054, 6853168.000000958), 'coordinates': [[[2.226559327154523, 48.77610203163561], [2.111889242882012, 48.739560198041474], [2.0822212746064093, 48.6858518071185], [2.0200056963818716, 48.64208882253288], [2.0175740602972905, 48.55759738743778], [1.9674261909808524, 48.53307136185833], [1.9221489648373706, 48.45760028607871], [1.9305557503485928, 48.404124841843824], [1.9765777946992389, 48.399384474494646], [1.994084718059379, 48.28658587795807], [2.1813499926674265, 48.313745436024654], [2.369810541415244, 48.308672482875544], [2.402664267131608, 48.320719459436084], [2.4298322285044196, 48.36201578313258], [2.533731834361712, 48.41125114634581], [2.504749755053753, 48.43944601613285], [2.4995246743322403, 48.52523904801557], [2.5437765144069613, 48.60384977115981], [2.5336160068074505, 48.6573313888409], [2.5716603184420737, 48.69201409166007], [2.503536569558129, 48.735211482185626], [2.3707067322771356, 48.72017592254696], [2.3207180175230318, 48.748756235094554], [2.226559327154523, 48.77610203163561]]]}, 'attributes': {'CODE_DEPT': '91', 'NOM_DEPT': 'ESSONNE'}}, 74: {'geometry': {'type': 'Polygon', 'bbox': (404250.7000000758, 6545825.20000186, 485042.7000000638, 6672433.600001494), 'coordinates': [[[0.197353505216163, 46.095550041529755], [0.21492180826491522, 46.13884556432997], [0.1551113740904502, 46.15716824459698], [0.11283682536372723, 46.21093260957406], [0.12883677213786587, 46.26723154899875], [0.177368795982455, 46.328113140597], [0.1375978499402633, 46.34939518270104], [0.07821800902702712, 46.30493353892288], [0.03760223980806839, 46.32552885451106], [0.034219979012944976, 46.37349679947998], [-0.017092824348942017, 46.41132239451375], [-0.031351255287516346, 46.524981019415726], [0.0259896380281596, 46.59474350677765], [-0.040426190194720726, 46.6637170238073], [0.0007042720140899882, 46.71623331657771], [-0.0203163360693799, 46.81265392500657], [-0.009032410299881494, 46.9074770060593], [-0.08769647758766945, 47.02313333571297], [-0.10212095637964697, 47.06479719081804], [-0.18483982751841338, 47.108336996905216], [-0.24153794845204718, 47.10572466544681], [-0.4007795061579291, 47.07077103460962], [-0.495340243761372, 47.08238521770847], [-0.5595318719263798, 47.06188673077483], [-0.5654683969778367, 47.019426143811984], [-0.6199767888274338, 46.9933220656585], [-0.7130578012324342, 46.986072210051866], [-0.7738774456713031, 47.00425220913205], [-0.8919599503022396, 46.97581784960789], [-0.8291443983745105, 46.93336473376703], [-0.7816473761536206, 46.84282850114098], [-0.700856479426351, 46.80862675485134], [-0.7273121698337276, 46.767632454458024], [-0.6561893352875896, 46.700774642460956], [-0.6440639078487055, 46.63802790732369], [-0.6141139330666159, 46.62039039102906], [-0.6021285989587037, 46.5332805477888], [-0.6124259071699314, 46.45873492951781], [-0.6406445679433723, 46.416229245156025], [-0.537800498012109, 46.386465465455736], [-0.5576498721967046, 46.363448573781824], [-0.7504755422947275, 46.304258794361985], [-0.751461997484196, 46.245070221736306], [-0.6907154750130782, 46.21920250569825], [-0.6199574101252711, 46.13775275457059], [-0.5469968076890194, 46.14422952781582], [-0.5060833286611979, 46.106705208008755], [-0.4005083126359273, 46.08471764024758], [-0.281734309419876, 46.079753777667676], [-0.10293687953014628, 45.96965998523801], [-0.04143104082306048, 45.993479981491], [-0.03199529342543973, 46.05592180291532], [0.019272784617025578, 46.05284782935703], [0.07297225926176307, 46.093895909585044], [0.197353505216163, 46.095550041529755]]]}, 'attributes': {'CODE_DEPT': '79', 'NOM_DEPT': 'DEUX-SEVRES'}}, 75: {'geometry': {'type': 'Polygon', 'bbox': (210123.50000008388, 6785524.900001191, 337450.2000000646, 6881072.500000926), 'coordinates': [[[-2.287278430400509, 48.13374556347385], [-2.2247373292770813, 48.17059701878943], [-2.1869612472272935, 48.24637857004592], [-2.110118931164645, 48.25290348209337], [-2.0532925486538467, 48.29832786131652], [-2.014100529199394, 48.27953190981906], [-1.9548327221541812, 48.317109845306696], [-1.912490070435076, 48.51884141990099], [-1.948036901044388, 48.538807904896906], [-2.006894935706841, 48.5661129019979], [-2.0759838668732145, 48.5676791967517], [-2.1237080247752878, 48.60441002857454], [-2.164261352109107, 48.57889313291284], [-2.2239475767870998, 48.595386986551844], [-2.312865288216964, 48.680922821719236], [-2.473428281486321, 48.62251656641612], [-2.6312676669697788, 48.538129672669214], [-2.6815589371179858, 48.53113342752677], [-2.819598830141576, 48.59352827458846], [-2.8269350213521784, 48.650569331562856], [-2.9479038576324976, 48.72721506679855], [-2.9436531177995495, 48.75833756842975], [-3.029396621867139, 48.77591418616988], [-3.1139761137339725, 48.86673762496768], [-3.231756943127047, 48.86741630826664], [-3.4307245025981667, 48.79722346333295], [-3.513199627496447, 48.83499877621907], [-3.585008235573636, 48.775499964709624], [-3.5812485466634114, 48.67001788505634], [-3.6591438196705726, 48.65920978068336], [-3.6493779946144076, 48.61015334623436], [-3.5538598863227366, 48.540920771753676], [-3.6040613963215824, 48.496439468782384], [-3.59041542299311, 48.42892323447733], [-3.5545842830629746, 48.37776678484624], [-3.55678682574261, 48.33551998788199], [-3.5184407178728905, 48.28227314703523], [-3.5648389737333277, 48.185746943072594], [-3.33675473563501, 48.17112526547111], [-3.2722443396278273, 48.14001476485908], [-3.1552540693335693, 48.158490943543626], [-3.116373512585391, 48.20636380948965], [-3.0335402161271037, 48.19936064624241], [-2.781951132488675, 48.120579730854125], [-2.652301006956971, 48.119324663861974], [-2.670050948442368, 48.047883952925766], [-2.6311897590265905, 48.035479312779835], [-2.5747859613042996, 48.070410038491524], [-2.49481856978248, 48.15784478551255], [-2.4089048721706594, 48.16861132667282], [-2.3713647531616733, 48.12210300840669], [-2.287278430400509, 48.13374556347385]]]}, 'attributes': {'CODE_DEPT': '22', 'NOM_DEPT': "COTES-D'ARMOR"}}, 76: {'geometry': {'type': 'Polygon', 'bbox': (644783.7000000156, 6537017.500001875, 776585.8999999785, 6633748.500001593), 'coordinates': [[[3.0320681893946824, 46.79491118852599], [2.9599146908207157, 46.80387657677336], [2.827616388160227, 46.73528787880113], [2.774488053228389, 46.71890739681208], [2.7049751251942706, 46.73938730526566], [2.5966478252098466, 46.63721956981655], [2.614955459722656, 46.55328003970232], [2.5366520207790546, 46.51969984591665], [2.482928804775826, 46.5326974446441], [2.352003555650292, 46.51221134727485], [2.2857578150118907, 46.4535191502933], [2.2810476101300576, 46.420405373181076], [2.3230243720211274, 46.32927925675381], [2.3918607677139923, 46.329982476677564], [2.478940668864652, 46.28114777459818], [2.51631108338946, 46.2394395827726], [2.5653790586982077, 46.14303218282909], [2.6406912317167386, 46.118477661719055], [2.733052145656418, 46.223324326165525], [2.810275114252155, 46.196212623621925], [2.8557252864968374, 46.25548612990178], [2.9371457775851466, 46.24291746827502], [2.9095928618303137, 46.203493810710896], [2.971756635840471, 46.12178012989878], [3.166531859715606, 46.065677976513456], [3.371595622264062, 46.055060948494486], [3.419029561174583, 46.074292455805036], [3.4635034430082112, 46.017936870152816], [3.5884696050346547, 46.02413780633841], [3.6940178008729885, 45.93073235641245], [3.708883724363123, 45.97378454864049], [3.788909241913359, 45.973858692630216], [3.8254431917706766, 45.99596774333176], [3.80676406021388, 46.045622930292026], [3.8218687105012137, 46.087983889770236], [3.789761994058612, 46.154851332057206], [3.804886833081295, 46.254857087118516], [3.8995333931893303, 46.27590543921822], [3.9866257932147806, 46.31919378739565], [3.9772154801510964, 46.39922459383986], [3.9980416518372484, 46.46546757106017], [3.957937642803863, 46.48975562185937], [3.8904705648097098, 46.481250929951884], [3.834005903932969, 46.53113227681361], [3.8017563441985818, 46.51989955458831], [3.7432867634118914, 46.56756978217597], [3.6969523102437005, 46.66058216583629], [3.6379005417614154, 46.707208771712104], [3.629423683496518, 46.74945902193758], [3.550392218815862, 46.71586467208164], [3.487153284024355, 46.65825255471402], [3.4341330414396496, 46.711906067614436], [3.3467088070518343, 46.684416345410945], [3.2697920192933188, 46.71674092869], [3.2155498733945853, 46.68289184476872], [3.049065356287102, 46.758078941893714], [3.0320681893946824, 46.79491118852599]]]}, 'attributes': {'CODE_DEPT': '03', 'NOM_DEPT': 'ALLIER'}}, 77: {'geometry': {'type': 'MultiPolygon', 'bbox': (350493.90000010264, 6448234.400002138, 464807.40000008, 6591808.800001736), 'coordinates': [[[[-1.3421247126758926, 46.200128411102206], [-1.4221002716213311, 46.20488076908434], [-1.5143725982265883, 46.25771384564718], [-1.5353220120922193, 46.20439467626832], [-1.4615984066336871, 46.20211883930835], [-1.354959085594671, 46.155888081222486], [-1.3421247126758926, 46.200128411102206]]], [[[-1.2154998604971092, 45.906680490194944], [-1.2479234576289189, 45.99041558337054], [-1.3127617814535801, 45.99297745042204], [-1.365933505631468, 46.0272660214926], [-1.383914399457972, 45.9514445914214], [-1.2661507817954059, 45.87816722390555], [-1.2364229444496362, 45.80453690546564], [-1.1956193786522455, 45.82969725881447], [-1.1884331226527605, 45.8867480515982], [-1.2154998604971092, 45.906680490194944]]], [[[0.004330746876935129, 45.19163255561608], [-0.04416800947411755, 45.247891172634034], [-0.11538526357329242, 45.24807269185139], [-0.1087860702850694, 45.288951578180324], [-0.22670231706753854, 45.32143289837579], [-0.2808959166071477, 45.359870837250334], [-0.2497593835924425, 45.40874172938648], [-0.2674239730736353, 45.45567770932366], [-0.2461560346224069, 45.49164146613398], [-0.2967152234141238, 45.56449387379335], [-0.375919653128293, 45.60891920266458], [-0.4089294944559104, 45.656179885078146], [-0.41583863552489897, 45.74166865754338], [-0.2731191101089057, 45.80655862747699], [-0.22174528634311572, 45.77574564408546], [-0.15309474428582787, 45.795737000339294], [-0.11540038254695609, 45.87066390237831], [-0.1316644506664795, 45.911020629982204], [-0.10293687953014628, 45.96965998523801], [-0.281734309419876, 46.079753777667676], [-0.4005083126359273, 46.08471764024758], [-0.5060833286611979, 46.106705208008755], [-0.5469968076890194, 46.14422952781582], [-0.6199574101252711, 46.13775275457059], [-0.6907154750130782, 46.21920250569825], [-0.751461997484196, 46.245070221736306], [-0.7504755422947275, 46.304258794361985], [-0.8398782038660582, 46.34036911732443], [-0.9348886609093251, 46.31285600461679], [-1.0138072401149993, 46.35562475996171], [-1.1294041774921524, 46.310276919156045], [-1.1111638836886606, 46.26134367831717], [-1.1989980101944597, 46.21324548926308], [-1.2238754783330177, 46.16594526939382], [-1.1264112813835236, 46.12426291495015], [-1.0526867952056977, 46.01118088641011], [-1.0989490769387036, 45.99050755133215], [-1.0643196475545214, 45.949909080847114], [-1.1371605532141822, 45.81989861485067], [-1.2425738599563503, 45.781571555535386], [-1.2372284214926077, 45.70589632544047], [-1.1158494510522972, 45.646981327907554], [-1.0096306936697135, 45.61143397047435], [-1.0257418763479111, 45.57469303281359], [-0.8410572249719399, 45.435083368260905], [-0.7740181405098181, 45.36920881364397], [-0.7526821734869668, 45.321769940978704], [-0.5944806728104978, 45.321142824588456], [-0.5595072006432491, 45.29770833934146], [-0.4291954727294859, 45.279473994648164], [-0.3940718179854251, 45.16477966588993], [-0.34233753875966594, 45.167558376604845], [-0.25508698029919, 45.114085277381534], [-0.15295329411286374, 45.088807215890796], [-0.0877028308704419, 45.12138883628677], [-0.04020033978963981, 45.10238433596349], [0.004330746876935129, 45.19163255561608]]]]}, 'attributes': {'CODE_DEPT': '17', 'NOM_DEPT': 'CHARENTE-MARITIME'}}, 78: {'geometry': {'type': 'Polygon', 'bbox': (626128.5000000258, 6391030.700002284, 728488.39999999, 6486680.300002018), 'coordinates': [[[3.3613425807398936, 44.97141170967906], [3.3471986847617563, 45.014233878924244], [3.2972503187682016, 45.03607778789884], [3.3257851579159827, 45.09513611769889], [3.2880332175079103, 45.120424409579364], [3.222465248668949, 45.271971446584864], [3.1179979977042014, 45.284187297622296], [3.1034981328800555, 45.35437310008839], [3.016710134630249, 45.28712067830814], [2.9486247512965202, 45.30912583525689], [2.9215557561638335, 45.36577511746247], [2.8523786840571645, 45.39234069238325], [2.714857227145231, 45.38155782083139], [2.651429936294738, 45.442655051563015], [2.5084086971130826, 45.478498798744894], [2.4874679068775096, 45.418838410808995], [2.4418608930121475, 45.38425846985713], [2.378246243484016, 45.414305790766505], [2.3504794408656373, 45.32755821486311], [2.2714136874802597, 45.29015191925769], [2.195361138057307, 45.22085230029842], [2.21369697618154, 45.16019264015236], [2.1717556853734434, 45.08149587397568], [2.09515947189117, 45.05602988503961], [2.132978967739458, 44.98552052019752], [2.0629142919730623, 44.97650640551568], [2.0942123106720874, 44.87201148950678], [2.171636274864375, 44.79002439871239], [2.1534919160094748, 44.753107579025304], [2.1694177928364127, 44.638066191426034], [2.207475285530841, 44.6155316765299], [2.208413991565611, 44.6438441016835], [2.3267857957506486, 44.669692455972545], [2.4350033478315978, 44.638877643596295], [2.5561238131207125, 44.72128489545452], [2.562709168390778, 44.77575324565901], [2.5993575445949, 44.79280887269856], [2.6026810523917403, 44.84316760837649], [2.7064349149756604, 44.90722612216468], [2.738254293313791, 44.941222184736795], [2.8019551055054883, 44.87362935290207], [2.8496583078406252, 44.871489339969614], [2.8795722036394493, 44.80301061014638], [2.9345215070232764, 44.77919827286605], [2.9232644794453155, 44.728638923157135], [2.981676986530433, 44.64467661262439], [3.0615255979734926, 44.81717597962282], [3.0994768968798603, 44.83358841808975], [3.1054983095640436, 44.88677480310241], [3.182311971252496, 44.863734531317256], [3.2496925236752454, 44.91623789304505], [3.3613425807398936, 44.97141170967906]]]}, 'attributes': {'CODE_DEPT': '15', 'NOM_DEPT': 'CANTAL'}}, 79: {'geometry': {'type': 'Polygon', 'bbox': (662679.3000000154, 6234873.500002678, 796379.4999999614, 6319158.60000247), 'coordinates': [[[2.5657873980365586, 43.4229597441041], [2.5399619094859687, 43.346221862319766], [2.6016030790296316, 43.29870698639696], [2.772248225673249, 43.25778564580627], [2.8327620472635995, 43.32241280561742], [3.004349268167806, 43.3201311415977], [3.004740938100306, 43.28853825294436], [3.1472079664155532, 43.24700506844506], [3.2010265503923754, 43.24916714805378], [3.24056113717041, 43.21280863308419], [3.343863387032852, 43.270396006101606], [3.4303316940306616, 43.2902095364361], [3.510954322025528, 43.27333336221096], [3.6026190412473764, 43.35542655651473], [3.66215922818193, 43.39227906437721], [3.796663802013001, 43.44103590991053], [3.907134242130848, 43.51684377775207], [4.011185334395633, 43.55244665251141], [4.1010416754063925, 43.55437094640871], [4.150215691493674, 43.58556246815695], [4.194441206758988, 43.65430382623312], [4.144780927023585, 43.73388653553421], [4.002046166191344, 43.81146444231592], [3.917385092127717, 43.885593220663814], [3.830797043559706, 43.86642403487079], [3.824905456819552, 43.91929773950891], [3.787325021892116, 43.96687037520123], [3.726990344828379, 43.96901626259547], [3.6235886150953553, 43.91697856675764], [3.5754482408134063, 43.86552224087749], [3.5307009207380955, 43.855624713961724], [3.4244480676686226, 43.9115981684474], [3.358359441304462, 43.91383289325508], [3.275074750407491, 43.89835231151913], [3.203111724562128, 43.81387268634433], [3.0598559764719786, 43.831647379945494], [3.060740509271366, 43.69307728703755], [2.98535037366361, 43.70851625233063], [2.9354629666803715, 43.69466778518896], [2.9159815194674086, 43.6600207453723], [2.754523557193863, 43.61413878643591], [2.711169474843746, 43.645596783987564], [2.6432637215975134, 43.65014616249515], [2.615607192520078, 43.56663335506628], [2.658651329156613, 43.525794099032666], [2.6595399785833935, 43.480163558005835], [2.6060811779610433, 43.431093773006495], [2.5657873980365586, 43.4229597441041]]]}, 'attributes': {'CODE_DEPT': '34', 'NOM_DEPT': 'HERAULT'}}, 80: {'geometry': {'type': 'Polygon', 'bbox': (831613.6999999505, 6338354.700002426, 921862.99999992, 6473590.500002059), 'coordinates': [[[5.801469996094522, 44.70677851287007], [5.759044078047862, 44.696070284154175], [5.627084872571889, 44.75246442874933], [5.464158754968865, 44.79242749679314], [5.483647138020397, 44.92229059824829], [5.483609211781887, 45.02278614732915], [5.4497888352441555, 45.070783659173394], [5.388382939418145, 45.03613916354614], [5.179384657685968, 45.08331022009434], [5.188573507748233, 45.17126853879264], [5.176540876984405, 45.24840204491137], [5.121425532367964, 45.24833591809071], [5.054318727576238, 45.31905467974741], [4.98919148345871, 45.3440466408362], [4.880237763487564, 45.29745400935145], [4.800493926884063, 45.29836066114302], [4.812473966213053, 45.164481831518785], [4.837672652853049, 45.00479181394793], [4.886589299843448, 44.936651630533625], [4.822513080923934, 44.81708784467803], [4.76621554467615, 44.77862679935865], [4.779060115885165, 44.65469880413619], [4.710266499941698, 44.581549114708444], [4.693639580520507, 44.54223067415186], [4.698652294124969, 44.45230946012685], [4.667367377491741, 44.43066448441984], [4.6506150134375535, 44.329805791511355], [4.762251228111598, 44.32538168266034], [4.802876705944989, 44.29659556592812], [4.814083573320774, 44.2323148850936], [5.060564583015947, 44.308139760560856], [5.1497271329806695, 44.28208386834496], [5.154903556803356, 44.23094499620103], [5.384523055943825, 44.20104672066323], [5.383240887752097, 44.1552847302192], [5.435755865794636, 44.152248640249894], [5.498787806458752, 44.11571934778844], [5.543986124993945, 44.136390782725556], [5.576187167563138, 44.18804165094914], [5.63959354437225, 44.16758605191373], [5.6760373255434615, 44.19143313185903], [5.686555113440127, 44.26691847226601], [5.6467813253574, 44.267091475448616], [5.631598076087923, 44.328303017470354], [5.4930715607447445, 44.337177520811814], [5.418530667075708, 44.42494737031908], [5.513340558551903, 44.49113051875823], [5.60363867462863, 44.46554529362203], [5.630798606104504, 44.531598322128225], [5.5972487980667855, 44.543273727979305], [5.649630948822756, 44.617881007404385], [5.790619766631355, 44.65329030204336], [5.801469996094522, 44.70677851287007]], [[4.892909784975503, 44.36481842003472], [4.918515009368784, 44.40778504385663], [4.970436397484981, 44.431369949348735], [5.015759498726315, 44.39276614596868], [5.013377111169766, 44.326140286469006], [4.978583367650993, 44.2974630383884], [4.8895301353902365, 44.30415309780481], [4.892909784975503, 44.36481842003472]]]}, 'attributes': {'CODE_DEPT': '26', 'NOM_DEPT': 'DROME'}}, 81: {'geometry': {'type': 'Polygon', 'bbox': (595443.1000000458, 6137190.400002889, 714274.8999999937, 6202112.800002751), 'coordinates': [[[1.7861250110638967, 42.57362343207799], [1.7498821218907068, 42.56358508914765], [1.7298881048979537, 42.49532568149947], [1.834622898672281, 42.481786229589915], [1.9582842085598802, 42.42404869009346], [1.9859066164117019, 42.362048166797855], [2.0835981014554434, 42.362700139815864], [2.1563417567377465, 42.423427445080726], [2.257800225542442, 42.43835800634614], [2.435482130866189, 42.38887656698723], [2.4829628754848416, 42.33964655377147], [2.5400343955805043, 42.33375178289363], [2.5778245531567956, 42.357933234601965], [2.6717654689105332, 42.341178207697936], [2.675046174210866, 42.40496831103936], [2.7532002138160787, 42.42535725427029], [2.799242281304166, 42.41856867596319], [2.8414109625242325, 42.45852270899337], [3.0407621096853417, 42.47314100863676], [3.085437328583658, 42.425509881233275], [3.1732198139368313, 42.43487739331475], [3.1335847928885587, 42.51294127329134], [3.0496064216977565, 42.55014015956984], [3.0354222951214984, 42.67824819650247], [3.0434985865888815, 42.83815011921819], [2.917114990593263, 42.88486022074895], [2.8652738803519484, 42.91834143726111], [2.789053819259419, 42.895988728811666], [2.7400003158100112, 42.837574151817094], [2.6975776462485945, 42.83043106598879], [2.5090117260388043, 42.8498316897036], [2.4524747607108766, 42.83693276356485], [2.327116045977923, 42.83744277583194], [2.357535079462851, 42.73412195489046], [2.322006120391769, 42.70779157620252], [2.166053682054993, 42.66391836976537], [2.0005149149001977, 42.66156483553949], [1.9717596461471247, 42.616920493794225], [1.8744850028357225, 42.58140598425574], [1.7861250110638967, 42.57362343207799]]]}, 'attributes': {'CODE_DEPT': '66', 'NOM_DEPT': 'PYRENEES-ORIENTALES'}}, 82: {'geometry': {'type': 'Polygon', 'bbox': (904448.5999999343, 6445704.300002147, 1027166.6999998918, 6541571.800001871), 'coordinates': [[[6.260566197557925, 45.12684791386638], [6.362922813242248, 45.104493949917355], [6.393914586674507, 45.06181851097428], [6.486234598441577, 45.05607309559151], [6.481254109642402, 45.09413629464079], [6.629987338137472, 45.10932692819998], [6.680067352474279, 45.14012497136197], [6.767935179515761, 45.15974375221748], [6.8498588431895495, 45.12716081574415], [6.968757184292426, 45.20806055776685], [7.1375903052782785, 45.25569487340009], [7.110695394012846, 45.32651229960499], [7.1842747748936695, 45.407480631519974], [7.11351645521197, 45.434194687331164], [7.099789135400909, 45.46943936219549], [7.000331708478394, 45.50441719658233], [7.00069053414829, 45.639901594374685], [6.934608837460736, 45.64709230917708], [6.82911456486592, 45.70283279544949], [6.802516663522652, 45.77837197402202], [6.711938518958688, 45.72291967208878], [6.661192099251396, 45.79890547186778], [6.6017329724955784, 45.79541992331821], [6.552237633503553, 45.82687986970043], [6.509087472467453, 45.908632873298934], [6.4705596799701395, 45.88469229739344], [6.423672125473555, 45.80244240743697], [6.383851558657904, 45.778055295582284], [6.330635270345084, 45.69553113948386], [6.239679907775352, 45.685404763162644], [6.189714169774869, 45.70416174969227], [6.166233910329838, 45.75571563232783], [6.042939005987317, 45.73909595131257], [5.913209603821916, 45.80414083870233], [5.87342650248464, 45.8380955581268], [5.862101395990038, 45.93240229486188], [5.831226413621035, 45.938459578293276], [5.78685622417971, 45.82295599649888], [5.7761608991802635, 45.729222395584365], [5.704119379498134, 45.71092632945925], [5.68918710219464, 45.648501612399514], [5.623748035268077, 45.613268326764235], [5.73637233564262, 45.47254042424711], [5.782081150720108, 45.44065533936717], [5.8797384015593375, 45.406796712103855], [5.966169653050878, 45.49230872138147], [6.049753851710851, 45.437919529651154], [6.121272339213555, 45.438897845399346], [6.177450938299201, 45.39316148783131], [6.1844503207792245, 45.31794850760677], [6.131944929909637, 45.28828721598462], [6.1256964814234856, 45.24427026883595], [6.189207693158913, 45.16373228327807], [6.260566197557925, 45.12684791386638]]]}, 'attributes': {'CODE_DEPT': '73', 'NOM_DEPT': 'SAVOIE'}}, 83: {'geometry': {'type': 'Polygon', 'bbox': (892505.1999999284, 6347226.500002407, 1022959.6999998831, 6452798.600002125), 'coordinates': [[[5.801469996094522, 44.70677851287007], [5.790619766631355, 44.65329030204336], [5.649630948822756, 44.617881007404385], [5.5972487980667855, 44.543273727979305], [5.630798606104504, 44.531598322128225], [5.60363867462863, 44.46554529362203], [5.513340558551903, 44.49113051875823], [5.418530667075708, 44.42494737031908], [5.4930715607447445, 44.337177520811814], [5.631598076087923, 44.328303017470354], [5.6467813253574, 44.267091475448616], [5.686555113440127, 44.26691847226601], [5.6760373255434615, 44.19143313185903], [5.755494196596879, 44.210207765237946], [5.881793583616446, 44.21099866254289], [5.82391188904594, 44.2789019553126], [5.912323479912073, 44.27153166809458], [5.9536703829504924, 44.395059266699306], [6.071139333430846, 44.45053588827675], [6.155615049010708, 44.46195982298566], [6.228221718294847, 44.3817003919971], [6.262481962582939, 44.41225003856598], [6.233718236049833, 44.4638309183279], [6.362000081358195, 44.52207257904401], [6.413884950226282, 44.4692899596284], [6.562444503095603, 44.44549275371164], [6.632376327558709, 44.44712877640482], [6.684305299896707, 44.54130010645845], [6.772207133133649, 44.58890871380483], [6.839801667428219, 44.60858882906445], [6.914488202179286, 44.65949945810221], [6.948335091404861, 44.65481629914683], [6.987055135805778, 44.69014148867842], [7.077108800206922, 44.6809175091735], [6.9995712397492555, 44.78944471324744], [7.0067737788907705, 44.83931596763321], [6.933687243037527, 44.86202607200874], [6.859863090422121, 44.852900819527136], [6.749745773276747, 44.90736131510606], [6.763455936171166, 44.97122008604696], [6.7408068424989125, 45.0167293468965], [6.673884165477501, 45.01961754078056], [6.629987338137472, 45.10932692819998], [6.481254109642402, 45.09413629464079], [6.486234598441577, 45.05607309559151], [6.393914586674507, 45.06181851097428], [6.362922813242248, 45.104493949917355], [6.260566197557925, 45.12684791386638], [6.229388123209471, 45.10875005580748], [6.203927022398642, 45.012469165084894], [6.318198197576597, 45.003856776770746], [6.358840060670484, 44.94128447146308], [6.355361452664248, 44.85477898991752], [6.302846745398275, 44.8732598816747], [6.25054409332542, 44.85265497741966], [6.136224190737252, 44.864072791226555], [6.056342958572753, 44.815908261733725], [6.030210546238997, 44.83809609775428], [5.949519247847449, 44.80453012289723], [5.915233300411789, 44.754705804536144], [5.850398663313627, 44.75074454418589], [5.801469996094522, 44.70677851287007]]]}, 'attributes': {'CODE_DEPT': '05', 'NOM_DEPT': 'HAUTES-ALPES'}}, 84: {'geometry': {'type': 'MultiPolygon', 'bbox': (831613.6999999505, 6287714.5000025565, 922160.3999999114, 6372214.700002337), 'coordinates': [[[[4.892909784975503, 44.36481842003472], [4.8895301353902365, 44.30415309780481], [4.978583367650993, 44.2974630383884], [5.013377111169766, 44.326140286469006], [5.015759498726315, 44.39276614596868], [4.970436397484981, 44.431369949348735], [4.918515009368784, 44.40778504385663], [4.892909784975503, 44.36481842003472]]], [[[4.739060856654237, 43.92405947349065], [4.853093547765335, 43.91138205123065], [4.966309299927297, 43.871647269138414], [5.029533445304739, 43.82779291313883], [5.051490035086313, 43.787881688465646], [5.187972296540632, 43.73510332278265], [5.229990308924738, 43.747672881125666], [5.31850282672, 43.735021431958316], [5.439245661034276, 43.68110432174814], [5.531453034372501, 43.65901134759583], [5.6069435191164425, 43.658685905164866], [5.753638490630262, 43.72462253878885], [5.757332977582704, 43.72940911375542], [5.654445137414141, 43.82511098585945], [5.578189791221216, 43.82992112219797], [5.607126670731597, 43.91377284375335], [5.51208954255573, 43.94600228564655], [5.543656674317525, 44.02870768768531], [5.502636785327954, 44.06343920865502], [5.498787806458752, 44.11571934778844], [5.435755865794636, 44.152248640249894], [5.383240887752097, 44.1552847302192], [5.384523055943825, 44.20104672066323], [5.154903556803356, 44.23094499620103], [5.1497271329806695, 44.28208386834496], [5.060564583015947, 44.308139760560856], [4.814083573320774, 44.2323148850936], [4.802876705944989, 44.29659556592812], [4.762251228111598, 44.32538168266034], [4.6506150134375535, 44.329805791511355], [4.649223666100485, 44.27035986501103], [4.722074664233515, 44.18742154948275], [4.707458356688191, 44.10367246401253], [4.787978024928094, 44.065054097470245], [4.842093969959471, 43.986474548464955], [4.739060856654237, 43.92405947349065]]]]}, 'attributes': {'CODE_DEPT': '84', 'NOM_DEPT': 'VAUCLUSE'}}, 85: {'geometry': {'type': 'Polygon', 'bbox': (537221.0000000435, 6584255.600001739, 638968.6000000171, 6687210.900001439), 'coordinates': [[[2.1677857181383846, 46.42406650081814], [2.151671606709124, 46.45796019235819], [2.2043972607989812, 46.48439997524811], [2.158700190947214, 46.55734628168224], [2.1856288615493806, 46.60286242584111], [2.1407244355816926, 46.695553715403406], [2.065751312591214, 46.742494802064954], [2.1153606164888155, 46.77435860147472], [2.048810332345124, 46.829448268143665], [2.1262038890477335, 46.87986509549622], [2.070698616355421, 46.93399643786311], [2.0933838995940373, 47.01573583573], [2.0514877607984485, 47.04001604864955], [2.0483748812476152, 47.10601550210716], [1.96641397939093, 47.12541751372794], [1.8827218498344331, 47.10194954564286], [1.77458130936527, 47.130846812692184], [1.8421086266284747, 47.178029354432915], [1.8390792420529527, 47.21930815773429], [1.7058305011298702, 47.26587806829796], [1.5924281213159726, 47.27667661630462], [1.4484622479605176, 47.23796792122444], [1.3266655450453901, 47.18622542473183], [1.365360999707624, 47.12205127770922], [1.3116729094606134, 47.09697527344035], [1.2730568495660926, 47.037834138185595], [1.1614221724181906, 47.03962297281958], [1.0776154683629746, 47.01584239818827], [1.0498776400419196, 46.980640418735526], [0.9888132945329698, 46.76154066839271], [0.8674688807081565, 46.74821910504852], [0.9247556936578996, 46.692793352316095], [0.8943018154002155, 46.62573665182292], [0.9420237588365904, 46.58079210842132], [1.0147644249831804, 46.567763998822045], [1.1459353661062854, 46.50640188056713], [1.151604534776636, 46.44923617581203], [1.2126902380833458, 46.43222161336166], [1.1772799568053671, 46.38395162215298], [1.3030567860553477, 46.37099465262584], [1.3560228953092235, 46.40012317441322], [1.415190510113751, 46.347218495873015], [1.5223068332769558, 46.426524994500525], [1.6448464161558112, 46.38681584908523], [1.7277108990817456, 46.388958713661], [1.8195004176655627, 46.43003833895096], [1.9930823669027027, 46.43091738935587], [2.088941803334241, 46.40890318674812], [2.1677857181383846, 46.42406650081814]]]}, 'attributes': {'CODE_DEPT': '36', 'NOM_DEPT': 'INDRE'}}, 86: {'geometry': {'type': 'Polygon', 'bbox': (1159341.799999797, 6102880.200002988, 1242212.6999997562, 6233783.10000272), 'coordinates': [[[9.402268324411988, 41.8586982422724], [9.412573752377243, 41.95247536073499], [9.549983013016067, 42.10416397232976], [9.558834031337037, 42.28526344136207], [9.53267016615381, 42.379967221908856], [9.543397471188385, 42.4284895809259], [9.533193015205354, 42.545944023399194], [9.449196243675715, 42.66223603163033], [9.446380758225056, 42.68612187004446], [9.492379312253558, 42.80510332631413], [9.47306347792927, 42.87413170694103], [9.463553614767086, 42.986403164804315], [9.421761206671862, 43.0117229260944], [9.340869996691138, 42.99446130565284], [9.353823296916072, 42.91623891811394], [9.31102033856565, 42.83467992024297], [9.342560255911149, 42.79480129860917], [9.344474787466682, 42.73781243290846], [9.293321757624451, 42.67431591000088], [9.25445227241371, 42.71851210134247], [9.16688288642443, 42.736561067518316], [9.085757984829678, 42.71460676752987], [9.020690214855305, 42.64427117625519], [8.886523760118468, 42.628970742503846], [8.808932860020777, 42.59905594696854], [8.804094980454654, 42.569860341632705], [8.666504962154614, 42.515224058632846], [8.655224073914711, 42.41573555548158], [8.608422093704315, 42.41682541343206], [8.573411068108614, 42.381405712050416], [8.640801666424288, 42.373436353833135], [8.819561377056067, 42.31755804188299], [8.904766989145307, 42.253859280701064], [9.04565931380628, 42.2069234314084], [9.07218689177604, 42.13021371520025], [9.119729450195365, 42.10777443178623], [9.160818391906192, 42.02601714338066], [9.221084024655989, 42.0275969605392], [9.227497390904741, 41.85558903234797], [9.329200877550077, 41.83681486608324], [9.402268324411988, 41.8586982422724]]]}, 'attributes': {'CODE_DEPT': '2B', 'NOM_DEPT': 'HAUTE-CORSE'}}, 87: {'geometry': {'type': 'Polygon', 'bbox': (515634.90000005835, 6484264.10000203, 614305.1000000271, 6590222.6000017235), 'coordinates': [[[1.2531518386328941, 45.44421907802489], [1.2870567570435636, 45.48993789201237], [1.3500778792847676, 45.46688830500584], [1.4120589140520188, 45.52808103157582], [1.4803697950912305, 45.565943138308214], [1.5571958047036878, 45.54936632471635], [1.637663451137719, 45.580351909123976], [1.7838678002323443, 45.680363378073274], [1.8713480467629338, 45.66465827008339], [1.8987307791829435, 45.69827755120417], [1.875140102478583, 45.73277978898966], [1.8808988285366517, 45.79771481845652], [1.7727491731275808, 45.84282757445299], [1.6766374034760072, 45.835114020235785], [1.6023984681707664, 45.857465158579075], [1.6087196458716781, 45.93341242644046], [1.532500175591522, 45.95280423814574], [1.5491757848158927, 46.035410141538826], [1.4527947858284078, 46.179754612070326], [1.3749003074212898, 46.215451100952365], [1.4437697350516507, 46.30589420737533], [1.415190510113751, 46.347218495873015], [1.3560228953092235, 46.40012317441322], [1.3030567860553477, 46.37099465262584], [1.1772799568053671, 46.38395162215298], [1.1297576486963086, 46.36046628124314], [1.0269954429337316, 46.34303442800402], [1.0058867393780466, 46.28097399864584], [0.9072715939898943, 46.285257481169175], [0.7963255053030069, 46.21096277430393], [0.8234337839606, 46.128581728488335], [0.8179096763959531, 46.047878116483744], [0.925625498473504, 46.010453963771695], [0.9425919960124768, 45.957436078431286], [0.8629055339639642, 45.919755494447834], [0.7822321483214062, 45.82108209588085], [0.7164398059782184, 45.805617938664106], [0.7148884001268344, 45.76311968057411], [0.6297424639524403, 45.714569989772734], [0.7758431349260257, 45.667569572341854], [0.7515297126109174, 45.61832385402009], [0.8115003322647287, 45.57587064346199], [0.9345523684647934, 45.61158201050324], [1.0358490435954526, 45.600209290253204], [1.1197844789851379, 45.48778292627882], [1.2531518386328941, 45.44421907802489]]]}, 'attributes': {'CODE_DEPT': '87', 'NOM_DEPT': 'HAUTE-VIENNE'}}, 88: {'geometry': {'type': 'MultiPolygon', 'bbox': (297360.00000010285, 6582707.500001765, 428213.4000000774, 6673611.100001499), 'coordinates': [[[[-2.301813103356832, 46.989742762366866], [-2.2643800884994, 46.960878388662], [-2.218334029034883, 47.007818944291785], [-2.287230516382024, 47.0246212592717], [-2.301813103356832, 46.989742762366866]]], [[[-1.9804144867428743, 47.0289064940757], [-2.027355429633454, 47.00991814012842], [-2.062740934359734, 46.948066582804685], [-2.1538266883941835, 46.89015018115234], [-2.144508393520905, 46.82639635681275], [-1.9428810018395466, 46.69270499139385], [-1.8560176099926666, 46.60857792818526], [-1.8123496382428257, 46.493418144353285], [-1.7771417987632765, 46.492758463623225], [-1.6270608317160016, 46.414221541074056], [-1.5021454225847803, 46.39734952406841], [-1.4659415635018052, 46.342359010199445], [-1.3667425638808834, 46.34861328663732], [-1.2073944924206355, 46.26657161481696], [-1.2010877236762245, 46.31634695785256], [-1.1294041774921524, 46.310276919156045], [-1.0138072401149993, 46.35562475996171], [-0.9348886609093251, 46.31285600461679], [-0.8398782038660582, 46.34036911732443], [-0.7504755422947275, 46.304258794361985], [-0.5576498721967046, 46.363448573781824], [-0.537800498012109, 46.386465465455736], [-0.6406445679433723, 46.416229245156025], [-0.6124259071699314, 46.45873492951781], [-0.6021285989587037, 46.5332805477888], [-0.6141139330666159, 46.62039039102906], [-0.6440639078487055, 46.63802790732369], [-0.6561893352875896, 46.700774642460956], [-0.7273121698337276, 46.767632454458024], [-0.700856479426351, 46.80862675485134], [-0.7816473761536206, 46.84282850114098], [-0.8291443983745105, 46.93336473376703], [-0.8919599503022396, 46.97581784960789], [-0.9334603151811857, 47.008908043397604], [-1.055403108514476, 47.00568547430046], [-1.148570488753439, 47.02954516258661], [-1.271206708715037, 47.08389319899781], [-1.2946349782361026, 47.03948346966519], [-1.3786124689367807, 47.03085386698659], [-1.372985770094949, 46.952184466609765], [-1.4561316296061408, 46.9262728543553], [-1.4821311833973978, 47.037861989589345], [-1.5523222833408639, 47.01834875737963], [-1.553563697237001, 46.98150474523176], [-1.5007668577856454, 46.883891152829825], [-1.5485110748777007, 46.86007983436473], [-1.689761273986443, 46.89049286319811], [-1.751062300240369, 46.92959568215281], [-1.8309821821134142, 46.93203372415455], [-1.9432276192598639, 46.99471092059498], [-1.9804144867428743, 47.0289064940757]]]]}, 'attributes': {'CODE_DEPT': '85', 'NOM_DEPT': 'VENDEE'}}, 89: {'geometry': {'type': 'Polygon', 'bbox': (916540.6999999128, 6220583.000002719, 1018255.5999998702, 6307147.400002514), 'coordinates': [[[5.671875005699277, 43.179268786905034], [5.694880043308293, 43.14358778681919], [5.812729626801352, 43.109364524560156], [5.804564531287972, 43.078284936751174], [5.857450411938568, 43.04661900463519], [5.941245658009144, 43.10766029019487], [6.031440047836646, 43.0774733246305], [6.124045766317683, 43.07930848251319], [6.1839937902841156, 43.10853535096948], [6.26529674054148, 43.121044618100576], [6.368261479285512, 43.089912921964], [6.387572821703613, 43.14489830267718], [6.493498246377527, 43.150222752221076], [6.559636361254334, 43.18862998328663], [6.635531400239645, 43.17251047188635], [6.659331915728427, 43.195927346581975], [6.677311623765607, 43.27879196431368], [6.665952517510404, 43.31821636550598], [6.73981102371754, 43.41288050528181], [6.859478029180434, 43.41816384523447], [6.933726236453416, 43.48006801088512], [6.884230099335205, 43.50253572781932], [6.908012993627823, 43.599079187947034], [6.798740654261998, 43.62818033606136], [6.7608013983957, 43.66648795918865], [6.753535969205428, 43.73816698047843], [6.636395800176684, 43.78895056709553], [6.5247619833224295, 43.80636597788814], [6.4144280526034985, 43.791594458434275], [6.413483066219063, 43.76036041847228], [6.356960735074888, 43.736367664887325], [6.216709972579084, 43.79951197699887], [6.182886008281907, 43.76217559136379], [6.036131813943926, 43.694163340855255], [5.901207402568148, 43.73258459518493], [5.781343238677484, 43.75565738832385], [5.757332977582704, 43.72940911375542], [5.753638490630262, 43.72462253878885], [5.813243983394541, 43.68896399525119], [5.799061112603832, 43.66051789095851], [5.700215221457389, 43.64171611369793], [5.682144833819897, 43.6137320600733], [5.724610447116372, 43.5508975272503], [5.698802592390259, 43.482170126904066], [5.751846953791003, 43.43429512520618], [5.682787396731936, 43.399156869316464], [5.760928945485899, 43.267337999671355], [5.683909137465821, 43.236058294491144], [5.671875005699277, 43.179268786905034]]]}, 'attributes': {'CODE_DEPT': '83', 'NOM_DEPT': 'VAR'}}, 90: {'geometry': {'type': 'Polygon', 'bbox': (650056.2000000083, 6843626.300000984, 671600.3000000048, 6862430.900000933), 'coordinates': [[[2.592280488308802, 48.80743667582849], [2.4956469644616233, 48.86084961766197], [2.4163397172813523, 48.8492382734211], [2.331895313988745, 48.81701271306946], [2.3207180175230318, 48.748756235094554], [2.3707067322771356, 48.72017592254696], [2.503536569558129, 48.735211482185626], [2.5716603184420737, 48.69201409166007], [2.6136476481340414, 48.76102719230643], [2.592280488308802, 48.80743667582849]]]}, 'attributes': {'CODE_DEPT': '94', 'NOM_DEPT': 'VAL-DE-MARNE'}}, 91: {'geometry': {'type': 'Polygon', 'bbox': (637702.2000000101, 6850064.200000968, 650942.200000008, 6872566.900000905), 'coordinates': [[[2.331895313988745, 48.81701271306946], [2.2551429018636835, 48.83480774229436], [2.231736346483731, 48.86906948088366], [2.319884458526643, 48.900458867352725], [2.2909735732251617, 48.950966788090646], [2.200591009269504, 48.908679329904004], [2.152869141422736, 48.87333985215582], [2.1515778037276108, 48.81702039835412], [2.226559327154523, 48.77610203163561], [2.3207180175230318, 48.748756235094554], [2.331895313988745, 48.81701271306946]]]}, 'attributes': {'CODE_DEPT': '92', 'NOM_DEPT': 'HAUTS-DE-SEINE'}}, 92: {'geometry': {'type': 'Polygon', 'bbox': (698546.9000000006, 6336169.1000024285, 779410.8999999706, 6430308.600002175), 'coordinates': [[[2.981676986530433, 44.64467661262439], [3.083593896775788, 44.55901439443305], [3.068542786200033, 44.50348970314479], [3.13573609856136, 44.45487023109913], [3.119711177226503, 44.38337811871582], [3.1542516260589815, 44.30837023621571], [3.1252288254578002, 44.28446357369589], [3.2298475773263053, 44.22625501460899], [3.3577995033411128, 44.19791043423504], [3.373648044830684, 44.17075587210572], [3.4397298934659633, 44.12909826593232], [3.633491144032294, 44.12269533049063], [3.6377691613510246, 44.17548804418238], [3.678640671819198, 44.18275878035759], [3.7969951126604835, 44.12738907948696], [3.862104986455047, 44.13007375244107], [3.9526044819739092, 44.17079372606867], [3.9513171396124562, 44.24779542988908], [3.922858913740669, 44.305217941025745], [3.952331315351652, 44.328389996777126], [3.8859181039452233, 44.38799905234699], [3.944362317344653, 44.399567503492385], [3.998162987763964, 44.45979755586332], [3.9451489956301886, 44.57379092180423], [3.9051719910706293, 44.59270804776968], [3.862527190139651, 44.74386343467101], [3.7406507355868404, 44.83869734813907], [3.6663649146430073, 44.82877808873485], [3.6595223843815874, 44.8699386445054], [3.5943359966689914, 44.87542977006513], [3.589348917106291, 44.83219404802301], [3.4757737071599757, 44.81537151910519], [3.4179705141646854, 44.90076835769564], [3.412834742275399, 44.944842501975934], [3.3613425807398936, 44.97141170967906], [3.2496925236752454, 44.91623789304505], [3.182311971252496, 44.863734531317256], [3.1054983095640436, 44.88677480310241], [3.0994768968798603, 44.83358841808975], [3.0615255979734926, 44.81717597962282], [2.981676986530433, 44.64467661262439]]]}, 'attributes': {'CODE_DEPT': '48', 'NOM_DEPT': 'LOZERE'}}, 93: {'geometry': {'type': 'Polygon', 'bbox': (799606.7999999593, 6232742.000002689, 926823.2999999092, 6315433.300002484), 'coordinates': [[[4.230283393392478, 43.46018543272649], [4.554920338571665, 43.44621502092883], [4.5880988691773705, 43.42270695496557], [4.562800334318894, 43.37213670596152], [4.6617830951472214, 43.346412345483685], [4.759588900377177, 43.34994067645605], [4.855048529182453, 43.3326166544089], [4.866850028014126, 43.40468173427733], [4.967705599857733, 43.42610491918491], [5.041038908355625, 43.327286652949944], [5.240586909552983, 43.33171447327505], [5.311030077911202, 43.360876400521285], [5.362055004284556, 43.32195654694654], [5.345688435376645, 43.28236341769554], [5.363644360087066, 43.20712491164306], [5.536931681001044, 43.21449364341575], [5.60088990032015, 43.1625456316741], [5.671875005699277, 43.179268786905034], [5.683909137465821, 43.236058294491144], [5.760928945485899, 43.267337999671355], [5.682787396731936, 43.399156869316464], [5.751846953791003, 43.43429512520618], [5.698802592390259, 43.482170126904066], [5.724610447116372, 43.5508975272503], [5.682144833819897, 43.6137320600733], [5.700215221457389, 43.64171611369793], [5.799061112603832, 43.66051789095851], [5.813243983394541, 43.68896399525119], [5.753638490630262, 43.72462253878885], [5.6069435191164425, 43.658685905164866], [5.531453034372501, 43.65901134759583], [5.439245661034276, 43.68110432174814], [5.31850282672, 43.735021431958316], [5.229990308924738, 43.747672881125666], [5.187972296540632, 43.73510332278265], [5.051490035086313, 43.787881688465646], [5.029533445304739, 43.82779291313883], [4.966309299927297, 43.871647269138414], [4.853093547765335, 43.91138205123065], [4.739060856654237, 43.92405947349065], [4.641909591242105, 43.86747754714173], [4.654821446467849, 43.806408691630295], [4.5930322483013235, 43.68746240297304], [4.487236861293796, 43.69923776661928], [4.427028042117802, 43.62067757183961], [4.409349673740097, 43.561127800636186], [4.238105541141803, 43.497626917839995], [4.230283393392478, 43.46018543272649]], [[5.09638202520383, 43.40140783165064], [5.05956976393125, 43.40397723018547], [5.051880922172624, 43.46355664001118], [5.006007239562996, 43.46966221650619], [5.015464900192831, 43.52972333434824], [5.10866638424325, 43.52549492153416], [5.157538221661901, 43.409584122707585], [5.09638202520383, 43.40140783165064]]]}, 'attributes': {'CODE_DEPT': '13', 'NOM_DEPT': 'BOUCHES-DU-RHONE'}}, 94: {'geometry': {'type': 'Polygon', 'bbox': (643644.0000000091, 6857645.800000944, 657169.1000000068, 6867065.000000917), 'coordinates': [[[2.331895313988745, 48.81701271306946], [2.4163397172813523, 48.8492382734211], [2.385151006972503, 48.90200779222234], [2.319884458526643, 48.900458867352725], [2.231736346483731, 48.86906948088366], [2.2551429018636835, 48.83480774229436], [2.331895313988745, 48.81701271306946]]]}, 'attributes': {'CODE_DEPT': '75', 'NOM_DEPT': 'PARIS'}}, 95: {'geometry': {'type': 'Polygon', 'bbox': (648070.7000000081, 6856451.100000947, 670882.1000000045, 6878970.900000885), 'coordinates': [[[2.592280488308802, 48.80743667582849], [2.5626221662429587, 48.888884130538436], [2.602598431431983, 48.92935660279411], [2.55306064485419, 49.00981711745223], [2.4594899596115933, 48.95504632684678], [2.366443627637154, 48.974176668580746], [2.2909735732251617, 48.950966788090646], [2.319884458526643, 48.900458867352725], [2.385151006972503, 48.90200779222234], [2.4163397172813523, 48.8492382734211], [2.4956469644616233, 48.86084961766197], [2.592280488308802, 48.80743667582849]]]}, 'attributes': {'CODE_DEPT': '93', 'NOM_DEPT': 'SEINE-SAINT-DENIS'}}}},
    },
    1: {
        "geolayer": geolayer_fr_dept_data_and_geometry,
        "out_crs": 4326,
        "in_crs": 2154,
        "return_value": {'metadata': {'name': 'FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_AND_GEOMETRY', 'fields': {'CODE_DEPT': {'type': 'String', 'width': 2, 'index': 0}, 'NOM_DEPT': {'type': 'String', 'width': 23, 'index': 1}}, 'geometry_ref': {'type': {'MultiPolygon', 'Polygon'}, 'crs': 4326}}, 'features': {0: {'geometry': {'type': 'Polygon', 'bbox': (438084.30000010587, 6248690.800002651, 554722.8000000587, 6333950.700002438), 'coordinates': [[[0.6068109749570959, 43.31088599158559], [0.6559378827169787, 43.31720926544656], [0.7175914463388231, 43.37663081008268], [0.8205416805525511, 43.41697502257897], [0.9172511345137198, 43.40633268927779], [0.9780837577086212, 43.362651706544284], [1.0181843408377875, 43.47333809239016], [1.201337008485553, 43.594812955020245], [1.1475492440427306, 43.634175893376046], [1.0876957388199562, 43.644975031688936], [0.9539831166064948, 43.78737246570894], [0.9061557706747253, 43.78433052070788], [0.8994393128667497, 43.864698458132814], [0.8628924476067095, 43.92328916304656], [0.7600848328151361, 43.94224249346582], [0.8604173969632195, 44.04078542270124], [0.7757831291372466, 44.03591070642866], [0.7418847912050018, 44.06519923501583], [0.666591773846917, 44.02514596559472], [0.5979775801101934, 44.07822724921209], [0.539030952371026, 44.05372241953208], [0.4595156323439905, 44.055237448974076], [0.4424499147549645, 44.02876198332598], [0.30409006822726997, 43.993057181274395], [0.1895751311264972, 44.01464171001979], [0.07604560969926165, 43.983143136582996], [0.07664688901342062, 43.91647114312968], [0.03255676418092499, 43.90018804605394], [-0.07359844651969293, 43.94504687607575], [-0.179109059517904, 43.93791976442846], [-0.23393876198189914, 43.89106775010974], [-0.19099217321599454, 43.87518333615964], [-0.19414330237233957, 43.737016685694776], [-0.23258236946731695, 43.71408748429121], [-0.24283655874306653, 43.584976209013746], [-0.17641328064610662, 43.59640400157074], [-0.0967829732087741, 43.58240589763179], [-0.015780894995830342, 43.60465738319832], [-0.0019248187812945813, 43.56554046143878], [0.056081443916198466, 43.518807249853], [0.11212423457670412, 43.51736991981866], [0.13798238183895745, 43.43291627195171], [0.1820312140000643, 43.37118267445086], [0.2772545000281141, 43.38579092290556], [0.49803381879209696, 43.326180572401476], [0.6068109749570959, 43.31088599158559]]]}, 'attributes': {'CODE_DEPT': '32', 'NOM_DEPT': 'GERS'}}, 1: {'geometry': {'type': 'Polygon', 'bbox': (449163.9000000953, 6324802.500002467, 547193.100000056, 6410676.300002238), 'coordinates': [[[1.0751408247250984, 44.57732478356566], [0.9791284687246188, 44.6436104555417], [0.8699961633462002, 44.59730727091498], [0.8170042739845027, 44.62700147643919], [0.827000964251777, 44.6918895790769], [0.657434416631217, 44.67784707846922], [0.6304884773468272, 44.70652766853696], [0.41470651574900597, 44.646337117152974], [0.36557538473802126, 44.662211036636265], [0.3354490861907097, 44.73743575883081], [0.2973255098237864, 44.76228467395244], [0.15300384600842049, 44.73048103978566], [0.13372640074632103, 44.6824441037855], [0.1826776591534788, 44.661072124007056], [0.153607862533407, 44.61612295595815], [0.04056782018280711, 44.553046617799], [-0.01545369989301612, 44.505062787136126], [-0.010552396185254522, 44.41854340374255], [0.018233646559888655, 44.389878791845156], [-0.08575207965012982, 44.337610049886734], [-0.034811250980738076, 44.296725798024674], [-0.06662475964814253, 44.24675799222613], [-0.1406884798527575, 44.22640474768996], [-0.12915451548994408, 44.15240992875165], [-0.004232390832891391, 44.149995950868565], [0.034593843822210965, 44.130652403429636], [0.13510828700872454, 44.12422070347961], [0.10082062971801486, 44.08677044167006], [0.0626980132929106, 44.00084249917973], [0.07604560969926165, 43.983143136582996], [0.1895751311264972, 44.01464171001979], [0.30409006822726997, 43.993057181274395], [0.4424499147549645, 44.02876198332598], [0.4595156323439905, 44.055237448974076], [0.539030952371026, 44.05372241953208], [0.5979775801101934, 44.07822724921209], [0.666591773846917, 44.02514596559472], [0.7418847912050018, 44.06519923501583], [0.7528835731451483, 44.1022698127059], [0.8687736555079509, 44.12632969467479], [0.9190898187097761, 44.23827002933668], [0.9499239562135774, 44.27644247710561], [0.8734701152053466, 44.323308108557846], [0.887330777155981, 44.36637485759445], [1.049803151007229, 44.36263857861537], [1.0640838318649115, 44.37851326503546], [1.0090253989657338, 44.48004110906175], [1.01316664592295, 44.536127142275056], [1.0751408247250984, 44.57732478356566]]]}, 'attributes': {'CODE_DEPT': '47', 'NOM_DEPT': 'LOT-ET-GARONNE'}}, 2: {'geometry': {'type': 'Polygon', 'bbox': (837307.6999999549, 6403479.700002258, 965006.099999906, 6534231.700001889), 'coordinates': [[[4.800493926884063, 45.29836066114302], [4.880237763487564, 45.29745400935145], [4.98919148345871, 45.3440466408362], [5.054318727576238, 45.31905467974741], [5.121425532367964, 45.24833591809071], [5.176540876984405, 45.24840204491137], [5.188573507748233, 45.17126853879264], [5.179384657685968, 45.08331022009434], [5.388382939418145, 45.03613916354614], [5.4497888352441555, 45.070783659173394], [5.483609211781887, 45.02278614732915], [5.483647138020397, 44.92229059824829], [5.464158754968865, 44.79242749679314], [5.627084872571889, 44.75246442874933], [5.759044078047862, 44.696070284154175], [5.801469996094522, 44.70677851287007], [5.850398663313627, 44.75074454418589], [5.915233300411789, 44.754705804536144], [5.949519247847449, 44.80453012289723], [6.030210546238997, 44.83809609775428], [6.056342958572753, 44.815908261733725], [6.136224190737252, 44.864072791226555], [6.25054409332542, 44.85265497741966], [6.302846745398275, 44.8732598816747], [6.355361452664248, 44.85477898991752], [6.358840060670484, 44.94128447146308], [6.318198197576597, 45.003856776770746], [6.203927022398642, 45.012469165084894], [6.229388123209471, 45.10875005580748], [6.260566197557925, 45.12684791386638], [6.189207693158913, 45.16373228327807], [6.1256964814234856, 45.24427026883595], [6.131944929909637, 45.28828721598462], [6.1844503207792245, 45.31794850760677], [6.177450938299201, 45.39316148783131], [6.121272339213555, 45.438897845399346], [6.049753851710851, 45.437919529651154], [5.966169653050878, 45.49230872138147], [5.8797384015593375, 45.406796712103855], [5.782081150720108, 45.44065533936717], [5.73637233564262, 45.47254042424711], [5.623748035268077, 45.613268326764235], [5.54554159780885, 45.71359345746494], [5.42264142008713, 45.80712379566383], [5.434944676804955, 45.831093776494356], [5.353827195805032, 45.88327273564147], [5.309169396437732, 45.85493340191014], [5.266894883868228, 45.78936901099023], [5.191532760208242, 45.77168800093884], [5.101067478338776, 45.813378082643716], [5.094526879742293, 45.7394533595093], [5.131048366350085, 45.70770885564481], [5.03514874052416, 45.63720294798385], [4.901457719834113, 45.60626780465852], [4.808696981728117, 45.57230056989166], [4.868481734036511, 45.523440212041656], [4.756935570818616, 45.455707349780305], [4.755996992712002, 45.36567226076606], [4.800493926884063, 45.29836066114302]]]}, 'attributes': {'CODE_DEPT': '38', 'NOM_DEPT': 'ISERE'}}, 3: {'geometry': {'type': 'Polygon', 'bbox': (597332.4000000085, 6993758.30000057, 712382.9999999988, 7101576.600000292), 'coordinates': [[[2.0677120276110013, 51.006505154674734], [1.915776261224724, 50.98408464073439], [1.7288531641107563, 50.93789161558701], [1.66409466424442, 50.89013244897838], [1.5806383872468288, 50.8673456889386], [1.6042134740274945, 50.79187042767518], [1.5607115203796043, 50.6996764042099], [1.5854134517805323, 50.53735245678956], [1.5577890976332032, 50.40471793677033], [1.6415439209955998, 50.35215320245149], [1.6707155098465685, 50.331010399908095], [1.7787842601942676, 50.36186618073267], [1.9180007470953697, 50.3117787753595], [1.9461316429137003, 50.28742804274709], [2.077820295455588, 50.2488212597536], [2.0957483707167435, 50.20554490564382], [2.2738282654200974, 50.226839899630434], [2.3702049076387826, 50.209770358333444], [2.4517852065078483, 50.23030237701513], [2.495690327572777, 50.19456202412894], [2.389777056686568, 50.15548482145538], [2.414507925852589, 50.100642406879025], [2.4766865519087604, 50.13699947000749], [2.551329915710551, 50.141605436872034], [2.5760198137336725, 50.11341281006871], [2.857843650412817, 50.077393119013884], [2.87653264314694, 50.04217932425911], [3.090253620620082, 50.0537405551461], [3.0957569207512843, 50.12420173434517], [3.1561320895920617, 50.1837151514849], [3.173376482382538, 50.24110767126835], [2.993078464231492, 50.379846956524474], [3.037672306035308, 50.441640098051245], [3.0207925423124586, 50.48176905741164], [2.9647097377674005, 50.51277802080956], [2.898951858432468, 50.501557815670935], [2.8259824668620874, 50.52538845143164], [2.8051660601438893, 50.60327122820495], [2.8404494526472543, 50.656566351404415], [2.769040910019394, 50.66367813930791], [2.713850503520111, 50.631292253556424], [2.630516060197486, 50.61795150536654], [2.495948921017839, 50.63124494194659], [2.4077924267844706, 50.67276560280949], [2.3408910264767204, 50.740906325444854], [2.2134304216785434, 50.81054861627207], [2.183904561046441, 50.88345246926367], [2.0976005370808024, 50.99842720037966], [2.0677120276110013, 51.006505154674734]]]}, 'attributes': {'CODE_DEPT': '62', 'NOM_DEPT': 'PAS-DE-CALAIS'}}, 4: {'geometry': {'type': 'Polygon', 'bbox': (774574.399999991, 6905214.700000814, 873032.1999999789, 7008458.800000535), 'coordinates': [[[4.047972977986833, 49.40564229477001], [4.1431697526129865, 49.404187032451034], [4.248308184547379, 49.38225617649833], [4.306756525620348, 49.32779732812255], [4.422583188651027, 49.28064492916811], [4.575868215345435, 49.2966511893251], [4.6251041072703405, 49.23565606344571], [4.686074799511885, 49.256759043814334], [4.826941205469511, 49.23576093817319], [4.894206220282045, 49.2590743389563], [4.950989232683009, 49.236865846314195], [5.051180998120573, 49.27405171211627], [5.02643699972715, 49.33591387471795], [5.1158969719764285, 49.42192447313757], [5.062396105126221, 49.499153471717584], [5.1182787291737935, 49.59307211739976], [5.162975033383015, 49.56353425623241], [5.311756637860765, 49.55928995634333], [5.393536658328508, 49.617087738514805], [5.350332008544782, 49.63085901370024], [5.269179131226729, 49.69607357002533], [5.166194556636604, 49.69291647768698], [5.093503384949335, 49.76373048636149], [5.0631826435981315, 49.76192871160778], [4.873874799688421, 49.82079506109401], [4.854192609787468, 49.86478713530524], [4.883307650501965, 49.89617895096], [4.8501895621955295, 49.946473039075464], [4.790903141595086, 49.95839770924098], [4.8685301585153855, 50.09762527597456], [4.8795515528000335, 50.152029766635124], [4.824292330401957, 50.160731428908065], [4.762161208292364, 50.13639695684066], [4.683190239835277, 50.06492226523267], [4.688865972729299, 49.995498425950466], [4.5930596502126235, 49.985507148105626], [4.510410432978068, 49.94668308725439], [4.446940783287938, 49.937504593983924], [4.3336466349033955, 49.963560807669346], [4.233068423333532, 49.95782375746413], [4.248507144358832, 49.856522649606475], [4.2095885412487295, 49.78178059628209], [4.250088858677235, 49.75710160234474], [4.1270215461885265, 49.67792125135548], [4.099316041330109, 49.62847816384557], [4.031390794494156, 49.61428997231127], [4.076570889635557, 49.57112749861901], [4.040711745102367, 49.50853465721909], [4.047972977986833, 49.40564229477001]]]}, 'attributes': {'CODE_DEPT': '08', 'NOM_DEPT': 'ARDENNES'}}, 5: {'geometry': {'type': 'Polygon', 'bbox': (728997.8999999948, 6759096.300001229, 837934.5999999736, 6845890.600000978), 'coordinates': [[[3.4147915595010963, 48.390273038835076], [3.498152764099384, 48.36909719474052], [3.6168043332338455, 48.27133989892491], [3.6216038851697063, 48.225740470572575], [3.667869602845747, 48.13921190362745], [3.74029124579523, 48.16970783295086], [3.8049683849961107, 48.10254956016535], [3.850029315571996, 47.983792407228414], [3.9020865465480417, 47.93917007405486], [4.1117857473984065, 47.926995657533396], [4.199158053352665, 47.969941402526324], [4.293424106945006, 47.92567623485384], [4.3090036167800365, 47.96117328279331], [4.448998378066956, 47.957154747586976], [4.5599688756782095, 47.97142319627397], [4.582678644289108, 48.02946360188037], [4.704238250439468, 48.02023237622195], [4.688818526238873, 48.073127919265815], [4.730610406781701, 48.11820899819217], [4.8193072949588815, 48.103192423478745], [4.850099917169891, 48.14175885540109], [4.858919933219105, 48.263638491502725], [4.80973775993872, 48.34735980335423], [4.716095686333966, 48.39485512883844], [4.653455248176321, 48.47054866780406], [4.670183207291811, 48.53188730233758], [4.614026636401956, 48.55380713072681], [4.545406992928757, 48.52525227165607], [4.40306312166006, 48.56126039350177], [4.315905486866125, 48.615578923340706], [4.325594012298644, 48.700277029545035], [4.166386793257749, 48.70745423754145], [4.080262439820496, 48.70106898078487], [4.001695483416846, 48.66387541822405], [3.9492266572894197, 48.60343162809795], [3.822742058660398, 48.51610441782203], [3.730879401425958, 48.53746785522521], [3.634028277746641, 48.54129826319994], [3.5556137492385345, 48.62028467658828], [3.5038535314822115, 48.60480913448515], [3.423442380707056, 48.53356269241414], [3.3919598867876517, 48.42432215347003], [3.4147915595010963, 48.390273038835076]]]}, 'attributes': {'CODE_DEPT': '10', 'NOM_DEPT': 'AUBE'}}, 6: {'geometry': {'type': 'Polygon', 'bbox': (992637.5999998839, 6272481.700002606, 1077560.2999998543, 6370071.400002356), 'coordinates': [[[6.88742990090296, 44.3610478380362], [6.796090992510112, 44.31610570751239], [6.7239938850023835, 44.24984330468271], [6.686536427072904, 44.169253930861075], [6.755280297628581, 44.07860658695586], [6.7457139505011225, 44.043235362043276], [6.836004210977611, 43.99060185096192], [6.851891862245591, 43.95479401195963], [6.913088787529998, 43.92796536503895], [6.884610185550847, 43.889120756894144], [6.830709312232405, 43.918363011486576], [6.745556290785884, 43.872108256875045], [6.697323345466608, 43.87365480225305], [6.636395800176684, 43.78895056709553], [6.753535969205428, 43.73816698047843], [6.7608013983957, 43.66648795918865], [6.798740654261998, 43.62818033606136], [6.908012993627823, 43.599079187947034], [6.884230099335205, 43.50253572781932], [6.933726236453416, 43.48006801088512], [6.971832403990881, 43.54544860181745], [7.040446281575285, 43.54158089325744], [7.126469292853879, 43.60527535172142], [7.167667333361662, 43.657403419865986], [7.241890731724425, 43.68848477342185], [7.3202910753685595, 43.69132686392653], [7.52851338181802, 43.790515150532556], [7.49543979690812, 43.864354891259204], [7.559218845189717, 43.89729463231819], [7.567109183508682, 43.94367801378092], [7.6485944611311, 43.97410878308102], [7.66498657284555, 44.03066821354596], [7.716933970025214, 44.081761260593446], [7.670852285754872, 44.15374050304125], [7.505741191835107, 44.14365239533765], [7.426949388266545, 44.112879446091384], [7.28196596662422, 44.14345130550786], [7.188914616489549, 44.19780338462867], [7.071037600740727, 44.23294982802467], [7.008054894297458, 44.236431060527096], [6.9934468208164935, 44.28089142785258], [6.88742990090296, 44.3610478380362]]]}, 'attributes': {'CODE_DEPT': '06', 'NOM_DEPT': 'ALPES-MARITIMES'}}, 7: {'geometry': {'type': 'Polygon', 'bbox': (753778.7999999836, 6460771.900002093, 837457.1999999543, 6575508.300001766), 'coordinates': [[[3.6940178008729885, 45.93073235641245], [3.7543707578917007, 45.88603083611288], [3.6997580221432105, 45.783181674804794], [3.7808499481107716, 45.72434927186403], [3.823453198078696, 45.63241694241687], [3.903596234209209, 45.59902246632493], [3.9543484081584332, 45.55596268333556], [3.9751057509236483, 45.4482695491395], [3.8991877616127324, 45.410307649293486], [3.897408424881887, 45.357083781715666], [3.97965057221058, 45.37513435596753], [4.024824051546119, 45.34288771363736], [4.177926371804464, 45.3926048786864], [4.308199323181691, 45.37098690693714], [4.366534405291163, 45.33699593440981], [4.362548869116956, 45.26439535681795], [4.418571110077435, 45.275424101661145], [4.483134616383878, 45.2364464819279], [4.602422910281466, 45.25170405771366], [4.614497435388505, 45.30983662841346], [4.679512199699748, 45.34611232691197], [4.755996992712002, 45.36567226076606], [4.756935570818616, 45.455707349780305], [4.722336796597094, 45.49429755062873], [4.661741865018663, 45.48675363928725], [4.614858045826018, 45.575468343903765], [4.519766458935654, 45.57325450372865], [4.410284239143385, 45.63205080632742], [4.365516200673114, 45.69851909472677], [4.391252031699621, 45.75493472371277], [4.383032288498641, 45.863993859081276], [4.3239261660748465, 45.900501336627656], [4.293912264205216, 45.95339953385292], [4.3060957589784294, 46.02122907041076], [4.280409632428633, 46.05294444469341], [4.321566636697418, 46.12922273900984], [4.438590902796802, 46.167878829695425], [4.388079599211451, 46.2197885167151], [4.282499756804287, 46.15695001476925], [4.261021127340282, 46.178750806087656], [4.132418427256319, 46.17782633253056], [4.104090700200876, 46.198394922849005], [3.988786873539471, 46.16980977454088], [3.972545422490283, 46.20271202778812], [3.8901323277345163, 46.214490641438694], [3.8995333931893303, 46.27590543921822], [3.804886833081295, 46.254857087118516], [3.789761994058612, 46.154851332057206], [3.8218687105012137, 46.087983889770236], [3.80676406021388, 46.045622930292026], [3.8254431917706766, 45.99596774333176], [3.788909241913359, 45.973858692630216], [3.708883724363123, 45.97378454864049], [3.6940178008729885, 45.93073235641245]]]}, 'attributes': {'CODE_DEPT': '42', 'NOM_DEPT': 'LOIRE'}}, 8: {'geometry': {'type': 'Polygon', 'bbox': (491362.4000000901, 6181124.600002802, 621363.1000000321, 6314318.000002484), 'coordinates': [[[0.6068109749570959, 43.31088599158559], [0.616280054756598, 43.28903679046815], [0.5515684940570379, 43.236102503746885], [0.5518748957180646, 43.209147130092994], [0.4419985587106286, 43.13127313187037], [0.5322696523895433, 43.093864488407355], [0.5630044583601449, 43.01746794817719], [0.6274179241908862, 43.00010287323438], [0.5759351469518764, 42.87082592303985], [0.4773013441230268, 42.87810749616219], [0.45889951642403815, 42.82814521426843], [0.45509422507364955, 42.72806064199966], [0.47774954032737066, 42.69999034279803], [0.6822635276176596, 42.7089682536353], [0.644540504562064, 42.78307646581698], [0.6590147498491514, 42.8385294654611], [0.708377779630982, 42.86140184526942], [0.8583056667230173, 42.825719089084565], [0.8324133769327763, 42.91998800205094], [0.8749113719387422, 42.957775746315384], [0.9791013887263271, 42.974430961914464], [1.0070461604480831, 43.00759100643923], [0.9851687313481595, 43.0670562815733], [1.0388356827344094, 43.100552820032334], [1.0589125480141455, 43.14182620134694], [1.124082084454217, 43.156907404761874], [1.2087344680123453, 43.11795105080999], [1.2274806300813905, 43.183893105810554], [1.3146078107375305, 43.189994724436794], [1.374373433475401, 43.213745765705475], [1.2933102990704721, 43.28533747712766], [1.343651969634677, 43.315606054765574], [1.4253606535844838, 43.256571535866804], [1.4637105789844818, 43.21060079806063], [1.5475200495883703, 43.275674269255795], [1.6372035311274429, 43.255115354491736], [1.6884197209147513, 43.27355372810057], [1.7477325973047735, 43.34374010112299], [1.8134240645221509, 43.34140359698674], [1.8040846789340412, 43.39168480485624], [1.8587429714302222, 43.44382089121744], [1.9101007956285108, 43.40405939980924], [2.0291328387973606, 43.4368979648422], [2.0181412825331915, 43.470350219604434], [1.882609451533412, 43.520928759682526], [1.824800921390716, 43.580831766261205], [1.6877710936117412, 43.63070037401996], [1.7308693816067124, 43.65775037692852], [1.7064455963184257, 43.71621951436262], [1.6604214137506874, 43.741834024882195], [1.6447876270393127, 43.80025749535751], [1.5910292905659658, 43.81548843933609], [1.555463245486847, 43.86831540012963], [1.5556171726831822, 43.91831715512148], [1.4478772809200224, 43.87355299852193], [1.3568133196337087, 43.884191550556004], [1.3608901489958334, 43.82107440669033], [1.2191934244058247, 43.770777524259024], [1.1445976144149483, 43.82229820079692], [0.9539831166064948, 43.78737246570894], [1.0876957388199562, 43.644975031688936], [1.1475492440427306, 43.634175893376046], [1.201337008485553, 43.594812955020245], [1.0181843408377875, 43.47333809239016], [0.9780837577086212, 43.362651706544284], [0.9172511345137198, 43.40633268927779], [0.8205416805525511, 43.41697502257897], [0.7175914463388231, 43.37663081008268], [0.6559378827169787, 43.31720926544656], [0.6068109749570959, 43.31088599158559]]]}, 'attributes': {'CODE_DEPT': '31', 'NOM_DEPT': 'HAUTE-GARONNE'}}, 9: {'geometry': {'type': 'Polygon', 'bbox': (748048.8999999872, 6562706.600001801, 887343.0999999508, 6673494.900001479), 'coordinates': [[[4.388079599211451, 46.2197885167151], [4.405813600867752, 46.29606050757105], [4.503987529872384, 46.26712984788548], [4.618551541036953, 46.264793087551574], [4.693107175516045, 46.30219481477724], [4.730529789085251, 46.17837212771996], [4.780213475718984, 46.17667702271943], [4.810994882268941, 46.259921516975695], [4.8882077017045455, 46.40298160185772], [4.891817622919295, 46.43991436571949], [4.940023082647429, 46.51719845218093], [5.052374107055715, 46.484872844561956], [5.201145108499203, 46.50820950515938], [5.215064143095116, 46.468359273121635], [5.310560613770374, 46.44676642071993], [5.415741925117894, 46.473138659412896], [5.3591908796398755, 46.52256096352789], [5.441107903009741, 46.63754001470951], [5.391088772820641, 46.72869554592405], [5.370244880835241, 46.826171259428975], [5.459286424114921, 46.85524478563496], [5.316959409128447, 46.90405615619236], [5.2632646167758095, 46.93591076096915], [5.255236339191405, 46.97988809464055], [5.106281375832607, 46.955765202475504], [5.049303736126249, 46.98158693341572], [4.728129651701317, 46.91937462593796], [4.623230215613321, 46.940820236785605], [4.493691403385164, 47.02837155710412], [4.406283415170732, 47.049999892555036], [4.405487083945716, 47.08164281958388], [4.259600310936345, 47.114326250580596], [4.209834279044644, 47.15541168354451], [4.181888404407953, 47.15050513981919], [4.115967069915809, 47.12333757652637], [4.06142733788571, 47.12104166410022], [4.038726355028209, 47.08001003428521], [4.072015136934213, 47.054494829385675], [4.039401951235417, 46.98511001230659], [4.037221978317054, 46.918155606841886], [4.093851364443379, 46.874734333229235], [4.056234450174583, 46.8432723767359], [4.062709832615211, 46.78936469128218], [3.9919591863262935, 46.77675109754475], [3.9233937335663804, 46.738872659809324], [3.797329518692337, 46.7015026371452], [3.73619002089105, 46.75247120098582], [3.629423683496518, 46.74945902193758], [3.6379005417614154, 46.707208771712104], [3.6969523102437005, 46.66058216583629], [3.7432867634118914, 46.56756978217597], [3.8017563441985818, 46.51989955458831], [3.834005903932969, 46.53113227681361], [3.8904705648097098, 46.481250929951884], [3.957937642803863, 46.48975562185937], [3.9980416518372484, 46.46546757106017], [3.9772154801510964, 46.39922459383986], [3.9866257932147806, 46.31919378739565], [3.8995333931893303, 46.27590543921822], [3.8901323277345163, 46.214490641438694], [3.972545422490283, 46.20271202778812], [3.988786873539471, 46.16980977454088], [4.104090700200876, 46.198394922849005], [4.132418427256319, 46.17782633253056], [4.261021127340282, 46.178750806087656], [4.282499756804287, 46.15695001476925], [4.388079599211451, 46.2197885167151]]]}, 'attributes': {'CODE_DEPT': '71', 'NOM_DEPT': 'SAONE-ET-LOIRE'}}, 10: {'attributes': {'CODE_DEPT': '53', 'NOM_DEPT': 'MAYENNE'}, 'geometry': {'type': 'Polygon', 'coordinates': [[[-1.0701645143702028, 48.5084938142048], [-1.0827940655347768, 48.43305823169245], [-1.045019529962301, 48.32772783001587], [-1.1000610480389637, 48.259280121227064], [-1.049606089398749, 48.08980493061712], [-1.0232833455698913, 48.068911203167616], [-1.0212610284765595, 47.99494016249541], [-1.1026711686637312, 47.989062782913926], [-1.1539940378788567, 47.96582099565702], [-1.1891839990021345, 47.86797794678786], [-1.2382517343256672, 47.80999146298689], [-1.1426272844041534, 47.774442466941096], [-1.0999157158854127, 47.78196684125323], [-0.9786565126647918, 47.761990588095294], [-0.9520300471637968, 47.796497072213384], [-0.8392941203736599, 47.75227330319133], [-0.741707658432875, 47.73810748628326], [-0.6108182423666888, 47.73568882742977], [-0.4604118623353681, 47.76509086787278], [-0.38170327004272336, 47.76056283995018], [-0.38820058256862766, 47.80531865640709], [-0.44785891788114673, 47.832216379468825], [-0.37067332986759555, 47.88002461791639], [-0.384840280948404, 47.93084465849811], [-0.2826331784456293, 47.95819180740859], [-0.34166482709193685, 48.043095522813545], [-0.23094244360355717, 48.058985357501875], [-0.2171740033885255, 48.106959664577076], [-0.24992127138834194, 48.157106805256824], [-0.1468370673865552, 48.20500891985261], [-0.16309583433799704, 48.25554245624931], [-0.13797809431803368, 48.361355595694256], [-0.05453120471342507, 48.38200345783028], [-0.05189625619319167, 48.453259769855784], [-0.14871347253945771, 48.45806753463183], [-0.16938268000563234, 48.53697035218057], [-0.20693829348513584, 48.5629447591783], [-0.2782279440483006, 48.506988913226], [-0.3676233888648984, 48.49294431514273], [-0.43075405116635984, 48.51181992420755], [-0.5050654278707287, 48.50579601257741], [-0.551717783599479, 48.473117087367115], [-0.6539938321279776, 48.4442821157106], [-0.757281139754533, 48.43655146992741], [-0.8603629154348665, 48.50145849653701], [-0.9563792193607092, 48.51661807961013], [-1.0039987501163443, 48.48917056001381], [-1.0701645143702028, 48.5084938142048]]]}}, 11: {'geometry': {'type': 'Polygon', 'bbox': (434480.3000000837, 6459163.500002107, 540666.4000000486, 6562343.900001808), 'coordinates': [[[-0.10293687953014628, 45.96965998523801], [-0.1316644506664795, 45.911020629982204], [-0.11540038254695609, 45.87066390237831], [-0.15309474428582787, 45.795737000339294], [-0.22174528634311572, 45.77574564408546], [-0.2731191101089057, 45.80655862747699], [-0.41583863552489897, 45.74166865754338], [-0.4089294944559104, 45.656179885078146], [-0.375919653128293, 45.60891920266458], [-0.2967152234141238, 45.56449387379335], [-0.2461560346224069, 45.49164146613398], [-0.2674239730736353, 45.45567770932366], [-0.2497593835924425, 45.40874172938648], [-0.2808959166071477, 45.359870837250334], [-0.22670231706753854, 45.32143289837579], [-0.1087860702850694, 45.288951578180324], [-0.11538526357329242, 45.24807269185139], [-0.04416800947411755, 45.247891172634034], [0.004330746876935129, 45.19163255561608], [0.05343044144838288, 45.22685497556189], [0.1277244971104147, 45.20911196586834], [0.26660921262945225, 45.29774875681216], [0.24932982871876333, 45.363043281591956], [0.30784894042745536, 45.460870365593415], [0.356537146854989, 45.46547909899263], [0.4962604525540854, 45.54448805439057], [0.49964715509464425, 45.617259300459516], [0.6006928771045719, 45.67214440425983], [0.6297424639524403, 45.714569989772734], [0.7148884001268344, 45.76311968057411], [0.7164398059782184, 45.805617938664106], [0.7822321483214062, 45.82108209588085], [0.8629055339639642, 45.919755494447834], [0.9425919960124768, 45.957436078431286], [0.925625498473504, 46.010453963771695], [0.8179096763959531, 46.047878116483744], [0.8234337839606, 46.128581728488335], [0.7469045366399738, 46.13857472178206], [0.6874528960648791, 46.09725460634651], [0.539972847134275, 46.0855581225283], [0.5064169377082234, 46.13195354986705], [0.4026555090199833, 46.062675603922386], [0.27980614406674986, 46.060966262312796], [0.197353505216163, 46.095550041529755], [0.07297225926176307, 46.093895909585044], [0.019272784617025578, 46.05284782935703], [-0.03199529342543973, 46.05592180291532], [-0.04143104082306048, 45.993479981491], [-0.10293687953014628, 45.96965998523801]]]}, 'attributes': {'CODE_DEPT': '16', 'NOM_DEPT': 'CHARENTE'}}, 12: {'geometry': {'type': 'Polygon', 'bbox': (343011.6000000426, 6826524.800001056, 423497.90000004787, 6969661.300000665), 'coordinates': [[[-0.8409353560137907, 48.75222016384713], [-0.9670546190041174, 48.786077720222416], [-1.089472833338895, 48.78151488426321], [-1.1326273918673369, 48.84885164217853], [-1.071180513900955, 48.870285157631265], [-0.9427299538328541, 48.967706984883456], [-0.8690886128916927, 49.06790310100597], [-0.8865942987279143, 49.129434041438124], [-0.9314549410204003, 49.145574313402285], [-0.900872906858209, 49.20297333587008], [-1.0226729579413112, 49.203385416252566], [-1.113423375217576, 49.26132689824705], [-1.1395424010513033, 49.3098708597634], [-1.1196225402660498, 49.35556798985948], [-1.163952010716086, 49.36665848651647], [-1.1825295039826558, 49.42401948473226], [-1.3063594927131794, 49.53892734054786], [-1.3041977944390666, 49.57368192357966], [-1.2295992003173177, 49.624650090584815], [-1.287842477634032, 49.69259317372232], [-1.4211576721789967, 49.70370298114806], [-1.5415745541135997, 49.654110262854196], [-1.6783876038065517, 49.661232646588175], [-1.9422451867330155, 49.72555529335993], [-1.9461788272965428, 49.674348301554], [-1.8603000418191251, 49.65019279205301], [-1.8410273136069877, 49.57173433703609], [-1.8856955118557919, 49.54039147247258], [-1.826772491313197, 49.45291724938543], [-1.8198285811721875, 49.3904836803323], [-1.7111682644583075, 49.32509928439525], [-1.5988432590535941, 49.169205064282544], [-1.6094115242692342, 49.079278117717536], [-1.5607059456223316, 49.00148291033306], [-1.5643431050154524, 48.921584069525686], [-1.5941451540783478, 48.83471201978299], [-1.5744067767391576, 48.751849448395745], [-1.5049438127030457, 48.687403463344886], [-1.3931950000571627, 48.65052438368423], [-1.449162081876617, 48.623418209167006], [-1.5710871213263624, 48.626445743066476], [-1.5189153941473388, 48.566594219597484], [-1.489947435142363, 48.48937484762061], [-1.377245885097968, 48.45828455073839], [-1.272248493564724, 48.533924823069405], [-1.2065557263083735, 48.542205944555754], [-1.0701645143702028, 48.5084938142048], [-1.0039987501163443, 48.48917056001381], [-0.9563792193607092, 48.51661807961013], [-0.8603629154348665, 48.50145849653701], [-0.7741715461672711, 48.56267832834257], [-0.7526143435139788, 48.617618520546905], [-0.7989559815697852, 48.71018883782028], [-0.8409353560137907, 48.75222016384713]]]}, 'attributes': {'CODE_DEPT': '50', 'NOM_DEPT': 'MANCHE'}}, 13: {'geometry': {'type': 'Polygon', 'bbox': (587215.6000000172, 6818024.90000106, 643162.6000000093, 6887345.000000862), 'coordinates': [[[1.5015238197988672, 48.94105360616862], [1.5572502545823872, 48.89157660949543], [1.5912030850964913, 48.81486963941434], [1.5795458299182854, 48.70181187350343], [1.602498423421542, 48.66376910929475], [1.7092527874670105, 48.57802434627667], [1.765329716198042, 48.56937104101408], [1.801445837919035, 48.466087959629114], [1.9221489648373706, 48.45760028607871], [1.9674261909808524, 48.53307136185833], [2.0175740602972905, 48.55759738743778], [2.0200056963818716, 48.64208882253288], [2.0822212746064093, 48.6858518071185], [2.111889242882012, 48.739560198041474], [2.226559327154523, 48.77610203163561], [2.1515778037276108, 48.81702039835412], [2.152869141422736, 48.87333985215582], [2.200591009269504, 48.908679329904004], [2.20585834678071, 48.949740742229906], [2.084914920835883, 49.014678714923626], [2.0247730444607908, 48.998755806202006], [1.9378021652564332, 49.02177632638558], [1.823950363006381, 49.07636122205329], [1.7234571618642336, 49.044976575520174], [1.673689127007117, 49.07815117319748], [1.608796070629922, 49.07789415355113], [1.5217661561843232, 49.06854572685726], [1.4577625828068002, 49.02629104623368], [1.5015238197988672, 48.94105360616862]]]}, 'attributes': {'CODE_DEPT': '78', 'NOM_DEPT': 'YVELINES'}}, 14: {'geometry': {'type': 'Polygon', 'bbox': (904021.0999999507, 6611179.900001672, 1006570.4999999271, 6724946.800001346), 'coordinates': [[[6.806992048333124, 47.56280181879932], [6.780972040773945, 47.536415287244694], [6.685554362876692, 47.562955627817985], [6.646719240296148, 47.53526063807287], [6.581776153124798, 47.53987013332599], [6.553562523020688, 47.49279726216728], [6.401377017027884, 47.520299753462304], [6.3343537374171, 47.50596607054921], [6.26232858266319, 47.43056987327868], [6.080045800270595, 47.3540364749941], [5.989355047833263, 47.327623386354006], [5.941374552825448, 47.34425359386968], [5.698725742766405, 47.26499677497711], [5.720409103677725, 47.21993674300861], [5.811467446057153, 47.169053816064604], [5.816084496368168, 47.134339348805725], [5.768548742190094, 47.08943503996258], [5.815050562004315, 47.020339093417896], [5.968560305501437, 46.98044449059878], [5.9640723607092, 46.94807945340025], [6.005778412779798, 46.87305283721094], [6.151793978046817, 46.8206673698074], [6.203329933961531, 46.77268138485174], [6.180271003478624, 46.741575238392684], [6.069828479910839, 46.68952488534495], [6.103767023618833, 46.64981840997855], [6.048566902902154, 46.607722856127914], [6.138108547029271, 46.557660399034106], [6.110748015678899, 46.57631320344649], [6.285329368806656, 46.691241021954795], [6.4381074734988255, 46.76174754330362], [6.431004694945304, 46.812411693948846], [6.464570889525094, 46.89020983338602], [6.43266944042617, 46.92860208537256], [6.518800213651558, 46.97085825240524], [6.640345422140114, 47.002757402096954], [6.714049325938046, 47.04912442357017], [6.73990764041836, 47.10805653932851], [6.858349567867173, 47.16438347703844], [6.882433031143577, 47.20161558472108], [6.954974253198658, 47.242940903153446], [6.993126569921013, 47.29554511881353], [7.062193873000224, 47.344157922732585], [7.016179011339007, 47.37183616717559], [6.917301026972028, 47.3561773266483], [6.940536510867673, 47.43337372142234], [6.907609859823659, 47.49454608019354], [6.905669627634238, 47.54736152102865], [6.806992048333124, 47.56280181879932]]]}, 'attributes': {'CODE_DEPT': '25', 'NOM_DEPT': 'DOUBS'}}, 15: {'geometry': {'type': 'Polygon', 'bbox': (838676.7999999775, 6816262.700001069, 906432.9999999686, 6949056.900000696), 'coordinates': [[[5.765154701602298, 48.49649260852762], [5.776211888772464, 48.540359251581435], [5.716089821783749, 48.561424169831746], [5.7617670452603855, 48.60939047861274], [5.757709339561898, 48.6956983342433], [5.71403634947959, 48.74453330887042], [5.780971762726474, 48.826749431299106], [5.747161790828688, 48.915257872650564], [5.800245290300756, 48.946746057604365], [5.823066740236894, 49.023106618165144], [5.818638375145696, 49.08617366651453], [5.76336075838886, 49.1078799656107], [5.7444679167795965, 49.15659587124916], [5.765544232834611, 49.19808862805665], [5.719044394768754, 49.215986946434604], [5.7317860065833734, 49.31134319109833], [5.688147604064061, 49.41510555458638], [5.634565984546506, 49.43743606552824], [5.529099312496952, 49.40737462727894], [5.461779526865532, 49.45269148820623], [5.47091013059277, 49.497205021307316], [5.426918930815695, 49.59734749374859], [5.393536658328508, 49.617087738514805], [5.311756637860765, 49.55928995634333], [5.162975033383015, 49.56353425623241], [5.1182787291737935, 49.59307211739976], [5.062396105126221, 49.499153471717584], [5.1158969719764285, 49.42192447313757], [5.02643699972715, 49.33591387471795], [5.051180998120573, 49.27405171211627], [4.950989232683009, 49.236865846314195], [4.9397619983736725, 49.185068204591545], [4.992117611940037, 49.11490008828468], [5.007681402681856, 49.034951950784894], [5.036321445219877, 49.02433254955411], [5.030128675561755, 48.95690245548527], [4.9362093920054075, 48.92214239513739], [4.888760929797641, 48.81720971455143], [4.990124563499123, 48.74183736488204], [4.988427677798424, 48.684418562247224], [5.005925627052494, 48.63403550117788], [5.070888258264775, 48.59572522100363], [5.118346103266605, 48.595510860548025], [5.208425883036941, 48.53861075459186], [5.349469998299744, 48.48198867903505], [5.4700481951761715, 48.42092912175581], [5.615963788740979, 48.43974531397395], [5.765154701602298, 48.49649260852762]]]}, 'attributes': {'CODE_DEPT': '55', 'NOM_DEPT': 'MEUSE'}}, 16: {'geometry': {'type': 'Polygon', 'bbox': (361697.30000012426, 6349285.200002406, 486169.1000000766, 6505244.800001987), 'coordinates': [[[0.2973255098237864, 44.76228467395244], [0.24175347207714265, 44.85689385892581], [0.17043367429958511, 44.82668350830176], [0.08302335597727074, 44.83122106182406], [-0.01544784730246714, 44.85771651694373], [0.03436214413600705, 44.91546925454329], [0.007378970051310477, 44.947298811504815], [0.07329671773303767, 45.07012096510989], [0.046060081710580396, 45.11322788942688], [-0.04020033978963981, 45.10238433596349], [-0.0877028308704419, 45.12138883628677], [-0.15295329411286374, 45.088807215890796], [-0.25508698029919, 45.114085277381534], [-0.34233753875966594, 45.167558376604845], [-0.3940718179854251, 45.16477966588993], [-0.4291954727294859, 45.279473994648164], [-0.5595072006432491, 45.29770833934146], [-0.5944806728104978, 45.321142824588456], [-0.7526821734869668, 45.321769940978704], [-0.7740181405098181, 45.36920881364397], [-0.8410572249719399, 45.435083368260905], [-1.0257418763479111, 45.57469303281359], [-1.0911993078778197, 45.562409624997784], [-1.157040252187611, 45.47037006217623], [-1.1623411294779706, 45.297866853837064], [-1.2229024029196511, 44.86482614411409], [-1.222955997695758, 44.70957693396094], [-1.160522506721864, 44.774663536811275], [-1.0363572283194804, 44.693563588536506], [-1.0053645293063393, 44.64804090229057], [-1.0807942554045624, 44.64060270635644], [-1.1915395677551643, 44.66072655577181], [-1.227400657614333, 44.57575101363349], [-1.2602820243561468, 44.53950655090701], [-1.2538901028077136, 44.467604212346195], [-1.1064909647292611, 44.50277289133715], [-1.0851664955491238, 44.532194571677685], [-0.9806969914576474, 44.482878935537535], [-1.0074534242441229, 44.4376523913387], [-0.9191704541834166, 44.443344362596065], [-0.8452736279017048, 44.418974549624686], [-0.7307029568976166, 44.446374662072614], [-0.6287774027434521, 44.443192240874644], [-0.6276476111842922, 44.398145662533665], [-0.528103107297291, 44.36465404326292], [-0.5176354697700609, 44.33911112646842], [-0.43183954131517804, 44.32257705443095], [-0.38338729038705477, 44.28631066773667], [-0.38961736206091657, 44.20948462715681], [-0.27211852903661043, 44.19380924623565], [-0.22344709828329368, 44.2058982638019], [-0.19411335198198013, 44.26904045949542], [-0.1406884798527575, 44.22640474768996], [-0.06662475964814253, 44.24675799222613], [-0.034811250980738076, 44.296725798024674], [-0.08575207965012982, 44.337610049886734], [0.018233646559888655, 44.389878791845156], [-0.010552396185254522, 44.41854340374255], [-0.01545369989301612, 44.505062787136126], [0.04056782018280711, 44.553046617799], [0.153607862533407, 44.61612295595815], [0.1826776591534788, 44.661072124007056], [0.13372640074632103, 44.6824441037855], [0.15300384600842049, 44.73048103978566], [0.2973255098237864, 44.76228467395244]]]}, 'attributes': {'CODE_DEPT': '33', 'NOM_DEPT': 'GIRONDE'}}, 17: {'geometry': {'type': 'Polygon', 'bbox': (396867.2000000489, 6857101.400000965, 512505.0000000287, 6928957.800000754), 'coordinates': [[[0.2972244202906157, 49.429861637295424], [0.21994001130961982, 49.42676180480031], [0.11038005889157869, 49.39426193748103], [-0.013368582587023795, 49.32120348155407], [-0.09959949005983877, 49.29760052806226], [-0.22569330389903036, 49.28181693022947], [-0.4148485981637226, 49.33558104325528], [-0.5153140242090203, 49.345016169896276], [-0.7222488013847791, 49.34700416595227], [-0.85116563037548, 49.362544751776724], [-0.9393846923333822, 49.3950422085724], [-1.0782173743324166, 49.388493505424975], [-1.1196225402660498, 49.35556798985948], [-1.1395424010513033, 49.3098708597634], [-1.113423375217576, 49.26132689824705], [-1.0226729579413112, 49.203385416252566], [-0.900872906858209, 49.20297333587008], [-0.9314549410204003, 49.145574313402285], [-0.8865942987279143, 49.129434041438124], [-0.8690886128916927, 49.06790310100597], [-0.9427299538328541, 48.967706984883456], [-1.071180513900955, 48.870285157631265], [-1.1326273918673369, 48.84885164217853], [-1.089472833338895, 48.78151488426321], [-0.9670546190041174, 48.786077720222416], [-0.8409353560137907, 48.75222016384713], [-0.71467861188995, 48.79986774273136], [-0.4637527288822014, 48.87136647589269], [-0.41151869249428263, 48.87014004742435], [-0.3462445710154035, 48.82199914076007], [-0.3059210867390902, 48.85830715301278], [-0.14634308820607453, 48.83444909950848], [-0.058807463588442944, 48.85358688784485], [0.05639799250069023, 48.90246403867087], [0.12760760912750327, 48.9522190708013], [0.15647487005382918, 48.92478758357601], [0.2756400197144905, 48.96474519881211], [0.3337726147565286, 48.942883562795664], [0.41281453288908837, 48.95062636770782], [0.4367513532066128, 49.008190235697356], [0.37767980975475246, 49.04945033021295], [0.4248747928572133, 49.130194368109024], [0.3946880087410215, 49.1501174749373], [0.38278674411941915, 49.264016474825524], [0.3230231728621308, 49.29699256483409], [0.2972244202906157, 49.429861637295424]]]}, 'attributes': {'CODE_DEPT': '14', 'NOM_DEPT': 'CALVADOS'}}, 18: {'geometry': {'type': 'Polygon', 'bbox': (878315.099999967, 6752777.700001265, 1011125.3999999412, 6831653.50000104), 'coordinates': [[[5.884726375202077, 47.926047148585354], [5.947521018814729, 47.979710391362566], [6.0022620475735735, 47.95608969904078], [6.072563808399438, 48.015666213333816], [6.15605787526197, 48.00694405924032], [6.167984818891343, 47.95235039238136], [6.237987058178877, 47.93284210199929], [6.366146412024702, 47.96194479078652], [6.431707255957784, 47.94381595263883], [6.478601854176571, 47.88552177370396], [6.542152823586114, 47.902610565311726], [6.601781921638083, 47.944398619135384], [6.645533181556613, 47.90402110648561], [6.784821909572191, 47.84962275518452], [6.823538854548164, 47.81305372460474], [6.846179818400713, 47.822945197015315], [6.920034363859817, 47.850287916338964], [6.9002133351392665, 47.89119137272693], [6.943356419805964, 47.99795794687724], [7.0018837438588974, 48.022399095831126], [7.058912798901163, 48.137266371556045], [7.133555808547297, 48.2459405500217], [7.1982815370299456, 48.310467861035285], [7.1219084409759965, 48.33329037922002], [7.097427065168082, 48.40564467454505], [7.1231653690285635, 48.51359226557106], [6.982986004562884, 48.47905957980011], [6.890810652427115, 48.41809431515708], [6.815166528707746, 48.398846200580046], [6.699498339648206, 48.413087540770555], [6.584971476704243, 48.460509163634704], [6.566974228865648, 48.41903184703233], [6.178419125638963, 48.39759887801264], [6.1167237857285315, 48.35403844101338], [5.961559100039155, 48.34989070448248], [5.856069666360069, 48.506844385600004], [5.765154701602298, 48.49649260852762], [5.615963788740979, 48.43974531397395], [5.4700481951761715, 48.42092912175581], [5.408721169498743, 48.383100190451266], [5.482149185087855, 48.35620132428276], [5.640901189478501, 48.24235420494444], [5.7108437679155655, 48.21992832819694], [5.6843187075882495, 48.14504209498634], [5.630534001339328, 48.0839862152433], [5.696798789098752, 48.077229566418524], [5.777747898583658, 48.0313619232788], [5.787280985479234, 47.95259697311846], [5.850003923490581, 47.96283504724517], [5.884726375202077, 47.926047148585354]]]}, 'attributes': {'CODE_DEPT': '88', 'NOM_DEPT': 'VOSGES'}}, 19: {'geometry': {'type': 'Polygon', 'bbox': (607114.3000000231, 6591411.800001717, 706033.1999999984, 6725640.400001325), 'coordinates': [[[2.2392136309887465, 47.620978307879966], [2.1279686465889998, 47.584697964594135], [2.195636277413897, 47.54857375641661], [2.238219079131483, 47.47234293194599], [2.1016927309861235, 47.386782556882636], [2.1389909561599825, 47.2854862202643], [1.9970384773235634, 47.265439340276224], [1.940816059215001, 47.290130782877135], [1.9040800791132246, 47.21565536643795], [1.8390792420529527, 47.21930815773429], [1.8421086266284747, 47.178029354432915], [1.77458130936527, 47.130846812692184], [1.8827218498344331, 47.10194954564286], [1.96641397939093, 47.12541751372794], [2.0483748812476152, 47.10601550210716], [2.0514877607984485, 47.04001604864955], [2.0933838995940373, 47.01573583573], [2.070698616355421, 46.93399643786311], [2.1262038890477335, 46.87986509549622], [2.048810332345124, 46.829448268143665], [2.1153606164888155, 46.77435860147472], [2.065751312591214, 46.742494802064954], [2.1407244355816926, 46.695553715403406], [2.1856288615493806, 46.60286242584111], [2.158700190947214, 46.55734628168224], [2.2043972607989812, 46.48439997524811], [2.151671606709124, 46.45796019235819], [2.1677857181383846, 46.42406650081814], [2.2810476101300576, 46.420405373181076], [2.2857578150118907, 46.4535191502933], [2.352003555650292, 46.51221134727485], [2.482928804775826, 46.5326974446441], [2.5366520207790546, 46.51969984591665], [2.614955459722656, 46.55328003970232], [2.5966478252098466, 46.63721956981655], [2.7049751251942706, 46.73938730526566], [2.774488053228389, 46.71890739681208], [2.827616388160227, 46.73528787880113], [2.9599146908207157, 46.80387657677336], [3.0320681893946824, 46.79491118852599], [3.0680947893123323, 46.877676731330396], [3.0502941730720203, 46.91063036589826], [3.0793297925031697, 46.95511875370015], [3.0757376737966906, 47.01914457943626], [3.0232152406674615, 47.0626168735247], [3.0280852399597813, 47.12906768514305], [2.9816846477683376, 47.22199695725166], [2.9834041014118906, 47.25976318039044], [2.8734906167112504, 47.348395958835304], [2.928902314704163, 47.4445667358034], [2.8746252064056805, 47.5204231125567], [2.8064837781833747, 47.494459329036964], [2.7680263231364868, 47.52352727566695], [2.7193534234556664, 47.49216663238495], [2.658459112358834, 47.48789924167962], [2.5998924219801753, 47.55368570340882], [2.4913582937968672, 47.56829543765222], [2.437347231323109, 47.6097781148652], [2.3730210260695963, 47.58552457239426], [2.2862379812937745, 47.62896236890434], [2.2392136309887465, 47.620978307879966]]]}, 'attributes': {'CODE_DEPT': '18', 'NOM_DEPT': 'CHER'}}, 20: {'geometry': {'type': 'Polygon', 'bbox': (768276.2999999755, 6352552.800002385, 848816.399999948, 6475559.3000020515), 'coordinates': [[[3.998162987763964, 44.45979755586332], [4.068441217053273, 44.405113572942064], [4.051451662788466, 44.317323657117086], [4.142867700090412, 44.313350855400145], [4.25884619798255, 44.264785576428054], [4.288416558058853, 44.31465868784345], [4.336073225463423, 44.339522743700364], [4.5035362130646455, 44.340188451230844], [4.55869985714841, 44.302444632604974], [4.649223666100485, 44.27035986501103], [4.6506150134375535, 44.329805791511355], [4.667367377491741, 44.43066448441984], [4.698652294124969, 44.45230946012685], [4.693639580520507, 44.54223067415186], [4.710266499941698, 44.581549114708444], [4.779060115885165, 44.65469880413619], [4.76621554467615, 44.77862679935865], [4.822513080923934, 44.81708784467803], [4.886589299843448, 44.936651630533625], [4.837672652853049, 45.00479181394793], [4.812473966213053, 45.164481831518785], [4.800493926884063, 45.29836066114302], [4.755996992712002, 45.36567226076606], [4.679512199699748, 45.34611232691197], [4.614497435388505, 45.30983662841346], [4.602422910281466, 45.25170405771366], [4.483134616383878, 45.2364464819279], [4.4432627898030574, 45.140832955911634], [4.376558944791765, 45.14435959050196], [4.375306064703462, 45.10483231156172], [4.289827924670836, 44.99730682920303], [4.221702631142119, 44.96133612938681], [4.156154791813548, 44.87333360834139], [4.039638866980703, 44.87316201331418], [4.0283748583288785, 44.834081003006226], [3.937001123548729, 44.79541721729978], [3.862527190139651, 44.74386343467101], [3.9051719910706293, 44.59270804776968], [3.9451489956301886, 44.57379092180423], [3.998162987763964, 44.45979755586332]]]}, 'attributes': {'CODE_DEPT': '07', 'NOM_DEPT': 'ARDECHE'}}, 21: {'geometry': {'type': 'Polygon', 'coordinates': [[[4.047972977986833, 49.40564229477001], [4.040711745102367, 49.50853465721909], [4.076570889635557, 49.57112749861901], [4.031390794494156, 49.61428997231127], [4.099316041330109, 49.62847816384557], [4.1270215461885265, 49.67792125135548], [4.250088858677235, 49.75710160234474], [4.2095885412487295, 49.78178059628209], [4.248507144358832, 49.856522649606475], [4.233068423333532, 49.95782375746413], [4.140895251736091, 49.97875959900575], [4.087128504749609, 49.969187585423256], [3.9803763118726985, 49.995376086949776], [3.923501465982154, 50.02643067661838], [3.7463798889650577, 50.05360423498406], [3.715184685025503, 50.06927463597468], [3.6136399192005855, 50.025418579188496], [3.54484649487849, 50.053793955280256], [3.4913598357111555, 50.01885605080664], [3.352982036655549, 50.03585934468007], [3.2801740988851327, 50.01518255081814], [3.2305405050170397, 50.03130959187674], [3.1727072271768164, 50.011994944690635], [3.1926752854802194, 49.9774646962746], [3.117968662907868, 49.91427637799499], [3.078694114076548, 49.82241521579585], [3.1184031553047866, 49.70596856016259], [3.0977762246810094, 49.656683091243586], [3.1314803354793224, 49.543377651804036], [3.0957783548212805, 49.51340305902506], [3.1605832452848968, 49.45158976267774], [3.0937834703774705, 49.43374686814669], [3.0953874973379834, 49.37711907479379], [2.97439031593416, 49.30233884823801], [3.0268878942941857, 49.27553205720364], [3.0640875194145396, 49.192738575710244], [3.1396578896700365, 49.152576953647774], [3.071884293834167, 49.11755421882924], [3.16523032905892, 49.099650858000736], [3.171683982224406, 49.01412318431705], [3.3047494707754015, 48.948764278958], [3.3302994547269797, 48.908706088655926], [3.4032194510047127, 48.86468651933575], [3.4851874436586847, 48.85190849438655], [3.5285764431169526, 48.912141028966566], [3.6015984944904185, 48.944072041330806], [3.646307433571441, 49.04058839071644], [3.600004656260228, 49.12069184513826], [3.622246623748465, 49.15110369338968], [3.704392046963459, 49.181373023481946], [3.6469532050746403, 49.31515350352492], [3.8474771401321166, 49.364586629449846], [3.9244337055179415, 49.406181771301206], [4.035496373111564, 49.359904159442664], [4.047972977986833, 49.40564229477001]]]}, 'attributes': {'CODE_DEPT': '02', 'NOM_DEPT': 'AISNE'}}, 22: {'geometry': {'type': 'Polygon', 'bbox': (314107.40000015876, 6194685.200002778, 457776.50000009924, 6283529.400002572), 'coordinates': [[[-1.5248665484221002, 43.529701346690175], [-1.5973846756448367, 43.43749281443983], [-1.6391097857903005, 43.40836090393245], [-1.7620275386554012, 43.375891589094934], [-1.7297463174854615, 43.29567717164454], [-1.6657616159233777, 43.3140776879948], [-1.6089349856953186, 43.25212549943685], [-1.5647156489015603, 43.28791168353558], [-1.5053245319871684, 43.29278486875212], [-1.3827862891090412, 43.253294314283245], [-1.383829083654522, 43.19081965347411], [-1.4139466293353427, 43.12917821198426], [-1.471735353863028, 43.08109307328772], [-1.4351852539528474, 43.04503271460899], [-1.3547480564678596, 43.02846729741793], [-1.343293307886626, 43.09537933451577], [-1.2642856059829313, 43.04456744579195], [-1.2311433515565389, 43.05449581378497], [-1.0064443208237903, 42.98899399788984], [-0.9464504061324416, 42.954061274088964], [-0.8100187374291915, 42.951433076654574], [-0.7516391053014931, 42.96693889977157], [-0.729761530231332, 42.89655917866081], [-0.5438135992737796, 42.793161075971256], [-0.509645724461578, 42.82539255578599], [-0.4397499421861347, 42.796462278453106], [-0.3925972910093655, 42.799558533888266], [-0.3134428634980887, 42.849375059707675], [-0.32708213440188894, 42.91578162376447], [-0.2815909254844988, 42.93356279018245], [-0.291551876667032, 42.98776781593251], [-0.22395152380116093, 43.033687539644006], [-0.19098404402245037, 43.111200014851946], [-0.14613235140227143, 43.12823595997721], [-0.11770146168361151, 43.180326663081985], [-0.01700753125072415, 43.270453175935074], [-0.046122416801734574, 43.300855792904095], [0.009598314167785659, 43.42210994370394], [-0.0690310020330968, 43.4373492706762], [-0.04013178615003942, 43.51260540210091], [-0.0967829732087741, 43.58240589763179], [-0.17641328064610662, 43.59640400157074], [-0.24283655874306653, 43.584976209013746], [-0.30369046804673383, 43.56027685025606], [-0.40604194753689593, 43.56822563862113], [-0.4482922578476383, 43.59608922647162], [-0.5571744316529481, 43.542797175106294], [-0.670807186170969, 43.5667169721835], [-0.7153911507395094, 43.54111406021413], [-0.7817805196343679, 43.56416715906691], [-0.8966906468904682, 43.55048921576576], [-0.9933935609538049, 43.50538804684222], [-1.109247829938908, 43.51412989565146], [-1.1708199655376668, 43.54560988391769], [-1.2911822396099, 43.49820457476763], [-1.4177740978933993, 43.49776692584465], [-1.4766198669954693, 43.53918405640505], [-1.5248665484221002, 43.529701346690175]]]}, 'attributes': {'CODE_DEPT': '64', 'NOM_DEPT': 'PYRENEES-ATLANTIQUES'}}, 23: {'geometry': {'type': 'Polygon', 'bbox': (518605.20000003977, 6677557.600001468, 642856.0000000128, 6782681.400001166), 'coordinates': [[[2.2392136309887465, 47.620978307879966], [2.2025585077490706, 47.67814460516372], [1.9424229848119665, 47.67563077912316], [1.8436947697611497, 47.686353216011], [1.7985957016041196, 47.63843148089742], [1.7399382527750797, 47.66153396919209], [1.697352800232305, 47.73839348418297], [1.5478779921036054, 47.76976159023594], [1.5337009096463898, 47.82052592916732], [1.588137738369647, 47.87642659620688], [1.5254235639039055, 47.929113580216004], [1.5201238283340495, 47.98227847700274], [1.3086281518302285, 47.953853799784625], [1.2096430686639745, 47.96850051669979], [1.1212335165894016, 48.039115919496666], [1.1122333320073277, 48.08072912595507], [1.0085477409246673, 48.08312677901138], [0.997330007937029, 48.12749350968228], [0.8412172317044133, 48.10306240933596], [0.7974846748199693, 48.037554414552474], [0.8458005593594112, 47.941401463859776], [0.7598746908928189, 47.89822684022159], [0.7745788175007332, 47.839687295150405], [0.7126298064021267, 47.79003621973886], [0.5805178732790726, 47.71232800972914], [0.6144311990931562, 47.69421364606964], [0.7353105618986358, 47.695401801856676], [0.8595037193186882, 47.669207269910096], [0.9190111731399371, 47.63260906010327], [1.0333525357335176, 47.60701157047619], [1.0763363652479017, 47.56322155433425], [1.0452908534068053, 47.53148801134605], [1.1323641891067446, 47.446466657485615], [1.107483394852318, 47.41132542515624], [1.1228353402815723, 47.3540166709069], [1.108127082601409, 47.298398043931414], [1.1620645187006389, 47.27219609172917], [1.2235368646048153, 47.29408083062269], [1.2769082168277979, 47.25470690394851], [1.3266655450453901, 47.18622542473183], [1.4484622479605176, 47.23796792122444], [1.5924281213159726, 47.27667661630462], [1.7058305011298702, 47.26587806829796], [1.8390792420529527, 47.21930815773429], [1.9040800791132246, 47.21565536643795], [1.940816059215001, 47.290130782877135], [1.9970384773235634, 47.265439340276224], [2.1389909561599825, 47.2854862202643], [2.1016927309861235, 47.386782556882636], [2.238219079131483, 47.47234293194599], [2.195636277413897, 47.54857375641661], [2.1279686465889998, 47.584697964594135], [2.2392136309887465, 47.620978307879966]]]}, 'attributes': {'CODE_DEPT': '41', 'NOM_DEPT': 'LOIR-ET-CHER'}}, 24: {'geometry': {'type': 'Polygon', 'bbox': (909643.199999973, 6833381.500001036, 1038623.699999949, 6939384.60000073), 'coordinates': [[[7.0793597709732445, 48.536417612714544], [7.167909935894841, 48.52759644356372], [7.256281654444216, 48.58867550766629], [7.283044927480475, 48.63810720118507], [7.242487615031405, 48.69154313192023], [7.311900506296782, 48.76730084432443], [7.149408408912649, 48.84470403838557], [7.126799106595454, 48.80114235821405], [7.054514540544792, 48.81370438623761], [7.045342890531057, 48.87154914038007], [6.964601688658045, 48.90452526766878], [6.989216409797389, 48.95992878869148], [7.054911912536332, 49.03061918772984], [7.107657105402385, 49.04411352332804], [7.17424027072314, 49.00636568135154], [7.29304884880289, 48.9734164509209], [7.326851980608823, 48.943372742034434], [7.446887904100118, 48.96577914856757], [7.538259039250205, 48.93296158495443], [7.578392137539887, 48.95740241812128], [7.635285449703197, 49.05416135519033], [7.53900482020311, 49.09206519191522], [7.439951314813092, 49.18079327996591], [7.365078240855516, 49.17183619633042], [7.298652796709715, 49.11745711802521], [7.247787410384872, 49.127981558041625], [7.06609408447456, 49.114583919911865], [7.0107044484055985, 49.18812137478714], [6.935411827637277, 49.222156387097606], [6.835378369933186, 49.2113238524707], [6.834537718950125, 49.15146671248141], [6.738512367681463, 49.163661139139315], [6.688137831919716, 49.224445572838164], [6.669191900827953, 49.28060494671162], [6.565838515282849, 49.347350170371804], [6.587074296882194, 49.384935828832845], [6.55223458161226, 49.42334910854837], [6.430122344093009, 49.476398147346536], [6.3919627145854445, 49.4644647328811], [6.296571041016303, 49.48010694492541], [6.2564130269948715, 49.51002255848146], [6.15688690583847, 49.50438979858011], [6.123493803074783, 49.4737561743855], [5.988987531307046, 49.45333363562849], [5.97176953371951, 49.49131664377085], [5.893401083719672, 49.49690975012321], [5.942619950432161, 49.45289553697136], [5.928530586493156, 49.37550729351067], [6.029385386695151, 49.23047199222701], [5.987627297222746, 49.20961691714645], [6.026149940244402, 49.16511893600301], [5.931603285178867, 49.10910433833667], [5.935399690626693, 49.071852219751314], [6.0449969560102, 49.01041872050658], [6.043435324319258, 48.977477915984394], [6.116898532084445, 48.96783320585781], [6.132207146051101, 48.93472094775403], [6.2719777673374155, 48.93313559709069], [6.338947107825572, 48.834058199842104], [6.355030133568448, 48.78165892452694], [6.554148775117041, 48.75409250997109], [6.5989655709524815, 48.715690797796334], [6.658407329856349, 48.708047286296704], [6.692283881384656, 48.67284039539553], [6.754672851450039, 48.66938665044198], [6.844053536871701, 48.62597500457003], [6.982882241286177, 48.61186293046636], [7.0793597709732445, 48.536417612714544]]]}, 'attributes': {'CODE_DEPT': '57', 'NOM_DEPT': 'MOSELLE'}}, 25: {'geometry': {'type': 'Polygon', 'bbox': (464624.4000000593, 6554736.200001831, 562772.8000000388, 6677880.4000014765), 'coordinates': [[[0.197353505216163, 46.095550041529755], [0.27980614406674986, 46.060966262312796], [0.4026555090199833, 46.062675603922386], [0.5064169377082234, 46.13195354986705], [0.539972847134275, 46.0855581225283], [0.6874528960648791, 46.09725460634651], [0.7469045366399738, 46.13857472178206], [0.8234337839606, 46.128581728488335], [0.7963255053030069, 46.21096277430393], [0.9072715939898943, 46.285257481169175], [1.0058867393780466, 46.28097399864584], [1.0269954429337316, 46.34303442800402], [1.1297576486963086, 46.36046628124314], [1.1772799568053671, 46.38395162215298], [1.2126902380833458, 46.43222161336166], [1.151604534776636, 46.44923617581203], [1.1459353661062854, 46.50640188056713], [1.0147644249831804, 46.567763998822045], [0.9420237588365904, 46.58079210842132], [0.8943018154002155, 46.62573665182292], [0.9247556936578996, 46.692793352316095], [0.8674688807081565, 46.74821910504852], [0.811901784063939, 46.7945079647172], [0.790328495561799, 46.852391083185985], [0.7043243920507868, 46.90329335315587], [0.692569282364634, 46.974307063017875], [0.5669489614197064, 47.002270374441686], [0.5983482495759445, 46.95676414686087], [0.5061414593305561, 46.959247361736196], [0.43870966025366004, 46.92958207105911], [0.3007362572498841, 46.97382765864786], [0.29823142261819774, 47.05391872520874], [0.17422061595767963, 47.07127519606648], [0.1361309026819461, 47.121580554147556], [0.07637120084195272, 47.12393194888828], [0.05382761471070627, 47.16373008265531], [-0.010736625571349077, 47.15750952036687], [-0.04416541443323664, 47.09324258439813], [-0.10212095637964697, 47.06479719081804], [-0.08769647758766945, 47.02313333571297], [-0.009032410299881494, 46.9074770060593], [-0.0203163360693799, 46.81265392500657], [0.0007042720140899882, 46.71623331657771], [-0.040426190194720726, 46.6637170238073], [0.0259896380281596, 46.59474350677765], [-0.031351255287516346, 46.524981019415726], [-0.017092824348942017, 46.41132239451375], [0.034219979012944976, 46.37349679947998], [0.03760223980806839, 46.32552885451106], [0.07821800902702712, 46.30493353892288], [0.1375978499402633, 46.34939518270104], [0.177368795982455, 46.328113140597], [0.12883677213786587, 46.26723154899875], [0.11283682536372723, 46.21093260957406], [0.1551113740904502, 46.15716824459698], [0.21492180826491522, 46.13884556432997], [0.197353505216163, 46.095550041529755]]]}, 'attributes': {'CODE_DEPT': '86', 'NOM_DEPT': 'VIENNE'}}, 26: {'geometry': {'type': 'Polygon', 'bbox': (460931.20000008226, 6388334.100002295, 577773.9000000425, 6515544.000001942), 'coordinates': [[[0.6297424639524403, 45.714569989772734], [0.6006928771045719, 45.67214440425983], [0.49964715509464425, 45.617259300459516], [0.4962604525540854, 45.54448805439057], [0.356537146854989, 45.46547909899263], [0.30784894042745536, 45.460870365593415], [0.24932982871876333, 45.363043281591956], [0.26660921262945225, 45.29774875681216], [0.1277244971104147, 45.20911196586834], [0.05343044144838288, 45.22685497556189], [0.004330746876935129, 45.19163255561608], [-0.04020033978963981, 45.10238433596349], [0.046060081710580396, 45.11322788942688], [0.07329671773303767, 45.07012096510989], [0.007378970051310477, 44.947298811504815], [0.03436214413600705, 44.91546925454329], [-0.01544784730246714, 44.85771651694373], [0.08302335597727074, 44.83122106182406], [0.17043367429958511, 44.82668350830176], [0.24175347207714265, 44.85689385892581], [0.2973255098237864, 44.76228467395244], [0.3354490861907097, 44.73743575883081], [0.36557538473802126, 44.662211036636265], [0.41470651574900597, 44.646337117152974], [0.6304884773468272, 44.70652766853696], [0.657434416631217, 44.67784707846922], [0.827000964251777, 44.6918895790769], [0.8170042739845027, 44.62700147643919], [0.8699961633462002, 44.59730727091498], [0.9791284687246188, 44.6436104555417], [1.0751408247250984, 44.57732478356566], [1.1537937079861713, 44.63940626971528], [1.1466718447537783, 44.67034606645634], [1.2245500554542503, 44.68426634892967], [1.287782139460227, 44.714781096530565], [1.364102971342699, 44.811568186415315], [1.3614038259537624, 44.84079526684306], [1.4419204827421668, 44.87757922298141], [1.4132990300005654, 44.99938624261534], [1.4482615439322117, 45.01931315867412], [1.3864424774272142, 45.10288137852406], [1.2965184989870582, 45.14018882562906], [1.2774962889939254, 45.242082419122035], [1.2271194403372112, 45.27197997099901], [1.3227969726587214, 45.38265936136428], [1.2596039598397974, 45.39834890279054], [1.2531518386328941, 45.44421907802489], [1.1197844789851379, 45.48778292627882], [1.0358490435954526, 45.600209290253204], [0.9345523684647934, 45.61158201050324], [0.8115003322647287, 45.57587064346199], [0.7515297126109174, 45.61832385402009], [0.7758431349260257, 45.667569572341854], [0.6297424639524403, 45.714569989772734]]]}, 'attributes': {'CODE_DEPT': '24', 'NOM_DEPT': 'DORDOGNE'}}, 27: {'geometry': {'type': 'Polygon', 'bbox': (871407.6999999562, 6576892.300001767, 944366.999999935, 6692352.700001431), 'coordinates': [[[5.310560613770374, 46.44676642071993], [5.307691028342544, 46.41681731886727], [5.377044586181938, 46.38135905559838], [5.373462288620209, 46.3522363046852], [5.4377951138533165, 46.315112971225524], [5.4730553115738125, 46.265063763323525], [5.542037828826234, 46.270201908707485], [5.649339135998929, 46.339491033036424], [5.714717731644378, 46.30876884774597], [5.725183003095842, 46.26072920479401], [5.849846074176258, 46.262063603326204], [5.908938421371525, 46.28395162005961], [5.986841317727858, 46.36487308875812], [6.06400848181829, 46.41622698893158], [6.073927085793577, 46.463946006284715], [6.156435507165684, 46.545468173119765], [6.138108547029271, 46.557660399034106], [6.048566902902154, 46.607722856127914], [6.103767023618833, 46.64981840997855], [6.069828479910839, 46.68952488534495], [6.180271003478624, 46.741575238392684], [6.203329933961531, 46.77268138485174], [6.151793978046817, 46.8206673698074], [6.005778412779798, 46.87305283721094], [5.9640723607092, 46.94807945340025], [5.968560305501437, 46.98044449059878], [5.815050562004315, 47.020339093417896], [5.768548742190094, 47.08943503996258], [5.816084496368168, 47.134339348805725], [5.811467446057153, 47.169053816064604], [5.720409103677725, 47.21993674300861], [5.698725742766405, 47.26499677497711], [5.602110210787403, 47.26053058451158], [5.518538729512593, 47.304186619469625], [5.488282961724511, 47.28934747033418], [5.47662851608292, 47.21602767128052], [5.439973300314684, 47.144397191390645], [5.386011880946294, 47.08197711021486], [5.322186205925132, 47.07298220144247], [5.310049747453534, 47.01802089675744], [5.255236339191405, 46.97988809464055], [5.2632646167758095, 46.93591076096915], [5.316959409128447, 46.90405615619236], [5.459286424114921, 46.85524478563496], [5.370244880835241, 46.826171259428975], [5.391088772820641, 46.72869554592405], [5.441107903009741, 46.63754001470951], [5.3591908796398755, 46.52256096352789], [5.415741925117894, 46.473138659412896], [5.310560613770374, 46.44676642071993]]]}, 'attributes': {'CODE_DEPT': '39', 'NOM_DEPT': 'JURA'}}, 28: {'geometry': {'type': 'Polygon', 'bbox': (519117.00000006985, 6298479.3000025265, 619220.100000031, 6366276.5000023525), 'coordinates': [[[1.8820828575359034, 44.3400652488443], [1.6995029158165786, 44.313814281404596], [1.6516207663148532, 44.28680580678524], [1.5691379539986454, 44.29839388706534], [1.5205387676670996, 44.263269755581995], [1.3803681196871471, 44.22485773308447], [1.2813793816235723, 44.23578619286313], [1.1079385683846075, 44.32740288340593], [1.0640838318649115, 44.37851326503546], [1.049803151007229, 44.36263857861537], [0.887330777155981, 44.36637485759445], [0.8734701152053466, 44.323308108557846], [0.9499239562135774, 44.27644247710561], [0.9190898187097761, 44.23827002933668], [0.8687736555079509, 44.12632969467479], [0.7528835731451483, 44.1022698127059], [0.7418847912050018, 44.06519923501583], [0.7757831291372466, 44.03591070642866], [0.8604173969632195, 44.04078542270124], [0.7600848328151361, 43.94224249346582], [0.8628924476067095, 43.92328916304656], [0.8994393128667497, 43.864698458132814], [0.9061557706747253, 43.78433052070788], [0.9539831166064948, 43.78737246570894], [1.1445976144149483, 43.82229820079692], [1.2191934244058247, 43.770777524259024], [1.3608901489958334, 43.82107440669033], [1.3568133196337087, 43.884191550556004], [1.4478772809200224, 43.87355299852193], [1.5556171726831822, 43.91831715512148], [1.552291489752299, 43.96302664758986], [1.6185715580365616, 43.97400163616608], [1.6913900365689174, 44.02434074044882], [1.6589585652250585, 44.11641211601683], [1.7455400915583983, 44.116267124994934], [1.777520207459107, 44.09681615657601], [1.841703958817319, 44.143691099981], [1.9196921618272458, 44.16294029634065], [1.990170712650344, 44.14945256348443], [1.976683004728593, 44.17992355171292], [1.902198887202942, 44.20432736443674], [1.9704438024330744, 44.276436279434094], [1.901390505373501, 44.279116463416905], [1.8820828575359034, 44.3400652488443]]]}, 'attributes': {'CODE_DEPT': '82', 'NOM_DEPT': 'TARN-ET-GARONNE'}}, 29: {'geometry': {'type': 'Polygon', 'bbox': (374866.6000000779, 6660135.3000015365, 491930.9000000467, 6754022.100001265), 'coordinates': [[[-0.8919599503022396, 46.97581784960789], [-0.7738774456713031, 47.00425220913205], [-0.7130578012324342, 46.986072210051866], [-0.6199767888274338, 46.9933220656585], [-0.5654683969778367, 47.019426143811984], [-0.5595318719263798, 47.06188673077483], [-0.495340243761372, 47.08238521770847], [-0.4007795061579291, 47.07077103460962], [-0.24153794845204718, 47.10572466544681], [-0.18483982751841338, 47.108336996905216], [-0.10212095637964697, 47.06479719081804], [-0.04416541443323664, 47.09324258439813], [-0.010736625571349077, 47.15750952036687], [0.05382761471070627, 47.16373008265531], [0.07897484723536348, 47.2828247550667], [0.18528045906678395, 47.424733449390764], [0.2201092524013729, 47.50195329713316], [0.20150312551615193, 47.54432775642865], [0.23000172635318558, 47.608398291933725], [0.15160368312924277, 47.581534768491814], [0.051659308485924815, 47.60651520171707], [-0.004507638464451783, 47.64768842380694], [-0.07183106759512486, 47.65800746667544], [-0.13503673265540259, 47.63251997721371], [-0.1931572478064973, 47.64791658039038], [-0.2330603877794416, 47.707562003167425], [-0.33407702419886187, 47.721165759995365], [-0.38170327004272336, 47.76056283995018], [-0.4604118623353681, 47.76509086787278], [-0.6108182423666888, 47.73568882742977], [-0.741707658432875, 47.73810748628326], [-0.8392941203736599, 47.75227330319133], [-0.9520300471637968, 47.796497072213384], [-0.9786565126647918, 47.761990588095294], [-1.0999157158854127, 47.78196684125323], [-1.1426272844041534, 47.774442466941096], [-1.2382517343256672, 47.80999146298689], [-1.245882346289053, 47.77671754769666], [-1.2545772523262646, 47.73364175152335], [-1.174929569150147, 47.69456501384606], [-1.1382017900650392, 47.61945704786123], [-1.0068639898836451, 47.58905339489957], [-1.04590950407258, 47.56335191106957], [-1.172416066194653, 47.573007547192], [-1.1572331855798583, 47.510083069606296], [-0.967482555917903, 47.49280029691797], [-0.9464433335100002, 47.386466852357906], [-1.0178737847602017, 47.36506226318966], [-1.1676096980775446, 47.3658872351569], [-1.2998771573086003, 47.337623665323264], [-1.305108502227792, 47.30316997819655], [-1.254174750571894, 47.249856282378325], [-1.197721609765016, 47.25058116645219], [-1.1632160710080464, 47.177784087549064], [-1.2352482689031186, 47.138781593625], [-1.231145713608837, 47.10995454752673], [-1.1154625363954844, 47.06256455498828], [-1.148570488753439, 47.02954516258661], [-1.055403108514476, 47.00568547430046], [-0.9334603151811857, 47.008908043397604], [-0.8919599503022396, 46.97581784960789]]]}, 'attributes': {'CODE_DEPT': '49', 'NOM_DEPT': 'MAINE-ET-LOIRE'}}, 30: {'geometry': {'type': 'Polygon', 'bbox': (798995.1999999703, 6485556.600002024, 865784.4999999475, 6579430.300001755), 'coordinates': [[[5.101067478338776, 45.813378082643716], [4.923799133458053, 45.80399936996719], [4.8645021533563355, 45.90461654376237], [4.7290969212308775, 45.94909221230223], [4.7546312797683195, 45.973622014972776], [4.739530214170902, 46.04720888365033], [4.750325275584826, 46.09414996659717], [4.797433206939167, 46.14070146436191], [4.780213475718984, 46.17667702271943], [4.730529789085251, 46.17837212771996], [4.693107175516045, 46.30219481477724], [4.618551541036953, 46.264793087551574], [4.503987529872384, 46.26712984788548], [4.405813600867752, 46.29606050757105], [4.388079599211451, 46.2197885167151], [4.438590902796802, 46.167878829695425], [4.321566636697418, 46.12922273900984], [4.280409632428633, 46.05294444469341], [4.3060957589784294, 46.02122907041076], [4.293912264205216, 45.95339953385292], [4.3239261660748465, 45.900501336627656], [4.383032288498641, 45.863993859081276], [4.391252031699621, 45.75493472371277], [4.365516200673114, 45.69851909472677], [4.410284239143385, 45.63205080632742], [4.519766458935654, 45.57325450372865], [4.614858045826018, 45.575468343903765], [4.661741865018663, 45.48675363928725], [4.722336796597094, 45.49429755062873], [4.756935570818616, 45.455707349780305], [4.868481734036511, 45.523440212041656], [4.808696981728117, 45.57230056989166], [4.901457719834113, 45.60626780465852], [5.03514874052416, 45.63720294798385], [5.131048366350085, 45.70770885564481], [5.094526879742293, 45.7394533595093], [5.101067478338776, 45.813378082643716]]]}, 'attributes': {'CODE_DEPT': '69', 'NOM_DEPT': 'RHONE'}}, 31: {'geometry': {'type': 'Polygon', 'bbox': (503908.00000002584, 6843337.50000099, 610930.7000000123, 6933754.900000739), 'coordinates': [[[1.7139375433100612, 49.409224988875955], [1.6593030583878117, 49.398986085408076], [1.5754225666575004, 49.44014397973678], [1.4121220377546606, 49.45649644273733], [1.3452333638981184, 49.44805852415384], [1.2721366387570645, 49.346289233402395], [1.1602558424773866, 49.34199415674212], [1.1339935379714459, 49.309842058204126], [1.048148843409499, 49.29788323231811], [1.0133166256832076, 49.25226297654121], [0.9214023473164955, 49.338552546249524], [0.9181193706199343, 49.38546058454825], [0.7648660757667759, 49.41958304774309], [0.665291415034114, 49.40200234792396], [0.5818886055232176, 49.43363577760692], [0.5249403531988147, 49.47786858988066], [0.3389828243594632, 49.44093130607368], [0.2972244202906157, 49.429861637295424], [0.3230231728621308, 49.29699256483409], [0.38278674411941915, 49.264016474825524], [0.3946880087410215, 49.1501174749373], [0.4248747928572133, 49.130194368109024], [0.37767980975475246, 49.04945033021295], [0.4367513532066128, 49.008190235697356], [0.41281453288908837, 48.95062636770782], [0.3861893489650427, 48.91041450586637], [0.4573579962478973, 48.8797624818295], [0.552503008373062, 48.87553783158533], [0.610293808614185, 48.831314149046584], [0.7335062460350482, 48.78336423504], [0.7749590431141302, 48.73752726459962], [0.7305886446296782, 48.70520779867271], [0.8148191028635929, 48.670167960202036], [0.8767072376479738, 48.71549244583088], [1.0316566693561064, 48.73058345602126], [1.1847306025015367, 48.772630163271536], [1.3195484140595366, 48.76096509556615], [1.3769640090609687, 48.79176905229479], [1.3621810029001888, 48.83417900338667], [1.4683503712150046, 48.892217344506555], [1.5015238197988672, 48.94105360616862], [1.4577625828068002, 49.02629104623368], [1.5217661561843232, 49.06854572685726], [1.608796070629922, 49.07789415355113], [1.6557774397127956, 49.1301621703505], [1.6757368125175736, 49.21186705776954], [1.7043642065965872, 49.23220177517624], [1.710479333974457, 49.264464162192816], [1.7756288406360832, 49.299693721359404], [1.7594117559881142, 49.368149815405616], [1.7139375433100612, 49.409224988875955]]]}, 'attributes': {'CODE_DEPT': '27', 'NOM_DEPT': 'EURE'}}, 32: {'geometry': {'type': 'Polygon', 'bbox': (607709.4000000342, 6288228.600002549, 736139.9999999859, 6426924.700002184), 'coordinates': [[[1.990170712650344, 44.14945256348443], [2.106128564722785, 44.19439456191692], [2.152470897558622, 44.19771468052582], [2.3892137722320053, 44.093490850148044], [2.410210271943262, 44.05584863724657], [2.459937005782879, 44.05139799957905], [2.522933752458295, 43.981282401194164], [2.4993471763625212, 43.95058625773131], [2.554997490001796, 43.92137993374893], [2.564162540693876, 43.8413310887232], [2.6813058930169467, 43.74396360331519], [2.742838073038075, 43.72904476801747], [2.813673557986314, 43.76171872931423], [2.9211070453325663, 43.73611367807573], [2.9354629666803715, 43.69466778518896], [2.98535037366361, 43.70851625233063], [3.060740509271366, 43.69307728703755], [3.0598559764719786, 43.831647379945494], [3.203111724562128, 43.81387268634433], [3.275074750407491, 43.89835231151913], [3.358359441304462, 43.91383289325508], [3.4507554815828207, 44.02078728434542], [3.328910418620988, 44.07902990387489], [3.3360602348274, 44.15867236265559], [3.373648044830684, 44.17075587210572], [3.3577995033411128, 44.19791043423504], [3.2298475773263053, 44.22625501460899], [3.1252288254578002, 44.28446357369589], [3.1542516260589815, 44.30837023621571], [3.119711177226503, 44.38337811871582], [3.13573609856136, 44.45487023109913], [3.068542786200033, 44.50348970314479], [3.083593896775788, 44.55901439443305], [2.981676986530433, 44.64467661262439], [2.9232644794453155, 44.728638923157135], [2.9345215070232764, 44.77919827286605], [2.8795722036394493, 44.80301061014638], [2.8496583078406252, 44.871489339969614], [2.8019551055054883, 44.87362935290207], [2.738254293313791, 44.941222184736795], [2.7064349149756604, 44.90722612216468], [2.6026810523917403, 44.84316760837649], [2.5993575445949, 44.79280887269856], [2.562709168390778, 44.77575324565901], [2.5561238131207125, 44.72128489545452], [2.4350033478315978, 44.638877643596295], [2.3267857957506486, 44.669692455972545], [2.208413991565611, 44.6438441016835], [2.207475285530841, 44.6155316765299], [2.153816544170514, 44.57190145626477], [2.0573690252842423, 44.582905559661995], [1.9314678023099077, 44.5063942771541], [1.83959954163412, 44.47590016897012], [1.8820828575359034, 44.3400652488443], [1.901390505373501, 44.279116463416905], [1.9704438024330744, 44.276436279434094], [1.902198887202942, 44.20432736443674], [1.976683004728593, 44.17992355171292], [1.990170712650344, 44.14945256348443]]]}, 'attributes': {'CODE_DEPT': '12', 'NOM_DEPT': 'AVEYRON'}}, 33: {'geometry': {'type': 'Polygon', 'bbox': (574729.8000000368, 6509220.700001954, 668605.1000000095, 6592907.500001715), 'coordinates': [[[2.1677857181383846, 46.42406650081814], [2.088941803334241, 46.40890318674812], [1.9930823669027027, 46.43091738935587], [1.8195004176655627, 46.43003833895096], [1.7277108990817456, 46.388958713661], [1.6448464161558112, 46.38681584908523], [1.5223068332769558, 46.426524994500525], [1.415190510113751, 46.347218495873015], [1.4437697350516507, 46.30589420737533], [1.3749003074212898, 46.215451100952365], [1.4527947858284078, 46.179754612070326], [1.5491757848158927, 46.035410141538826], [1.532500175591522, 45.95280423814574], [1.6087196458716781, 45.93341242644046], [1.6023984681707664, 45.857465158579075], [1.6766374034760072, 45.835114020235785], [1.7727491731275808, 45.84282757445299], [1.8808988285366517, 45.79771481845652], [1.875140102478583, 45.73277978898966], [1.8987307791829435, 45.69827755120417], [2.0176087689830706, 45.75549036080031], [2.1135454727593443, 45.7247750650252], [2.1743533542862306, 45.732215961682584], [2.1939584682323856, 45.69904710388091], [2.3377545093277403, 45.680604829561815], [2.3491828014700613, 45.70947892430512], [2.4358558482207813, 45.6992750614443], [2.4921255582417543, 45.73767009540711], [2.4341187302759346, 45.769857352447296], [2.3880204308712214, 45.827375905124306], [2.4425852582122802, 45.863012555807416], [2.492225410180823, 45.86402992467924], [2.594418920141694, 45.98944187163362], [2.5490476236021444, 46.114071399553694], [2.5653790586982077, 46.14303218282909], [2.51631108338946, 46.2394395827726], [2.478940668864652, 46.28114777459818], [2.3918607677139923, 46.329982476677564], [2.3230243720211274, 46.32927925675381], [2.2810476101300576, 46.420405373181076], [2.1677857181383846, 46.42406650081814]]]}, 'attributes': {'CODE_DEPT': '23', 'NOM_DEPT': 'CREUSE'}}, 34: {'geometry': {'type': 'Polygon', 'bbox': (589164.5000000226, 6709782.20000137, 709584.899999998, 6802433.8000011025), 'coordinates': [[[2.936314411640624, 48.163391744163064], [2.7989445730680167, 48.16827665011802], [2.7065470696044738, 48.124819245820426], [2.5381092459271755, 48.1406481032753], [2.506191747348858, 48.23853573046795], [2.4237635277023717, 48.26029732659773], [2.402664267131608, 48.320719459436084], [2.369810541415244, 48.308672482875544], [2.1813499926674265, 48.313745436024654], [1.994084718059379, 48.28658587795807], [1.9654790051841278, 48.25546624531193], [1.8656712589157687, 48.083857198730676], [1.7448338583126364, 48.066144349606134], [1.624592871969399, 48.06722274292949], [1.5941156652809603, 48.030699920759346], [1.5129757558119397, 48.028721780858234], [1.5201238283340495, 47.98227847700274], [1.5254235639039055, 47.929113580216004], [1.588137738369647, 47.87642659620688], [1.5337009096463898, 47.82052592916732], [1.5478779921036054, 47.76976159023594], [1.697352800232305, 47.73839348418297], [1.7399382527750797, 47.66153396919209], [1.7985957016041196, 47.63843148089742], [1.8436947697611497, 47.686353216011], [1.9424229848119665, 47.67563077912316], [2.2025585077490706, 47.67814460516372], [2.2392136309887465, 47.620978307879966], [2.2862379812937745, 47.62896236890434], [2.3730210260695963, 47.58552457239426], [2.437347231323109, 47.6097781148652], [2.4913582937968672, 47.56829543765222], [2.5998924219801753, 47.55368570340882], [2.658459112358834, 47.48789924167962], [2.7193534234556664, 47.49216663238495], [2.7680263231364868, 47.52352727566695], [2.8064837781833747, 47.494459329036964], [2.8746252064056805, 47.5204231125567], [2.914297452553034, 47.565970182735285], [2.9765380120036067, 47.56942879711261], [2.937999037836789, 47.598884707750514], [2.9231098081748264, 47.680559698484025], [2.8585180302225814, 47.71199289202641], [2.8566660682192713, 47.76092647079024], [2.9350577707343026, 47.76324627617625], [3.023798094359226, 47.78655467901546], [3.0102926272319244, 47.90471697202151], [3.0501042789379826, 47.911447449150145], [3.1284501214452565, 47.97097324036124], [3.088317798651479, 48.05393639482615], [3.0504714242752176, 48.072334131140266], [3.0294654865478936, 48.13320717201311], [2.936314411640624, 48.163391744163064]]]}, 'attributes': {'CODE_DEPT': '45', 'NOM_DEPT': 'LOIRET'}}, 35: {'geometry': {'type': 'Polygon', 'bbox': (878352.0999999599, 6687710.700001444, 986155.499999935, 6772821.300001199), 'coordinates': [[[6.823538854548164, 47.81305372460474], [6.784821909572191, 47.84962275518452], [6.645533181556613, 47.90402110648561], [6.601781921638083, 47.944398619135384], [6.542152823586114, 47.902610565311726], [6.478601854176571, 47.88552177370396], [6.431707255957784, 47.94381595263883], [6.366146412024702, 47.96194479078652], [6.237987058178877, 47.93284210199929], [6.167984818891343, 47.95235039238136], [6.15605787526197, 48.00694405924032], [6.072563808399438, 48.015666213333816], [6.0022620475735735, 47.95608969904078], [5.947521018814729, 47.979710391362566], [5.884726375202077, 47.926047148585354], [5.821435400588566, 47.868176059732946], [5.76119123886598, 47.8593344921856], [5.690283323540387, 47.818603890805136], [5.676611542335574, 47.7791582554239], [5.709213007321315, 47.744817354995476], [5.6900664799156155, 47.684838881520605], [5.596682241448043, 47.671686031739085], [5.4825679194907515, 47.68460287491283], [5.4063428720210265, 47.673400744490415], [5.374078595885573, 47.604541652802524], [5.425863186006295, 47.63211377458535], [5.477547427463132, 47.60872207291233], [5.496859255517603, 47.544144504783], [5.447063511552308, 47.496253655362246], [5.3992024955272315, 47.49901446301566], [5.451397515008267, 47.38406251346723], [5.518538729512593, 47.304186619469625], [5.602110210787403, 47.26053058451158], [5.698725742766405, 47.26499677497711], [5.941374552825448, 47.34425359386968], [5.989355047833263, 47.327623386354006], [6.080045800270595, 47.3540364749941], [6.26232858266319, 47.43056987327868], [6.3343537374171, 47.50596607054921], [6.401377017027884, 47.520299753462304], [6.553562523020688, 47.49279726216728], [6.581776153124798, 47.53987013332599], [6.646719240296148, 47.53526063807287], [6.685554362876692, 47.562955627817985], [6.780972040773945, 47.536415287244694], [6.806992048333124, 47.56280181879932], [6.780404771904785, 47.62526070546138], [6.757638483670511, 47.74787796649103], [6.823538854548164, 47.81305372460474]]]}, 'attributes': {'CODE_DEPT': '70', 'NOM_DEPT': 'HAUTE-SAONE'}}, 36: {'geometry': {'type': 'Polygon', 'bbox': (652488.5000000148, 6465307.100002078, 776221.1999999749, 6572856.000001771), 'coordinates': [[[3.6940178008729885, 45.93073235641245], [3.5884696050346547, 46.02413780633841], [3.4635034430082112, 46.017936870152816], [3.419029561174583, 46.074292455805036], [3.371595622264062, 46.055060948494486], [3.166531859715606, 46.065677976513456], [2.971756635840471, 46.12178012989878], [2.9095928618303137, 46.203493810710896], [2.9371457775851466, 46.24291746827502], [2.8557252864968374, 46.25548612990178], [2.810275114252155, 46.196212623621925], [2.733052145656418, 46.223324326165525], [2.6406912317167386, 46.118477661719055], [2.5653790586982077, 46.14303218282909], [2.5490476236021444, 46.114071399553694], [2.594418920141694, 45.98944187163362], [2.492225410180823, 45.86402992467924], [2.4425852582122802, 45.863012555807416], [2.3880204308712214, 45.827375905124306], [2.4341187302759346, 45.769857352447296], [2.4921255582417543, 45.73767009540711], [2.528364779747827, 45.681924336473784], [2.514296706686258, 45.63953208017773], [2.46534961788347, 45.600822875828726], [2.5163323173042995, 45.55342661392318], [2.5084086971130826, 45.478498798744894], [2.651429936294738, 45.442655051563015], [2.714857227145231, 45.38155782083139], [2.8523786840571645, 45.39234069238325], [2.9215557561638335, 45.36577511746247], [2.9486247512965202, 45.30912583525689], [3.016710134630249, 45.28712067830814], [3.1034981328800555, 45.35437310008839], [3.1680632240379363, 45.352259807508055], [3.290691872112179, 45.401821892426085], [3.4567465988864985, 45.40028672539175], [3.501320580432494, 45.427578687052645], [3.625846869344361, 45.33834565932035], [3.667209012708465, 45.37619709113052], [3.7722554467335283, 45.349191883525606], [3.8083099578489272, 45.391611966842156], [3.897408424881887, 45.357083781715666], [3.8991877616127324, 45.410307649293486], [3.9751057509236483, 45.4482695491395], [3.9543484081584332, 45.55596268333556], [3.903596234209209, 45.59902246632493], [3.823453198078696, 45.63241694241687], [3.7808499481107716, 45.72434927186403], [3.6997580221432105, 45.783181674804794], [3.7543707578917007, 45.88603083611288], [3.6940178008729885, 45.93073235641245]]]}, 'attributes': {'CODE_DEPT': '63', 'NOM_DEPT': 'PUY-DE-DOME'}}, 37: {'geometry': {'type': 'Polygon', 'bbox': (583816.2000000454, 6255615.400002628, 694795.5000000021, 6344664.200002406), 'coordinates': [[[1.5556171726831822, 43.91831715512148], [1.555463245486847, 43.86831540012963], [1.5910292905659658, 43.81548843933609], [1.6447876270393127, 43.80025749535751], [1.6604214137506874, 43.741834024882195], [1.7064455963184257, 43.71621951436262], [1.7308693816067124, 43.65775037692852], [1.6877710936117412, 43.63070037401996], [1.824800921390716, 43.580831766261205], [1.882609451533412, 43.520928759682526], [2.0181412825331915, 43.470350219604434], [2.0291328387973606, 43.4368979648422], [2.0728007398118375, 43.39568694741014], [2.224167733501991, 43.43176717254877], [2.259100479380118, 43.45992952515688], [2.4036304838758644, 43.41867070093128], [2.4331017858919792, 43.43517605493282], [2.5657873980365586, 43.4229597441041], [2.6060811779610433, 43.431093773006495], [2.6595399785833935, 43.480163558005835], [2.658651329156613, 43.525794099032666], [2.615607192520078, 43.56663335506628], [2.6432637215975134, 43.65014616249515], [2.711169474843746, 43.645596783987564], [2.754523557193863, 43.61413878643591], [2.9159815194674086, 43.6600207453723], [2.9354629666803715, 43.69466778518896], [2.9211070453325663, 43.73611367807573], [2.813673557986314, 43.76171872931423], [2.742838073038075, 43.72904476801747], [2.6813058930169467, 43.74396360331519], [2.564162540693876, 43.8413310887232], [2.554997490001796, 43.92137993374893], [2.4993471763625212, 43.95058625773131], [2.522933752458295, 43.981282401194164], [2.459937005782879, 44.05139799957905], [2.410210271943262, 44.05584863724657], [2.3892137722320053, 44.093490850148044], [2.152470897558622, 44.19771468052582], [2.106128564722785, 44.19439456191692], [1.990170712650344, 44.14945256348443], [1.9196921618272458, 44.16294029634065], [1.841703958817319, 44.143691099981], [1.777520207459107, 44.09681615657601], [1.7455400915583983, 44.116267124994934], [1.6589585652250585, 44.11641211601683], [1.6913900365689174, 44.02434074044882], [1.6185715580365616, 43.97400163616608], [1.552291489752299, 43.96302664758986], [1.5556171726831822, 43.91831715512148]]]}, 'attributes': {'CODE_DEPT': '81', 'NOM_DEPT': 'TARN'}}, 38: {'geometry': {'type': 'Polygon', 'bbox': (487453.2000000271, 6907663.900000811, 612313.8000000101, 6997484.700000563), 'coordinates': [[[1.7838370588623418, 49.7583075010794], [1.7270555289768355, 49.82888410523527], [1.678450674227239, 49.91813416150288], [1.4564621593341678, 50.03783334266402], [1.3797050374151874, 50.06501467639243], [1.1943823852499293, 49.96803785452345], [1.0659015382478352, 49.92561385767935], [0.9631874837108039, 49.919857551525], [0.7697293792067511, 49.87209561354354], [0.5729399803584816, 49.84972067060625], [0.32055875091141817, 49.74154748099047], [0.2116632434482728, 49.714468642629264], [0.1545347165457167, 49.648642302689645], [0.0656068775498632, 49.51257112098537], [0.1212453831412706, 49.463190908138515], [0.3389828243594632, 49.44093130607368], [0.5249403531988147, 49.47786858988066], [0.5818886055232176, 49.43363577760692], [0.665291415034114, 49.40200234792396], [0.7648660757667759, 49.41958304774309], [0.9181193706199343, 49.38546058454825], [0.9214023473164955, 49.338552546249524], [1.0133166256832076, 49.25226297654121], [1.048148843409499, 49.29788323231811], [1.1339935379714459, 49.309842058204126], [1.1602558424773866, 49.34199415674212], [1.2721366387570645, 49.346289233402395], [1.3452333638981184, 49.44805852415384], [1.4121220377546606, 49.45649644273733], [1.5754225666575004, 49.44014397973678], [1.6593030583878117, 49.398986085408076], [1.7139375433100612, 49.409224988875955], [1.766345027141405, 49.4661503637365], [1.719232660445319, 49.508223020119125], [1.7451334451250173, 49.5317376936539], [1.7045819685135708, 49.605398925870894], [1.7252046142437363, 49.672634359616865], [1.6895758821118128, 49.694785646272834], [1.7838370588623418, 49.7583075010794]]]}, 'attributes': {'CODE_DEPT': '76', 'NOM_DEPT': 'SEINE-MARITIME'}}, 39: {'geometry': {'type': 'Polygon', 'bbox': (822210.4999999779, 6725365.600001331, 915393.7999999551, 6844875.900000985), 'coordinates': [[[4.670183207291811, 48.53188730233758], [4.653455248176321, 48.47054866780406], [4.716095686333966, 48.39485512883844], [4.80973775993872, 48.34735980335423], [4.858919933219105, 48.263638491502725], [4.850099917169891, 48.14175885540109], [4.8193072949588815, 48.103192423478745], [4.730610406781701, 48.11820899819217], [4.688818526238873, 48.073127919265815], [4.704238250439468, 48.02023237622195], [4.789083695644796, 48.007829382573114], [4.786512602874469, 47.96420222558574], [4.852043179350451, 47.95623862322436], [4.9540942495981195, 47.866768148099524], [4.982400768988487, 47.80034738345197], [4.949610301299182, 47.76500253040031], [4.979107142832903, 47.68776283651176], [5.108878229414663, 47.64968494441669], [5.173597037303846, 47.65256871238266], [5.23923227423911, 47.616130098992706], [5.374078595885573, 47.604541652802524], [5.4063428720210265, 47.673400744490415], [5.4825679194907515, 47.68460287491283], [5.596682241448043, 47.671686031739085], [5.6900664799156155, 47.684838881520605], [5.709213007321315, 47.744817354995476], [5.676611542335574, 47.7791582554239], [5.690283323540387, 47.818603890805136], [5.76119123886598, 47.8593344921856], [5.821435400588566, 47.868176059732946], [5.884726375202077, 47.926047148585354], [5.850003923490581, 47.96283504724517], [5.787280985479234, 47.95259697311846], [5.777747898583658, 48.0313619232788], [5.696798789098752, 48.077229566418524], [5.630534001339328, 48.0839862152433], [5.6843187075882495, 48.14504209498634], [5.7108437679155655, 48.21992832819694], [5.640901189478501, 48.24235420494444], [5.482149185087855, 48.35620132428276], [5.408721169498743, 48.383100190451266], [5.4700481951761715, 48.42092912175581], [5.349469998299744, 48.48198867903505], [5.208425883036941, 48.53861075459186], [5.118346103266605, 48.595510860548025], [5.070888258264775, 48.59572522100363], [5.005925627052494, 48.63403550117788], [4.988427677798424, 48.684418562247224], [4.9112683198753935, 48.68871245200531], [4.841961389732739, 48.649667045531814], [4.849256143140029, 48.62363257093909], [4.769195892207036, 48.58868831064457], [4.799180099828291, 48.529779876263504], [4.670183207291811, 48.53188730233758]]]}, 'attributes': {'CODE_DEPT': '52', 'NOM_DEPT': 'HAUTE-MARNE'}}, 40: {'geometry': {'type': 'Polygon', 'bbox': (726344.2999999899, 6263118.800002612, 847769.4999999425, 6373918.100002329), 'coordinates': [[[4.649223666100485, 44.27035986501103], [4.55869985714841, 44.302444632604974], [4.5035362130646455, 44.340188451230844], [4.336073225463423, 44.339522743700364], [4.288416558058853, 44.31465868784345], [4.25884619798255, 44.264785576428054], [4.142867700090412, 44.313350855400145], [4.051451662788466, 44.317323657117086], [4.068441217053273, 44.405113572942064], [3.998162987763964, 44.45979755586332], [3.944362317344653, 44.399567503492385], [3.8859181039452233, 44.38799905234699], [3.952331315351652, 44.328389996777126], [3.922858913740669, 44.305217941025745], [3.9513171396124562, 44.24779542988908], [3.9526044819739092, 44.17079372606867], [3.862104986455047, 44.13007375244107], [3.7969951126604835, 44.12738907948696], [3.678640671819198, 44.18275878035759], [3.6377691613510246, 44.17548804418238], [3.633491144032294, 44.12269533049063], [3.4397298934659633, 44.12909826593232], [3.373648044830684, 44.17075587210572], [3.3360602348274, 44.15867236265559], [3.328910418620988, 44.07902990387489], [3.4507554815828207, 44.02078728434542], [3.358359441304462, 43.91383289325508], [3.4244480676686226, 43.9115981684474], [3.5307009207380955, 43.855624713961724], [3.5754482408134063, 43.86552224087749], [3.6235886150953553, 43.91697856675764], [3.726990344828379, 43.96901626259547], [3.787325021892116, 43.96687037520123], [3.824905456819552, 43.91929773950891], [3.830797043559706, 43.86642403487079], [3.917385092127717, 43.885593220663814], [4.002046166191344, 43.81146444231592], [4.144780927023585, 43.73388653553421], [4.194441206758988, 43.65430382623312], [4.150215691493674, 43.58556246815695], [4.1010416754063925, 43.55437094640871], [4.13912342859037, 43.53189642273357], [4.13766421830876, 43.48194592546537], [4.230283393392478, 43.46018543272649], [4.238105541141803, 43.497626917839995], [4.409349673740097, 43.561127800636186], [4.427028042117802, 43.62067757183961], [4.487236861293796, 43.69923776661928], [4.5930322483013235, 43.68746240297304], [4.654821446467849, 43.806408691630295], [4.641909591242105, 43.86747754714173], [4.739060856654237, 43.92405947349065], [4.842093969959471, 43.986474548464955], [4.787978024928094, 44.065054097470245], [4.707458356688191, 44.10367246401253], [4.722074664233515, 44.18742154948275], [4.649223666100485, 44.27035986501103]]]}, 'attributes': {'CODE_DEPT': '30', 'NOM_DEPT': 'GARD'}}, 41: {'geometry': {'type': 'Polygon', 'bbox': (990508.299999954, 6789869.300001165, 1081448.299999941, 6895577.800000864), 'coordinates': [[[7.1982815370299456, 48.310467861035285], [7.275183721811301, 48.3052347870644], [7.348562541549848, 48.24719461957468], [7.476943375699937, 48.203536684298435], [7.470560946722399, 48.16101452404043], [7.519368638022094, 48.12611186664675], [7.577312855212314, 48.120368521818186], [7.667802806274932, 48.22391081447789], [7.703140260600039, 48.3088120928765], [7.73988076758838, 48.321748229095604], [7.735975751999303, 48.40415792791916], [7.768185493209042, 48.489658145885635], [7.805195566047562, 48.51357147162407], [7.804169862129346, 48.592334654361416], [7.839817246895408, 48.641373985119756], [7.963140045094564, 48.72135309730477], [7.9717451577555725, 48.757628209866056], [8.09632056331982, 48.81038371016163], [8.14793847273242, 48.90380819881706], [8.214337990422152, 48.97509304801685], [8.091376040143567, 48.98925821692837], [7.934626827531662, 49.057809150319585], [7.868785609773861, 49.034157073278124], [7.800436670933279, 49.06411681073709], [7.732229514556393, 49.04436019364183], [7.635285449703197, 49.05416135519033], [7.578392137539887, 48.95740241812128], [7.538259039250205, 48.93296158495443], [7.446887904100118, 48.96577914856757], [7.326851980608823, 48.943372742034434], [7.29304884880289, 48.9734164509209], [7.17424027072314, 49.00636568135154], [7.107657105402385, 49.04411352332804], [7.054911912536332, 49.03061918772984], [6.989216409797389, 48.95992878869148], [6.964601688658045, 48.90452526766878], [7.045342890531057, 48.87154914038007], [7.054514540544792, 48.81370438623761], [7.126799106595454, 48.80114235821405], [7.149408408912649, 48.84470403838557], [7.311900506296782, 48.76730084432443], [7.242487615031405, 48.69154313192023], [7.283044927480475, 48.63810720118507], [7.256281654444216, 48.58867550766629], [7.167909935894841, 48.52759644356372], [7.0793597709732445, 48.536417612714544], [7.1231653690285635, 48.51359226557106], [7.097427065168082, 48.40564467454505], [7.1219084409759965, 48.33329037922002], [7.1982815370299456, 48.310467861035285]]]}, 'attributes': {'CODE_DEPT': '67', 'NOM_DEPT': 'BAS-RHIN'}}, 42: {'geometry': {'type': 'Polygon', 'bbox': (593467.3000000443, 6174169.900002814, 719561.0999999918, 6262595.80000261), 'coordinates': [[[3.24056113717041, 43.21280863308419], [3.2010265503923754, 43.24916714805378], [3.1472079664155532, 43.24700506844506], [3.004740938100306, 43.28853825294436], [3.004349268167806, 43.3201311415977], [2.8327620472635995, 43.32241280561742], [2.772248225673249, 43.25778564580627], [2.6016030790296316, 43.29870698639696], [2.5399619094859687, 43.346221862319766], [2.5657873980365586, 43.4229597441041], [2.4331017858919792, 43.43517605493282], [2.4036304838758644, 43.41867070093128], [2.259100479380118, 43.45992952515688], [2.224167733501991, 43.43176717254877], [2.0728007398118375, 43.39568694741014], [2.0291328387973606, 43.4368979648422], [1.9101007956285108, 43.40405939980924], [1.8587429714302222, 43.44382089121744], [1.8040846789340412, 43.39168480485624], [1.8134240645221509, 43.34140359698674], [1.7477325973047735, 43.34374010112299], [1.6884197209147513, 43.27355372810057], [1.7238440687530254, 43.224524250769115], [1.7100564477992013, 43.18969803410906], [1.8247721988689323, 43.14581388915543], [1.9494758652019253, 43.11949443816388], [1.9411328732906326, 43.052715472626794], [1.9851004481943353, 43.02627232234244], [1.9869209142233524, 42.87101168756068], [1.8804739886198156, 42.85266926902656], [1.9081798281291236, 42.76766704348015], [1.955395663529541, 42.73670079860324], [2.057204243184995, 42.75622286126001], [2.1758741195218594, 42.68279522431071], [2.166053682054993, 42.66391836976537], [2.322006120391769, 42.70779157620252], [2.357535079462851, 42.73412195489046], [2.327116045977923, 42.83744277583194], [2.4524747607108766, 42.83693276356485], [2.5090117260388043, 42.8498316897036], [2.6975776462485945, 42.83043106598879], [2.7400003158100112, 42.837574151817094], [2.789053819259419, 42.895988728811666], [2.8652738803519484, 42.91834143726111], [2.917114990593263, 42.88486022074895], [3.0434985865888815, 42.83815011921819], [3.060589297455898, 42.91705990494522], [3.0428431893335772, 42.9601537879993], [3.1172205062222833, 43.10183913719133], [3.24056113717041, 43.21280863308419]]]}, 'attributes': {'CODE_DEPT': '11', 'NOM_DEPT': 'AUDE'}}, 43: {'geometry': {'type': 'Polygon', 'bbox': (655720.9000000084, 6780535.000001167, 740951.9999999929, 6890862.900000851), 'coordinates': [[[2.936314411640624, 48.163391744163064], [3.0051556578134635, 48.20767000036064], [3.043627253848888, 48.272022357627314], [3.0495188960927044, 48.36012035558039], [3.167737573570585, 48.371860839541355], [3.3651592673815314, 48.372280687121055], [3.4147915595010963, 48.390273038835076], [3.3919598867876517, 48.42432215347003], [3.423442380707056, 48.53356269241414], [3.5038535314822115, 48.60480913448515], [3.5556137492385345, 48.62028467658828], [3.460426313142606, 48.65300999880743], [3.4769636430994466, 48.699358067133204], [3.4358089868027415, 48.753571716354905], [3.4851874436586847, 48.85190849438655], [3.4032194510047127, 48.86468651933575], [3.3302994547269797, 48.908706088655926], [3.3047494707754015, 48.948764278958], [3.171683982224406, 49.01412318431705], [3.16523032905892, 49.099650858000736], [3.071884293834167, 49.11755421882924], [3.0085155429257675, 49.09151015781777], [2.735012683493696, 49.060449825264335], [2.633272965218076, 49.108376218976154], [2.5905242793946224, 49.079654846745605], [2.55306064485419, 49.00981711745223], [2.602598431431983, 48.92935660279411], [2.5626221662429587, 48.888884130538436], [2.592280488308802, 48.80743667582849], [2.6136476481340414, 48.76102719230643], [2.5716603184420737, 48.69201409166007], [2.5336160068074505, 48.6573313888409], [2.5437765144069613, 48.60384977115981], [2.4995246743322403, 48.52523904801557], [2.504749755053753, 48.43944601613285], [2.533731834361712, 48.41125114634581], [2.4298322285044196, 48.36201578313258], [2.402664267131608, 48.320719459436084], [2.4237635277023717, 48.26029732659773], [2.506191747348858, 48.23853573046795], [2.5381092459271755, 48.1406481032753], [2.7065470696044738, 48.124819245820426], [2.7989445730680167, 48.16827665011802], [2.936314411640624, 48.163391744163064]]]}, 'attributes': {'CODE_DEPT': '77', 'NOM_DEPT': 'SEINE-ET-MARNE'}}, 44: {'geometry': {'type': 'Polygon', 'bbox': (583879.5000000115, 6942514.300000707, 713832.6999999986, 7030025.100000476), 'coordinates': [[[3.090253620620082, 50.0537405551461], [2.87653264314694, 50.04217932425911], [2.857843650412817, 50.077393119013884], [2.5760198137336725, 50.11341281006871], [2.551329915710551, 50.141605436872034], [2.4766865519087604, 50.13699947000749], [2.414507925852589, 50.100642406879025], [2.389777056686568, 50.15548482145538], [2.495690327572777, 50.19456202412894], [2.4517852065078483, 50.23030237701513], [2.3702049076387826, 50.209770358333444], [2.2738282654200974, 50.226839899630434], [2.0957483707167435, 50.20554490564382], [2.077820295455588, 50.2488212597536], [1.9461316429137003, 50.28742804274709], [1.9180007470953697, 50.3117787753595], [1.7787842601942676, 50.36186618073267], [1.6707155098465685, 50.331010399908095], [1.6415439209955998, 50.35215320245149], [1.5509358115042573, 50.35032330174563], [1.5379477347729347, 50.28266847459979], [1.5902673346965246, 50.25595102356094], [1.478714399387514, 50.16491841312994], [1.453881224461018, 50.11032909894591], [1.3797050374151874, 50.06501467639243], [1.4564621593341678, 50.03783334266402], [1.678450674227239, 49.91813416150288], [1.7270555289768355, 49.82888410523527], [1.7838370588623418, 49.7583075010794], [1.8938643249004963, 49.69898823077294], [1.933209822166273, 49.71962996350131], [2.121409706926089, 49.688074091756725], [2.2471685906926684, 49.70164087682517], [2.3731456632291623, 49.65626624027031], [2.504748899250395, 49.63946726892116], [2.571493337841171, 49.597080627026244], [2.670723151725744, 49.581411971799525], [2.6891419821315017, 49.625601863486416], [2.7994949073615056, 49.62058605182692], [2.793612422958185, 49.65595422264364], [2.915712813038834, 49.70267238897875], [3.1184031553047866, 49.70596856016259], [3.078694114076548, 49.82241521579585], [3.117968662907868, 49.91427637799499], [3.1926752854802194, 49.9774646962746], [3.1727072271768164, 50.011994944690635], [3.090253620620082, 50.0537405551461]]]}, 'attributes': {'CODE_DEPT': '80', 'NOM_DEPT': 'SOMME'}}, 45: {'geometry': {'type': 'Polygon', 'bbox': (708104.1999999973, 6405343.300002245, 816369.7999999607, 6481030.400002034), 'coordinates': [[[3.1034981328800555, 45.35437310008839], [3.1179979977042014, 45.284187297622296], [3.222465248668949, 45.271971446584864], [3.2880332175079103, 45.120424409579364], [3.3257851579159827, 45.09513611769889], [3.2972503187682016, 45.03607778789884], [3.3471986847617563, 45.014233878924244], [3.3613425807398936, 44.97141170967906], [3.412834742275399, 44.944842501975934], [3.4179705141646854, 44.90076835769564], [3.4757737071599757, 44.81537151910519], [3.589348917106291, 44.83219404802301], [3.5943359966689914, 44.87542977006513], [3.6595223843815874, 44.8699386445054], [3.6663649146430073, 44.82877808873485], [3.7406507355868404, 44.83869734813907], [3.862527190139651, 44.74386343467101], [3.937001123548729, 44.79541721729978], [4.0283748583288785, 44.834081003006226], [4.039638866980703, 44.87316201331418], [4.156154791813548, 44.87333360834139], [4.221702631142119, 44.96133612938681], [4.289827924670836, 44.99730682920303], [4.375306064703462, 45.10483231156172], [4.376558944791765, 45.14435959050196], [4.4432627898030574, 45.140832955911634], [4.483134616383878, 45.2364464819279], [4.418571110077435, 45.275424101661145], [4.362548869116956, 45.26439535681795], [4.366534405291163, 45.33699593440981], [4.308199323181691, 45.37098690693714], [4.177926371804464, 45.3926048786864], [4.024824051546119, 45.34288771363736], [3.97965057221058, 45.37513435596753], [3.897408424881887, 45.357083781715666], [3.8083099578489272, 45.391611966842156], [3.7722554467335283, 45.349191883525606], [3.667209012708465, 45.37619709113052], [3.625846869344361, 45.33834565932035], [3.501320580432494, 45.427578687052645], [3.4567465988864985, 45.40028672539175], [3.290691872112179, 45.401821892426085], [3.1680632240379363, 45.352259807508055], [3.1034981328800555, 45.35437310008839]]]}, 'attributes': {'CODE_DEPT': '43', 'NOM_DEPT': 'HAUTE-LOIRE'}}, 46: {'geometry': {'type': 'Polygon', 'bbox': (732040.0999999946, 6824301.40000104, 848914.8999999773, 6923412.200000763), 'coordinates': [[[4.047972977986833, 49.40564229477001], [4.035496373111564, 49.359904159442664], [3.9244337055179415, 49.406181771301206], [3.8474771401321166, 49.364586629449846], [3.6469532050746403, 49.31515350352492], [3.704392046963459, 49.181373023481946], [3.622246623748465, 49.15110369338968], [3.600004656260228, 49.12069184513826], [3.646307433571441, 49.04058839071644], [3.6015984944904185, 48.944072041330806], [3.5285764431169526, 48.912141028966566], [3.4851874436586847, 48.85190849438655], [3.4358089868027415, 48.753571716354905], [3.4769636430994466, 48.699358067133204], [3.460426313142606, 48.65300999880743], [3.5556137492385345, 48.62028467658828], [3.634028277746641, 48.54129826319994], [3.730879401425958, 48.53746785522521], [3.822742058660398, 48.51610441782203], [3.9492266572894197, 48.60343162809795], [4.001695483416846, 48.66387541822405], [4.080262439820496, 48.70106898078487], [4.166386793257749, 48.70745423754145], [4.325594012298644, 48.700277029545035], [4.315905486866125, 48.615578923340706], [4.40306312166006, 48.56126039350177], [4.545406992928757, 48.52525227165607], [4.614026636401956, 48.55380713072681], [4.670183207291811, 48.53188730233758], [4.799180099828291, 48.529779876263504], [4.769195892207036, 48.58868831064457], [4.849256143140029, 48.62363257093909], [4.841961389732739, 48.649667045531814], [4.9112683198753935, 48.68871245200531], [4.988427677798424, 48.684418562247224], [4.990124563499123, 48.74183736488204], [4.888760929797641, 48.81720971455143], [4.9362093920054075, 48.92214239513739], [5.030128675561755, 48.95690245548527], [5.036321445219877, 49.02433254955411], [5.007681402681856, 49.034951950784894], [4.992117611940037, 49.11490008828468], [4.9397619983736725, 49.185068204591545], [4.950989232683009, 49.236865846314195], [4.894206220282045, 49.2590743389563], [4.826941205469511, 49.23576093817319], [4.686074799511885, 49.256759043814334], [4.6251041072703405, 49.23565606344571], [4.575868215345435, 49.2966511893251], [4.422583188651027, 49.28064492916811], [4.306756525620348, 49.32779732812255], [4.248308184547379, 49.38225617649833], [4.1431697526129865, 49.404187032451034], [4.047972977986833, 49.40564229477001]]]}, 'attributes': {'CODE_DEPT': '51', 'NOM_DEPT': 'MARNE'}}, 47: {'geometry': {'type': 'Polygon', 'bbox': (428150.0000001159, 6178840.6000028085, 506455.20000008016, 6283050.700002572), 'coordinates': [[[-0.3134428634980887, 42.849375059707675], [-0.14599159174135176, 42.768466932454174], [-0.10610940781291786, 42.72082372641465], [-0.01063758464629181, 42.684385085093275], [0.1757204586573474, 42.73648479569695], [0.25988295627208224, 42.71581111366553], [0.29282224858132516, 42.674924581801044], [0.3596287954835796, 42.72339183232163], [0.4292757338727024, 42.69074972940043], [0.47774954032737066, 42.69999034279803], [0.45509422507364955, 42.72806064199966], [0.45889951642403815, 42.82814521426843], [0.4773013441230268, 42.87810749616219], [0.5759351469518764, 42.87082592303985], [0.6274179241908862, 43.00010287323438], [0.5630044583601449, 43.01746794817719], [0.5322696523895433, 43.093864488407355], [0.4419985587106286, 43.13127313187037], [0.5518748957180646, 43.209147130092994], [0.5515684940570379, 43.236102503746885], [0.616280054756598, 43.28903679046815], [0.6068109749570959, 43.31088599158559], [0.49803381879209696, 43.326180572401476], [0.2772545000281141, 43.38579092290556], [0.1820312140000643, 43.37118267445086], [0.13798238183895745, 43.43291627195171], [0.11212423457670412, 43.51736991981866], [0.056081443916198466, 43.518807249853], [-0.0019248187812945813, 43.56554046143878], [-0.015780894995830342, 43.60465738319832], [-0.0967829732087741, 43.58240589763179], [-0.04013178615003942, 43.51260540210091], [-0.0690310020330968, 43.4373492706762], [0.009598314167785659, 43.42210994370394], [-0.046122416801734574, 43.300855792904095], [-0.01700753125072415, 43.270453175935074], [-0.11770146168361151, 43.180326663081985], [-0.14613235140227143, 43.12823595997721], [-0.19098404402245037, 43.111200014851946], [-0.22395152380116093, 43.033687539644006], [-0.291551876667032, 42.98776781593251], [-0.2815909254844988, 42.93356279018245], [-0.32708213440188894, 42.91578162376447], [-0.3134428634980887, 42.849375059707675]]]}, 'attributes': {'CODE_DEPT': '65', 'NOM_DEPT': 'HAUTES-PYRENEES'}}, 48: {'geometry': {'type': 'Polygon', 'bbox': (541672.6000000585, 6348642.700002397, 637121.800000023, 6439627.500002151), 'coordinates': [[[1.0751408247250984, 44.57732478356566], [1.01316664592295, 44.536127142275056], [1.0090253989657338, 44.48004110906175], [1.0640838318649115, 44.37851326503546], [1.1079385683846075, 44.32740288340593], [1.2813793816235723, 44.23578619286313], [1.3803681196871471, 44.22485773308447], [1.5205387676670996, 44.263269755581995], [1.5691379539986454, 44.29839388706534], [1.6516207663148532, 44.28680580678524], [1.6995029158165786, 44.313814281404596], [1.8820828575359034, 44.3400652488443], [1.83959954163412, 44.47590016897012], [1.9314678023099077, 44.5063942771541], [2.0573690252842423, 44.582905559661995], [2.153816544170514, 44.57190145626477], [2.207475285530841, 44.6155316765299], [2.1694177928364127, 44.638066191426034], [2.1534919160094748, 44.753107579025304], [2.171636274864375, 44.79002439871239], [2.0942123106720874, 44.87201148950678], [2.0629142919730623, 44.97650640551568], [1.9081561620078975, 44.978426771844745], [1.8239145263410472, 44.92768244845702], [1.7506251087427585, 44.954959479535844], [1.6509837683346413, 45.02501608647886], [1.5357253751118871, 45.04628038727674], [1.4482615439322117, 45.01931315867412], [1.4132990300005654, 44.99938624261534], [1.4419204827421668, 44.87757922298141], [1.3614038259537624, 44.84079526684306], [1.364102971342699, 44.811568186415315], [1.287782139460227, 44.714781096530565], [1.2245500554542503, 44.68426634892967], [1.1466718447537783, 44.67034606645634], [1.1537937079861713, 44.63940626971528], [1.0751408247250984, 44.57732478356566]]]}, 'attributes': {'CODE_DEPT': '46', 'NOM_DEPT': 'LOT'}}, 49: {'geometry': {'type': 'Polygon', 'bbox': (899977.8999999232, 6293054.100002545, 1014122.199999877, 6403290.200002269), 'coordinates': [[[6.636395800176684, 43.78895056709553], [6.697323345466608, 43.87365480225305], [6.745556290785884, 43.872108256875045], [6.830709312232405, 43.918363011486576], [6.884610185550847, 43.889120756894144], [6.913088787529998, 43.92796536503895], [6.851891862245591, 43.95479401195963], [6.836004210977611, 43.99060185096192], [6.7457139505011225, 44.043235362043276], [6.755280297628581, 44.07860658695586], [6.686536427072904, 44.169253930861075], [6.7239938850023835, 44.24984330468271], [6.796090992510112, 44.31610570751239], [6.88742990090296, 44.3610478380362], [6.8819574044011205, 44.477252952765745], [6.854013487274841, 44.529129653944274], [6.933506639572193, 44.5759517467791], [6.948335091404861, 44.65481629914683], [6.914488202179286, 44.65949945810221], [6.839801667428219, 44.60858882906445], [6.772207133133649, 44.58890871380483], [6.684305299896707, 44.54130010645845], [6.632376327558709, 44.44712877640482], [6.562444503095603, 44.44549275371164], [6.413884950226282, 44.4692899596284], [6.362000081358195, 44.52207257904401], [6.233718236049833, 44.4638309183279], [6.262481962582939, 44.41225003856598], [6.228221718294847, 44.3817003919971], [6.155615049010708, 44.46195982298566], [6.071139333430846, 44.45053588827675], [5.9536703829504924, 44.395059266699306], [5.912323479912073, 44.27153166809458], [5.82391188904594, 44.2789019553126], [5.881793583616446, 44.21099866254289], [5.755494196596879, 44.210207765237946], [5.6760373255434615, 44.19143313185903], [5.63959354437225, 44.16758605191373], [5.576187167563138, 44.18804165094914], [5.543986124993945, 44.136390782725556], [5.498787806458752, 44.11571934778844], [5.502636785327954, 44.06343920865502], [5.543656674317525, 44.02870768768531], [5.51208954255573, 43.94600228564655], [5.607126670731597, 43.91377284375335], [5.578189791221216, 43.82992112219797], [5.654445137414141, 43.82511098585945], [5.757332977582704, 43.72940911375542], [5.781343238677484, 43.75565738832385], [5.901207402568148, 43.73258459518493], [6.036131813943926, 43.694163340855255], [6.182886008281907, 43.76217559136379], [6.216709972579084, 43.79951197699887], [6.356960735074888, 43.736367664887325], [6.413483066219063, 43.76036041847228], [6.4144280526034985, 43.791594458434275], [6.5247619833224295, 43.80636597788814], [6.636395800176684, 43.78895056709553]]]}, 'attributes': {'CODE_DEPT': '04', 'NOM_DEPT': 'ALPES-DE-HAUTE-PROVENCE'}}, 50: {'geometry': {'type': 'Polygon', 'bbox': (442127.900000055, 6722018.100001343, 542578.400000031, 6823412.100001052), 'coordinates': [[[0.6144311990931562, 47.69421364606964], [0.5805178732790726, 47.71232800972914], [0.7126298064021267, 47.79003621973886], [0.7745788175007332, 47.839687295150405], [0.7598746908928189, 47.89822684022159], [0.8458005593594112, 47.941401463859776], [0.7974846748199693, 48.037554414552474], [0.8412172317044133, 48.10306240933596], [0.8824911871126113, 48.161763238455556], [0.7976558384942257, 48.19445221756441], [0.7378268325294973, 48.18907227443458], [0.6832238274745249, 48.248585603870666], [0.5359730618565093, 48.24984731425016], [0.4875722818038879, 48.307800269645206], [0.3826045470591676, 48.33382739377157], [0.36395898803578647, 48.45163268084123], [0.2958599914991128, 48.48017405402528], [0.11624508246972828, 48.43555379653748], [0.062488371910724295, 48.38221653184688], [-0.002558831894627075, 48.39731388623217], [-0.05453120471342507, 48.38200345783028], [-0.13797809431803368, 48.361355595694256], [-0.16309583433799704, 48.25554245624931], [-0.1468370673865552, 48.20500891985261], [-0.24992127138834194, 48.157106805256824], [-0.2171740033885255, 48.106959664577076], [-0.23094244360355717, 48.058985357501875], [-0.34166482709193685, 48.043095522813545], [-0.2826331784456293, 47.95819180740859], [-0.384840280948404, 47.93084465849811], [-0.37067332986759555, 47.88002461791639], [-0.44785891788114673, 47.832216379468825], [-0.38820058256862766, 47.80531865640709], [-0.38170327004272336, 47.76056283995018], [-0.33407702419886187, 47.721165759995365], [-0.2330603877794416, 47.707562003167425], [-0.1931572478064973, 47.64791658039038], [-0.13503673265540259, 47.63251997721371], [-0.07183106759512486, 47.65800746667544], [-0.004507638464451783, 47.64768842380694], [0.051659308485924815, 47.60651520171707], [0.15160368312924277, 47.581534768491814], [0.23000172635318558, 47.608398291933725], [0.3789609617763965, 47.569104055270486], [0.45663070361835567, 47.6388264115843], [0.542891970097039, 47.65620713810867], [0.6144311990931562, 47.69421364606964]]]}, 'attributes': {'CODE_DEPT': '72', 'NOM_DEPT': 'SARTHE'}}, 51: {'geometry': {'type': 'MultiPolygon', 'coordinates': [[[[-3.2354453135683303, 47.32381750417188], [-3.086556315866053, 47.28307372555509], [-3.0931183741107304, 47.31513470944217], [-3.155860890833796, 47.36108442086488], [-3.2487748311646665, 47.379576048214616], [-3.2354453135683303, 47.32381750417188]]], [[[-3.5230042934996066, 47.84914685715857], [-3.5299269866083165, 47.78246448850768], [-3.452760568692726, 47.695341637300814], [-3.3442177923412864, 47.70836269956608], [-3.208127827120783, 47.6634208285362], [-3.2097530809913435, 47.64069004036757], [-3.123258986370401, 47.569508156886485], [-2.975177828281593, 47.576071697749526], [-2.8511507321351166, 47.61902226485759], [-2.77857375285652, 47.61915856972313], [-2.701950798992519, 47.58991904582013], [-2.7305385199390986, 47.54248870669774], [-2.8136159976601767, 47.552972982703686], [-2.871566103275048, 47.532183584787376], [-2.8002084412292914, 47.48727462509061], [-2.664337299385734, 47.51863653795232], [-2.537129650340701, 47.52567909144418], [-2.4412239148217294, 47.49623958284173], [-2.458489165173328, 47.44812172073537], [-2.312868292914679, 47.46446874949351], [-2.1073336439134778, 47.53105690026967], [-2.097035597340285, 47.631359844030904], [-2.131472084919134, 47.72224026217332], [-2.0897121808782697, 47.73856050587445], [-2.049526070392867, 47.8169173979452], [-2.1162985684590634, 47.88095628990024], [-2.079088544973961, 47.91952249841043], [-2.1368653813504146, 47.979116800921744], [-2.2395935242179426, 47.999461627992105], [-2.279595013670352, 48.02636073133588], [-2.2332446439270153, 48.075627876360535], [-2.287278430400509, 48.13374556347385], [-2.3713647531616733, 48.12210300840669], [-2.4089048721706594, 48.16861132667282], [-2.49481856978248, 48.15784478551255], [-2.5747859613042996, 48.070410038491524], [-2.6311897590265905, 48.035479312779835], [-2.670050948442368, 48.047883952925766], [-2.652301006956971, 48.119324663861974], [-2.781951132488675, 48.120579730854125], [-3.0335402161271037, 48.19936064624241], [-3.116373512585391, 48.20636380948965], [-3.1552540693335693, 48.158490943543626], [-3.2722443396278273, 48.14001476485908], [-3.33675473563501, 48.17112526547111], [-3.5648389737333277, 48.185746943072594], [-3.695838514922977, 48.15221175123511], [-3.695020686823403, 48.093494659480534], [-3.6402315330750725, 47.98524271313111], [-3.5552758457516056, 47.99309847047771], [-3.4848124678130397, 47.966889784603126], [-3.392624522513051, 47.95445115827384], [-3.4034429894056712, 47.87011455487806], [-3.5230042934996066, 47.84914685715857]]]]}, 'attributes': {'CODE_DEPT': '56', 'NOM_DEPT': 'MORBIHAN'}}, 52: {'geometry': {'type': 'Polygon', 'bbox': (534094.1000000313, 6762847.800001221, 625387.4000000142, 6872272.800000905), 'coordinates': [[[0.8148191028635929, 48.670167960202036], [0.8506421037670122, 48.58262673082052], [0.9665513231299335, 48.52274528509245], [0.9422407728065412, 48.399001153466926], [0.8833710269390447, 48.35667269478065], [0.7854319060188932, 48.34042724029942], [0.7621929543543114, 48.30687661402512], [0.830483470832425, 48.21071322673855], [0.7976558384942257, 48.19445221756441], [0.8824911871126113, 48.161763238455556], [0.8412172317044133, 48.10306240933596], [0.997330007937029, 48.12749350968228], [1.0085477409246673, 48.08312677901138], [1.1122333320073277, 48.08072912595507], [1.1212335165894016, 48.039115919496666], [1.2096430686639745, 47.96850051669979], [1.3086281518302285, 47.953853799784625], [1.5201238283340495, 47.98227847700274], [1.5129757558119397, 48.028721780858234], [1.5941156652809603, 48.030699920759346], [1.624592871969399, 48.06722274292949], [1.7448338583126364, 48.066144349606134], [1.8656712589157687, 48.083857198730676], [1.9654790051841278, 48.25546624531193], [1.994084718059379, 48.28658587795807], [1.9765777946992389, 48.399384474494646], [1.9305557503485928, 48.404124841843824], [1.9221489648373706, 48.45760028607871], [1.801445837919035, 48.466087959629114], [1.765329716198042, 48.56937104101408], [1.7092527874670105, 48.57802434627667], [1.602498423421542, 48.66376910929475], [1.5795458299182854, 48.70181187350343], [1.5912030850964913, 48.81486963941434], [1.5572502545823872, 48.89157660949543], [1.5015238197988672, 48.94105360616862], [1.4683503712150046, 48.892217344506555], [1.3621810029001888, 48.83417900338667], [1.3769640090609687, 48.79176905229479], [1.3195484140595366, 48.76096509556615], [1.1847306025015367, 48.772630163271536], [1.0316566693561064, 48.73058345602126], [0.8767072376479738, 48.71549244583088], [0.8148191028635929, 48.670167960202036]]]}, 'attributes': {'CODE_DEPT': '28', 'NOM_DEPT': 'EURE-ET-LOIR'}}, 53: {'geometry': {'type': 'Polygon', 'bbox': (1159341.799999797, 6050135.700003077, 1233465.899999756, 6158598.900002873), 'coordinates': [[[9.402268324411988, 41.8586982422724], [9.329200877550077, 41.83681486608324], [9.227497390904741, 41.85558903234797], [9.221084024655989, 42.0275969605392], [9.160818391906192, 42.02601714338066], [9.119729450195365, 42.10777443178623], [9.07218689177604, 42.13021371520025], [9.04565931380628, 42.2069234314084], [8.904766989145307, 42.253859280701064], [8.819561377056067, 42.31755804188299], [8.640801666424288, 42.373436353833135], [8.573411068108614, 42.381405712050416], [8.689105710448825, 42.263523971751304], [8.616716018939044, 42.25545987317005], [8.570335354249012, 42.230300263765095], [8.590170524060465, 42.16388769237896], [8.6605051108979, 42.10358657526475], [8.71025694439948, 42.09582422568574], [8.741332481964943, 42.04090929509718], [8.65641983419225, 42.00934596433846], [8.668873449917275, 41.98243065721414], [8.59769539752256, 41.95324306386655], [8.64145251301252, 41.90988911486005], [8.721430218965407, 41.90925797590231], [8.754903133430052, 41.93256867906016], [8.803137234079097, 41.89138353772907], [8.771293565923225, 41.81123955107434], [8.684518163125169, 41.747002267405335], [8.717235397872976, 41.72277126801705], [8.914509146058741, 41.68972719719787], [8.877266064638947, 41.65245090152453], [8.793074221956438, 41.62955272381404], [8.788528375117986, 41.55773356360875], [8.841680682750065, 41.54654924536316], [8.938397598811326, 41.48966696643918], [9.082197812197029, 41.441977672838874], [9.09553200430217, 41.41243171053331], [9.219681605069644, 41.36821448934], [9.228899383902924, 41.425302802667254], [9.265877253287043, 41.46599484844734], [9.287551136639262, 41.5302255321191], [9.340900099192766, 41.55924531057797], [9.327204087148893, 41.6163597070917], [9.387496558130868, 41.65736235225344], [9.407323413987857, 41.767639126591654], [9.402268324411988, 41.8586982422724]]]}, 'attributes': {'CODE_DEPT': '2A', 'NOM_DEPT': 'CORSE-DU-SUD'}}, 54: {'geometry': {'type': 'Polygon', 'bbox': (878534.0999999767, 6809622.900001093, 1004384.8999999457, 6942685.000000716), 'coordinates': [[[5.47091013059277, 49.497205021307316], [5.461779526865532, 49.45269148820623], [5.529099312496952, 49.40737462727894], [5.634565984546506, 49.43743606552824], [5.688147604064061, 49.41510555458638], [5.7317860065833734, 49.31134319109833], [5.719044394768754, 49.215986946434604], [5.765544232834611, 49.19808862805665], [5.7444679167795965, 49.15659587124916], [5.76336075838886, 49.1078799656107], [5.818638375145696, 49.08617366651453], [5.823066740236894, 49.023106618165144], [5.800245290300756, 48.946746057604365], [5.747161790828688, 48.915257872650564], [5.780971762726474, 48.826749431299106], [5.71403634947959, 48.74453330887042], [5.757709339561898, 48.6956983342433], [5.7617670452603855, 48.60939047861274], [5.716089821783749, 48.561424169831746], [5.776211888772464, 48.540359251581435], [5.765154701602298, 48.49649260852762], [5.856069666360069, 48.506844385600004], [5.961559100039155, 48.34989070448248], [6.1167237857285315, 48.35403844101338], [6.178419125638963, 48.39759887801264], [6.566974228865648, 48.41903184703233], [6.584971476704243, 48.460509163634704], [6.699498339648206, 48.413087540770555], [6.815166528707746, 48.398846200580046], [6.890810652427115, 48.41809431515708], [6.982986004562884, 48.47905957980011], [7.1231653690285635, 48.51359226557106], [7.0793597709732445, 48.536417612714544], [6.982882241286177, 48.61186293046636], [6.844053536871701, 48.62597500457003], [6.754672851450039, 48.66938665044198], [6.692283881384656, 48.67284039539553], [6.658407329856349, 48.708047286296704], [6.5989655709524815, 48.715690797796334], [6.554148775117041, 48.75409250997109], [6.355030133568448, 48.78165892452694], [6.338947107825572, 48.834058199842104], [6.2719777673374155, 48.93313559709069], [6.132207146051101, 48.93472094775403], [6.116898532084445, 48.96783320585781], [6.043435324319258, 48.977477915984394], [6.0449969560102, 49.01041872050658], [5.935399690626693, 49.071852219751314], [5.931603285178867, 49.10910433833667], [6.026149940244402, 49.16511893600301], [5.987627297222746, 49.20961691714645], [6.029385386695151, 49.23047199222701], [5.928530586493156, 49.37550729351067], [5.942619950432161, 49.45289553697136], [5.893401083719672, 49.49690975012321], [5.793930405166044, 49.55124020374713], [5.7152789345945125, 49.5393397855389], [5.659768488051474, 49.55287086490548], [5.47091013059277, 49.497205021307316]]]}, 'attributes': {'CODE_DEPT': '54', 'NOM_DEPT': 'MEURTHE-ET-MOSELLE'}}, 55: {'geometry': {'type': 'Polygon', 'bbox': (414934.20000005106, 6790042.700001144, 549859.0000000268, 6877306.500000899), 'coordinates': [[[0.41281453288908837, 48.95062636770782], [0.3337726147565286, 48.942883562795664], [0.2756400197144905, 48.96474519881211], [0.15647487005382918, 48.92478758357601], [0.12760760912750327, 48.9522190708013], [0.05639799250069023, 48.90246403867087], [-0.058807463588442944, 48.85358688784485], [-0.14634308820607453, 48.83444909950848], [-0.3059210867390902, 48.85830715301278], [-0.3462445710154035, 48.82199914076007], [-0.41151869249428263, 48.87014004742435], [-0.4637527288822014, 48.87136647589269], [-0.71467861188995, 48.79986774273136], [-0.8409353560137907, 48.75222016384713], [-0.7989559815697852, 48.71018883782028], [-0.7526143435139788, 48.617618520546905], [-0.7741715461672711, 48.56267832834257], [-0.8603629154348665, 48.50145849653701], [-0.757281139754533, 48.43655146992741], [-0.6539938321279776, 48.4442821157106], [-0.551717783599479, 48.473117087367115], [-0.5050654278707287, 48.50579601257741], [-0.43075405116635984, 48.51181992420755], [-0.3676233888648984, 48.49294431514273], [-0.2782279440483006, 48.506988913226], [-0.20693829348513584, 48.5629447591783], [-0.16938268000563234, 48.53697035218057], [-0.14871347253945771, 48.45806753463183], [-0.05189625619319167, 48.453259769855784], [-0.05453120471342507, 48.38200345783028], [-0.002558831894627075, 48.39731388623217], [0.062488371910724295, 48.38221653184688], [0.11624508246972828, 48.43555379653748], [0.2958599914991128, 48.48017405402528], [0.36395898803578647, 48.45163268084123], [0.3826045470591676, 48.33382739377157], [0.4875722818038879, 48.307800269645206], [0.5359730618565093, 48.24984731425016], [0.6832238274745249, 48.248585603870666], [0.7378268325294973, 48.18907227443458], [0.7976558384942257, 48.19445221756441], [0.830483470832425, 48.21071322673855], [0.7621929543543114, 48.30687661402512], [0.7854319060188932, 48.34042724029942], [0.8833710269390447, 48.35667269478065], [0.9422407728065412, 48.399001153466926], [0.9665513231299335, 48.52274528509245], [0.8506421037670122, 48.58262673082052], [0.8148191028635929, 48.670167960202036], [0.7305886446296782, 48.70520779867271], [0.7749590431141302, 48.73752726459962], [0.7335062460350482, 48.78336423504], [0.610293808614185, 48.831314149046584], [0.552503008373062, 48.87553783158533], [0.4573579962478973, 48.8797624818295], [0.3861893489650427, 48.91041450586637], [0.41281453288908837, 48.95062636770782]]]}, 'attributes': {'CODE_DEPT': '61', 'NOM_DEPT': 'ORNE'}}, 56: {'geometry': {'type': 'Polygon', 'bbox': (833932.999999959, 6504924.000001975, 943609.5999999304, 6603737.100001686), 'coordinates': [[[5.310560613770374, 46.44676642071993], [5.215064143095116, 46.468359273121635], [5.201145108499203, 46.50820950515938], [5.052374107055715, 46.484872844561956], [4.940023082647429, 46.51719845218093], [4.891817622919295, 46.43991436571949], [4.8882077017045455, 46.40298160185772], [4.810994882268941, 46.259921516975695], [4.780213475718984, 46.17667702271943], [4.797433206939167, 46.14070146436191], [4.750325275584826, 46.09414996659717], [4.739530214170902, 46.04720888365033], [4.7546312797683195, 45.973622014972776], [4.7290969212308775, 45.94909221230223], [4.8645021533563355, 45.90461654376237], [4.923799133458053, 45.80399936996719], [5.101067478338776, 45.813378082643716], [5.191532760208242, 45.77168800093884], [5.266894883868228, 45.78936901099023], [5.309169396437732, 45.85493340191014], [5.353827195805032, 45.88327273564147], [5.434944676804955, 45.831093776494356], [5.42264142008713, 45.80712379566383], [5.54554159780885, 45.71359345746494], [5.623748035268077, 45.613268326764235], [5.68918710219464, 45.648501612399514], [5.704119379498134, 45.71092632945925], [5.7761608991802635, 45.729222395584365], [5.78685622417971, 45.82295599649888], [5.831226413621035, 45.938459578293276], [5.809643351753075, 45.989799603818724], [5.807622444833504, 46.06393497838283], [5.832300912634431, 46.105995858563126], [5.956063159932632, 46.13208943594275], [6.033127717153323, 46.23799614420538], [6.124247271884754, 46.25101201647224], [6.102638404712804, 46.285063966079505], [6.1697416603127335, 46.36793686221594], [6.06400848181829, 46.41622698893158], [5.986841317727858, 46.36487308875812], [5.908938421371525, 46.28395162005961], [5.849846074176258, 46.262063603326204], [5.725183003095842, 46.26072920479401], [5.714717731644378, 46.30876884774597], [5.649339135998929, 46.339491033036424], [5.542037828826234, 46.270201908707485], [5.4730553115738125, 46.265063763323525], [5.4377951138533165, 46.315112971225524], [5.373462288620209, 46.3522363046852], [5.377044586181938, 46.38135905559838], [5.307691028342544, 46.41681731886727], [5.310560613770374, 46.44676642071993]]]}, 'attributes': {'CODE_DEPT': '01', 'NOM_DEPT': 'AIN'}}, 57: {'geometry': {'type': 'Polygon', 'bbox': (522873.2000000755, 6164532.000002834, 632373.2000000293, 6247681.500002648), 'coordinates': [[[0.8583056667230173, 42.825719089084565], [0.9273318147672923, 42.789260220632244], [1.0751084975718936, 42.785350960627355], [1.161848153380759, 42.711046329846056], [1.2302117813358224, 42.727586080760815], [1.3250261279091804, 42.723903970602294], [1.3895996264494759, 42.685082877157555], [1.4350544962266254, 42.60607634725265], [1.549248343808621, 42.65577628584995], [1.6014701367981332, 42.6280393270752], [1.6873586751619767, 42.6239041279916], [1.7861250110638967, 42.57362343207799], [1.8744850028357225, 42.58140598425574], [1.9717596461471247, 42.616920493794225], [2.0005149149001977, 42.66156483553949], [2.166053682054993, 42.66391836976537], [2.1758741195218594, 42.68279522431071], [2.057204243184995, 42.75622286126001], [1.955395663529541, 42.73670079860324], [1.9081798281291236, 42.76766704348015], [1.8804739886198156, 42.85266926902656], [1.9869209142233524, 42.87101168756068], [1.9851004481943353, 43.02627232234244], [1.9411328732906326, 43.052715472626794], [1.9494758652019253, 43.11949443816388], [1.8247721988689323, 43.14581388915543], [1.7100564477992013, 43.18969803410906], [1.7238440687530254, 43.224524250769115], [1.6884197209147513, 43.27355372810057], [1.6372035311274429, 43.255115354491736], [1.5475200495883703, 43.275674269255795], [1.4637105789844818, 43.21060079806063], [1.4253606535844838, 43.256571535866804], [1.343651969634677, 43.315606054765574], [1.2933102990704721, 43.28533747712766], [1.374373433475401, 43.213745765705475], [1.3146078107375305, 43.189994724436794], [1.2274806300813905, 43.183893105810554], [1.2087344680123453, 43.11795105080999], [1.124082084454217, 43.156907404761874], [1.0589125480141455, 43.14182620134694], [1.0388356827344094, 43.100552820032334], [0.9851687313481595, 43.0670562815733], [1.0070461604480831, 43.00759100643923], [0.9791013887263271, 42.974430961914464], [0.8749113719387422, 42.957775746315384], [0.8324133769327763, 42.91998800205094], [0.8583056667230173, 42.825719089084565]]]}, 'attributes': {'CODE_DEPT': '09', 'NOM_DEPT': 'ARIEGE'}}, 58: {'geometry': {'type': 'Polygon', 'bbox': (560988.4000000468, 6426078.100002187, 663287.6000000116, 6517796.40000193), 'coordinates': [[[1.2531518386328941, 45.44421907802489], [1.2596039598397974, 45.39834890279054], [1.3227969726587214, 45.38265936136428], [1.2271194403372112, 45.27197997099901], [1.2774962889939254, 45.242082419122035], [1.2965184989870582, 45.14018882562906], [1.3864424774272142, 45.10288137852406], [1.4482615439322117, 45.01931315867412], [1.5357253751118871, 45.04628038727674], [1.6509837683346413, 45.02501608647886], [1.7506251087427585, 44.954959479535844], [1.8239145263410472, 44.92768244845702], [1.9081561620078975, 44.978426771844745], [2.0629142919730623, 44.97650640551568], [2.132978967739458, 44.98552052019752], [2.09515947189117, 45.05602988503961], [2.1717556853734434, 45.08149587397568], [2.21369697618154, 45.16019264015236], [2.195361138057307, 45.22085230029842], [2.2714136874802597, 45.29015191925769], [2.3504794408656373, 45.32755821486311], [2.378246243484016, 45.414305790766505], [2.4418608930121475, 45.38425846985713], [2.4874679068775096, 45.418838410808995], [2.5084086971130826, 45.478498798744894], [2.5163323173042995, 45.55342661392318], [2.46534961788347, 45.600822875828726], [2.514296706686258, 45.63953208017773], [2.528364779747827, 45.681924336473784], [2.4921255582417543, 45.73767009540711], [2.4358558482207813, 45.6992750614443], [2.3491828014700613, 45.70947892430512], [2.3377545093277403, 45.680604829561815], [2.1939584682323856, 45.69904710388091], [2.1743533542862306, 45.732215961682584], [2.1135454727593443, 45.7247750650252], [2.0176087689830706, 45.75549036080031], [1.8987307791829435, 45.69827755120417], [1.8713480467629338, 45.66465827008339], [1.7838678002323443, 45.680363378073274], [1.637663451137719, 45.580351909123976], [1.5571958047036878, 45.54936632471635], [1.4803697950912305, 45.565943138308214], [1.4120589140520188, 45.52808103157582], [1.3500778792847676, 45.46688830500584], [1.2870567570435636, 45.48993789201237], [1.2531518386328941, 45.44421907802489]]]}, 'attributes': {'CODE_DEPT': '19', 'NOM_DEPT': 'CORREZE'}}, 59: {'geometry': {'type': 'Polygon', 'bbox': (987690.6999999384, 6711033.600001389, 1044907.7999999225, 6809400.400001105), 'coordinates': [[[6.846179818400713, 47.822945197015315], [6.863475516127668, 47.78516087450236], [7.015960767929834, 47.7432327394991], [7.0463147529081755, 47.67150171049488], [7.004983231421509, 47.61938273175806], [7.086270201422719, 47.592562199673935], [7.130345969302942, 47.50302658240902], [7.1730769339875815, 47.44718259366282], [7.246297061693767, 47.42220209989128], [7.301734408679474, 47.43781547828918], [7.403411294214605, 47.43552354218886], [7.5067536714993555, 47.49563386054376], [7.503407577023023, 47.541980294952374], [7.584705904821392, 47.577264323429596], [7.59279821775334, 47.60177705410432], [7.5223457901007045, 47.662321489865825], [7.513752001020269, 47.70281805791821], [7.548078387714245, 47.73958664485912], [7.53125975560987, 47.7867580927562], [7.556704620769355, 47.87994110575864], [7.622090012011824, 47.972273158298435], [7.571623278915892, 48.030379632553476], [7.577312855212314, 48.120368521818186], [7.519368638022094, 48.12611186664675], [7.470560946722399, 48.16101452404043], [7.476943375699937, 48.203536684298435], [7.348562541549848, 48.24719461957468], [7.275183721811301, 48.3052347870644], [7.1982815370299456, 48.310467861035285], [7.133555808547297, 48.2459405500217], [7.058912798901163, 48.137266371556045], [7.0018837438588974, 48.022399095831126], [6.943356419805964, 47.99795794687724], [6.9002133351392665, 47.89119137272693], [6.920034363859817, 47.850287916338964], [6.846179818400713, 47.822945197015315]]]}, 'attributes': {'CODE_DEPT': '68', 'NOM_DEPT': 'HAUT-RHIN'}}, 60: {'geometry': {'type': 'Polygon', 'bbox': (476861.20000005513, 6629764.700001611, 576079.4000000309, 6735350.200001305), 'coordinates': [[[1.3266655450453901, 47.18622542473183], [1.2769082168277979, 47.25470690394851], [1.2235368646048153, 47.29408083062269], [1.1620645187006389, 47.27219609172917], [1.108127082601409, 47.298398043931414], [1.1228353402815723, 47.3540166709069], [1.107483394852318, 47.41132542515624], [1.1323641891067446, 47.446466657485615], [1.0452908534068053, 47.53148801134605], [1.0763363652479017, 47.56322155433425], [1.0333525357335176, 47.60701157047619], [0.9190111731399371, 47.63260906010327], [0.8595037193186882, 47.669207269910096], [0.7353105618986358, 47.695401801856676], [0.6144311990931562, 47.69421364606964], [0.542891970097039, 47.65620713810867], [0.45663070361835567, 47.6388264115843], [0.3789609617763965, 47.569104055270486], [0.23000172635318558, 47.608398291933725], [0.20150312551615193, 47.54432775642865], [0.2201092524013729, 47.50195329713316], [0.18528045906678395, 47.424733449390764], [0.07897484723536348, 47.2828247550667], [0.05382761471070627, 47.16373008265531], [0.07637120084195272, 47.12393194888828], [0.1361309026819461, 47.121580554147556], [0.17422061595767963, 47.07127519606648], [0.29823142261819774, 47.05391872520874], [0.3007362572498841, 46.97382765864786], [0.43870966025366004, 46.92958207105911], [0.5061414593305561, 46.959247361736196], [0.5983482495759445, 46.95676414686087], [0.5669489614197064, 47.002270374441686], [0.692569282364634, 46.974307063017875], [0.7043243920507868, 46.90329335315587], [0.790328495561799, 46.852391083185985], [0.811901784063939, 46.7945079647172], [0.8674688807081565, 46.74821910504852], [0.9888132945329698, 46.76154066839271], [1.0498776400419196, 46.980640418735526], [1.0776154683629746, 47.01584239818827], [1.1614221724181906, 47.03962297281958], [1.2730568495660926, 47.037834138185595], [1.3116729094606134, 47.09697527344035], [1.365360999707624, 47.12205127770922], [1.3266655450453901, 47.18622542473183]]]}, 'attributes': {'CODE_DEPT': '37', 'NOM_DEPT': 'INDRE-ET-LOIRE'}}, 61: {'geometry': {'type': 'Polygon', 'bbox': (634421.5000000035, 6986161.900000591, 788005.7999999913, 7110430.10000027), 'coordinates': [[[2.0677120276110013, 51.006505154674734], [2.0976005370808024, 50.99842720037966], [2.183904561046441, 50.88345246926367], [2.2134304216785434, 50.81054861627207], [2.3408910264767204, 50.740906325444854], [2.4077924267844706, 50.67276560280949], [2.495948921017839, 50.63124494194659], [2.630516060197486, 50.61795150536654], [2.713850503520111, 50.631292253556424], [2.769040910019394, 50.66367813930791], [2.8404494526472543, 50.656566351404415], [2.8051660601438893, 50.60327122820495], [2.8259824668620874, 50.52538845143164], [2.898951858432468, 50.501557815670935], [2.9647097377674005, 50.51277802080956], [3.0207925423124586, 50.48176905741164], [3.037672306035308, 50.441640098051245], [2.993078464231492, 50.379846956524474], [3.173376482382538, 50.24110767126835], [3.1561320895920617, 50.1837151514849], [3.0957569207512843, 50.12420173434517], [3.090253620620082, 50.0537405551461], [3.1727072271768164, 50.011994944690635], [3.2305405050170397, 50.03130959187674], [3.2801740988851327, 50.01518255081814], [3.352982036655549, 50.03585934468007], [3.4913598357111555, 50.01885605080664], [3.54484649487849, 50.053793955280256], [3.6136399192005855, 50.025418579188496], [3.715184685025503, 50.06927463597468], [3.7463798889650577, 50.05360423498406], [3.923501465982154, 50.02643067661838], [3.9803763118726985, 49.995376086949776], [4.087128504749609, 49.969187585423256], [4.140895251736091, 49.97875959900575], [4.162223866832849, 50.048984846947924], [4.227998848506976, 50.0663716441179], [4.199886857285581, 50.13107752153304], [4.126926892460068, 50.13501086615994], [4.160120194753327, 50.202535967152805], [4.221850100147641, 50.2569526030574], [4.136656244682008, 50.27430028767412], [4.037614330208127, 50.342949130962005], [3.967898522087576, 50.35036640689913], [3.889799951126813, 50.32998024473762], [3.852755582095813, 50.35159288087616], [3.747403815562772, 50.35092914841262], [3.694426981658981, 50.31582758313083], [3.658270970690328, 50.371341179611775], [3.6642184777732343, 50.453174658802986], [3.613009891798258, 50.4924694652765], [3.4739635628750074, 50.53356175115673], [3.3738916027191275, 50.491824935733376], [3.2865173191905384, 50.5275758381365], [3.248509229627794, 50.63804120854452], [3.2583710099316026, 50.700649521314936], [3.1912194219619847, 50.72440644617065], [3.1519976780893755, 50.782343296693874], [3.0613770323899683, 50.780500851248156], [2.938073313612885, 50.74434123804409], [2.8983800599236966, 50.694236112980164], [2.813275390169948, 50.71694763018353], [2.717481067754576, 50.813607735175225], [2.6349827331217086, 50.812756418772004], [2.599594701801672, 50.85333434261119], [2.6326872836805335, 50.9460051993682], [2.5759824197772865, 51.01375274756831], [2.543034614375203, 51.088542812197964], [2.4247542826080695, 51.05562611742251], [2.3478396554296364, 51.05983236212976], [2.1097003640363865, 51.00382398081887], [2.0677120276110013, 51.006505154674734]]]}, 'attributes': {'CODE_DEPT': '59', 'NOM_DEPT': 'NORD'}}, 62: {'geometry': {'type': 'Polygon', 'bbox': (981470.1999999387, 6711078.800001388, 1010785.5999999286, 6753957.700001263), 'coordinates': [[[7.130345969302942, 47.50302658240902], [7.086270201422719, 47.592562199673935], [7.004983231421509, 47.61938273175806], [7.0463147529081755, 47.67150171049488], [7.015960767929834, 47.7432327394991], [6.863475516127668, 47.78516087450236], [6.846179818400713, 47.822945197015315], [6.823538854548164, 47.81305372460474], [6.757638483670511, 47.74787796649103], [6.780404771904785, 47.62526070546138], [6.806992048333124, 47.56280181879932], [6.905669627634238, 47.54736152102865], [6.907609859823659, 47.49454608019354], [6.940536510867673, 47.43337372142234], [6.9989628186755155, 47.45229903123539], [6.983118836626173, 47.493302817356295], [7.079276690803702, 47.48886399588566], [7.130345969302942, 47.50302658240902]]]}, 'attributes': {'CODE_DEPT': '90', 'NOM_DEPT': 'TERRITOIRE DE BELFORT'}}, 63: {'geometry': {'type': 'Polygon', 'bbox': (282805.7000000984, 6649967.800001572, 402393.3000000701, 6756672.500001258), 'coordinates': [[[-1.245882346289053, 47.77671754769666], [-1.3528642478531776, 47.79769264008963], [-1.390427968841582, 47.8282808011693], [-1.5934074072820477, 47.776050091798155], [-1.6548203169539597, 47.712592802370295], [-1.7724163023563166, 47.69845339610201], [-1.8640133393104226, 47.70698467056552], [-1.9690539759076375, 47.688369032584816], [-2.097035597340285, 47.631359844030904], [-2.1073336439134778, 47.53105690026967], [-2.312868292914679, 47.46446874949351], [-2.458489165173328, 47.44812172073537], [-2.5341025675524804, 47.38296506335946], [-2.513805375083308, 47.29837226752572], [-2.447540278501031, 47.26175565750243], [-2.3983809001599146, 47.28144600128063], [-2.301643363345211, 47.23640440230942], [-2.1873645299124607, 47.28061948954126], [-2.1583713304619323, 47.20905347869719], [-2.1670644777818073, 47.16618049901816], [-2.2268232180853564, 47.130940362387484], [-2.0534725301465024, 47.09412159709032], [-1.9804144867428743, 47.0289064940757], [-1.9432276192598639, 46.99471092059498], [-1.8309821821134142, 46.93203372415455], [-1.751062300240369, 46.92959568215281], [-1.689761273986443, 46.89049286319811], [-1.5485110748777007, 46.86007983436473], [-1.5007668577856454, 46.883891152829825], [-1.553563697237001, 46.98150474523176], [-1.5523222833408639, 47.01834875737963], [-1.4821311833973978, 47.037861989589345], [-1.4561316296061408, 46.9262728543553], [-1.372985770094949, 46.952184466609765], [-1.3786124689367807, 47.03085386698659], [-1.2946349782361026, 47.03948346966519], [-1.271206708715037, 47.08389319899781], [-1.148570488753439, 47.02954516258661], [-1.1154625363954844, 47.06256455498828], [-1.231145713608837, 47.10995454752673], [-1.2352482689031186, 47.138781593625], [-1.1632160710080464, 47.177784087549064], [-1.197721609765016, 47.25058116645219], [-1.254174750571894, 47.249856282378325], [-1.305108502227792, 47.30316997819655], [-1.2998771573086003, 47.337623665323264], [-1.1676096980775446, 47.3658872351569], [-1.0178737847602017, 47.36506226318966], [-0.9464433335100002, 47.386466852357906], [-0.967482555917903, 47.49280029691797], [-1.1572331855798583, 47.510083069606296], [-1.172416066194653, 47.573007547192], [-1.04590950407258, 47.56335191106957], [-1.0068639898836451, 47.58905339489957], [-1.1382017900650392, 47.61945704786123], [-1.174929569150147, 47.69456501384606], [-1.2545772523262646, 47.73364175152335], [-1.245882346289053, 47.77671754769666]]]}, 'attributes': {'CODE_DEPT': '44', 'NOM_DEPT': 'LOIRE-ATLANTIQUE'}}, 64: {'geometry': {'type': 'Polygon', 'bbox': (689262.3000000024, 6692939.9000014225, 799826.7999999784, 6810077.50000108), 'coordinates': [[[2.9765380120036067, 47.56942879711261], [3.0256381393798466, 47.55875277695222], [3.10199661377424, 47.58795617120518], [3.122046633548593, 47.54104902333157], [3.2046491761957805, 47.522966343587036], [3.2354769572493565, 47.48917911094726], [3.307051239784071, 47.49471952596054], [3.3463147218972584, 47.47243811385125], [3.397288000265388, 47.50886749595521], [3.487879079980051, 47.49392259510358], [3.513504992889226, 47.527668013758365], [3.5806168100615214, 47.4978632363306], [3.5801133565565157, 47.46490071650617], [3.6789914842274656, 47.445533677890616], [3.7147823454353084, 47.4068346666404], [3.7856341851420208, 47.39054233152033], [3.9706779602609212, 47.378314438290566], [3.9730845789314024, 47.332712785374405], [4.106085850126875, 47.339255985508295], [4.066060118363545, 47.40725128721289], [4.119426533664949, 47.44355339332813], [4.11550026231875, 47.515008579609585], [4.17512808182493, 47.553259163229534], [4.212381292101605, 47.62796570433968], [4.268422869492533, 47.68140992396884], [4.2581642665265, 47.727402970861355], [4.332471702607339, 47.75651131040829], [4.324394417243652, 47.84715746363825], [4.2610008241447535, 47.84385063868308], [4.293424106945006, 47.92567623485384], [4.199158053352665, 47.969941402526324], [4.1117857473984065, 47.926995657533396], [3.9020865465480417, 47.93917007405486], [3.850029315571996, 47.983792407228414], [3.8049683849961107, 48.10254956016535], [3.74029124579523, 48.16970783295086], [3.667869602845747, 48.13921190362745], [3.6216038851697063, 48.225740470572575], [3.6168043332338455, 48.27133989892491], [3.498152764099384, 48.36909719474052], [3.4147915595010963, 48.390273038835076], [3.3651592673815314, 48.372280687121055], [3.167737573570585, 48.371860839541355], [3.0495188960927044, 48.36012035558039], [3.043627253848888, 48.272022357627314], [3.0051556578134635, 48.20767000036064], [2.936314411640624, 48.163391744163064], [3.0294654865478936, 48.13320717201311], [3.0504714242752176, 48.072334131140266], [3.088317798651479, 48.05393639482615], [3.1284501214452565, 47.97097324036124], [3.0501042789379826, 47.911447449150145], [3.0102926272319244, 47.90471697202151], [3.023798094359226, 47.78655467901546], [2.9350577707343026, 47.76324627617625], [2.8566660682192713, 47.76092647079024], [2.8585180302225814, 47.71199289202641], [2.9231098081748264, 47.680559698484025], [2.937999037836789, 47.598884707750514], [2.9765380120036067, 47.56942879711261]]]}, 'attributes': {'CODE_DEPT': '89', 'NOM_DEPT': 'YONNE'}}, 65: {'geometry': {'type': 'MultiPolygon', 'bbox': (306739.2000000799, 6738013.600001321, 400464.5000000602, 6855953.00000098), 'coordinates': [[[[-2.006894935706841, 48.5661129019979], [-2.0486879074738513, 48.63697592733373], [-2.1237080247752878, 48.60441002857454], [-2.0759838668732145, 48.5676791967517], [-2.006894935706841, 48.5661129019979]]], [[[-1.0701645143702028, 48.5084938142048], [-1.2065557263083735, 48.542205944555754], [-1.272248493564724, 48.533924823069405], [-1.377245885097968, 48.45828455073839], [-1.489947435142363, 48.48937484762061], [-1.5189153941473388, 48.566594219597484], [-1.5710871213263624, 48.626445743066476], [-1.76415180087166, 48.603560368616066], [-1.8450734275301919, 48.6163682505842], [-1.8716564802790987, 48.64741056212522], [-1.8561321209072548, 48.70485450482966], [-1.9698282134951812, 48.6863231253415], [-2.0289596768793032, 48.64691471299467], [-1.948036901044388, 48.538807904896906], [-1.912490070435076, 48.51884141990099], [-1.9548327221541812, 48.317109845306696], [-2.014100529199394, 48.27953190981906], [-2.0532925486538467, 48.29832786131652], [-2.110118931164645, 48.25290348209337], [-2.1869612472272935, 48.24637857004592], [-2.2247373292770813, 48.17059701878943], [-2.287278430400509, 48.13374556347385], [-2.2332446439270153, 48.075627876360535], [-2.279595013670352, 48.02636073133588], [-2.2395935242179426, 47.999461627992105], [-2.1368653813504146, 47.979116800921744], [-2.079088544973961, 47.91952249841043], [-2.1162985684590634, 47.88095628990024], [-2.049526070392867, 47.8169173979452], [-2.0897121808782697, 47.73856050587445], [-2.131472084919134, 47.72224026217332], [-2.097035597340285, 47.631359844030904], [-1.9690539759076375, 47.688369032584816], [-1.8640133393104226, 47.70698467056552], [-1.7724163023563166, 47.69845339610201], [-1.6548203169539597, 47.712592802370295], [-1.5934074072820477, 47.776050091798155], [-1.390427968841582, 47.8282808011693], [-1.3528642478531776, 47.79769264008963], [-1.245882346289053, 47.77671754769666], [-1.2382517343256672, 47.80999146298689], [-1.1891839990021345, 47.86797794678786], [-1.1539940378788567, 47.96582099565702], [-1.1026711686637312, 47.989062782913926], [-1.0212610284765595, 47.99494016249541], [-1.0232833455698913, 48.068911203167616], [-1.049606089398749, 48.08980493061712], [-1.1000610480389637, 48.259280121227064], [-1.045019529962301, 48.32772783001587], [-1.0827940655347768, 48.43305823169245], [-1.0701645143702028, 48.5084938142048]]]]}, 'attributes': {'CODE_DEPT': '35', 'NOM_DEPT': 'ILLE-ET-VILAINE'}}, 66: {'geometry': {'type': 'Polygon', 'bbox': (334282.70000014844, 6275534.700002595, 470768.600000088, 6389853.100002306), 'coordinates': [[[-1.5248665484221002, 43.529701346690175], [-1.4766198669954693, 43.53918405640505], [-1.4177740978933993, 43.49776692584465], [-1.2911822396099, 43.49820457476763], [-1.1708199655376668, 43.54560988391769], [-1.109247829938908, 43.51412989565146], [-0.9933935609538049, 43.50538804684222], [-0.8966906468904682, 43.55048921576576], [-0.7817805196343679, 43.56416715906691], [-0.7153911507395094, 43.54111406021413], [-0.670807186170969, 43.5667169721835], [-0.5571744316529481, 43.542797175106294], [-0.4482922578476383, 43.59608922647162], [-0.40604194753689593, 43.56822563862113], [-0.30369046804673383, 43.56027685025606], [-0.24283655874306653, 43.584976209013746], [-0.23258236946731695, 43.71408748429121], [-0.19414330237233957, 43.737016685694776], [-0.19099217321599454, 43.87518333615964], [-0.23393876198189914, 43.89106775010974], [-0.179109059517904, 43.93791976442846], [-0.07359844651969293, 43.94504687607575], [0.03255676418092499, 43.90018804605394], [0.07664688901342062, 43.91647114312968], [0.07604560969926165, 43.983143136582996], [0.0626980132929106, 44.00084249917973], [0.10082062971801486, 44.08677044167006], [0.13510828700872454, 44.12422070347961], [0.034593843822210965, 44.130652403429636], [-0.004232390832891391, 44.149995950868565], [-0.12915451548994408, 44.15240992875165], [-0.1406884798527575, 44.22640474768996], [-0.19411335198198013, 44.26904045949542], [-0.22344709828329368, 44.2058982638019], [-0.27211852903661043, 44.19380924623565], [-0.38961736206091657, 44.20948462715681], [-0.38338729038705477, 44.28631066773667], [-0.43183954131517804, 44.32257705443095], [-0.5176354697700609, 44.33911112646842], [-0.528103107297291, 44.36465404326292], [-0.6276476111842922, 44.398145662533665], [-0.6287774027434521, 44.443192240874644], [-0.7307029568976166, 44.446374662072614], [-0.8452736279017048, 44.418974549624686], [-0.9191704541834166, 44.443344362596065], [-1.0074534242441229, 44.4376523913387], [-0.9806969914576474, 44.482878935537535], [-1.0851664955491238, 44.532194571677685], [-1.1064909647292611, 44.50277289133715], [-1.2538901028077136, 44.467604212346195], [-1.3123241886692378, 44.144802425789784], [-1.3749866629484853, 43.91378891976503], [-1.4365038283323686, 43.71056513002188], [-1.448204124676214, 43.64227785427411], [-1.5248665484221002, 43.529701346690175]]]}, 'attributes': {'CODE_DEPT': '40', 'NOM_DEPT': 'LANDES'}}, 67: {'geometry': {'type': 'Polygon', 'bbox': (124277.10000010568, 6761104.000001276, 223352.10000009876, 6867490.700000975), 'coordinates': [[[-3.6591438196705726, 48.65920978068336], [-3.660936253648766, 48.69406986743352], [-3.8323800958932193, 48.71193803705031], [-3.864417712752576, 48.67033253739846], [-3.9494602787296564, 48.652859530177146], [-3.975748942975551, 48.699033371438986], [-4.186935690423403, 48.68646122791495], [-4.272767520288336, 48.64958226193913], [-4.351408108864256, 48.67611752116847], [-4.4627626687883355, 48.627102278372654], [-4.5614755513739285, 48.623803539462266], [-4.630604970514316, 48.57769163688516], [-4.730582004767841, 48.55634921053221], [-4.7754733948519, 48.49100463763031], [-4.793344007924671, 48.41623318233541], [-4.760909970272354, 48.37274934623393], [-4.608723907528041, 48.33788748523839], [-4.424948261340764, 48.397597431917745], [-4.441760780702185, 48.35361514080612], [-4.302158218411379, 48.34377660540236], [-4.30803032884924, 48.29716811392344], [-4.38449955320125, 48.275155727113344], [-4.423777088962563, 48.291668243167024], [-4.566613794720501, 48.286343567289286], [-4.5640238131019215, 48.232230611582196], [-4.448362289029716, 48.235630356768205], [-4.301125453787073, 48.191446905097344], [-4.2717344631091825, 48.13305570981134], [-4.306988535338466, 48.0891826157327], [-4.374400199477132, 48.11016030592404], [-4.488600722253488, 48.086471142269296], [-4.668222169685978, 48.070200318653285], [-4.72303043310844, 48.03359626570833], [-4.453570861423827, 47.9817743919044], [-4.362572451765144, 47.889262907304484], [-4.3624185212011595, 47.79574368618671], [-4.192310067833884, 47.79738016645037], [-4.163559448578026, 47.84918510805773], [-4.077726475728434, 47.866526585168934], [-4.041588845349635, 47.84599945335797], [-3.9115007019573893, 47.87028016364022], [-3.902476125408803, 47.83593985815641], [-3.8006004190720035, 47.787632394585984], [-3.732543627824175, 47.8029267390027], [-3.6808401232958046, 47.77678956846737], [-3.532308891348817, 47.7682788561134], [-3.5230042934996066, 47.84914685715857], [-3.4034429894056712, 47.87011455487806], [-3.392624522513051, 47.95445115827384], [-3.4848124678130397, 47.966889784603126], [-3.5552758457516056, 47.99309847047771], [-3.6402315330750725, 47.98524271313111], [-3.695020686823403, 48.093494659480534], [-3.695838514922977, 48.15221175123511], [-3.5648389737333277, 48.185746943072594], [-3.5184407178728905, 48.28227314703523], [-3.55678682574261, 48.33551998788199], [-3.5545842830629746, 48.37776678484624], [-3.59041542299311, 48.42892323447733], [-3.6040613963215824, 48.496439468782384], [-3.5538598863227366, 48.540920771753676], [-3.6493779946144076, 48.61015334623436], [-3.6591438196705726, 48.65920978068336]]]}, 'attributes': {'CODE_DEPT': '29', 'NOM_DEPT': 'FINISTERE'}}, 68: {'geometry': {'type': 'Polygon', 'bbox': (916991.9999999349, 6514709.9000019515, 1013274.7999999039, 6596473.600001719), 'coordinates': [[[6.802516663522652, 45.77837197402202], [6.81807863673278, 45.83497696816754], [6.939604939153821, 45.846732106422444], [6.991719912014906, 45.868199872091495], [7.043893795018055, 45.92208520277864], [7.01824561421289, 45.98418643361584], [6.951511564566567, 46.049956099423994], [6.8914542235903, 46.08449157208843], [6.898381393099357, 46.122562070394125], [6.81473216290061, 46.129696461365256], [6.803660834214749, 46.20434524954359], [6.864509851829646, 46.28299076988357], [6.782637056089519, 46.33688407311208], [6.795664927569208, 46.393092558626826], [6.722868985320351, 46.407553897804995], [6.545175304790925, 46.39472735936461], [6.3900361566872315, 46.34016563406093], [6.326997851713536, 46.37112568338632], [6.2799119246622785, 46.351094432713545], [6.237797813525851, 46.277334258516746], [6.295655645057157, 46.22605896768262], [6.232071540724356, 46.20547030935738], [6.17507237787808, 46.158149899601725], [5.956063159932632, 46.13208943594275], [5.832300912634431, 46.105995858563126], [5.807622444833504, 46.06393497838283], [5.809643351753075, 45.989799603818724], [5.831226413621035, 45.938459578293276], [5.862101395990038, 45.93240229486188], [5.87342650248464, 45.8380955581268], [5.913209603821916, 45.80414083870233], [6.042939005987317, 45.73909595131257], [6.166233910329838, 45.75571563232783], [6.189714169774869, 45.70416174969227], [6.239679907775352, 45.685404763162644], [6.330635270345084, 45.69553113948386], [6.383851558657904, 45.778055295582284], [6.423672125473555, 45.80244240743697], [6.4705596799701395, 45.88469229739344], [6.509087472467453, 45.908632873298934], [6.552237633503553, 45.82687986970043], [6.6017329724955784, 45.79541992331821], [6.661192099251396, 45.79890547186778], [6.711938518958688, 45.72291967208878], [6.802516663522652, 45.77837197402202]]]}, 'attributes': {'CODE_DEPT': '74', 'NOM_DEPT': 'HAUTE-SAVOIE'}}, 69: {'geometry': {'type': 'Polygon', 'bbox': (605400.9000000112, 6884542.30000087, 711647.6999999984, 6962826.200000654), 'coordinates': [[[1.7043642065965872, 49.23220177517624], [1.7421373979981685, 49.18015527803753], [1.795468686327552, 49.1852591252518], [1.8852389528169071, 49.162637864554874], [1.9968226136719949, 49.17644980801165], [2.080887804244836, 49.20977574825314], [2.252488213818398, 49.15288152247387], [2.310929044686543, 49.18640655834875], [2.346257050814552, 49.16181582457663], [2.440902617873646, 49.14580320715759], [2.5905242793946224, 49.079654846745605], [2.633272965218076, 49.108376218976154], [2.735012683493696, 49.060449825264335], [3.0085155429257675, 49.09151015781777], [3.071884293834167, 49.11755421882924], [3.1396578896700365, 49.152576953647774], [3.0640875194145396, 49.192738575710244], [3.0268878942941857, 49.27553205720364], [2.97439031593416, 49.30233884823801], [3.0953874973379834, 49.37711907479379], [3.0937834703774705, 49.43374686814669], [3.1605832452848968, 49.45158976267774], [3.0957783548212805, 49.51340305902506], [3.1314803354793224, 49.543377651804036], [3.0977762246810094, 49.656683091243586], [3.1184031553047866, 49.70596856016259], [2.915712813038834, 49.70267238897875], [2.793612422958185, 49.65595422264364], [2.7994949073615056, 49.62058605182692], [2.6891419821315017, 49.625601863486416], [2.670723151725744, 49.581411971799525], [2.571493337841171, 49.597080627026244], [2.504748899250395, 49.63946726892116], [2.3731456632291623, 49.65626624027031], [2.2471685906926684, 49.70164087682517], [2.121409706926089, 49.688074091756725], [1.933209822166273, 49.71962996350131], [1.8938643249004963, 49.69898823077294], [1.7838370588623418, 49.7583075010794], [1.6895758821118128, 49.694785646272834], [1.7252046142437363, 49.672634359616865], [1.7045819685135708, 49.605398925870894], [1.7451334451250173, 49.5317376936539], [1.719232660445319, 49.508223020119125], [1.766345027141405, 49.4661503637365], [1.7139375433100612, 49.409224988875955], [1.7594117559881142, 49.368149815405616], [1.7756288406360832, 49.299693721359404], [1.710479333974457, 49.264464162192816], [1.7043642065965872, 49.23220177517624]]]}, 'attributes': {'CODE_DEPT': '60', 'NOM_DEPT': 'OISE'}}, 70: {'geometry': {'type': 'Polygon', 'coordinates': [[[1.608796070629922, 49.07789415355113], [1.673689127007117, 49.07815117319748], [1.7234571618642336, 49.044976575520174], [1.823950363006381, 49.07636122205329], [1.9378021652564332, 49.02177632638558], [2.0247730444607908, 48.998755806202006], [2.084914920835883, 49.014678714923626], [2.20585834678071, 48.949740742229906], [2.200591009269504, 48.908679329904004], [2.2909735732251617, 48.950966788090646], [2.366443627637154, 48.974176668580746], [2.4594899596115933, 48.95504632684678], [2.55306064485419, 49.00981711745223], [2.5905242793946224, 49.079654846745605], [2.440902617873646, 49.14580320715759], [2.346257050814552, 49.16181582457663], [2.310929044686543, 49.18640655834875], [2.252488213818398, 49.15288152247387], [2.080887804244836, 49.20977574825314], [1.9968226136719949, 49.17644980801165], [1.8852389528169071, 49.162637864554874], [1.795468686327552, 49.1852591252518], [1.7421373979981685, 49.18015527803753], [1.7043642065965872, 49.23220177517624], [1.6757368125175736, 49.21186705776954], [1.6557774397127956, 49.1301621703505], [1.608796070629922, 49.07789415355113]]]}, 'attributes': {'CODE_DEPT': '95', 'NOM_DEPT': "VAL-D'OISE"}}, 71: {'geometry': {'type': 'Polygon', 'bbox': (690449.1000000023, 6617690.400001641, 793165.4999999772, 6720847.300001339), 'coordinates': [[[4.106085850126875, 47.339255985508295], [3.9730845789314024, 47.332712785374405], [3.9706779602609212, 47.378314438290566], [3.7856341851420208, 47.39054233152033], [3.7147823454353084, 47.4068346666404], [3.6789914842274656, 47.445533677890616], [3.5801133565565157, 47.46490071650617], [3.5806168100615214, 47.4978632363306], [3.513504992889226, 47.527668013758365], [3.487879079980051, 47.49392259510358], [3.397288000265388, 47.50886749595521], [3.3463147218972584, 47.47243811385125], [3.307051239784071, 47.49471952596054], [3.2354769572493565, 47.48917911094726], [3.2046491761957805, 47.522966343587036], [3.122046633548593, 47.54104902333157], [3.10199661377424, 47.58795617120518], [3.0256381393798466, 47.55875277695222], [2.9765380120036067, 47.56942879711261], [2.914297452553034, 47.565970182735285], [2.8746252064056805, 47.5204231125567], [2.928902314704163, 47.4445667358034], [2.8734906167112504, 47.348395958835304], [2.9834041014118906, 47.25976318039044], [2.9816846477683376, 47.22199695725166], [3.0280852399597813, 47.12906768514305], [3.0232152406674615, 47.0626168735247], [3.0757376737966906, 47.01914457943626], [3.0793297925031697, 46.95511875370015], [3.0502941730720203, 46.91063036589826], [3.0680947893123323, 46.877676731330396], [3.0320681893946824, 46.79491118852599], [3.049065356287102, 46.758078941893714], [3.2155498733945853, 46.68289184476872], [3.2697920192933188, 46.71674092869], [3.3467088070518343, 46.684416345410945], [3.4341330414396496, 46.711906067614436], [3.487153284024355, 46.65825255471402], [3.550392218815862, 46.71586467208164], [3.629423683496518, 46.74945902193758], [3.73619002089105, 46.75247120098582], [3.797329518692337, 46.7015026371452], [3.9233937335663804, 46.738872659809324], [3.9919591863262935, 46.77675109754475], [4.062709832615211, 46.78936469128218], [4.056234450174583, 46.8432723767359], [4.093851364443379, 46.874734333229235], [4.037221978317054, 46.918155606841886], [4.039401951235417, 46.98511001230659], [4.072015136934213, 47.054494829385675], [4.038726355028209, 47.08001003428521], [4.06142733788571, 47.12104166410022], [4.115967069915809, 47.12333757652637], [4.181888404407953, 47.15050513981919], [4.209834279044644, 47.15541168354451], [4.230655226496763, 47.19895127921229], [4.178052285148682, 47.25028786310226], [4.135479914723283, 47.23739632414042], [4.106085850126875, 47.339255985508295]]]}, 'attributes': {'CODE_DEPT': '58', 'NOM_DEPT': 'NIEVRE'}}, 72: {'geometry': {'type': 'Polygon', 'bbox': (780392.7999999812, 6648014.700001555, 890264.8999999544, 6771079.900001195), 'coordinates': [[[5.255236339191405, 46.97988809464055], [5.310049747453534, 47.01802089675744], [5.322186205925132, 47.07298220144247], [5.386011880946294, 47.08197711021486], [5.439973300314684, 47.144397191390645], [5.47662851608292, 47.21602767128052], [5.488282961724511, 47.28934747033418], [5.518538729512593, 47.304186619469625], [5.451397515008267, 47.38406251346723], [5.3992024955272315, 47.49901446301566], [5.447063511552308, 47.496253655362246], [5.496859255517603, 47.544144504783], [5.477547427463132, 47.60872207291233], [5.425863186006295, 47.63211377458535], [5.374078595885573, 47.604541652802524], [5.23923227423911, 47.616130098992706], [5.173597037303846, 47.65256871238266], [5.108878229414663, 47.64968494441669], [4.979107142832903, 47.68776283651176], [4.949610301299182, 47.76500253040031], [4.982400768988487, 47.80034738345197], [4.9540942495981195, 47.866768148099524], [4.852043179350451, 47.95623862322436], [4.786512602874469, 47.96420222558574], [4.789083695644796, 48.007829382573114], [4.704238250439468, 48.02023237622195], [4.582678644289108, 48.02946360188037], [4.5599688756782095, 47.97142319627397], [4.448998378066956, 47.957154747586976], [4.3090036167800365, 47.96117328279331], [4.293424106945006, 47.92567623485384], [4.2610008241447535, 47.84385063868308], [4.324394417243652, 47.84715746363825], [4.332471702607339, 47.75651131040829], [4.2581642665265, 47.727402970861355], [4.268422869492533, 47.68140992396884], [4.212381292101605, 47.62796570433968], [4.17512808182493, 47.553259163229534], [4.11550026231875, 47.515008579609585], [4.119426533664949, 47.44355339332813], [4.066060118363545, 47.40725128721289], [4.106085850126875, 47.339255985508295], [4.135479914723283, 47.23739632414042], [4.178052285148682, 47.25028786310226], [4.230655226496763, 47.19895127921229], [4.209834279044644, 47.15541168354451], [4.259600310936345, 47.114326250580596], [4.405487083945716, 47.08164281958388], [4.406283415170732, 47.049999892555036], [4.493691403385164, 47.02837155710412], [4.623230215613321, 46.940820236785605], [4.728129651701317, 46.91937462593796], [5.049303736126249, 46.98158693341572], [5.106281375832607, 46.955765202475504], [5.255236339191405, 46.97988809464055]]]}, 'attributes': {'CODE_DEPT': '21', 'NOM_DEPT': "COTE-D'OR"}}, 73: {'geometry': {'type': 'Polygon', 'bbox': (620310.8000000145, 6798947.800001114, 668471.5000000054, 6853168.000000958), 'coordinates': [[[2.226559327154523, 48.77610203163561], [2.111889242882012, 48.739560198041474], [2.0822212746064093, 48.6858518071185], [2.0200056963818716, 48.64208882253288], [2.0175740602972905, 48.55759738743778], [1.9674261909808524, 48.53307136185833], [1.9221489648373706, 48.45760028607871], [1.9305557503485928, 48.404124841843824], [1.9765777946992389, 48.399384474494646], [1.994084718059379, 48.28658587795807], [2.1813499926674265, 48.313745436024654], [2.369810541415244, 48.308672482875544], [2.402664267131608, 48.320719459436084], [2.4298322285044196, 48.36201578313258], [2.533731834361712, 48.41125114634581], [2.504749755053753, 48.43944601613285], [2.4995246743322403, 48.52523904801557], [2.5437765144069613, 48.60384977115981], [2.5336160068074505, 48.6573313888409], [2.5716603184420737, 48.69201409166007], [2.503536569558129, 48.735211482185626], [2.3707067322771356, 48.72017592254696], [2.3207180175230318, 48.748756235094554], [2.226559327154523, 48.77610203163561]]]}, 'attributes': {'CODE_DEPT': '91', 'NOM_DEPT': 'ESSONNE'}}, 74: {'geometry': {'type': 'Polygon', 'bbox': (404250.7000000758, 6545825.20000186, 485042.7000000638, 6672433.600001494), 'coordinates': [[[0.197353505216163, 46.095550041529755], [0.21492180826491522, 46.13884556432997], [0.1551113740904502, 46.15716824459698], [0.11283682536372723, 46.21093260957406], [0.12883677213786587, 46.26723154899875], [0.177368795982455, 46.328113140597], [0.1375978499402633, 46.34939518270104], [0.07821800902702712, 46.30493353892288], [0.03760223980806839, 46.32552885451106], [0.034219979012944976, 46.37349679947998], [-0.017092824348942017, 46.41132239451375], [-0.031351255287516346, 46.524981019415726], [0.0259896380281596, 46.59474350677765], [-0.040426190194720726, 46.6637170238073], [0.0007042720140899882, 46.71623331657771], [-0.0203163360693799, 46.81265392500657], [-0.009032410299881494, 46.9074770060593], [-0.08769647758766945, 47.02313333571297], [-0.10212095637964697, 47.06479719081804], [-0.18483982751841338, 47.108336996905216], [-0.24153794845204718, 47.10572466544681], [-0.4007795061579291, 47.07077103460962], [-0.495340243761372, 47.08238521770847], [-0.5595318719263798, 47.06188673077483], [-0.5654683969778367, 47.019426143811984], [-0.6199767888274338, 46.9933220656585], [-0.7130578012324342, 46.986072210051866], [-0.7738774456713031, 47.00425220913205], [-0.8919599503022396, 46.97581784960789], [-0.8291443983745105, 46.93336473376703], [-0.7816473761536206, 46.84282850114098], [-0.700856479426351, 46.80862675485134], [-0.7273121698337276, 46.767632454458024], [-0.6561893352875896, 46.700774642460956], [-0.6440639078487055, 46.63802790732369], [-0.6141139330666159, 46.62039039102906], [-0.6021285989587037, 46.5332805477888], [-0.6124259071699314, 46.45873492951781], [-0.6406445679433723, 46.416229245156025], [-0.537800498012109, 46.386465465455736], [-0.5576498721967046, 46.363448573781824], [-0.7504755422947275, 46.304258794361985], [-0.751461997484196, 46.245070221736306], [-0.6907154750130782, 46.21920250569825], [-0.6199574101252711, 46.13775275457059], [-0.5469968076890194, 46.14422952781582], [-0.5060833286611979, 46.106705208008755], [-0.4005083126359273, 46.08471764024758], [-0.281734309419876, 46.079753777667676], [-0.10293687953014628, 45.96965998523801], [-0.04143104082306048, 45.993479981491], [-0.03199529342543973, 46.05592180291532], [0.019272784617025578, 46.05284782935703], [0.07297225926176307, 46.093895909585044], [0.197353505216163, 46.095550041529755]]]}, 'attributes': {'CODE_DEPT': '79', 'NOM_DEPT': 'DEUX-SEVRES'}}, 75: {'geometry': {'type': 'Polygon', 'bbox': (210123.50000008388, 6785524.900001191, 337450.2000000646, 6881072.500000926), 'coordinates': [[[-2.287278430400509, 48.13374556347385], [-2.2247373292770813, 48.17059701878943], [-2.1869612472272935, 48.24637857004592], [-2.110118931164645, 48.25290348209337], [-2.0532925486538467, 48.29832786131652], [-2.014100529199394, 48.27953190981906], [-1.9548327221541812, 48.317109845306696], [-1.912490070435076, 48.51884141990099], [-1.948036901044388, 48.538807904896906], [-2.006894935706841, 48.5661129019979], [-2.0759838668732145, 48.5676791967517], [-2.1237080247752878, 48.60441002857454], [-2.164261352109107, 48.57889313291284], [-2.2239475767870998, 48.595386986551844], [-2.312865288216964, 48.680922821719236], [-2.473428281486321, 48.62251656641612], [-2.6312676669697788, 48.538129672669214], [-2.6815589371179858, 48.53113342752677], [-2.819598830141576, 48.59352827458846], [-2.8269350213521784, 48.650569331562856], [-2.9479038576324976, 48.72721506679855], [-2.9436531177995495, 48.75833756842975], [-3.029396621867139, 48.77591418616988], [-3.1139761137339725, 48.86673762496768], [-3.231756943127047, 48.86741630826664], [-3.4307245025981667, 48.79722346333295], [-3.513199627496447, 48.83499877621907], [-3.585008235573636, 48.775499964709624], [-3.5812485466634114, 48.67001788505634], [-3.6591438196705726, 48.65920978068336], [-3.6493779946144076, 48.61015334623436], [-3.5538598863227366, 48.540920771753676], [-3.6040613963215824, 48.496439468782384], [-3.59041542299311, 48.42892323447733], [-3.5545842830629746, 48.37776678484624], [-3.55678682574261, 48.33551998788199], [-3.5184407178728905, 48.28227314703523], [-3.5648389737333277, 48.185746943072594], [-3.33675473563501, 48.17112526547111], [-3.2722443396278273, 48.14001476485908], [-3.1552540693335693, 48.158490943543626], [-3.116373512585391, 48.20636380948965], [-3.0335402161271037, 48.19936064624241], [-2.781951132488675, 48.120579730854125], [-2.652301006956971, 48.119324663861974], [-2.670050948442368, 48.047883952925766], [-2.6311897590265905, 48.035479312779835], [-2.5747859613042996, 48.070410038491524], [-2.49481856978248, 48.15784478551255], [-2.4089048721706594, 48.16861132667282], [-2.3713647531616733, 48.12210300840669], [-2.287278430400509, 48.13374556347385]]]}, 'attributes': {'CODE_DEPT': '22', 'NOM_DEPT': "COTES-D'ARMOR"}}, 76: {'geometry': {'type': 'Polygon', 'bbox': (644783.7000000156, 6537017.500001875, 776585.8999999785, 6633748.500001593), 'coordinates': [[[3.0320681893946824, 46.79491118852599], [2.9599146908207157, 46.80387657677336], [2.827616388160227, 46.73528787880113], [2.774488053228389, 46.71890739681208], [2.7049751251942706, 46.73938730526566], [2.5966478252098466, 46.63721956981655], [2.614955459722656, 46.55328003970232], [2.5366520207790546, 46.51969984591665], [2.482928804775826, 46.5326974446441], [2.352003555650292, 46.51221134727485], [2.2857578150118907, 46.4535191502933], [2.2810476101300576, 46.420405373181076], [2.3230243720211274, 46.32927925675381], [2.3918607677139923, 46.329982476677564], [2.478940668864652, 46.28114777459818], [2.51631108338946, 46.2394395827726], [2.5653790586982077, 46.14303218282909], [2.6406912317167386, 46.118477661719055], [2.733052145656418, 46.223324326165525], [2.810275114252155, 46.196212623621925], [2.8557252864968374, 46.25548612990178], [2.9371457775851466, 46.24291746827502], [2.9095928618303137, 46.203493810710896], [2.971756635840471, 46.12178012989878], [3.166531859715606, 46.065677976513456], [3.371595622264062, 46.055060948494486], [3.419029561174583, 46.074292455805036], [3.4635034430082112, 46.017936870152816], [3.5884696050346547, 46.02413780633841], [3.6940178008729885, 45.93073235641245], [3.708883724363123, 45.97378454864049], [3.788909241913359, 45.973858692630216], [3.8254431917706766, 45.99596774333176], [3.80676406021388, 46.045622930292026], [3.8218687105012137, 46.087983889770236], [3.789761994058612, 46.154851332057206], [3.804886833081295, 46.254857087118516], [3.8995333931893303, 46.27590543921822], [3.9866257932147806, 46.31919378739565], [3.9772154801510964, 46.39922459383986], [3.9980416518372484, 46.46546757106017], [3.957937642803863, 46.48975562185937], [3.8904705648097098, 46.481250929951884], [3.834005903932969, 46.53113227681361], [3.8017563441985818, 46.51989955458831], [3.7432867634118914, 46.56756978217597], [3.6969523102437005, 46.66058216583629], [3.6379005417614154, 46.707208771712104], [3.629423683496518, 46.74945902193758], [3.550392218815862, 46.71586467208164], [3.487153284024355, 46.65825255471402], [3.4341330414396496, 46.711906067614436], [3.3467088070518343, 46.684416345410945], [3.2697920192933188, 46.71674092869], [3.2155498733945853, 46.68289184476872], [3.049065356287102, 46.758078941893714], [3.0320681893946824, 46.79491118852599]]]}, 'attributes': {'CODE_DEPT': '03', 'NOM_DEPT': 'ALLIER'}}, 77: {'geometry': {'type': 'MultiPolygon', 'bbox': (350493.90000010264, 6448234.400002138, 464807.40000008, 6591808.800001736), 'coordinates': [[[[-1.3421247126758926, 46.200128411102206], [-1.4221002716213311, 46.20488076908434], [-1.5143725982265883, 46.25771384564718], [-1.5353220120922193, 46.20439467626832], [-1.4615984066336871, 46.20211883930835], [-1.354959085594671, 46.155888081222486], [-1.3421247126758926, 46.200128411102206]]], [[[-1.2154998604971092, 45.906680490194944], [-1.2479234576289189, 45.99041558337054], [-1.3127617814535801, 45.99297745042204], [-1.365933505631468, 46.0272660214926], [-1.383914399457972, 45.9514445914214], [-1.2661507817954059, 45.87816722390555], [-1.2364229444496362, 45.80453690546564], [-1.1956193786522455, 45.82969725881447], [-1.1884331226527605, 45.8867480515982], [-1.2154998604971092, 45.906680490194944]]], [[[0.004330746876935129, 45.19163255561608], [-0.04416800947411755, 45.247891172634034], [-0.11538526357329242, 45.24807269185139], [-0.1087860702850694, 45.288951578180324], [-0.22670231706753854, 45.32143289837579], [-0.2808959166071477, 45.359870837250334], [-0.2497593835924425, 45.40874172938648], [-0.2674239730736353, 45.45567770932366], [-0.2461560346224069, 45.49164146613398], [-0.2967152234141238, 45.56449387379335], [-0.375919653128293, 45.60891920266458], [-0.4089294944559104, 45.656179885078146], [-0.41583863552489897, 45.74166865754338], [-0.2731191101089057, 45.80655862747699], [-0.22174528634311572, 45.77574564408546], [-0.15309474428582787, 45.795737000339294], [-0.11540038254695609, 45.87066390237831], [-0.1316644506664795, 45.911020629982204], [-0.10293687953014628, 45.96965998523801], [-0.281734309419876, 46.079753777667676], [-0.4005083126359273, 46.08471764024758], [-0.5060833286611979, 46.106705208008755], [-0.5469968076890194, 46.14422952781582], [-0.6199574101252711, 46.13775275457059], [-0.6907154750130782, 46.21920250569825], [-0.751461997484196, 46.245070221736306], [-0.7504755422947275, 46.304258794361985], [-0.8398782038660582, 46.34036911732443], [-0.9348886609093251, 46.31285600461679], [-1.0138072401149993, 46.35562475996171], [-1.1294041774921524, 46.310276919156045], [-1.1111638836886606, 46.26134367831717], [-1.1989980101944597, 46.21324548926308], [-1.2238754783330177, 46.16594526939382], [-1.1264112813835236, 46.12426291495015], [-1.0526867952056977, 46.01118088641011], [-1.0989490769387036, 45.99050755133215], [-1.0643196475545214, 45.949909080847114], [-1.1371605532141822, 45.81989861485067], [-1.2425738599563503, 45.781571555535386], [-1.2372284214926077, 45.70589632544047], [-1.1158494510522972, 45.646981327907554], [-1.0096306936697135, 45.61143397047435], [-1.0257418763479111, 45.57469303281359], [-0.8410572249719399, 45.435083368260905], [-0.7740181405098181, 45.36920881364397], [-0.7526821734869668, 45.321769940978704], [-0.5944806728104978, 45.321142824588456], [-0.5595072006432491, 45.29770833934146], [-0.4291954727294859, 45.279473994648164], [-0.3940718179854251, 45.16477966588993], [-0.34233753875966594, 45.167558376604845], [-0.25508698029919, 45.114085277381534], [-0.15295329411286374, 45.088807215890796], [-0.0877028308704419, 45.12138883628677], [-0.04020033978963981, 45.10238433596349], [0.004330746876935129, 45.19163255561608]]]]}, 'attributes': {'CODE_DEPT': '17', 'NOM_DEPT': 'CHARENTE-MARITIME'}}, 78: {'geometry': {'type': 'Polygon', 'bbox': (626128.5000000258, 6391030.700002284, 728488.39999999, 6486680.300002018), 'coordinates': [[[3.3613425807398936, 44.97141170967906], [3.3471986847617563, 45.014233878924244], [3.2972503187682016, 45.03607778789884], [3.3257851579159827, 45.09513611769889], [3.2880332175079103, 45.120424409579364], [3.222465248668949, 45.271971446584864], [3.1179979977042014, 45.284187297622296], [3.1034981328800555, 45.35437310008839], [3.016710134630249, 45.28712067830814], [2.9486247512965202, 45.30912583525689], [2.9215557561638335, 45.36577511746247], [2.8523786840571645, 45.39234069238325], [2.714857227145231, 45.38155782083139], [2.651429936294738, 45.442655051563015], [2.5084086971130826, 45.478498798744894], [2.4874679068775096, 45.418838410808995], [2.4418608930121475, 45.38425846985713], [2.378246243484016, 45.414305790766505], [2.3504794408656373, 45.32755821486311], [2.2714136874802597, 45.29015191925769], [2.195361138057307, 45.22085230029842], [2.21369697618154, 45.16019264015236], [2.1717556853734434, 45.08149587397568], [2.09515947189117, 45.05602988503961], [2.132978967739458, 44.98552052019752], [2.0629142919730623, 44.97650640551568], [2.0942123106720874, 44.87201148950678], [2.171636274864375, 44.79002439871239], [2.1534919160094748, 44.753107579025304], [2.1694177928364127, 44.638066191426034], [2.207475285530841, 44.6155316765299], [2.208413991565611, 44.6438441016835], [2.3267857957506486, 44.669692455972545], [2.4350033478315978, 44.638877643596295], [2.5561238131207125, 44.72128489545452], [2.562709168390778, 44.77575324565901], [2.5993575445949, 44.79280887269856], [2.6026810523917403, 44.84316760837649], [2.7064349149756604, 44.90722612216468], [2.738254293313791, 44.941222184736795], [2.8019551055054883, 44.87362935290207], [2.8496583078406252, 44.871489339969614], [2.8795722036394493, 44.80301061014638], [2.9345215070232764, 44.77919827286605], [2.9232644794453155, 44.728638923157135], [2.981676986530433, 44.64467661262439], [3.0615255979734926, 44.81717597962282], [3.0994768968798603, 44.83358841808975], [3.1054983095640436, 44.88677480310241], [3.182311971252496, 44.863734531317256], [3.2496925236752454, 44.91623789304505], [3.3613425807398936, 44.97141170967906]]]}, 'attributes': {'CODE_DEPT': '15', 'NOM_DEPT': 'CANTAL'}}, 79: {'geometry': {'type': 'Polygon', 'bbox': (662679.3000000154, 6234873.500002678, 796379.4999999614, 6319158.60000247), 'coordinates': [[[2.5657873980365586, 43.4229597441041], [2.5399619094859687, 43.346221862319766], [2.6016030790296316, 43.29870698639696], [2.772248225673249, 43.25778564580627], [2.8327620472635995, 43.32241280561742], [3.004349268167806, 43.3201311415977], [3.004740938100306, 43.28853825294436], [3.1472079664155532, 43.24700506844506], [3.2010265503923754, 43.24916714805378], [3.24056113717041, 43.21280863308419], [3.343863387032852, 43.270396006101606], [3.4303316940306616, 43.2902095364361], [3.510954322025528, 43.27333336221096], [3.6026190412473764, 43.35542655651473], [3.66215922818193, 43.39227906437721], [3.796663802013001, 43.44103590991053], [3.907134242130848, 43.51684377775207], [4.011185334395633, 43.55244665251141], [4.1010416754063925, 43.55437094640871], [4.150215691493674, 43.58556246815695], [4.194441206758988, 43.65430382623312], [4.144780927023585, 43.73388653553421], [4.002046166191344, 43.81146444231592], [3.917385092127717, 43.885593220663814], [3.830797043559706, 43.86642403487079], [3.824905456819552, 43.91929773950891], [3.787325021892116, 43.96687037520123], [3.726990344828379, 43.96901626259547], [3.6235886150953553, 43.91697856675764], [3.5754482408134063, 43.86552224087749], [3.5307009207380955, 43.855624713961724], [3.4244480676686226, 43.9115981684474], [3.358359441304462, 43.91383289325508], [3.275074750407491, 43.89835231151913], [3.203111724562128, 43.81387268634433], [3.0598559764719786, 43.831647379945494], [3.060740509271366, 43.69307728703755], [2.98535037366361, 43.70851625233063], [2.9354629666803715, 43.69466778518896], [2.9159815194674086, 43.6600207453723], [2.754523557193863, 43.61413878643591], [2.711169474843746, 43.645596783987564], [2.6432637215975134, 43.65014616249515], [2.615607192520078, 43.56663335506628], [2.658651329156613, 43.525794099032666], [2.6595399785833935, 43.480163558005835], [2.6060811779610433, 43.431093773006495], [2.5657873980365586, 43.4229597441041]]]}, 'attributes': {'CODE_DEPT': '34', 'NOM_DEPT': 'HERAULT'}}, 80: {'geometry': {'type': 'Polygon', 'bbox': (831613.6999999505, 6338354.700002426, 921862.99999992, 6473590.500002059), 'coordinates': [[[5.801469996094522, 44.70677851287007], [5.759044078047862, 44.696070284154175], [5.627084872571889, 44.75246442874933], [5.464158754968865, 44.79242749679314], [5.483647138020397, 44.92229059824829], [5.483609211781887, 45.02278614732915], [5.4497888352441555, 45.070783659173394], [5.388382939418145, 45.03613916354614], [5.179384657685968, 45.08331022009434], [5.188573507748233, 45.17126853879264], [5.176540876984405, 45.24840204491137], [5.121425532367964, 45.24833591809071], [5.054318727576238, 45.31905467974741], [4.98919148345871, 45.3440466408362], [4.880237763487564, 45.29745400935145], [4.800493926884063, 45.29836066114302], [4.812473966213053, 45.164481831518785], [4.837672652853049, 45.00479181394793], [4.886589299843448, 44.936651630533625], [4.822513080923934, 44.81708784467803], [4.76621554467615, 44.77862679935865], [4.779060115885165, 44.65469880413619], [4.710266499941698, 44.581549114708444], [4.693639580520507, 44.54223067415186], [4.698652294124969, 44.45230946012685], [4.667367377491741, 44.43066448441984], [4.6506150134375535, 44.329805791511355], [4.762251228111598, 44.32538168266034], [4.802876705944989, 44.29659556592812], [4.814083573320774, 44.2323148850936], [5.060564583015947, 44.308139760560856], [5.1497271329806695, 44.28208386834496], [5.154903556803356, 44.23094499620103], [5.384523055943825, 44.20104672066323], [5.383240887752097, 44.1552847302192], [5.435755865794636, 44.152248640249894], [5.498787806458752, 44.11571934778844], [5.543986124993945, 44.136390782725556], [5.576187167563138, 44.18804165094914], [5.63959354437225, 44.16758605191373], [5.6760373255434615, 44.19143313185903], [5.686555113440127, 44.26691847226601], [5.6467813253574, 44.267091475448616], [5.631598076087923, 44.328303017470354], [5.4930715607447445, 44.337177520811814], [5.418530667075708, 44.42494737031908], [5.513340558551903, 44.49113051875823], [5.60363867462863, 44.46554529362203], [5.630798606104504, 44.531598322128225], [5.5972487980667855, 44.543273727979305], [5.649630948822756, 44.617881007404385], [5.790619766631355, 44.65329030204336], [5.801469996094522, 44.70677851287007]], [[4.892909784975503, 44.36481842003472], [4.918515009368784, 44.40778504385663], [4.970436397484981, 44.431369949348735], [5.015759498726315, 44.39276614596868], [5.013377111169766, 44.326140286469006], [4.978583367650993, 44.2974630383884], [4.8895301353902365, 44.30415309780481], [4.892909784975503, 44.36481842003472]]]}, 'attributes': {'CODE_DEPT': '26', 'NOM_DEPT': 'DROME'}}, 81: {'geometry': {'type': 'Polygon', 'bbox': (595443.1000000458, 6137190.400002889, 714274.8999999937, 6202112.800002751), 'coordinates': [[[1.7861250110638967, 42.57362343207799], [1.7498821218907068, 42.56358508914765], [1.7298881048979537, 42.49532568149947], [1.834622898672281, 42.481786229589915], [1.9582842085598802, 42.42404869009346], [1.9859066164117019, 42.362048166797855], [2.0835981014554434, 42.362700139815864], [2.1563417567377465, 42.423427445080726], [2.257800225542442, 42.43835800634614], [2.435482130866189, 42.38887656698723], [2.4829628754848416, 42.33964655377147], [2.5400343955805043, 42.33375178289363], [2.5778245531567956, 42.357933234601965], [2.6717654689105332, 42.341178207697936], [2.675046174210866, 42.40496831103936], [2.7532002138160787, 42.42535725427029], [2.799242281304166, 42.41856867596319], [2.8414109625242325, 42.45852270899337], [3.0407621096853417, 42.47314100863676], [3.085437328583658, 42.425509881233275], [3.1732198139368313, 42.43487739331475], [3.1335847928885587, 42.51294127329134], [3.0496064216977565, 42.55014015956984], [3.0354222951214984, 42.67824819650247], [3.0434985865888815, 42.83815011921819], [2.917114990593263, 42.88486022074895], [2.8652738803519484, 42.91834143726111], [2.789053819259419, 42.895988728811666], [2.7400003158100112, 42.837574151817094], [2.6975776462485945, 42.83043106598879], [2.5090117260388043, 42.8498316897036], [2.4524747607108766, 42.83693276356485], [2.327116045977923, 42.83744277583194], [2.357535079462851, 42.73412195489046], [2.322006120391769, 42.70779157620252], [2.166053682054993, 42.66391836976537], [2.0005149149001977, 42.66156483553949], [1.9717596461471247, 42.616920493794225], [1.8744850028357225, 42.58140598425574], [1.7861250110638967, 42.57362343207799]]]}, 'attributes': {'CODE_DEPT': '66', 'NOM_DEPT': 'PYRENEES-ORIENTALES'}}, 82: {'geometry': {'type': 'Polygon', 'bbox': (904448.5999999343, 6445704.300002147, 1027166.6999998918, 6541571.800001871), 'coordinates': [[[6.260566197557925, 45.12684791386638], [6.362922813242248, 45.104493949917355], [6.393914586674507, 45.06181851097428], [6.486234598441577, 45.05607309559151], [6.481254109642402, 45.09413629464079], [6.629987338137472, 45.10932692819998], [6.680067352474279, 45.14012497136197], [6.767935179515761, 45.15974375221748], [6.8498588431895495, 45.12716081574415], [6.968757184292426, 45.20806055776685], [7.1375903052782785, 45.25569487340009], [7.110695394012846, 45.32651229960499], [7.1842747748936695, 45.407480631519974], [7.11351645521197, 45.434194687331164], [7.099789135400909, 45.46943936219549], [7.000331708478394, 45.50441719658233], [7.00069053414829, 45.639901594374685], [6.934608837460736, 45.64709230917708], [6.82911456486592, 45.70283279544949], [6.802516663522652, 45.77837197402202], [6.711938518958688, 45.72291967208878], [6.661192099251396, 45.79890547186778], [6.6017329724955784, 45.79541992331821], [6.552237633503553, 45.82687986970043], [6.509087472467453, 45.908632873298934], [6.4705596799701395, 45.88469229739344], [6.423672125473555, 45.80244240743697], [6.383851558657904, 45.778055295582284], [6.330635270345084, 45.69553113948386], [6.239679907775352, 45.685404763162644], [6.189714169774869, 45.70416174969227], [6.166233910329838, 45.75571563232783], [6.042939005987317, 45.73909595131257], [5.913209603821916, 45.80414083870233], [5.87342650248464, 45.8380955581268], [5.862101395990038, 45.93240229486188], [5.831226413621035, 45.938459578293276], [5.78685622417971, 45.82295599649888], [5.7761608991802635, 45.729222395584365], [5.704119379498134, 45.71092632945925], [5.68918710219464, 45.648501612399514], [5.623748035268077, 45.613268326764235], [5.73637233564262, 45.47254042424711], [5.782081150720108, 45.44065533936717], [5.8797384015593375, 45.406796712103855], [5.966169653050878, 45.49230872138147], [6.049753851710851, 45.437919529651154], [6.121272339213555, 45.438897845399346], [6.177450938299201, 45.39316148783131], [6.1844503207792245, 45.31794850760677], [6.131944929909637, 45.28828721598462], [6.1256964814234856, 45.24427026883595], [6.189207693158913, 45.16373228327807], [6.260566197557925, 45.12684791386638]]]}, 'attributes': {'CODE_DEPT': '73', 'NOM_DEPT': 'SAVOIE'}}, 83: {'geometry': {'type': 'Polygon', 'bbox': (892505.1999999284, 6347226.500002407, 1022959.6999998831, 6452798.600002125), 'coordinates': [[[5.801469996094522, 44.70677851287007], [5.790619766631355, 44.65329030204336], [5.649630948822756, 44.617881007404385], [5.5972487980667855, 44.543273727979305], [5.630798606104504, 44.531598322128225], [5.60363867462863, 44.46554529362203], [5.513340558551903, 44.49113051875823], [5.418530667075708, 44.42494737031908], [5.4930715607447445, 44.337177520811814], [5.631598076087923, 44.328303017470354], [5.6467813253574, 44.267091475448616], [5.686555113440127, 44.26691847226601], [5.6760373255434615, 44.19143313185903], [5.755494196596879, 44.210207765237946], [5.881793583616446, 44.21099866254289], [5.82391188904594, 44.2789019553126], [5.912323479912073, 44.27153166809458], [5.9536703829504924, 44.395059266699306], [6.071139333430846, 44.45053588827675], [6.155615049010708, 44.46195982298566], [6.228221718294847, 44.3817003919971], [6.262481962582939, 44.41225003856598], [6.233718236049833, 44.4638309183279], [6.362000081358195, 44.52207257904401], [6.413884950226282, 44.4692899596284], [6.562444503095603, 44.44549275371164], [6.632376327558709, 44.44712877640482], [6.684305299896707, 44.54130010645845], [6.772207133133649, 44.58890871380483], [6.839801667428219, 44.60858882906445], [6.914488202179286, 44.65949945810221], [6.948335091404861, 44.65481629914683], [6.987055135805778, 44.69014148867842], [7.077108800206922, 44.6809175091735], [6.9995712397492555, 44.78944471324744], [7.0067737788907705, 44.83931596763321], [6.933687243037527, 44.86202607200874], [6.859863090422121, 44.852900819527136], [6.749745773276747, 44.90736131510606], [6.763455936171166, 44.97122008604696], [6.7408068424989125, 45.0167293468965], [6.673884165477501, 45.01961754078056], [6.629987338137472, 45.10932692819998], [6.481254109642402, 45.09413629464079], [6.486234598441577, 45.05607309559151], [6.393914586674507, 45.06181851097428], [6.362922813242248, 45.104493949917355], [6.260566197557925, 45.12684791386638], [6.229388123209471, 45.10875005580748], [6.203927022398642, 45.012469165084894], [6.318198197576597, 45.003856776770746], [6.358840060670484, 44.94128447146308], [6.355361452664248, 44.85477898991752], [6.302846745398275, 44.8732598816747], [6.25054409332542, 44.85265497741966], [6.136224190737252, 44.864072791226555], [6.056342958572753, 44.815908261733725], [6.030210546238997, 44.83809609775428], [5.949519247847449, 44.80453012289723], [5.915233300411789, 44.754705804536144], [5.850398663313627, 44.75074454418589], [5.801469996094522, 44.70677851287007]]]}, 'attributes': {'CODE_DEPT': '05', 'NOM_DEPT': 'HAUTES-ALPES'}}, 84: {'geometry': {'type': 'MultiPolygon', 'bbox': (831613.6999999505, 6287714.5000025565, 922160.3999999114, 6372214.700002337), 'coordinates': [[[[4.892909784975503, 44.36481842003472], [4.8895301353902365, 44.30415309780481], [4.978583367650993, 44.2974630383884], [5.013377111169766, 44.326140286469006], [5.015759498726315, 44.39276614596868], [4.970436397484981, 44.431369949348735], [4.918515009368784, 44.40778504385663], [4.892909784975503, 44.36481842003472]]], [[[4.739060856654237, 43.92405947349065], [4.853093547765335, 43.91138205123065], [4.966309299927297, 43.871647269138414], [5.029533445304739, 43.82779291313883], [5.051490035086313, 43.787881688465646], [5.187972296540632, 43.73510332278265], [5.229990308924738, 43.747672881125666], [5.31850282672, 43.735021431958316], [5.439245661034276, 43.68110432174814], [5.531453034372501, 43.65901134759583], [5.6069435191164425, 43.658685905164866], [5.753638490630262, 43.72462253878885], [5.757332977582704, 43.72940911375542], [5.654445137414141, 43.82511098585945], [5.578189791221216, 43.82992112219797], [5.607126670731597, 43.91377284375335], [5.51208954255573, 43.94600228564655], [5.543656674317525, 44.02870768768531], [5.502636785327954, 44.06343920865502], [5.498787806458752, 44.11571934778844], [5.435755865794636, 44.152248640249894], [5.383240887752097, 44.1552847302192], [5.384523055943825, 44.20104672066323], [5.154903556803356, 44.23094499620103], [5.1497271329806695, 44.28208386834496], [5.060564583015947, 44.308139760560856], [4.814083573320774, 44.2323148850936], [4.802876705944989, 44.29659556592812], [4.762251228111598, 44.32538168266034], [4.6506150134375535, 44.329805791511355], [4.649223666100485, 44.27035986501103], [4.722074664233515, 44.18742154948275], [4.707458356688191, 44.10367246401253], [4.787978024928094, 44.065054097470245], [4.842093969959471, 43.986474548464955], [4.739060856654237, 43.92405947349065]]]]}, 'attributes': {'CODE_DEPT': '84', 'NOM_DEPT': 'VAUCLUSE'}}, 85: {'geometry': {'type': 'Polygon', 'bbox': (537221.0000000435, 6584255.600001739, 638968.6000000171, 6687210.900001439), 'coordinates': [[[2.1677857181383846, 46.42406650081814], [2.151671606709124, 46.45796019235819], [2.2043972607989812, 46.48439997524811], [2.158700190947214, 46.55734628168224], [2.1856288615493806, 46.60286242584111], [2.1407244355816926, 46.695553715403406], [2.065751312591214, 46.742494802064954], [2.1153606164888155, 46.77435860147472], [2.048810332345124, 46.829448268143665], [2.1262038890477335, 46.87986509549622], [2.070698616355421, 46.93399643786311], [2.0933838995940373, 47.01573583573], [2.0514877607984485, 47.04001604864955], [2.0483748812476152, 47.10601550210716], [1.96641397939093, 47.12541751372794], [1.8827218498344331, 47.10194954564286], [1.77458130936527, 47.130846812692184], [1.8421086266284747, 47.178029354432915], [1.8390792420529527, 47.21930815773429], [1.7058305011298702, 47.26587806829796], [1.5924281213159726, 47.27667661630462], [1.4484622479605176, 47.23796792122444], [1.3266655450453901, 47.18622542473183], [1.365360999707624, 47.12205127770922], [1.3116729094606134, 47.09697527344035], [1.2730568495660926, 47.037834138185595], [1.1614221724181906, 47.03962297281958], [1.0776154683629746, 47.01584239818827], [1.0498776400419196, 46.980640418735526], [0.9888132945329698, 46.76154066839271], [0.8674688807081565, 46.74821910504852], [0.9247556936578996, 46.692793352316095], [0.8943018154002155, 46.62573665182292], [0.9420237588365904, 46.58079210842132], [1.0147644249831804, 46.567763998822045], [1.1459353661062854, 46.50640188056713], [1.151604534776636, 46.44923617581203], [1.2126902380833458, 46.43222161336166], [1.1772799568053671, 46.38395162215298], [1.3030567860553477, 46.37099465262584], [1.3560228953092235, 46.40012317441322], [1.415190510113751, 46.347218495873015], [1.5223068332769558, 46.426524994500525], [1.6448464161558112, 46.38681584908523], [1.7277108990817456, 46.388958713661], [1.8195004176655627, 46.43003833895096], [1.9930823669027027, 46.43091738935587], [2.088941803334241, 46.40890318674812], [2.1677857181383846, 46.42406650081814]]]}, 'attributes': {'CODE_DEPT': '36', 'NOM_DEPT': 'INDRE'}}, 86: {'geometry': {'type': 'Polygon', 'bbox': (1159341.799999797, 6102880.200002988, 1242212.6999997562, 6233783.10000272), 'coordinates': [[[9.402268324411988, 41.8586982422724], [9.412573752377243, 41.95247536073499], [9.549983013016067, 42.10416397232976], [9.558834031337037, 42.28526344136207], [9.53267016615381, 42.379967221908856], [9.543397471188385, 42.4284895809259], [9.533193015205354, 42.545944023399194], [9.449196243675715, 42.66223603163033], [9.446380758225056, 42.68612187004446], [9.492379312253558, 42.80510332631413], [9.47306347792927, 42.87413170694103], [9.463553614767086, 42.986403164804315], [9.421761206671862, 43.0117229260944], [9.340869996691138, 42.99446130565284], [9.353823296916072, 42.91623891811394], [9.31102033856565, 42.83467992024297], [9.342560255911149, 42.79480129860917], [9.344474787466682, 42.73781243290846], [9.293321757624451, 42.67431591000088], [9.25445227241371, 42.71851210134247], [9.16688288642443, 42.736561067518316], [9.085757984829678, 42.71460676752987], [9.020690214855305, 42.64427117625519], [8.886523760118468, 42.628970742503846], [8.808932860020777, 42.59905594696854], [8.804094980454654, 42.569860341632705], [8.666504962154614, 42.515224058632846], [8.655224073914711, 42.41573555548158], [8.608422093704315, 42.41682541343206], [8.573411068108614, 42.381405712050416], [8.640801666424288, 42.373436353833135], [8.819561377056067, 42.31755804188299], [8.904766989145307, 42.253859280701064], [9.04565931380628, 42.2069234314084], [9.07218689177604, 42.13021371520025], [9.119729450195365, 42.10777443178623], [9.160818391906192, 42.02601714338066], [9.221084024655989, 42.0275969605392], [9.227497390904741, 41.85558903234797], [9.329200877550077, 41.83681486608324], [9.402268324411988, 41.8586982422724]]]}, 'attributes': {'CODE_DEPT': '2B', 'NOM_DEPT': 'HAUTE-CORSE'}}, 87: {'geometry': {'type': 'Polygon', 'bbox': (515634.90000005835, 6484264.10000203, 614305.1000000271, 6590222.6000017235), 'coordinates': [[[1.2531518386328941, 45.44421907802489], [1.2870567570435636, 45.48993789201237], [1.3500778792847676, 45.46688830500584], [1.4120589140520188, 45.52808103157582], [1.4803697950912305, 45.565943138308214], [1.5571958047036878, 45.54936632471635], [1.637663451137719, 45.580351909123976], [1.7838678002323443, 45.680363378073274], [1.8713480467629338, 45.66465827008339], [1.8987307791829435, 45.69827755120417], [1.875140102478583, 45.73277978898966], [1.8808988285366517, 45.79771481845652], [1.7727491731275808, 45.84282757445299], [1.6766374034760072, 45.835114020235785], [1.6023984681707664, 45.857465158579075], [1.6087196458716781, 45.93341242644046], [1.532500175591522, 45.95280423814574], [1.5491757848158927, 46.035410141538826], [1.4527947858284078, 46.179754612070326], [1.3749003074212898, 46.215451100952365], [1.4437697350516507, 46.30589420737533], [1.415190510113751, 46.347218495873015], [1.3560228953092235, 46.40012317441322], [1.3030567860553477, 46.37099465262584], [1.1772799568053671, 46.38395162215298], [1.1297576486963086, 46.36046628124314], [1.0269954429337316, 46.34303442800402], [1.0058867393780466, 46.28097399864584], [0.9072715939898943, 46.285257481169175], [0.7963255053030069, 46.21096277430393], [0.8234337839606, 46.128581728488335], [0.8179096763959531, 46.047878116483744], [0.925625498473504, 46.010453963771695], [0.9425919960124768, 45.957436078431286], [0.8629055339639642, 45.919755494447834], [0.7822321483214062, 45.82108209588085], [0.7164398059782184, 45.805617938664106], [0.7148884001268344, 45.76311968057411], [0.6297424639524403, 45.714569989772734], [0.7758431349260257, 45.667569572341854], [0.7515297126109174, 45.61832385402009], [0.8115003322647287, 45.57587064346199], [0.9345523684647934, 45.61158201050324], [1.0358490435954526, 45.600209290253204], [1.1197844789851379, 45.48778292627882], [1.2531518386328941, 45.44421907802489]]]}, 'attributes': {'CODE_DEPT': '87', 'NOM_DEPT': 'HAUTE-VIENNE'}}, 88: {'geometry': {'type': 'MultiPolygon', 'bbox': (297360.00000010285, 6582707.500001765, 428213.4000000774, 6673611.100001499), 'coordinates': [[[[-2.301813103356832, 46.989742762366866], [-2.2643800884994, 46.960878388662], [-2.218334029034883, 47.007818944291785], [-2.287230516382024, 47.0246212592717], [-2.301813103356832, 46.989742762366866]]], [[[-1.9804144867428743, 47.0289064940757], [-2.027355429633454, 47.00991814012842], [-2.062740934359734, 46.948066582804685], [-2.1538266883941835, 46.89015018115234], [-2.144508393520905, 46.82639635681275], [-1.9428810018395466, 46.69270499139385], [-1.8560176099926666, 46.60857792818526], [-1.8123496382428257, 46.493418144353285], [-1.7771417987632765, 46.492758463623225], [-1.6270608317160016, 46.414221541074056], [-1.5021454225847803, 46.39734952406841], [-1.4659415635018052, 46.342359010199445], [-1.3667425638808834, 46.34861328663732], [-1.2073944924206355, 46.26657161481696], [-1.2010877236762245, 46.31634695785256], [-1.1294041774921524, 46.310276919156045], [-1.0138072401149993, 46.35562475996171], [-0.9348886609093251, 46.31285600461679], [-0.8398782038660582, 46.34036911732443], [-0.7504755422947275, 46.304258794361985], [-0.5576498721967046, 46.363448573781824], [-0.537800498012109, 46.386465465455736], [-0.6406445679433723, 46.416229245156025], [-0.6124259071699314, 46.45873492951781], [-0.6021285989587037, 46.5332805477888], [-0.6141139330666159, 46.62039039102906], [-0.6440639078487055, 46.63802790732369], [-0.6561893352875896, 46.700774642460956], [-0.7273121698337276, 46.767632454458024], [-0.700856479426351, 46.80862675485134], [-0.7816473761536206, 46.84282850114098], [-0.8291443983745105, 46.93336473376703], [-0.8919599503022396, 46.97581784960789], [-0.9334603151811857, 47.008908043397604], [-1.055403108514476, 47.00568547430046], [-1.148570488753439, 47.02954516258661], [-1.271206708715037, 47.08389319899781], [-1.2946349782361026, 47.03948346966519], [-1.3786124689367807, 47.03085386698659], [-1.372985770094949, 46.952184466609765], [-1.4561316296061408, 46.9262728543553], [-1.4821311833973978, 47.037861989589345], [-1.5523222833408639, 47.01834875737963], [-1.553563697237001, 46.98150474523176], [-1.5007668577856454, 46.883891152829825], [-1.5485110748777007, 46.86007983436473], [-1.689761273986443, 46.89049286319811], [-1.751062300240369, 46.92959568215281], [-1.8309821821134142, 46.93203372415455], [-1.9432276192598639, 46.99471092059498], [-1.9804144867428743, 47.0289064940757]]]]}, 'attributes': {'CODE_DEPT': '85', 'NOM_DEPT': 'VENDEE'}}, 89: {'geometry': {'type': 'Polygon', 'bbox': (916540.6999999128, 6220583.000002719, 1018255.5999998702, 6307147.400002514), 'coordinates': [[[5.671875005699277, 43.179268786905034], [5.694880043308293, 43.14358778681919], [5.812729626801352, 43.109364524560156], [5.804564531287972, 43.078284936751174], [5.857450411938568, 43.04661900463519], [5.941245658009144, 43.10766029019487], [6.031440047836646, 43.0774733246305], [6.124045766317683, 43.07930848251319], [6.1839937902841156, 43.10853535096948], [6.26529674054148, 43.121044618100576], [6.368261479285512, 43.089912921964], [6.387572821703613, 43.14489830267718], [6.493498246377527, 43.150222752221076], [6.559636361254334, 43.18862998328663], [6.635531400239645, 43.17251047188635], [6.659331915728427, 43.195927346581975], [6.677311623765607, 43.27879196431368], [6.665952517510404, 43.31821636550598], [6.73981102371754, 43.41288050528181], [6.859478029180434, 43.41816384523447], [6.933726236453416, 43.48006801088512], [6.884230099335205, 43.50253572781932], [6.908012993627823, 43.599079187947034], [6.798740654261998, 43.62818033606136], [6.7608013983957, 43.66648795918865], [6.753535969205428, 43.73816698047843], [6.636395800176684, 43.78895056709553], [6.5247619833224295, 43.80636597788814], [6.4144280526034985, 43.791594458434275], [6.413483066219063, 43.76036041847228], [6.356960735074888, 43.736367664887325], [6.216709972579084, 43.79951197699887], [6.182886008281907, 43.76217559136379], [6.036131813943926, 43.694163340855255], [5.901207402568148, 43.73258459518493], [5.781343238677484, 43.75565738832385], [5.757332977582704, 43.72940911375542], [5.753638490630262, 43.72462253878885], [5.813243983394541, 43.68896399525119], [5.799061112603832, 43.66051789095851], [5.700215221457389, 43.64171611369793], [5.682144833819897, 43.6137320600733], [5.724610447116372, 43.5508975272503], [5.698802592390259, 43.482170126904066], [5.751846953791003, 43.43429512520618], [5.682787396731936, 43.399156869316464], [5.760928945485899, 43.267337999671355], [5.683909137465821, 43.236058294491144], [5.671875005699277, 43.179268786905034]]]}, 'attributes': {'CODE_DEPT': '83', 'NOM_DEPT': 'VAR'}}, 90: {'geometry': {'type': 'Polygon', 'bbox': (650056.2000000083, 6843626.300000984, 671600.3000000048, 6862430.900000933), 'coordinates': [[[2.592280488308802, 48.80743667582849], [2.4956469644616233, 48.86084961766197], [2.4163397172813523, 48.8492382734211], [2.331895313988745, 48.81701271306946], [2.3207180175230318, 48.748756235094554], [2.3707067322771356, 48.72017592254696], [2.503536569558129, 48.735211482185626], [2.5716603184420737, 48.69201409166007], [2.6136476481340414, 48.76102719230643], [2.592280488308802, 48.80743667582849]]]}, 'attributes': {'CODE_DEPT': '94', 'NOM_DEPT': 'VAL-DE-MARNE'}}, 91: {'geometry': {'type': 'Polygon', 'bbox': (637702.2000000101, 6850064.200000968, 650942.200000008, 6872566.900000905), 'coordinates': [[[2.331895313988745, 48.81701271306946], [2.2551429018636835, 48.83480774229436], [2.231736346483731, 48.86906948088366], [2.319884458526643, 48.900458867352725], [2.2909735732251617, 48.950966788090646], [2.200591009269504, 48.908679329904004], [2.152869141422736, 48.87333985215582], [2.1515778037276108, 48.81702039835412], [2.226559327154523, 48.77610203163561], [2.3207180175230318, 48.748756235094554], [2.331895313988745, 48.81701271306946]]]}, 'attributes': {'CODE_DEPT': '92', 'NOM_DEPT': 'HAUTS-DE-SEINE'}}, 92: {'geometry': {'type': 'Polygon', 'bbox': (698546.9000000006, 6336169.1000024285, 779410.8999999706, 6430308.600002175), 'coordinates': [[[2.981676986530433, 44.64467661262439], [3.083593896775788, 44.55901439443305], [3.068542786200033, 44.50348970314479], [3.13573609856136, 44.45487023109913], [3.119711177226503, 44.38337811871582], [3.1542516260589815, 44.30837023621571], [3.1252288254578002, 44.28446357369589], [3.2298475773263053, 44.22625501460899], [3.3577995033411128, 44.19791043423504], [3.373648044830684, 44.17075587210572], [3.4397298934659633, 44.12909826593232], [3.633491144032294, 44.12269533049063], [3.6377691613510246, 44.17548804418238], [3.678640671819198, 44.18275878035759], [3.7969951126604835, 44.12738907948696], [3.862104986455047, 44.13007375244107], [3.9526044819739092, 44.17079372606867], [3.9513171396124562, 44.24779542988908], [3.922858913740669, 44.305217941025745], [3.952331315351652, 44.328389996777126], [3.8859181039452233, 44.38799905234699], [3.944362317344653, 44.399567503492385], [3.998162987763964, 44.45979755586332], [3.9451489956301886, 44.57379092180423], [3.9051719910706293, 44.59270804776968], [3.862527190139651, 44.74386343467101], [3.7406507355868404, 44.83869734813907], [3.6663649146430073, 44.82877808873485], [3.6595223843815874, 44.8699386445054], [3.5943359966689914, 44.87542977006513], [3.589348917106291, 44.83219404802301], [3.4757737071599757, 44.81537151910519], [3.4179705141646854, 44.90076835769564], [3.412834742275399, 44.944842501975934], [3.3613425807398936, 44.97141170967906], [3.2496925236752454, 44.91623789304505], [3.182311971252496, 44.863734531317256], [3.1054983095640436, 44.88677480310241], [3.0994768968798603, 44.83358841808975], [3.0615255979734926, 44.81717597962282], [2.981676986530433, 44.64467661262439]]]}, 'attributes': {'CODE_DEPT': '48', 'NOM_DEPT': 'LOZERE'}}, 93: {'geometry': {'type': 'Polygon', 'bbox': (799606.7999999593, 6232742.000002689, 926823.2999999092, 6315433.300002484), 'coordinates': [[[4.230283393392478, 43.46018543272649], [4.554920338571665, 43.44621502092883], [4.5880988691773705, 43.42270695496557], [4.562800334318894, 43.37213670596152], [4.6617830951472214, 43.346412345483685], [4.759588900377177, 43.34994067645605], [4.855048529182453, 43.3326166544089], [4.866850028014126, 43.40468173427733], [4.967705599857733, 43.42610491918491], [5.041038908355625, 43.327286652949944], [5.240586909552983, 43.33171447327505], [5.311030077911202, 43.360876400521285], [5.362055004284556, 43.32195654694654], [5.345688435376645, 43.28236341769554], [5.363644360087066, 43.20712491164306], [5.536931681001044, 43.21449364341575], [5.60088990032015, 43.1625456316741], [5.671875005699277, 43.179268786905034], [5.683909137465821, 43.236058294491144], [5.760928945485899, 43.267337999671355], [5.682787396731936, 43.399156869316464], [5.751846953791003, 43.43429512520618], [5.698802592390259, 43.482170126904066], [5.724610447116372, 43.5508975272503], [5.682144833819897, 43.6137320600733], [5.700215221457389, 43.64171611369793], [5.799061112603832, 43.66051789095851], [5.813243983394541, 43.68896399525119], [5.753638490630262, 43.72462253878885], [5.6069435191164425, 43.658685905164866], [5.531453034372501, 43.65901134759583], [5.439245661034276, 43.68110432174814], [5.31850282672, 43.735021431958316], [5.229990308924738, 43.747672881125666], [5.187972296540632, 43.73510332278265], [5.051490035086313, 43.787881688465646], [5.029533445304739, 43.82779291313883], [4.966309299927297, 43.871647269138414], [4.853093547765335, 43.91138205123065], [4.739060856654237, 43.92405947349065], [4.641909591242105, 43.86747754714173], [4.654821446467849, 43.806408691630295], [4.5930322483013235, 43.68746240297304], [4.487236861293796, 43.69923776661928], [4.427028042117802, 43.62067757183961], [4.409349673740097, 43.561127800636186], [4.238105541141803, 43.497626917839995], [4.230283393392478, 43.46018543272649]], [[5.09638202520383, 43.40140783165064], [5.05956976393125, 43.40397723018547], [5.051880922172624, 43.46355664001118], [5.006007239562996, 43.46966221650619], [5.015464900192831, 43.52972333434824], [5.10866638424325, 43.52549492153416], [5.157538221661901, 43.409584122707585], [5.09638202520383, 43.40140783165064]]]}, 'attributes': {'CODE_DEPT': '13', 'NOM_DEPT': 'BOUCHES-DU-RHONE'}}, 94: {'geometry': {'type': 'Polygon', 'bbox': (643644.0000000091, 6857645.800000944, 657169.1000000068, 6867065.000000917), 'coordinates': [[[2.331895313988745, 48.81701271306946], [2.4163397172813523, 48.8492382734211], [2.385151006972503, 48.90200779222234], [2.319884458526643, 48.900458867352725], [2.231736346483731, 48.86906948088366], [2.2551429018636835, 48.83480774229436], [2.331895313988745, 48.81701271306946]]]}, 'attributes': {'CODE_DEPT': '75', 'NOM_DEPT': 'PARIS'}}, 95: {'geometry': {'type': 'Polygon', 'bbox': (648070.7000000081, 6856451.100000947, 670882.1000000045, 6878970.900000885), 'coordinates': [[[2.592280488308802, 48.80743667582849], [2.5626221662429587, 48.888884130538436], [2.602598431431983, 48.92935660279411], [2.55306064485419, 49.00981711745223], [2.4594899596115933, 48.95504632684678], [2.366443627637154, 48.974176668580746], [2.2909735732251617, 48.950966788090646], [2.319884458526643, 48.900458867352725], [2.385151006972503, 48.90200779222234], [2.4163397172813523, 48.8492382734211], [2.4956469644616233, 48.86084961766197], [2.592280488308802, 48.80743667582849]]]}, 'attributes': {'CODE_DEPT': '93', 'NOM_DEPT': 'SEINE-SAINT-DENIS'}}}}
    },
}


def test_all():
    # create_geolayer_from_i_feat_list
    print(
        test_function(
            create_geolayer_from_i_feat_list,
            create_geolayer_from_i_feat_list_parameters,
        )
    )

    # reproject_geolayer
    print(test_function(reproject_geolayer, reproject_geolayer_parameters))


if __name__ == "__main__":
    test_all()
