# coding: utf-8

"""
    videoapi

    The video APIs help you convert, encode, and transcode videos.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudmersive_video_api_client.api_client import ApiClient


class VideoApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def video_convert_to_gif(self, input_file, **kwargs):  # noqa: E501
        """Convert Video to Animated GIF format.  # noqa: E501

        Automatically detect video file format and convert it to animated GIF format. Supports many input video formats, including AVI, ASF, FLV, MP4, MPEG/MPG, Matroska/WEBM, 3G2, OGV, MKV, M4V and MOV. Uses 1 API call per 10 MB of file size. Maximum output file size is 50GB. Default height is 250 pixels, while preserving the video's aspect ratio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_convert_to_gif(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str file_url: Optional; URL of a video file being used for conversion. Use this option for files larger than 2GB.
        :param int max_width: Optional; Maximum width of the output video, up to the original video width. Defaults to 250 pixels.
        :param int max_height: Optional; Maximum height of the output video, up to the original video width. Defaults to 250 pixels.
        :param bool preserve_aspect_ratio: Optional; If false, the original video's aspect ratio will not be preserved, allowing customization of the aspect ratio using maxWidth and maxHeight, potentially skewing the video. Default is true.
        :param int frame_rate: Optional; Specify the frame rate of the output video. Defaults to 24 frames per second.
        :param bool extend_processing_time: Optional; If true, will allow additional processing time for the video file conversion, using one API call per additional minute over the 5 minute default processing time, up to a maximum of 25 total minutes. This is generally necessary for files larger than 500 MB or longer than 30 minutes.
        :param datetime start_time: Optional; Specify the desired starting time of the GIF video in TimeSpan format.
        :param datetime time_span: Optional; Specify the desired length of the GIF video in TimeSpan format. Limit is 30 minutes.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.video_convert_to_gif_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.video_convert_to_gif_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def video_convert_to_gif_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Convert Video to Animated GIF format.  # noqa: E501

        Automatically detect video file format and convert it to animated GIF format. Supports many input video formats, including AVI, ASF, FLV, MP4, MPEG/MPG, Matroska/WEBM, 3G2, OGV, MKV, M4V and MOV. Uses 1 API call per 10 MB of file size. Maximum output file size is 50GB. Default height is 250 pixels, while preserving the video's aspect ratio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_convert_to_gif_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str file_url: Optional; URL of a video file being used for conversion. Use this option for files larger than 2GB.
        :param int max_width: Optional; Maximum width of the output video, up to the original video width. Defaults to 250 pixels.
        :param int max_height: Optional; Maximum height of the output video, up to the original video width. Defaults to 250 pixels.
        :param bool preserve_aspect_ratio: Optional; If false, the original video's aspect ratio will not be preserved, allowing customization of the aspect ratio using maxWidth and maxHeight, potentially skewing the video. Default is true.
        :param int frame_rate: Optional; Specify the frame rate of the output video. Defaults to 24 frames per second.
        :param bool extend_processing_time: Optional; If true, will allow additional processing time for the video file conversion, using one API call per additional minute over the 5 minute default processing time, up to a maximum of 25 total minutes. This is generally necessary for files larger than 500 MB or longer than 30 minutes.
        :param datetime start_time: Optional; Specify the desired starting time of the GIF video in TimeSpan format.
        :param datetime time_span: Optional; Specify the desired length of the GIF video in TimeSpan format. Limit is 30 minutes.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'file_url', 'max_width', 'max_height', 'preserve_aspect_ratio', 'frame_rate', 'extend_processing_time', 'start_time', 'time_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method video_convert_to_gif" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `video_convert_to_gif`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'file_url' in params:
            header_params['fileUrl'] = params['file_url']  # noqa: E501
        if 'max_width' in params:
            header_params['maxWidth'] = params['max_width']  # noqa: E501
        if 'max_height' in params:
            header_params['maxHeight'] = params['max_height']  # noqa: E501
        if 'preserve_aspect_ratio' in params:
            header_params['preserveAspectRatio'] = params['preserve_aspect_ratio']  # noqa: E501
        if 'frame_rate' in params:
            header_params['frameRate'] = params['frame_rate']  # noqa: E501
        if 'extend_processing_time' in params:
            header_params['extendProcessingTime'] = params['extend_processing_time']  # noqa: E501
        if 'start_time' in params:
            header_params['startTime'] = params['start_time']  # noqa: E501
        if 'time_span' in params:
            header_params['timeSpan'] = params['time_span']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/video/convert/to/gif', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def video_convert_to_mov(self, input_file, **kwargs):  # noqa: E501
        """Convert Video to MOV format.  # noqa: E501

        Automatically detect video file format and convert it to MOV format. Supports many input video formats, including AVI, ASF, FLV, MP4, MPEG/MPG, Matroska/WEBM, 3G2, OGV, MKV, M4V and MOV. Uses 1 API call per 10 MB of file size. Maximum output file size is 50GB.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_convert_to_mov(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str file_url: Optional; URL of a video file being used for conversion. Use this option for files larger than 2GB.
        :param int max_width: Optional; Maximum width of the output video, up to the original video width. Defaults to original video width.
        :param int max_height: Optional; Maximum height of the output video, up to the original video width. Defaults to original video height.
        :param bool preserve_aspect_ratio: Optional; If false, the original video's aspect ratio will not be preserved, allowing customization of the aspect ratio using maxWidth and maxHeight, potentially skewing the video. Default is true.
        :param int frame_rate: Optional; Specify the frame rate of the output video. Defaults to original video frame rate.
        :param int quality: Optional; Specify the quality of the output video, where 100 is lossless and 1 is the lowest possible quality with highest compression. Default is 50.
        :param bool extend_processing_time: Optional; If true, will allow additional processing time for the video file conversion, using one API call per additional minute over the 5 minute default processing time, up to a maximum of 25 total minutes. This is generally necessary for files larger than 500 MB or longer than 30 minutes.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.video_convert_to_mov_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.video_convert_to_mov_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def video_convert_to_mov_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Convert Video to MOV format.  # noqa: E501

        Automatically detect video file format and convert it to MOV format. Supports many input video formats, including AVI, ASF, FLV, MP4, MPEG/MPG, Matroska/WEBM, 3G2, OGV, MKV, M4V and MOV. Uses 1 API call per 10 MB of file size. Maximum output file size is 50GB.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_convert_to_mov_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str file_url: Optional; URL of a video file being used for conversion. Use this option for files larger than 2GB.
        :param int max_width: Optional; Maximum width of the output video, up to the original video width. Defaults to original video width.
        :param int max_height: Optional; Maximum height of the output video, up to the original video width. Defaults to original video height.
        :param bool preserve_aspect_ratio: Optional; If false, the original video's aspect ratio will not be preserved, allowing customization of the aspect ratio using maxWidth and maxHeight, potentially skewing the video. Default is true.
        :param int frame_rate: Optional; Specify the frame rate of the output video. Defaults to original video frame rate.
        :param int quality: Optional; Specify the quality of the output video, where 100 is lossless and 1 is the lowest possible quality with highest compression. Default is 50.
        :param bool extend_processing_time: Optional; If true, will allow additional processing time for the video file conversion, using one API call per additional minute over the 5 minute default processing time, up to a maximum of 25 total minutes. This is generally necessary for files larger than 500 MB or longer than 30 minutes.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'file_url', 'max_width', 'max_height', 'preserve_aspect_ratio', 'frame_rate', 'quality', 'extend_processing_time']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method video_convert_to_mov" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `video_convert_to_mov`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'file_url' in params:
            header_params['fileUrl'] = params['file_url']  # noqa: E501
        if 'max_width' in params:
            header_params['maxWidth'] = params['max_width']  # noqa: E501
        if 'max_height' in params:
            header_params['maxHeight'] = params['max_height']  # noqa: E501
        if 'preserve_aspect_ratio' in params:
            header_params['preserveAspectRatio'] = params['preserve_aspect_ratio']  # noqa: E501
        if 'frame_rate' in params:
            header_params['frameRate'] = params['frame_rate']  # noqa: E501
        if 'quality' in params:
            header_params['quality'] = params['quality']  # noqa: E501
        if 'extend_processing_time' in params:
            header_params['extendProcessingTime'] = params['extend_processing_time']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/video/convert/to/mov', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def video_convert_to_mp4(self, input_file, **kwargs):  # noqa: E501
        """Convert Video to MP4 format.  # noqa: E501

        Automatically detect video file format and convert it to MP4 format. Supports many input video formats, including AVI, ASF, FLV, MP4, MPEG/MPG, Matroska/WEBM, 3G2, OGV, MKV, M4V and MOV. Uses 1 API call per 10 MB of file size. Maximum output file size is 50GB.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_convert_to_mp4(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str file_url: Optional; URL of a video file being used for conversion. Use this option for files larger than 2GB.
        :param int max_width: Optional; Maximum width of the output video, up to the original video width. Defaults to original video width.
        :param int max_height: Optional; Maximum height of the output video, up to the original video width. Defaults to original video height.
        :param bool preserve_aspect_ratio: Optional; If false, the original video's aspect ratio will not be preserved, allowing customization of the aspect ratio using maxWidth and maxHeight, potentially skewing the video. Default is true.
        :param int frame_rate: Optional; Specify the frame rate of the output video. Defaults to original video frame rate.
        :param int quality: Optional; Specify the quality of the output video, where 100 is lossless and 1 is the lowest possible quality with highest compression. Default is 50.
        :param bool extend_processing_time: Optional; If true, will allow additional processing time for the video file conversion, using one API call per additional minute over the 5 minute default processing time, up to a maximum of 25 total minutes. This is generally necessary for files larger than 500 MB or longer than 30 minutes.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.video_convert_to_mp4_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.video_convert_to_mp4_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def video_convert_to_mp4_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Convert Video to MP4 format.  # noqa: E501

        Automatically detect video file format and convert it to MP4 format. Supports many input video formats, including AVI, ASF, FLV, MP4, MPEG/MPG, Matroska/WEBM, 3G2, OGV, MKV, M4V and MOV. Uses 1 API call per 10 MB of file size. Maximum output file size is 50GB.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_convert_to_mp4_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str file_url: Optional; URL of a video file being used for conversion. Use this option for files larger than 2GB.
        :param int max_width: Optional; Maximum width of the output video, up to the original video width. Defaults to original video width.
        :param int max_height: Optional; Maximum height of the output video, up to the original video width. Defaults to original video height.
        :param bool preserve_aspect_ratio: Optional; If false, the original video's aspect ratio will not be preserved, allowing customization of the aspect ratio using maxWidth and maxHeight, potentially skewing the video. Default is true.
        :param int frame_rate: Optional; Specify the frame rate of the output video. Defaults to original video frame rate.
        :param int quality: Optional; Specify the quality of the output video, where 100 is lossless and 1 is the lowest possible quality with highest compression. Default is 50.
        :param bool extend_processing_time: Optional; If true, will allow additional processing time for the video file conversion, using one API call per additional minute over the 5 minute default processing time, up to a maximum of 25 total minutes. This is generally necessary for files larger than 500 MB or longer than 30 minutes.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'file_url', 'max_width', 'max_height', 'preserve_aspect_ratio', 'frame_rate', 'quality', 'extend_processing_time']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method video_convert_to_mp4" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `video_convert_to_mp4`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'file_url' in params:
            header_params['fileUrl'] = params['file_url']  # noqa: E501
        if 'max_width' in params:
            header_params['maxWidth'] = params['max_width']  # noqa: E501
        if 'max_height' in params:
            header_params['maxHeight'] = params['max_height']  # noqa: E501
        if 'preserve_aspect_ratio' in params:
            header_params['preserveAspectRatio'] = params['preserve_aspect_ratio']  # noqa: E501
        if 'frame_rate' in params:
            header_params['frameRate'] = params['frame_rate']  # noqa: E501
        if 'quality' in params:
            header_params['quality'] = params['quality']  # noqa: E501
        if 'extend_processing_time' in params:
            header_params['extendProcessingTime'] = params['extend_processing_time']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/video/convert/to/mp4', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def video_convert_to_webm(self, input_file, **kwargs):  # noqa: E501
        """Convert Video to WEBM format.  # noqa: E501

        Automatically detect video file format and convert it to WEBM format. Supports many input video formats, including AVI, ASF, FLV, MP4, MPEG/MPG, Matroska/WEBM, 3G2, OGV, MKV, M4V and MOV. Uses 1 API call per 10 MB of file size. Maximum output file size is 50GB.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_convert_to_webm(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str file_url: Optional; URL of a video file being used for conversion. Use this option for files larger than 2GB.
        :param int max_width: Optional; Maximum width of the output video, up to the original video width. Defaults to original video width.
        :param int max_height: Optional; Maximum height of the output video, up to the original video width. Defaults to original video height.
        :param bool preserve_aspect_ratio: Optional; If false, the original video's aspect ratio will not be preserved, allowing customization of the aspect ratio using maxWidth and maxHeight, potentially skewing the video. Default is true.
        :param int frame_rate: Optional; Specify the frame rate of the output video. Defaults to original video frame rate.
        :param int quality: Optional; Specify the quality of the output video, where 100 is lossless and 1 is the lowest possible quality with highest compression. Default is 50.
        :param bool extend_processing_time: Optional; If true, will allow additional processing time for the video file conversion, using one API call per additional minute over the 5 minute default processing time, up to a maximum of 25 total minutes. This is generally necessary for files larger than 500 MB or longer than 30 minutes.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.video_convert_to_webm_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.video_convert_to_webm_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def video_convert_to_webm_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Convert Video to WEBM format.  # noqa: E501

        Automatically detect video file format and convert it to WEBM format. Supports many input video formats, including AVI, ASF, FLV, MP4, MPEG/MPG, Matroska/WEBM, 3G2, OGV, MKV, M4V and MOV. Uses 1 API call per 10 MB of file size. Maximum output file size is 50GB.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_convert_to_webm_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str file_url: Optional; URL of a video file being used for conversion. Use this option for files larger than 2GB.
        :param int max_width: Optional; Maximum width of the output video, up to the original video width. Defaults to original video width.
        :param int max_height: Optional; Maximum height of the output video, up to the original video width. Defaults to original video height.
        :param bool preserve_aspect_ratio: Optional; If false, the original video's aspect ratio will not be preserved, allowing customization of the aspect ratio using maxWidth and maxHeight, potentially skewing the video. Default is true.
        :param int frame_rate: Optional; Specify the frame rate of the output video. Defaults to original video frame rate.
        :param int quality: Optional; Specify the quality of the output video, where 100 is lossless and 1 is the lowest possible quality with highest compression. Default is 50.
        :param bool extend_processing_time: Optional; If true, will allow additional processing time for the video file conversion, using one API call per additional minute over the 5 minute default processing time, up to a maximum of 25 total minutes. This is generally necessary for files larger than 500 MB or longer than 30 minutes.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'file_url', 'max_width', 'max_height', 'preserve_aspect_ratio', 'frame_rate', 'quality', 'extend_processing_time']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method video_convert_to_webm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `video_convert_to_webm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'file_url' in params:
            header_params['fileUrl'] = params['file_url']  # noqa: E501
        if 'max_width' in params:
            header_params['maxWidth'] = params['max_width']  # noqa: E501
        if 'max_height' in params:
            header_params['maxHeight'] = params['max_height']  # noqa: E501
        if 'preserve_aspect_ratio' in params:
            header_params['preserveAspectRatio'] = params['preserve_aspect_ratio']  # noqa: E501
        if 'frame_rate' in params:
            header_params['frameRate'] = params['frame_rate']  # noqa: E501
        if 'quality' in params:
            header_params['quality'] = params['quality']  # noqa: E501
        if 'extend_processing_time' in params:
            header_params['extendProcessingTime'] = params['extend_processing_time']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/video/convert/to/webm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def video_get_info(self, input_file, **kwargs):  # noqa: E501
        """Get detailed information about a video or audio file  # noqa: E501

        Retrieve detailed information about a video or audio file, including format, dimensions, file size, bit rate, duration and start time. Compatible with many formats, including: AVI, ASF, FLV, GIF, MP4, MPEG/MPG, Matroska/WEBM, MOV, AIFF, ASF, CAF, MP3, MP2, MP1, Ogg, OMG/OMA, and WAV. Uses 1 API call per 10 MB of file size.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_get_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str file_url: Optional; URL of a video file being used for conversion. Use this option for files larger than 2GB.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.video_get_info_with_http_info(input_file, **kwargs)  # noqa: E501
        else:
            (data) = self.video_get_info_with_http_info(input_file, **kwargs)  # noqa: E501
            return data

    def video_get_info_with_http_info(self, input_file, **kwargs):  # noqa: E501
        """Get detailed information about a video or audio file  # noqa: E501

        Retrieve detailed information about a video or audio file, including format, dimensions, file size, bit rate, duration and start time. Compatible with many formats, including: AVI, ASF, FLV, GIF, MP4, MPEG/MPG, Matroska/WEBM, MOV, AIFF, ASF, CAF, MP3, MP2, MP1, Ogg, OMG/OMA, and WAV. Uses 1 API call per 10 MB of file size.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.video_get_info_with_http_info(input_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Input file to perform the operation on. (required)
        :param str file_url: Optional; URL of a video file being used for conversion. Use this option for files larger than 2GB.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'file_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method video_get_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'input_file' is set
        if ('input_file' not in params or
                params['input_file'] is None):
            raise ValueError("Missing the required parameter `input_file` when calling `video_get_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'file_url' in params:
            header_params['fileUrl'] = params['file_url']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/video/convert/get-info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
