# generated by datamodel-codegen:
#   filename:  security/credentials/gcsCredentials.json
#   timestamp: 2022-12-02T16:12:28+00:00

from __future__ import annotations

from typing import List, Optional, Union

from pydantic import AnyUrl, BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr


class SingleProjectId(BaseModel):
    __root__: str = Field(..., title='Single Project ID')


class MultipleProjectId(BaseModel):
    __root__: List[str] = Field(..., title='Multiple Project ID')


class GCSValues(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[str] = Field(
        None, description='Google Cloud service account type.', title='Credentials Type'
    )
    projectId: Optional[Union[SingleProjectId, MultipleProjectId]] = Field(
        None, description='Project ID', title='Project ID'
    )
    privateKeyId: Optional[str] = Field(
        None, description='Google Cloud private key id.', title='Private Key ID'
    )
    privateKey: Optional[CustomSecretStr] = Field(
        None, description='Google Cloud private key.', title='Private Key'
    )
    clientEmail: Optional[str] = Field(
        None, description='Google Cloud email.', title='Client Email'
    )
    clientId: Optional[str] = Field(
        None, description='Google Cloud Client ID.', title='Client ID'
    )
    authUri: Optional[AnyUrl] = Field(
        'https://accounts.google.com/o/oauth2/auth',
        description='Google Cloud auth uri.',
        title='Authentication URI',
    )
    tokenUri: Optional[AnyUrl] = Field(
        'https://oauth2.googleapis.com/token',
        description='Google Cloud token uri.',
        title='Token URI',
    )
    authProviderX509CertUrl: Optional[AnyUrl] = Field(
        'https://www.googleapis.com/oauth2/v1/certs',
        description='Google Cloud auth provider certificate.',
        title='Authentication Provider x509 Certificate URL',
    )
    clientX509CertUrl: Optional[AnyUrl] = Field(
        None,
        description='Google Cloud client certificate uri.',
        title='Client x509 Certificate URL',
    )


class GCSCredentialsPath(BaseModel):
    __root__: str = Field(
        ...,
        description='Pass the path of file containing the GCS credentials info',
        title='GCS Credentials Path',
    )


class GCSCredentials(BaseModel):
    class Config:
        extra = Extra.forbid

    gcsConfig: Union[GCSValues, GCSCredentialsPath] = Field(
        ...,
        description='We support two ways of authenticating to GCS i.e via GCS Credentials Values or GCS Credentials Path',
        title='GCS Credentials Configuration',
    )
