# generated by datamodel-codegen:
#   filename:  metadataIngestion/databaseServiceQueryUsagePipeline.json
#   timestamp: 2022-12-02T16:12:28+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from ..type import filterPattern


class DatabaseUsageConfigType(Enum):
    DatabaseUsage = 'DatabaseUsage'


class DatabaseServiceQueryUsagePipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DatabaseUsageConfigType] = Field(
        DatabaseUsageConfigType.DatabaseUsage, description='Pipeline type'
    )
    queryLogDuration: Optional[int] = Field(
        1,
        description='Configuration to tune how far we want to look back in query logs to process usage data.',
    )
    stageFileLocation: Optional[str] = Field(
        '/tmp/query_log',
        description='Temporary file name to store the query logs before processing. Absolute file path required.',
    )
    resultLimit: Optional[int] = Field(
        '1000', description='Configuration to set the limit for query logs'
    )
    queryLogFilePath: Optional[str] = Field(
        None, description='Configuration to set the file path for query logs'
    )
    schemaFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch tables or databases that matches the pattern.',
    )
    tableFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex exclude tables or databases that matches the pattern.'
    )
    databaseFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex to only fetch databases that matches the pattern.'
    )
