# generated by datamodel-codegen:
#   filename:  metadataIngestion/databaseServiceMetadataPipeline.json
#   timestamp: 2022-12-02T16:12:28+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from ..type import filterPattern
from .dbtconfig import (
    dbtCloudConfig,
    dbtGCSConfig,
    dbtHttpConfig,
    dbtLocalConfig,
    dbtS3Config,
)


class DatabaseMetadataConfigType(Enum):
    DatabaseMetadata = 'DatabaseMetadata'


class DatabaseServiceMetadataPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DatabaseMetadataConfigType] = Field(
        DatabaseMetadataConfigType.DatabaseMetadata, description='Pipeline type'
    )
    markDeletedTables: Optional[bool] = Field(
        True,
        description='Optional configuration to soft delete tables in OpenMetadata if the source tables are deleted.',
    )
    markDeletedTablesFromFilterOnly: Optional[bool] = Field(
        False,
        description='Optional configuration to mark deleted tables only to the filtered schema',
    )
    includeTables: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching metadata for tables.',
    )
    includeViews: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching metadata for views.',
    )
    includeTags: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching metadata for tags.',
    )
    useFqnForFiltering: Optional[bool] = Field(
        False,
        description='Regex will be applied on fully qualified name (e.g service_name.db_name.schema_name.table_name) instead of raw name (e.g. table_name)',
    )
    schemaFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch tables or databases that matches the pattern.',
    )
    tableFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex exclude tables or databases that matches the pattern.'
    )
    databaseFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex to only fetch databases that matches the pattern.'
    )
    dbtConfigSource: Optional[
        Union[
            dbtCloudConfig.DbtCloudConfig,
            dbtLocalConfig.DbtLocalConfig,
            dbtHttpConfig.DbtHttpConfig,
            dbtS3Config.DbtS3Config,
            dbtGCSConfig.DbtGcsConfig,
        ]
    ] = Field(
        None,
        description='Available sources to fetch DBT catalog and manifest files.',
        title='DBT Configuration Source',
    )
