# generated by datamodel-codegen:
#   filename:  entity/services/databaseService.json
#   timestamp: 2022-12-02T16:12:28+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityHistory, entityReference
from .connections.database import (
    athenaConnection,
    azureSQLConnection,
    bigQueryConnection,
    clickhouseConnection,
    customDatabaseConnection,
    databricksConnection,
    datalakeConnection,
    db2Connection,
    deltaLakeConnection,
    domodatabaseConnection,
    druidConnection,
    dynamoDBConnection,
    glueConnection,
    hiveConnection,
    mariaDBConnection,
    mssqlConnection,
    mysqlConnection,
    oracleConnection,
    pinotDBConnection,
    postgresConnection,
    prestoConnection,
    redshiftConnection,
    salesforceConnection,
    sampleDataConnection,
    singleStoreConnection,
    snowflakeConnection,
    sqliteConnection,
    trinoConnection,
    verticaConnection,
)


class DatabaseServiceType(Enum):
    BigQuery = 'BigQuery'
    Mysql = 'Mysql'
    Redshift = 'Redshift'
    Snowflake = 'Snowflake'
    Postgres = 'Postgres'
    Mssql = 'Mssql'
    Oracle = 'Oracle'
    Athena = 'Athena'
    Hive = 'Hive'
    Presto = 'Presto'
    Trino = 'Trino'
    Vertica = 'Vertica'
    Glue = 'Glue'
    MariaDB = 'MariaDB'
    Druid = 'Druid'
    Db2 = 'Db2'
    Clickhouse = 'Clickhouse'
    Databricks = 'Databricks'
    AzureSQL = 'AzureSQL'
    DynamoDB = 'DynamoDB'
    SingleStore = 'SingleStore'
    SQLite = 'SQLite'
    DeltaLake = 'DeltaLake'
    Salesforce = 'Salesforce'
    SampleData = 'SampleData'
    PinotDB = 'PinotDB'
    Datalake = 'Datalake'
    DomoDatabase = 'DomoDatabase'
    QueryLog = 'QueryLog'
    CustomDatabase = 'CustomDatabase'


class DatabaseConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    config: Optional[
        Union[
            bigQueryConnection.BigQueryConnection,
            athenaConnection.AthenaConnection,
            azureSQLConnection.AzureSQLConnection,
            clickhouseConnection.ClickhouseConnection,
            databricksConnection.DatabricksConnection,
            db2Connection.Db2Connection,
            deltaLakeConnection.DeltaLakeConnection,
            druidConnection.DruidConnection,
            dynamoDBConnection.DynamoDBConnection,
            glueConnection.GlueConnection,
            hiveConnection.HiveConnection,
            mariaDBConnection.MariaDBConnection,
            mssqlConnection.MssqlConnection,
            mysqlConnection.MysqlConnection,
            sqliteConnection.SQLiteConnection,
            oracleConnection.OracleConnection,
            postgresConnection.PostgresConnection,
            prestoConnection.PrestoConnection,
            redshiftConnection.RedshiftConnection,
            salesforceConnection.SalesforceConnection,
            singleStoreConnection.SingleStoreConnection,
            snowflakeConnection.SnowflakeConnection,
            trinoConnection.TrinoConnection,
            verticaConnection.VerticaConnection,
            sampleDataConnection.SampleDataConnection,
            pinotDBConnection.PinotDBConnection,
            datalakeConnection.DatalakeConnection,
            domodatabaseConnection.DomoDatabaseConnection,
            customDatabaseConnection.CustomDatabaseConnection,
        ]
    ] = None


class DatabaseService(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier of this database service instance.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that identifies this database service.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this database service.'
    )
    serviceType: DatabaseServiceType = Field(
        ...,
        description='Type of database service such as MySQL, BigQuery, Snowflake, Redshift, Postgres...',
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of a database service instance.'
    )
    connection: Optional[DatabaseConnection] = None
    pipelines: Optional[entityReference.EntityReferenceList] = Field(
        None,
        description='References to pipelines deployed for this database service to extract metadata, usage, lineage etc..',
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this database service.'
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this database service.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
