# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/fivetranConnection.json
#   timestamp: 2022-12-02T16:12:28+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class FivetranType(Enum):
    Fivetran = 'Fivetran'


class FivetranConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[FivetranType] = Field(
        FivetranType.Fivetran, description='Service Type', title='Service Type'
    )
    apiKey: str = Field(
        ..., description='Fivetran API Secret.', title='Fivetran API Key'
    )
    hostPort: Optional[AnyUrl] = Field(
        'https://api.fivetran.com',
        description='Pipeline Service Management/UI URI.',
        title='Host And Port',
    )
    apiSecret: CustomSecretStr = Field(
        ..., description='Fivetran API Secret.', title='Fivetran API Secret'
    )
    limit: Optional[int] = Field(
        1000,
        description='Fivetran API Limit For Pagination.',
        title='Fivetran API Limit',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
