# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/dagsterConnection.json
#   timestamp: 2022-12-02T16:12:28+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class DagsterType(Enum):
    Dagster = 'Dagster'


class LocalDagtser(BaseModel):
    hostPort: AnyUrl = Field(
        ..., description='Pipeline Service Management/UI URI.', title='Host and Port'
    )


class CloudDagster(BaseModel):
    host: AnyUrl = Field(
        ..., description='Pipeline Service Management/UI URI.', title='Host'
    )
    token: CustomSecretStr = Field(
        ..., description='To Connect to Dagster Cloud', title='Token'
    )


class DagsterConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DagsterType] = Field(
        DagsterType.Dagster, description='Service Type', title='Service Type'
    )
    configSource: Union[LocalDagtser, CloudDagster] = Field(
        ...,
        description='Available sources to fetch files.',
        title='Dagster Configuration Source',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
