/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import libpadeldescriptor.AtomConstants;
import libpadeldescriptor.IntrinsicStateDescriptor;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.matrix.TopologicalMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class AutocorrelationDescriptor
implements IMolecularDescriptor {
    private static final int maxLag = 8;
    public String[] names = new String[18 * (wtypes.length - 1) + 18 * wtypes.length + 16 * wtypes.length];
    private static final String[] atstypes = new String[]{"ATS", "AATS", "ATSC", "AATSC", "MATS", "GATS"};
    private static final String[] wtypes = new String[]{"c", "m", "v", "e", "p", "i", "s"};

    public AutocorrelationDescriptor() {
        int n;
        int n2;
        String string;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < 2; ++n3) {
            string = atstypes[n3];
            for (int i = 1; i < wtypes.length; ++i) {
                String string2 = wtypes[i];
                for (n2 = 0; n2 <= 8; ++n2) {
                    this.names[n4++] = string + n2 + string2;
                }
            }
        }
        for (n3 = 2; n3 < 4; ++n3) {
            string = atstypes[n3];
            String[] stringArray = wtypes;
            int n5 = stringArray.length;
            for (n2 = 0; n2 < n5; ++n2) {
                String string3 = stringArray[n2];
                for (n = 0; n <= 8; ++n) {
                    this.names[n4++] = string + n + string3;
                }
            }
        }
        for (n3 = 4; n3 < 6; ++n3) {
            string = atstypes[n3];
            for (String string3 : wtypes) {
                for (n = 1; n <= 8; ++n) {
                    this.names[n4++] = string + n + string3;
                }
            }
        }
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("Autocorrelation", this.getClass().getName(), "$Id: AutocorrelationDescriptor.java 1 2014-06-06 12:00:00Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return this.names;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n4 = iAtomContainer.getAtomCount();
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        double[] dArray4 = new double[n4];
        double[] dArray5 = new double[n4];
        double[] dArray6 = new double[n4];
        double[] dArray7 = new double[n4];
        try {
            object5 = new Molecule(iAtomContainer.clone());
            object4 = new GasteigerMarsiliPartialCharges();
            ((GasteigerMarsiliPartialCharges)object4).assignGasteigerMarsiliSigmaPartialCharges((IAtomContainer)object5, true);
            object3 = new IntrinsicStateDescriptor();
            for (int i = 0; i < n4; ++i) {
                int n5 = iAtomContainer.getAtom(i).getAtomicNumber();
                dArray[i] = ((AtomContainer)object5).getAtom(i).getCharge();
                dArray2[i] = n5 < AtomConstants.masses.length ? AtomConstants.masses[n5] : Double.NaN;
                dArray3[i] = n5 < AtomConstants.volumes.length ? AtomConstants.volumes[n5] : Double.NaN;
                dArray4[i] = n5 < AtomConstants.sandersonelnegativities.length ? AtomConstants.sandersonelnegativities[n5] : Double.NaN;
                dArray5[i] = n5 < AtomConstants.polarizabilities.length ? AtomConstants.polarizabilities[n5] : Double.NaN;
                dArray6[i] = n5 < AtomConstants.ionpotentials.length ? AtomConstants.ionpotentials[n5] : Double.NaN;
                object2 = iAtomContainer.getAtom(i);
                if (n5 == 1) {
                    dArray7[i] = 1.0;
                    continue;
                }
                object = (DoubleArrayResult)((IntrinsicStateDescriptor)object3).calculate((IAtom)object2, iAtomContainer).getValue();
                dArray7[i] = ((DoubleArrayResult)object).get(0);
            }
        }
        catch (Exception exception) {
            DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
            for (int i = 0; i < this.getDescriptorNames().length; ++i) {
                doubleArrayResult.add(Double.NaN);
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), new CDKException("Error during calculation of properties: " + exception.getMessage(), exception));
        }
        object5 = this.getCenteredValues(dArray);
        object4 = this.getCenteredValues(dArray2);
        object3 = this.getCenteredValues(dArray3);
        double[] dArray8 = this.getCenteredValues(dArray4);
        double[] dArray9 = this.getCenteredValues(dArray5);
        object2 = this.getCenteredValues(dArray6);
        object = this.getCenteredValues(dArray7);
        double[][] dArray10 = new double[9][wtypes.length];
        double[][] dArray11 = new double[9][wtypes.length];
        double[][] dArray12 = new double[9][wtypes.length];
        double[][] dArray13 = new double[9][wtypes.length];
        double[][] dArray14 = new double[9][wtypes.length];
        double[][] dArray15 = new double[9][wtypes.length];
        for (n3 = 0; n3 < n4; ++n3) {
            double[] dArray16 = dArray10[0];
            dArray16[0] = dArray16[0] + dArray[n3] * dArray[n3];
            double[] dArray17 = dArray10[0];
            dArray17[1] = dArray17[1] + dArray2[n3] * dArray2[n3];
            double[] dArray18 = dArray10[0];
            dArray18[2] = dArray18[2] + dArray3[n3] * dArray3[n3];
            double[] dArray19 = dArray10[0];
            dArray19[3] = dArray19[3] + dArray4[n3] * dArray4[n3];
            double[] dArray20 = dArray10[0];
            dArray20[4] = dArray20[4] + dArray5[n3] * dArray5[n3];
            double[] dArray21 = dArray10[0];
            dArray21[5] = dArray21[5] + dArray6[n3] * dArray6[n3];
            double[] dArray22 = dArray10[0];
            dArray22[6] = dArray22[6] + dArray7[n3] * dArray7[n3];
            double[] dArray23 = dArray12[0];
            dArray23[0] = dArray23[0] + object5[n3] * object5[n3];
            double[] dArray24 = dArray12[0];
            dArray24[1] = dArray24[1] + object4[n3] * object4[n3];
            double[] dArray25 = dArray12[0];
            dArray25[2] = dArray25[2] + object3[n3] * object3[n3];
            double[] dArray26 = dArray12[0];
            dArray26[3] = dArray26[3] + dArray8[n3] * dArray8[n3];
            double[] dArray27 = dArray12[0];
            dArray27[4] = dArray27[4] + dArray9[n3] * dArray9[n3];
            double[] dArray28 = dArray12[0];
            dArray28[5] = dArray28[5] + object2[n3] * object2[n3];
            double[] dArray29 = dArray12[0];
            dArray29[6] = dArray29[6] + object[n3] * object[n3];
        }
        for (n3 = 0; n3 < wtypes.length; ++n3) {
            dArray11[0][n3] = dArray10[0][n3] / (double)n4;
            dArray13[0][n3] = dArray12[0][n3] / (double)n4;
            dArray14[0][n3] = dArray13[0][n3];
            dArray15[0][n3] = dArray12[0][n3] / (double)(n4 - 1);
        }
        int[][] nArray = TopologicalMatrix.getMatrix(iAtomContainer);
        for (int i = 1; i <= 8; ++i) {
            n2 = 0;
            for (n = 0; n < n4; ++n) {
                for (int j = n + 1; j < n4; ++j) {
                    if (nArray[n][j] != i) continue;
                    double[] dArray30 = dArray10[i];
                    dArray30[0] = dArray30[0] + dArray[n] * dArray[j];
                    double[] dArray31 = dArray10[i];
                    dArray31[1] = dArray31[1] + dArray2[n] * dArray2[j];
                    double[] dArray32 = dArray10[i];
                    dArray32[2] = dArray32[2] + dArray3[n] * dArray3[j];
                    double[] dArray33 = dArray10[i];
                    dArray33[3] = dArray33[3] + dArray4[n] * dArray4[j];
                    double[] dArray34 = dArray10[i];
                    dArray34[4] = dArray34[4] + dArray5[n] * dArray5[j];
                    double[] dArray35 = dArray10[i];
                    dArray35[5] = dArray35[5] + dArray6[n] * dArray6[j];
                    double[] dArray36 = dArray10[i];
                    dArray36[6] = dArray36[6] + dArray7[n] * dArray7[j];
                    double[] dArray37 = dArray12[i];
                    dArray37[0] = dArray37[0] + object5[n] * object5[j];
                    double[] dArray38 = dArray12[i];
                    dArray38[1] = dArray38[1] + object4[n] * object4[j];
                    double[] dArray39 = dArray12[i];
                    dArray39[2] = dArray39[2] + object3[n] * object3[j];
                    double[] dArray40 = dArray12[i];
                    dArray40[3] = dArray40[3] + dArray8[n] * dArray8[j];
                    double[] dArray41 = dArray12[i];
                    dArray41[4] = dArray41[4] + dArray9[n] * dArray9[j];
                    double[] dArray42 = dArray12[i];
                    dArray42[5] = dArray42[5] + object2[n] * object2[j];
                    double[] dArray43 = dArray12[i];
                    dArray43[6] = dArray43[6] + object[n] * object[j];
                    double[] dArray44 = dArray15[i];
                    dArray44[0] = dArray44[0] + (dArray[n] - dArray[j]) * (dArray[n] - dArray[j]);
                    double[] dArray45 = dArray15[i];
                    dArray45[1] = dArray45[1] + (dArray2[n] - dArray2[j]) * (dArray2[n] - dArray2[j]);
                    double[] dArray46 = dArray15[i];
                    dArray46[2] = dArray46[2] + (dArray3[n] - dArray3[j]) * (dArray3[n] - dArray3[j]);
                    double[] dArray47 = dArray15[i];
                    dArray47[3] = dArray47[3] + (dArray4[n] - dArray4[j]) * (dArray4[n] - dArray4[j]);
                    double[] dArray48 = dArray15[i];
                    dArray48[4] = dArray48[4] + (dArray5[n] - dArray5[j]) * (dArray5[n] - dArray5[j]);
                    double[] dArray49 = dArray15[i];
                    dArray49[5] = dArray49[5] + (dArray6[n] - dArray6[j]) * (dArray6[n] - dArray6[j]);
                    double[] dArray50 = dArray15[i];
                    dArray50[6] = dArray50[6] + (dArray7[n] - dArray7[j]) * (dArray7[n] - dArray7[j]);
                    ++n2;
                }
            }
            for (n = 0; n < wtypes.length; ++n) {
                dArray11[i][n] = n2 > 0 ? dArray10[i][n] / (double)n2 : 0.0;
                dArray13[i][n] = n2 > 0 ? dArray12[i][n] / (double)n2 : 0.0;
                dArray14[i][n] = dArray14[0][n] > 0.0 ? dArray13[i][n] / dArray14[0][n] : 0.0;
                dArray15[i][n] = n2 > 0 & dArray15[0][n] > 0.0 ? dArray15[i][n] / ((double)(2 * n2) * dArray15[0][n]) : 0.0;
            }
        }
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        for (n2 = 1; n2 < wtypes.length; ++n2) {
            for (n = 0; n <= 8; ++n) {
                doubleArrayResult.add(dArray10[n][n2]);
            }
        }
        for (n2 = 1; n2 < wtypes.length; ++n2) {
            for (n = 0; n <= 8; ++n) {
                doubleArrayResult.add(dArray11[n][n2]);
            }
        }
        for (n2 = 0; n2 < wtypes.length; ++n2) {
            for (n = 0; n <= 8; ++n) {
                doubleArrayResult.add(dArray12[n][n2]);
            }
        }
        for (n2 = 0; n2 < wtypes.length; ++n2) {
            for (n = 0; n <= 8; ++n) {
                doubleArrayResult.add(dArray13[n][n2]);
            }
        }
        for (n2 = 0; n2 < wtypes.length; ++n2) {
            for (n = 1; n <= 8; ++n) {
                doubleArrayResult.add(dArray14[n][n2]);
            }
        }
        for (n2 = 0; n2 < wtypes.length; ++n2) {
            for (n = 1; n <= 8; ++n) {
                doubleArrayResult.add(dArray15[n][n2]);
            }
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames());
    }

    private double[] getCenteredValues(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        double d2 = d / (double)dArray.length;
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] - d2;
        }
        return dArray2;
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(this.names.length);
    }
}

