import { Stack } from "aws-cdk-lib";
import { IMachineImage, InstanceType } from "aws-cdk-lib/aws-ec2";
import { CfnInstanceProfile, IRole } from "aws-cdk-lib/aws-iam";
import { IStringParameter } from "aws-cdk-lib/aws-ssm";
import { Construct } from "constructs";
import { RunnerConfiguration } from "../runner-configuration";
/**
 * The runner EC2 instances configuration. If not set, the defaults will be used.
 */
export interface GitlabRunnerAutoscalingJobRunnerProps {
    /**
     * The runner’s authentication token, which is obtained during runner registration. Not the same as the registration token.
     * @see https://docs.gitlab.com/ee/api/runners.html#register-a-new-runner
     */
    readonly token: IStringParameter;
    /**
     * The runner EC2 instances configuration. If not set, the defaults will be used.
     * @link RunnerConfiguration
     */
    readonly configuration: RunnerConfiguration;
    /**
     * Instance type for runner EC2 instances. It's a combination of a class and size.
     * @default InstanceType.of(InstanceClass.T3, InstanceSize.MICRO)
     */
    readonly instanceType?: InstanceType;
    /**
     * An Amazon Machine Image ID for the Runners EC2 instances. If empty the latest Ubuntu 20.04 focal will be looked up.
     *
     * Any operating system supported by Docker Machine's provisioner.
     *
     * @see https://cloud-images.ubuntu.com/locator/ec2/
     * @see https://gitlab.com/gitlab-org/ci-cd/docker-machine/-/tree/main/libmachine/provision
     */
    readonly machineImage?: IMachineImage;
    /**
     * Optionally pass an IAM role, that get's assigned to the EC2 runner instances via Instance Profile.
     */
    readonly role?: IRole;
}
export declare class GitlabRunnerAutoscalingJobRunner extends Construct {
    private static generateUniqueName;
    readonly configuration: RunnerConfiguration;
    readonly instanceType: InstanceType;
    readonly machineImage: IMachineImage;
    readonly role: IRole;
    readonly instanceProfile: CfnInstanceProfile;
    constructor(scope: Stack, id: string, props: GitlabRunnerAutoscalingJobRunnerProps);
}
