# AUTOGENERATED! DO NOT EDIT! File to edit: ../notebooks/00-utils.ipynb.

# %% auto 0
__all__ = ['copy_template']

# %% ../notebooks/00-utils.ipynb 1
import importlib.resources as pkg_resources
from pathlib import Path

# %% ../notebooks/00-utils.ipynb 3
def copy_template(tmp: str, file: str, append: bool = False):
    "Copies a template from the templates directory"
    filepath = Path(file)
    filepath.parent.mkdir(parents=True, exist_ok=True)
    content = pkg_resources.files("tjutils").joinpath(f"templates/{tmp}").read_text()
    with open(file, "a" if append else "w") as f:
        f.write(content)
    return None
